/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.List;

public class DataValidationCustomTableModel
extends DataValidationTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationCustomTableModel.class);
    static final int NUM_VISIBLE_COLUMNS = 2;
    static final int NUM_HIDDEN_COLUMNS = 7;
    static final int CUSTOM_NAME_INDEX = 0;
    static final int CUSTOM_CONDITION_INDEX = 1;
    static final int CUSTOM_ASSIGN_0_INDEX = 2;
    static final int CUSTOM_ASSIGN_1_INDEX = 3;
    static final int CUSTOM_EXCEPTION_0_INDEX = 4;
    static final int CUSTOM_EXCEPTION_1_INDEX = 5;
    static final int CUSTOM_ACTION_0_INDEX = 6;
    static final int CUSTOM_ACTION_1_INDEX = 7;
    static final int CUSTOM_DVR_INDEX = 8;
    static final int CUSTOM_NUM_VALUES = 9;
    public IModelListener m_lsnrModel = new ModelListener();

    public DataValidationCustomTableModel(DataValidationTransformModel oDVTransformModel) {
        super(oDVTransformModel);
        this.m_DVTransformModel.getModel().addModelListener(this.m_lsnrModel);
    }

    @Override
    public void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("DataValidationTableModel.Name.label.txt"), 150);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DataValidationTableModel.Condition.label.txt"), 200);
        this.m_aColumns[3] = new WsMetadataTableColumn();
        this.m_aColumns[5] = new WsMetadataTableColumn();
        this.m_aColumns[7] = new WsMetadataTableColumn();
        this.m_aColumns[2] = new WsMetadataTableColumn();
        this.m_aColumns[4] = new WsMetadataTableColumn();
        this.m_aColumns[6] = new WsMetadataTableColumn();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getHiddenColumnCount() {
        return 7;
    }

    @Override
    public String getValidationType() {
        return "Custom";
    }

    @Override
    public void moveDataToModel() {
        this.clear();
        List lDVRs = this.m_DVTransformModel.getModelList(this.getValidationType());
        for (int recNum = 0; recNum < lDVRs.size(); ++recNum) {
            DataValidationRecord oDVR = (DataValidationRecord)lDVRs.get(recNum);
            this.m_lData.add(this.createRowValues(oDVR));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    @Override
    public List addRowValues(DataValidationRecord oDVR, List lRowValues) {
        return DataValidationCustomTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    @Override
    public void dispose() {
        this.m_DVTransformModel.getModel().removeModelListener(this.m_lsnrModel);
    }

    public static List getRowValuesFromValidationRecord(DataValidationRecord oDVR, List lRowValues) {
        lRowValues.set(0, oDVR.getEvent_Name());
        lRowValues.set(1, oDVR.getExpression());
        lRowValues.set(2, oDVR.getCustomFalseTypeRecords());
        lRowValues.set(3, oDVR.getCustomTrueTypeRecords());
        lRowValues.set(4, oDVR.get_Property_FalseExceptionChkBox_DefVal());
        lRowValues.set(5, oDVR.get_Property_TrueExceptionChkBox_DefVal());
        lRowValues.set(6, oDVR.getPropertyFalse_PS1_DefVal());
        lRowValues.set(7, oDVR.getPropertyTrue_PS1_DefVal());
        lRowValues.set(8, oDVR);
        return lRowValues;
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                DataValidationCustomTableModel.this.moveDataToModel();
            } else if (obj == DataValidationCustomTableModel.this.m_DVTransformModel) {
                if (sType == "DVR:CustomTypeDataValidationRecordAdded") {
                    DataValidationCustomTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:CustomTypeDataValidationRecordMoved") {
                    DataValidationCustomTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                    DataValidationCustomTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:CustomTypeDataValidationRecordRemoved") {
                    DataValidationCustomTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                }
            }
        }
    }
}

