/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.casloader;

import com.ibm.icu.text.MessageFormat;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.BaseGeneratedTable;
import com.sas.etl.models.data.impl.BaseGeneratedTableColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.visuals.ObjectBrowsableTextField;
import com.sas.wadmin.visuals.common.ChooseColumnsPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class SASDataPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(SASDataPanel.class);
    private CASLoaderTransformModel transform;
    private TitledBorder m_titledBorder;
    private ModelListener m_lsnrModel;
    private JLabel lblTableText;
    private ObjectBrowsableTextField tableTextField;
    private cDocumentListener docListener;
    private ViewOutputTableAction m_actViewOutputTable;
    private JButton m_btnOutputColumns;

    public SASDataPanel(CASLoaderTransformModel txf) {
        this.transform = txf;
        this.m_lsnrModel = new ModelListener();
        this.transform.getModel().addModelListener((IModelListener)this.m_lsnrModel);
        this.m_actViewOutputTable = new ViewOutputTableAction();
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)MessageFormat.format((String)bundle.getString("SourcePropertyTab.SourceType.DATA.desc.txt"), (Object[])new Object[]{"DATA"}));
        this.docListener = new cDocumentListener();
        this.tableTextField = new ObjectBrowsableTextField("PhysicalTable");
        this.tableTextField.getTextField().getDocument().addDocumentListener(this.docListener);
        this.listenForDataChangesTo((JTextComponent)this.tableTextField.getTextField());
        this.lblTableText = WsUIUtilities.createLabelForComponent((JComponent)((Object)this.tableTextField), (String)bundle.getString("SASDataPanel.Table.txt"));
        this.lblTableText.setToolTipText(bundle.getString("SASDataPanel.Table.ToolTip.txt"));
        this.m_btnOutputColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actViewOutputTable);
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(this.m_titledBorder);
        this.add(this.lblTableText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.tableTextField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.m_btnOutputColumns, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void updateActions() {
        boolean actionEnabled = this.isEditable() && !this.transform.isUsingUserWrittenCode();
    }

    public void moveDataToView() throws RemoteException, MdException {
        super.moveDataToView();
        this.tableTextField.setData(this.transform.getSourceTable());
        this.tableTextField.setText(this.transform.getSourceTable() != null ? this.transform.getSourceTable().getName() : "");
        this.m_actViewOutputTable.setEnabled(this.transform.getSourceTable() != null && this.transform.getTargetTable() != null);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.transform.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    private boolean launchChooseColumnsDialog() {
        BaseTransformPort port = new BaseTransformPort(this.transform.getModel().createIDForNewObject(this.transform.getID()), this.transform.getModel());
        port.setCanIncludeSourceColumns(false);
        port.setObject((Object)this.transform.getTargetTable());
        BaseGeneratedTable table = new BaseGeneratedTable(this.transform.getModel().createIDForNewObject(this.transform.getID()));
        port.setGeneratedTable((IGeneratedTable)table);
        List columns = table.getColumns();
        if (this.tableTextField.getData() instanceof IPhysicalTable) {
            IPhysicalTable srctable = (IPhysicalTable)this.tableTextField.getData();
            for (IColumn column : srctable.getColumns()) {
                BaseGeneratedTableColumn newColumn = new BaseGeneratedTableColumn((IGeneratedTable)table, this.transform.getModel().createIDForNewObject(this.transform.getID()));
                newColumn.setName(column.getName());
                newColumn.setFormat(column.getFormat());
                newColumn.setSASLength(column.getLength());
                newColumn.setSASType(column.getType());
                newColumn.setDescription(column.getDescription());
                columns.add(newColumn);
            }
        } else {
            return false;
        }
        ChooseColumnsPanel pnlChooseColumns = new ChooseColumnsPanel((ITransformPort<IPhysicalTable>)port, null);
        pnlChooseColumns.setEditable(this.isEditable());
        pnlChooseColumns.setHelpProduct("wdb");
        pnlChooseColumns.setHelpTopic("select_output_columns");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("DirectiveTargetPanel.ChooseColumns.Title.txt"), true, (WAPanel)pnlChooseColumns);
        dlg.setEditable(this.isEditable());
        dlg.setResizable(true);
        dlg.setPreferredSize(new Dimension(750, 600));
        dlg.show();
        return false;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.tableTextField.setEditable(editable);
    }

    private class ViewOutputTableAction
    extends WsAbstractAction {
        public ViewOutputTableAction() {
            super(bundle, "FileDataPanel.ViewOutputTableAction", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPublicType("Column"));
        }

        public void actionPerformed(ActionEvent e) {
            SASDataPanel.this.launchChooseColumnsDialog();
        }
    }

    private class ModelListener
    implements IModelListener {
        private boolean isListening = true;

        private ModelListener() {
        }

        public void setListening(boolean value) {
            this.isListening = value;
        }

        public void modelChanged(ModelEvent ev) {
            if (!this.isListening) {
                return;
            }
            String sType = ev.getType();
            if ("DataTransform.DataSourceAdded".equals(sType)) {
                SASDataPanel.this.tableTextField.setData(ev.getData());
                SASDataPanel.this.m_actViewOutputTable.setEnabled(SASDataPanel.this.transform.getTargetTable() != null);
            } else if ("DataTransform.DataSourceRemoved".equals(sType)) {
                SASDataPanel.this.tableTextField.setData(null);
                SASDataPanel.this.m_actViewOutputTable.setEnabled(SASDataPanel.this.transform.getTargetTable() != null);
            }
        }
    }

    private class cDocumentListener
    implements DocumentListener {
        private cDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateValue(DocumentEvent e) {
            if (SASDataPanel.this.tableTextField.getTextField().getDocument() == e.getDocument()) {
                Object data = SASDataPanel.this.tableTextField.getData();
                if (data == null) {
                    SASDataPanel.this.transform.getDataSourceList().clear();
                } else if (data instanceof PhysicalTable) {
                    try {
                        OMRAdapter omr = new OMRAdapter(SASDataPanel.this.transform.getModel(), Workspace.getMdFactory(), "MetadataConnectionManager");
                        IPhysicalTable table = null;
                        try {
                            table = (IPhysicalTable)omr.acquireObjectUsingTemplate((Root)((PhysicalTable)data));
                            if (SASDataPanel.this.transform.containsInDataSources((IDataObject)table)) {
                                return;
                            }
                            SASDataPanel.this.transform.getDataSourceList().clear();
                            SASDataPanel.this.transform.addDataSource((IDataObject)table);
                        }
                        finally {
                            omr.dispose();
                        }
                    }
                    catch (RemoteException e1) {
                        Workspace.handleRemoteException((RemoteException)e1);
                    }
                    catch (MdException e1) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Reading");
                    }
                }
            }
        }
    }
}

