/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.casloader;

import com.ibm.icu.text.MessageFormat;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.loader.NameValueComboBoxModel;
import com.sas.wadmin.visuals.ObjectBrowsableTextField;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FileDataPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(FileDataPanel.class);
    private CASLoaderTransformModel transform;
    private TitledBorder m_titledBorder;
    private ModelListener m_lsnrModel;
    private JLabel lblFile;
    private ObjectBrowsableTextField fileTextField;
    private JLabel m_lblSourceType;
    private WAComboBox m_cmbSourceType;
    private NameValueComboBoxModel m_sourceTypeListModel;
    private WsAbstractAction m_actSourceType;
    private cDocumentListener docListener;

    public FileDataPanel(CASLoaderTransformModel txf) {
        this.transform = txf;
        this.m_lsnrModel = new ModelListener();
        this.transform.getModel().addModelListener((IModelListener)this.m_lsnrModel);
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)MessageFormat.format((String)bundle.getString("SourcePropertyTab.SourceType.FILE.desc.txt"), (Object[])new Object[]{"FILE"}));
        this.docListener = new cDocumentListener();
        this.fileTextField = new ObjectBrowsableTextField("File");
        this.fileTextField.getTextField().getDocument().addDocumentListener(this.docListener);
        this.listenForDataChangesTo((JTextComponent)this.fileTextField.getTextField());
        this.lblFile = WsUIUtilities.createLabelForComponent((JComponent)((Object)this.fileTextField), (String)bundle.getString("FileDataPanel.File.txt"));
        this.lblFile.setToolTipText(bundle.getString("FileDataPanel.File.ToolTip.txt"));
        this.m_sourceTypeListModel = new NameValueComboBoxModel(bundle, "FileDataPanel.FileType", true);
        String[] fileTypes = this.transform.getExternalFileTypes();
        if (fileTypes != null) {
            for (String type : fileTypes) {
                this.m_sourceTypeListModel.addItem(type);
            }
        } else {
            this.m_sourceTypeListModel.addItem("AUTO");
        }
        this.m_cmbSourceType = new WAComboBox();
        this.m_cmbSourceType.setModel((ComboBoxModel)this.m_sourceTypeListModel);
        this.m_lblSourceType = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceType, (String)bundle.getString("FileDataPanel.FileType.txt"));
        this.m_lblSourceType.setToolTipText(bundle.getString("FileDataPanel.FileType.ToolTip.txt"));
        this.listenForDataChangesTo((JComboBox)this.m_cmbSourceType);
        this.m_actSourceType = new cSourceTypeAction();
        this.m_cmbSourceType.addActionListener((ActionListener)this.m_actSourceType);
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(this.m_titledBorder);
        this.add(this.lblFile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.fileTextField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.m_lblSourceType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_cmbSourceType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void updateActions() {
        boolean actionEnabled = this.isEditable() && !this.transform.isUsingUserWrittenCode();
    }

    public void moveDataToView() throws RemoteException, MdException {
        super.moveDataToView();
        this.fileTextField.setText(this.transform.getExternalFile() != null ? this.transform.getExternalFile() : "");
        this.m_sourceTypeListModel.setSelectedValue(this.transform.getExternalFileType());
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.transform.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_cmbSourceType.setEnabled(editable);
        this.fileTextField.setEditable(editable);
    }

    private class ModelListener
    implements IModelListener {
        private boolean isListening = true;

        private ModelListener() {
        }

        public void setListening(boolean value) {
            this.isListening = value;
        }

        public void modelChanged(ModelEvent ev) {
            if (!this.isListening) {
                return;
            }
            String sType = ev.getType();
            if ("CASLoaderTransformModel:ExternalFileChanged".equals(sType)) {
                FileDataPanel.this.fileTextField.setText(ev.getData() != null ? ev.getData().toString() : null);
            } else if ("CASLoaderTransformModel:ExternalFileTypeChanged".equals(sType)) {
                FileDataPanel.this.m_cmbSourceType.setSelectedItem(ev.getData());
            }
        }
    }

    private class cDocumentListener
    implements DocumentListener {
        private cDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateValue(DocumentEvent e) {
            if (FileDataPanel.this.fileTextField.getTextField().getDocument() == e.getDocument()) {
                String data = FileDataPanel.this.fileTextField.getText();
                boolean isListening = FileDataPanel.this.m_lsnrModel.isListening;
                FileDataPanel.this.m_lsnrModel.setListening(false);
                try {
                    FileDataPanel.this.transform.setExternalFile(data);
                }
                finally {
                    FileDataPanel.this.m_lsnrModel.setListening(isListening);
                }
            }
        }
    }

    protected class cSourceTypeAction
    extends WsAbstractAction {
        protected cSourceTypeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!FileDataPanel.this.isListeningForChanges()) {
                return;
            }
            FileDataPanel.this.transform.setExternalFileType(FileDataPanel.this.m_sourceTypeListModel.getSelectedValue());
        }
    }
}

