/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.sascodeimporter;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IDirectory;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectFactory;
import com.sas.etl.models.job.ICodeFragment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.sql.impl.SQLJoinTransformModel;
import com.sas.etl.models.other.IConnection;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.PhysicalTableFilter;
import com.sas.services.util.XMLUtil;
import com.sas.wadmin.sascodeimporter.ParseLogger;
import com.sas.wadmin.sascodeimporter.SASCodeItem;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobParser {
    private static final WAdminResource bundle = WAdminResource.getBundle(JobParser.class);
    private static final int BEGIN_NEXT_STEP = 0;
    private static final int PROCESSING_HEADER = 2;
    private static final int PROCESSING_CODE = 3;
    private static final String STATEMENT_JOBSPLIT = "/* JOBSPLIT:";
    private static final String STATEMENT_LIBNAME = "/* JOBSPLIT: LIBNAME";
    private static final String STATEMENT_CONCATMEM = "/* JOBSPLIT: CONCATMEM";
    private static final String STATEMENT_TABLE = "/* JOBSPLIT: DATASET";
    private static final String STATEMENT_COLUMN = "/* JOBSPLIT: ATTR";
    private static final String STATEMENT_PROCNAME = "/* JOBSPLIT: PROCNAME";
    private static final String STATEMENT_SYSSCP = "/* JOBSPLIT: SYSSCP";
    private static final String STATEMENT_ALTERNATE_NODE_NAME = "/* ALTERNATE_NODE_NAME:";
    private static final String STATEMENT_ALTERNATE_NODE_DESC = "/* ALTERNATE_NODE_DESCRIPTION:";
    private static final String STATEMENT_COMMENT = "/* COMMENT:";
    private static final String BASE_STEP_NAME = "Step";
    private static final String COLLECT_RUNTIME_STATISTICS_KEY = "NewJobDialog.CollectRuntimeStatistics";
    private DesignTimeJobModel m_mdl;
    private String m_sOriginalCode;
    private String m_sAnalyzedCode;
    private String m_sysscp;
    private ServerInterface m_server;
    private OMRAdapter m_omr;
    private List<IPersistableObject> m_lObjectsToPersist;
    private List<IPersistableObject> m_lWorkTablesToPersist;
    private IFolder m_targetFolder;
    private boolean m_bRegisterWorkTables;
    private ParseLogger m_log = new ParseLogger();
    private SASCodeItem.Result m_result;
    private int m_iStepsCreated = 0;
    private int m_iLibrariesMatched = 0;
    private int m_iLibrariesCreated = 0;
    private int m_iTablesMatched = 0;
    private int m_iTablesCreated = 0;
    private int m_iColumnsCreated = 0;

    public JobParser(String sOriginalCode, String sAnalyzedCode, ServerInterface server, boolean bRegisterWorkTables) {
        this.m_sOriginalCode = sOriginalCode;
        this.m_sAnalyzedCode = sAnalyzedCode;
        this.m_server = server;
        this.m_bRegisterWorkTables = bRegisterWorkTables;
        this.m_result = SASCodeItem.Result.SUCCESS;
    }

    public void parseAndCreateJob(String sJobName, String sFolderID) {
        ParsedJob pJob = this.parseJob();
        if (pJob != null && this.createJob(pJob, sJobName, sFolderID, true)) {
            this.logStats();
        }
    }

    public void parseAndAnalyzeJob(String sJobName, String sFolderID) {
        ParsedJob pJob = this.parseJob();
        if (pJob != null && this.createJob(pJob, sJobName, sFolderID, false)) {
            this.logStats();
        }
    }

    private void logStats() {
        this.m_log.info("");
        this.m_log.info(bundle.getString("JobParser.Stats.Heading.txt"));
        this.m_log.info(1, bundle.formatString("JobParser.Stats.Steps.fmt", (Object)this.m_iStepsCreated));
        this.m_log.info(1, bundle.formatString("JobParser.Stats.NewLibraries.fmt", (Object)this.m_iLibrariesCreated));
        this.m_log.info(1, bundle.formatString("JobParser.Stats.MatchedLibraries.fmt", (Object)this.m_iLibrariesMatched));
        this.m_log.info(1, bundle.formatString("JobParser.Stats.NewTables.fmt", (Object)this.m_iTablesCreated));
        this.m_log.info(1, bundle.formatString("JobParser.Stats.MatchedTables.fmt", (Object)this.m_iTablesMatched));
        this.m_log.info(1, bundle.formatString("JobParser.Stats.NewColumns.fmt", (Object)this.m_iColumnsCreated));
    }

    private Prototype getGenericEnginePrototype(String strContext, MdObjectStore objectStore) throws RemoteException, MdException {
        Prototype prototype = PrototypeUtil.getPrototypeByIdentifier((IOMI)Workspace.getWorkspace().getCMRHandle(), null, (String)"name", (String)"Library.Generic.Prototype.Name.xmlKey.txt", (String)strContext, null, null, (MdStore)objectStore);
        return prototype;
    }

    private ParsedJob parseJob() {
        BufferedReader reader = new BufferedReader(new StringReader(this.m_sAnalyzedCode));
        int iState = 0;
        StringBuilder sbAccumulateCode = new StringBuilder();
        StringBuilder sbAccumulateComment = new StringBuilder();
        String sStepName = null;
        String sStepDesc = null;
        String sStepType = null;
        int iStepIndex = 1;
        ParsedJob pJob = new ParsedJob();
        ParsedStep pStep = new ParsedStep();
        try {
            String sBuffer;
            while ((sBuffer = reader.readLine()) != null) {
                if (sBuffer.startsWith(STATEMENT_ALTERNATE_NODE_NAME)) {
                    sStepName = this.parseComment(sBuffer);
                    continue;
                }
                if (sBuffer.startsWith(STATEMENT_ALTERNATE_NODE_DESC)) {
                    sStepDesc = this.parseComment(sBuffer);
                    continue;
                }
                if (sBuffer.startsWith(STATEMENT_COMMENT)) {
                    sbAccumulateComment.append(this.parseComment(sBuffer) + "\n");
                    continue;
                }
                if (sBuffer.startsWith(STATEMENT_JOBSPLIT)) {
                    String[] aTokens;
                    if (iState == 3) {
                        if (sStepName == null && sStepType == null) {
                            sStepName = BASE_STEP_NAME + String.valueOf(iStepIndex++);
                        }
                        pStep.m_sStepName = sStepName;
                        pStep.m_sStepDesc = sStepDesc;
                        pStep.m_sStepType = sStepType;
                        pStep.m_sCode = sbAccumulateCode.toString();
                        pStep.m_sComment = sbAccumulateComment.toString();
                        pJob.addStep(pStep);
                        this.m_log.info(bundle.getString("JobParser.Parse.EndStep.txt"));
                        this.m_log.info("");
                        sbAccumulateCode = new StringBuilder();
                        sbAccumulateComment = new StringBuilder();
                        sStepName = null;
                        sStepDesc = null;
                        sStepType = null;
                        pStep = new ParsedStep();
                        iState = 0;
                    }
                    if (iState == 0) {
                        iState = 2;
                    }
                    if (iState != 2) continue;
                    if (sBuffer.startsWith(STATEMENT_TABLE) && !sBuffer.endsWith(".INDEX */")) {
                        pStep.addTable(sBuffer);
                        continue;
                    }
                    if (sBuffer.startsWith(STATEMENT_LIBNAME)) {
                        pStep.addLibrary(sBuffer);
                        continue;
                    }
                    if (sBuffer.startsWith(STATEMENT_CONCATMEM)) {
                        pStep.addConcatenatedLibraryMember(sBuffer);
                        continue;
                    }
                    if (sBuffer.startsWith(STATEMENT_COLUMN)) {
                        pStep.addColumn(sBuffer);
                        continue;
                    }
                    if (sBuffer.startsWith(STATEMENT_PROCNAME)) {
                        aTokens = sBuffer.split(" ");
                        sStepType = aTokens[3];
                        continue;
                    }
                    if (!sBuffer.startsWith(STATEMENT_SYSSCP)) continue;
                    aTokens = sBuffer.split(" ");
                    this.m_sysscp = aTokens[3];
                    continue;
                }
                if (iState == 2) {
                    iState = 3;
                }
                if (iState != 3) continue;
                sbAccumulateCode.append(sBuffer + "\n");
            }
        }
        catch (Exception e) {
            this.m_log.error(e);
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            this.m_result = SASCodeItem.Result.ERROR;
            return null;
        }
        return pJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createJob(ParsedJob pJob, String sJobName, String folderID, boolean bCreate) {
        IPersistableObject object;
        Iterator<IPersistableObject> iter;
        block16: {
            try {
                String sContainerID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getDefaultRepository().getFQID() : folderID;
                this.m_mdl = DesignTimeJobModel.createModelForNewJob((String)sContainerID);
                try {
                    this.m_omr = new OMRAdapter((IModel)this.m_mdl, Workspace.getMdFactory(), "SASCodeImporter");
                    IJob job = this.m_mdl.getJob();
                    job.setName(sJobName);
                    job.setDescription(bundle.getString("JobParser.JobDescription.txt"));
                    job.setDISVersion(Double.valueOf(Workspace.getWorkspace().getApplicationVersionNumber()));
                    this.m_targetFolder = this.m_mdl.getObjectFactory().createFolder(folderID);
                    this.m_targetFolder.loadFromOMR(this.m_omr);
                    job.setFolder(this.m_targetFolder);
                    job.setCollectStatistics(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(COLLECT_RUNTIME_STATISTICS_KEY, true));
                    job.setCollectTableStatistics(false);
                    this.m_lObjectsToPersist = new ArrayList<IPersistableObject>();
                    this.m_lWorkTablesToPersist = new ArrayList<IPersistableObject>();
                    pJob.createJob();
                    if (!bCreate) {
                        this.m_log.info("");
                        this.m_log.info(bundle.getString("JobParser.Create.AnalyzeOnly.txt"));
                        return true;
                    }
                    this.m_log.info("");
                    this.m_log.info(bundle.getString("JobParser.Create.StartWriteMetadata.txt"));
                    job.saveToOMR(this.m_omr);
                    iter = this.m_lObjectsToPersist.iterator();
                    break block16;
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                    this.m_log.error(e);
                    Workspace.getDefaultLogger().error((Object)e);
                    this.m_result = SASCodeItem.Result.ERROR;
                    boolean bl = false;
                    return bl;
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)e);
                    return true;
                }
                catch (Exception e) {
                    this.m_log.error(e);
                    Workspace.getDefaultLogger().error((Object)e);
                    this.m_result = SASCodeItem.Result.ERROR;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.m_omr.dispose();
                    this.m_mdl.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            return true;
        }
        while (iter.hasNext()) {
            SASLibrary mdoLib;
            String sName;
            String sValidName;
            object = iter.next();
            if ((object instanceof IPhysicalTable || object instanceof ILibrary) && !(sValidName = WsMetadataNameUtil.getValidName((String)(sName = object.getName()), (Tree)((Tree)this.m_mdl.getOMRObject((IPersistableObject)this.m_targetFolder, Workspace.getMdFactory())), (String)(object instanceof IPhysicalTable ? "Table" : "Library"))).equals(sName)) {
                object.setName(sValidName);
            }
            object.saveToOMR(this.m_omr);
            if (!(object instanceof ILibrary) || !(mdoLib = (SASLibrary)this.m_omr.acquireOMRObject(object.getID(), object.getOMRType())).getUsingPrototypes().isEmpty()) continue;
            String reposId = "A0000001." + object.getID().subSequence(0, object.getID().indexOf(".")).toString();
            mdoLib.setUsingPrototype((Root)this.getGenericEnginePrototype(reposId, this.m_omr.getOMRStore()));
        }
        Iterator<IPersistableObject> iterator = this.m_lWorkTablesToPersist.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.m_omr.save();
                this.m_log.info(bundle.getString("JobParser.Create.EndWriteMetadata.txt"));
                return true;
            }
            object = iterator.next();
            if (!object.isChanged()) continue;
            object.saveToOMR(this.m_omr);
        }
    }

    private String parseComment(String sBuffer) {
        int iStartIndex = sBuffer.indexOf(58) + 1;
        int iEndIndex = sBuffer.lastIndexOf("*/");
        return sBuffer.substring(iStartIndex, iEndIndex).trim();
    }

    private ILibrary findLibrary(ParsedLibrary pLibrary) throws RemoteException, MdException, ServiceException {
        if (!this.m_bRegisterWorkTables && pLibrary.m_sLibRef.equalsIgnoreCase("WORK")) {
            return null;
        }
        this.m_log.info(1, bundle.formatString("JobParser.Create.MatchLibrary.fmt", (Object)pLibrary));
        ILibrary library = this.findLibraryInModel(pLibrary);
        if (library != null) {
            return library;
        }
        library = this.findLibraryOnServer(pLibrary);
        if (library == null) {
            this.m_log.info(2, bundle.getString("JobParser.Create.NoMatches.txt"));
        }
        return library;
    }

    private ILibrary findLibraryInModel(ParsedLibrary pLibrary) throws MdException {
        IObject[] aObjects = this.m_mdl.getAllObjects();
        for (int i = 0; i < aObjects.length; ++i) {
            ILibrary library;
            if (!(aObjects[i] instanceof ILibrary) || !pLibrary.equals(library = (ILibrary)aObjects[i])) continue;
            this.m_log.info(2, bundle.formatString("JobParser.Create.MatchLibraryModel.fmt", (Object)library.getSBIPUrl(false)));
            return library;
        }
        return null;
    }

    private ILibrary findLibraryOnServer(ParsedLibrary pLibrary) throws ServiceException, RemoteException, MdException {
        LibraryFilter filter = new LibraryFilter();
        filter.setLibref(pLibrary.m_sLibRef);
        filter.setSchemaName(pLibrary.m_sSchemaName);
        List lLibraries = this.m_server.browseSearch((FilterInterface)filter);
        if (!lLibraries.isEmpty()) {
            if (lLibraries.size() > 1) {
                this.m_log.warn(2, bundle.getString("JobParser.Create.MatchLibraryMultipleWarning.txt"));
            }
            BrowseMetadataInterface browseObject = (BrowseMetadataInterface)lLibraries.get(0);
            ILibrary library = this.m_mdl.getObjectFactory().createLibrary(browseObject.getReposId());
            library.loadFromOMR(this.m_omr);
            library.setName(browseObject.getName());
            library.setChanged(false);
            this.m_log.info(2, bundle.formatString("JobParser.Create.MatchLibraryServer.fmt", (Object)library.getSBIPUrl(false)));
            ++this.m_iLibrariesMatched;
            BrowseLibrary browseLibrary = new BrowseLibrary(browseObject);
            if (!pLibrary.equals(browseLibrary)) {
                this.m_log.warn(2, bundle.getString("JobParser.Create.MatchLibraryPathWarning.txt"));
            }
            return library;
        }
        return null;
    }

    private IPhysicalTable findTable(ParsedTable pTable) throws MdException, RemoteException, ServiceException {
        this.m_log.info(1, bundle.formatString("JobParser.Create.MatchTable.fmt", (Object)pTable));
        IPhysicalTable table = this.findTableInModel(pTable);
        if (table != null) {
            return table;
        }
        if (pTable.m_sLibRef.equals("WORK")) {
            return null;
        }
        table = this.findTableOnServer(pTable);
        if (table == null) {
            this.m_log.info(2, bundle.getString("JobParser.Create.NoMatches.txt"));
        }
        return table;
    }

    private IPhysicalTable findTableInModel(ParsedTable pTable) throws MdException {
        IObject[] aObjects = this.m_mdl.getAllObjects();
        for (int i = 0; i < aObjects.length; ++i) {
            IPhysicalTable table;
            if (!(aObjects[i] instanceof IPhysicalTable) || !pTable.equals(table = (IPhysicalTable)aObjects[i])) continue;
            this.m_log.info(2, bundle.formatString("JobParser.Create.MatchTableModel.fmt", (Object)table.getSBIPUrl(false)));
            return table;
        }
        return null;
    }

    private IPhysicalTable findTableOnServer(ParsedTable pTable) throws ServiceException, RemoteException, MdException {
        TableFilter filter = new TableFilter();
        filter.setName(pTable.m_sName);
        filter.setLibref(pTable.m_sLibRef);
        filter.setDBMSTable(pTable.isDBMSTable());
        List lTables = this.m_server.browseSearch((FilterInterface)filter);
        boolean bTablesFound = !lTables.isEmpty();
        Iterator iter = lTables.iterator();
        while (iter.hasNext()) {
            BrowseTable browseTable = new BrowseTable((BrowseMetadataInterface)iter.next());
            if (pTable.equals(browseTable)) continue;
            iter.remove();
        }
        if (!lTables.isEmpty()) {
            if (lTables.size() > 1) {
                this.m_log.warn(2, bundle.getString("JobParser.Create.MatchTableMultipleWarning.txt"));
            }
            BrowseMetadataInterface browseObject = (BrowseMetadataInterface)lTables.get(0);
            IPhysicalTable table = this.m_mdl.getObjectFactory().createPhysicalTable(browseObject.getReposId());
            table.loadFromOMR(this.m_omr);
            table.setName(browseObject.getName());
            table.setChanged(false);
            this.m_log.info(2, bundle.formatString("JobParser.Create.MatchTableServer.fmt", (Object)table.getSBIPUrl(false)));
            ++this.m_iTablesMatched;
            return table;
        }
        if (bTablesFound) {
            this.m_log.warn(2, bundle.getString("JobParser.Create.MatchTableColumnWarning.txt"));
        }
        return null;
    }

    private String getUniqueNameInJob(String sOrigName, Class objectType) {
        String sUniqueName = sOrigName;
        int iCounter = 2;
        int MAX_NAME_LENGTH = 60;
        while (!this.isNameUniqueInJob(sUniqueName, objectType)) {
            sUniqueName = sOrigName + iCounter;
            if (sUniqueName.length() > 60) {
                int iEndIndex = sOrigName.length() - (sUniqueName.length() - 60);
                sUniqueName = sOrigName.substring(0, iEndIndex) + iCounter;
            }
            ++iCounter;
        }
        return sUniqueName;
    }

    private boolean isNameUniqueInJob(String sName, Class objectType) {
        for (IPersistableObject object : this.m_lObjectsToPersist) {
            IComplexPersistableObject complexObject;
            if (!objectType.equals(object.getClass()) || !(object instanceof IComplexPersistableObject) || !sName.equals((complexObject = (IComplexPersistableObject)object).getName()) || !this.m_targetFolder.equals((Object)complexObject.getFolder())) continue;
            return false;
        }
        return true;
    }

    public ParseLogger getParseLog() {
        return this.m_log;
    }

    public SASCodeItem.Result getParseResult() {
        return this.m_result;
    }

    private class ParsedTable {
        ParsedStep m_pStep;
        String m_sName;
        String m_sTableRef;
        String m_sLibRef;
        String m_sInputOrOutput;
        String m_sType;
        List<ParsedColumn> m_lColumns;

        ParsedTable(String sBuffer, ParsedStep pStep) {
            this.m_pStep = pStep;
            String[] aTokens = sBuffer.split(" ");
            this.m_sInputOrOutput = aTokens[3];
            this.m_sTableRef = aTokens[5];
            String[] aTableTokens = this.m_sTableRef.split("\\.");
            this.m_sLibRef = aTableTokens[0];
            this.m_sName = aTableTokens[1];
            this.m_sType = aTableTokens[2];
            this.m_lColumns = new ArrayList<ParsedColumn>();
        }

        public String toString() {
            return this.m_sLibRef + "." + this.m_sName;
        }

        boolean isInput() {
            return !this.m_sInputOrOutput.equals("OUTPUT");
        }

        boolean isOutput() {
            return !this.m_sInputOrOutput.equals("INPUT");
        }

        boolean isView() {
            return this.m_sType.equals("VIEW");
        }

        boolean isWorkTable() {
            return this.m_sLibRef.equals("WORK");
        }

        boolean isDBMSTable() {
            if (this.isWorkTable()) {
                return false;
            }
            ParsedLibrary library = this.m_pStep.m_mLibraries.get(this.m_sLibRef);
            return library != null && library.isDBMSLibrary();
        }

        void addColumn(ParsedColumn column) {
            for (int i = 0; i < this.m_lColumns.size(); ++i) {
                if (!this.m_lColumns.get((int)i).m_sName.equals(column.m_sName)) continue;
                return;
            }
            this.m_lColumns.add(column);
        }

        boolean equals(IPhysicalTable table) {
            try {
                if (!this.m_sName.equals(table.getSASTableName()) || !this.m_sLibRef.equalsIgnoreCase(table.getLibref(null)) || this.isView() != table.isView()) {
                    return false;
                }
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                return false;
            }
            if (this.m_lColumns.size() != table.getColumnCount()) {
                return false;
            }
            IColumn[] aColumns = table.getColumns();
            for (int i = 0; i < aColumns.length; ++i) {
                if (this.containsMatchingColumn(aColumns[i])) continue;
                return false;
            }
            return true;
        }

        boolean equals(BrowseTable table) {
            BrowseColumn[] aColumns = table.getColumns();
            if (this.m_lColumns.size() != aColumns.length) {
                return false;
            }
            for (int i = 0; i < aColumns.length; ++i) {
                if (this.containsMatchingColumn(aColumns[i])) continue;
                return false;
            }
            return true;
        }

        public int hashcode() {
            return super.hashCode();
        }

        boolean containsMatchingColumn(IColumn column) {
            for (ParsedColumn localColumn : this.m_lColumns) {
                if (!localColumn.equals(column)) continue;
                return true;
            }
            return false;
        }

        boolean containsMatchingColumn(BrowseColumn column) {
            for (ParsedColumn localColumn : this.m_lColumns) {
                if (!localColumn.equals(column)) continue;
                return true;
            }
            return false;
        }

        IPhysicalTable createTable() throws RemoteException, ServiceException, MdException {
            IPhysicalTable table;
            if (this.m_sType.equals("UTILITY")) {
                return null;
            }
            if (this.m_sLibRef.startsWith("#")) {
                this.m_sLibRef = this.m_pStep.m_mConcatenatedMembers.get(this.m_sLibRef);
                this.m_sTableRef = this.m_sLibRef + "." + this.m_sName + "." + this.m_sType;
            }
            if ((table = JobParser.this.findTable(this)) == null) {
                if (!JobParser.this.m_bRegisterWorkTables && this.m_sLibRef.equals("WORK")) {
                    JobParser.this.m_log.info(2, bundle.formatString("JobParser.Create.WorkTable.fmt", (Object)this.m_sName));
                    JobParser.this.m_iTablesCreated++;
                    table = JobParser.this.m_mdl.getObjectFactory().createNewWorkTable(JobParser.this.m_mdl.getJob().getID());
                    table.setName(this.m_sName);
                    table.setSASTableName(this.m_sName);
                    JobParser.this.m_lWorkTablesToPersist.add(table);
                } else {
                    ILibrary library = null;
                    ParsedLibrary pLibrary = this.m_pStep.m_mLibraries.get(this.m_sLibRef);
                    if (pLibrary != null) {
                        library = JobParser.this.findLibrary(pLibrary);
                    }
                    String sContainerID = library != null ? library.getID() : JobParser.this.m_targetFolder.getID();
                    table = JobParser.this.m_mdl.getObjectFactory().createNewPhysicalTable(sContainerID);
                    table.setSASTableName(this.m_sName);
                    table.setName(JobParser.this.getUniqueNameInJob(this.m_sName, table.getClass()));
                    table.setFolder(JobParser.this.m_targetFolder);
                    JobParser.this.m_log.info(2, bundle.formatString("JobParser.Create.Table.fmt", (Object)table.getSBIPUrl(false)));
                    JobParser.this.m_iTablesCreated++;
                    table.setView(this.m_sType.equals("VIEW"));
                    if (library != null) {
                        table.setLibrary(library);
                    }
                    JobParser.this.m_lObjectsToPersist.add(table);
                }
                for (ParsedColumn pColumn : this.m_lColumns) {
                    IColumn column = pColumn.createColumn(table.getID());
                    table.addColumn(column);
                }
            }
            return table;
        }
    }

    private class ParsedLibrary {
        String m_sLibRef;
        String m_sEngine;
        List<String> m_lPaths;
        String m_sSchemaName;
        boolean m_bConcatenatedMember;

        ParsedLibrary(String sBuffer) {
            String[] aTokens = sBuffer.split(" ");
            int iIndex = 3;
            this.m_sLibRef = aTokens[iIndex++];
            if (this.m_sLibRef.startsWith("#")) {
                this.m_bConcatenatedMember = true;
                return;
            }
            if (aTokens[iIndex].equals("")) {
                ++iIndex;
            }
            if (!aTokens[iIndex].startsWith("'") && !aTokens[iIndex].startsWith("\"")) {
                this.m_sEngine = aTokens[iIndex++];
            }
            if (aTokens[iIndex].equals("'(")) {
                int n = ++iIndex;
                ++iIndex;
                String sPaths = aTokens[n];
                while (!aTokens[iIndex].equals(")'")) {
                    sPaths = sPaths + " " + aTokens[iIndex++];
                }
                this.m_lPaths = this.getConcatenatedPaths(sPaths);
            } else if (aTokens[iIndex].startsWith("'") || aTokens[iIndex].startsWith("\"")) {
                String quote = Character.toString(aTokens[iIndex].charAt(0));
                String sPath = aTokens[iIndex++];
                while (!sPath.endsWith(quote)) {
                    sPath = sPath + " " + aTokens[iIndex++];
                }
                this.m_lPaths = new ArrayList<String>(1);
                this.m_lPaths.add(this.stripQuotes(sPath));
            } else if (this.m_sEngine.equalsIgnoreCase("V9")) {
                String sPath = aTokens[iIndex++];
                while (!aTokens[iIndex].equals("*/")) {
                    sPath = sPath + " " + aTokens[iIndex++];
                }
                this.m_lPaths = new ArrayList<String>(1);
                this.m_lPaths.add(this.stripQuotes(sPath));
            }
            String sRegex = "schema\\s*=\\s*(['\"]?\\w*['\"])";
            Pattern pattern = Pattern.compile(sRegex, 2);
            Matcher matcher = pattern.matcher(sBuffer);
            if (matcher.find()) {
                String InitialSchemaName = matcher.group(1);
                this.m_sSchemaName = InitialSchemaName.replaceAll("\"", "");
            }
        }

        private String stripQuotes(String sPath) {
            if (sPath != null && sPath.length() > 0) {
                if (sPath.startsWith("'") || sPath.startsWith("\"")) {
                    sPath = sPath.substring(1);
                }
                if (sPath.endsWith("'") || sPath.endsWith("\"")) {
                    sPath = sPath.substring(0, sPath.length() - 1);
                }
            }
            return sPath;
        }

        private List<String> getConcatenatedPaths(String sPaths) {
            ArrayList<String> lPaths = new ArrayList<String>();
            String[] aTokens = sPaths.split(" ");
            int iIndex = 0;
            while (iIndex < aTokens.length) {
                String sPath = aTokens[iIndex++];
                String quote = sPath.substring(0, 1);
                while (!sPath.endsWith(quote)) {
                    sPath = sPath + " " + aTokens[iIndex++];
                }
                lPaths.add(this.stripQuotes(sPath));
            }
            return lPaths;
        }

        public String toString() {
            return this.m_sLibRef;
        }

        boolean isDBMSLibrary() {
            if (this.m_sEngine == null) {
                return false;
            }
            return !"BASE".equalsIgnoreCase(this.m_sEngine) && !"SASIOSR3".equalsIgnoreCase(this.m_sEngine) && !"SPDE".equalsIgnoreCase(this.m_sEngine) && !"TAPE".equalsIgnoreCase(this.m_sEngine) && !"V6".equalsIgnoreCase(this.m_sEngine) && !"V7".equalsIgnoreCase(this.m_sEngine) && !"V701".equalsIgnoreCase(this.m_sEngine) && !"V8".equalsIgnoreCase(this.m_sEngine) && !"V9".equalsIgnoreCase(this.m_sEngine) && !"XML".equalsIgnoreCase(this.m_sEngine) && !"XMLV2".equalsIgnoreCase(this.m_sEngine);
        }

        boolean equals(ILibrary library) {
            if (!this.m_sLibRef.equals(library.getLibref())) {
                return false;
            }
            if (this.m_lPaths != null) {
                IDirectory[] aDirectories = library.getDirectories();
                if (this.m_lPaths.size() != aDirectories.length) {
                    return false;
                }
                for (IDirectory directory : aDirectories) {
                    if (this.m_lPaths.contains(directory.getDirectoryName())) continue;
                    return false;
                }
            }
            return true;
        }

        boolean equals(BrowseLibrary library) {
            if (this.m_lPaths != null) {
                String[] aPaths = library.getPaths();
                if (this.m_lPaths.size() != aPaths.length) {
                    return false;
                }
                for (String path : aPaths) {
                    if (this.m_lPaths.contains(path)) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashcode() {
            return super.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ILibrary createLibrary() throws RemoteException, MdException, ServiceException {
            if (this.m_bConcatenatedMember) {
                return null;
            }
            if (!JobParser.this.m_bRegisterWorkTables && this.m_sLibRef.equalsIgnoreCase("WORK")) {
                return null;
            }
            ILibrary library = JobParser.this.findLibrary(this);
            if (library == null) {
                library = JobParser.this.m_mdl.getObjectFactory().createNewLibrary(JobParser.this.m_targetFolder.getID());
                library.setName(JobParser.this.getUniqueNameInJob(this.m_sLibRef, library.getClass()));
                library.setLibref(this.m_sLibRef);
                library.setFolder(JobParser.this.m_targetFolder);
                JobParser.this.m_log.info(2, bundle.formatString("JobParser.Create.Library.fmt", (Object)library.getSBIPUrl(false)));
                JobParser.this.m_iLibrariesCreated++;
                if (this.m_sEngine != null) {
                    library.setEngine(this.m_sEngine);
                }
                if (this.m_sLibRef.equalsIgnoreCase("SASHELP") || this.m_sLibRef.equalsIgnoreCase("WORK")) {
                    library.setIsPreAssigned(true);
                }
                if (this.isDBMSLibrary()) {
                    IDatabaseSchema schema = JobParser.this.m_mdl.getObjectFactory().createNewDatabaseSchema(JobParser.this.m_targetFolder.getID());
                    if (this.m_sSchemaName != null) {
                        schema.setName(this.m_sSchemaName);
                        schema.setSchemaName(this.m_sSchemaName);
                    } else {
                        schema.setName(library.getName() + "Schema");
                    }
                    library.setDatabaseSchema(schema);
                    library.setIsDBMSLibname(true);
                    IServer server = JobParser.this.m_mdl.getObjectFactory().createServer(JobParser.this.m_mdl.createIDForNewObject(schema.getID()));
                    server.setOMRType("ServerComponent");
                    server.setServiceType("DBMS Server");
                    server.setName("Server: " + library.getName());
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "JobParser");
                    try {
                        String reposId = "A0000001." + library.getID().subSequence(0, library.getID().indexOf(".")).toString();
                        Prototype proto = null;
                        proto = this.getPrototype("ServerComponent", this.getClassID(library), reposId, store);
                        if (proto != null) {
                            this.setAttributesFromPrototype(library, server, proto, store, this.getClassID(library), reposId);
                        } else {
                            library.setDatabaseSchema(null);
                            library.setIsDBMSLibname(false);
                            server = null;
                        }
                    }
                    finally {
                        if (store != null) {
                            store.dispose();
                        }
                    }
                    if (server != null) {
                        schema.setServer(server);
                        JobParser.this.m_lObjectsToPersist.add(server);
                        JobParser.this.m_lObjectsToPersist.add(schema);
                    }
                }
                JobParser.this.m_lObjectsToPersist.add(library);
                if (this.m_lPaths != null && library.getDBMSType() instanceof SASType) {
                    for (String sPath : this.m_lPaths) {
                        IDirectory directory = JobParser.this.m_mdl.getObjectFactory().createNewDirectory(library.getID());
                        directory.setName("Path");
                        directory.setDirectoryName(sPath);
                        directory.setDirectoryRole("LibraryPath");
                        library.addDirectory(directory);
                    }
                }
            }
            return library;
        }

        private void setAttributesFromPrototype(ILibrary library, IServer server, Prototype proto, MdObjectStore store, String id, String reposId) throws RemoteException, MdException {
            PropertyGroup primary = proto.getPrimaryPropertyGroup();
            List modifiedPropertiesList = PrototypeUtil.getAllPropertiesRecursive((PropertyGroup)primary);
            for (int i = 0; i < modifiedPropertiesList.size(); ++i) {
                AssociationProperty assocProp;
                AbstractProperty property = (AbstractProperty)modifiedPropertiesList.get(i);
                if (property instanceof AttributeProperty) {
                    AttributeProperty ap = (AttributeProperty)property;
                    String name = ap.getPropertyName();
                    String strDefaultValue = ap.getDefaultValue();
                    if ("ProductName".equals(name)) {
                        server.setProductName(strDefaultValue);
                        continue;
                    }
                    if ("ClassIdentifier".equals(name)) {
                        server.setClassIdentifier(strDefaultValue);
                        continue;
                    }
                    if ("Vendor".equals(name)) {
                        server.setVendor(strDefaultValue);
                        continue;
                    }
                    if ("Major".equals(name)) {
                        server.setMajor(Integer.parseInt(strDefaultValue));
                        continue;
                    }
                    if ("Minor".equals(name)) {
                        server.setMinor(Integer.parseInt(strDefaultValue));
                        continue;
                    }
                    if (!"SoftwareVersion".equals(name)) continue;
                    server.setSoftwareVersion(strDefaultValue);
                    continue;
                }
                if (!(property instanceof AssociationProperty) || !"SourceConnections".equals((assocProp = (AssociationProperty)property).getAssociationName())) continue;
                AssociationList protos = assocProp.getAssociatedPrototypes();
                for (int j = 0; j < protos.size(); ++j) {
                    Prototype p = (Prototype)protos.get(j);
                    if (!"SASClientConnection".equals(p.getMetadataType())) continue;
                    ISASClientConnection connection = server.getModel().getObjectFactory().createSASClientConnection(server.getModel().createIDForNewObject(server.getID()));
                    connection.setName("Connection: " + library.getName());
                    server.addClientConnection((IConnection)connection);
                    library.setLibraryConnection(connection);
                    PropertyGroup group = p.getPrimaryPropertyGroup();
                    if (group != null) {
                        List props = PrototypeUtil.getAllPropertiesRecursive((PropertyGroup)group);
                        for (int k = 0; k < props.size(); ++k) {
                            AbstractProperty prop = (AbstractProperty)props.get(k);
                            if (!(prop instanceof AttributeProperty)) continue;
                            AttributeProperty aP = (AttributeProperty)prop;
                            String propName = aP.getPropertyName();
                            if ("CommunicationProtocol".equals(propName)) {
                                connection.setCommunicationProtocol(aP.getDefaultValue());
                                continue;
                            }
                            if ("ApplicationProtocol".equals(propName)) {
                                connection.setApplicationProtocol(aP.getDefaultValue());
                                continue;
                            }
                            if (!"AuthenticationType".equals(propName)) continue;
                            connection.setAuthenticationType(aP.getDefaultValue());
                        }
                    }
                    JobParser.this.m_lObjectsToPersist.add(connection);
                }
            }
        }

        private Prototype getPrototype(String strMetadataType, String strValue, String strContext, MdObjectStore objectStore) throws RemoteException, MdException {
            String strAssociation = "PrototypeProperties";
            String strAttribute = "ClassIdentifier";
            Prototype prototype = PrototypeUtil.getPrototypeByIdentifier((IOMI)Workspace.getWorkspace().getCMRHandle(), (String)strAssociation, (String)strAttribute, (String)strValue, (String)strContext, (String)strMetadataType, null, (MdStore)objectStore);
            return prototype;
        }

        private String getClassID(ILibrary library) {
            String strClassID = library.getEngine();
            if (strClassID.startsWith("REMOTE")) {
                strClassID = "SHARE";
            } else if (strClassID.equalsIgnoreCase("SASTS")) {
                strClassID = "e803e04b-aaf0-4c74-86a6-f7008aa702dc";
            } else if (strClassID.equalsIgnoreCase("DB2")) {
                strClassID = JobParser.this.m_sysscp != null && JobParser.this.m_sysscp.equalsIgnoreCase("OS") ? "DB2OS390" : "DB2UNXPC";
            }
            return strClassID;
        }
    }

    private class ParsedJob {
        private List<ParsedStep> m_lSteps = new ArrayList<ParsedStep>();

        ParsedJob() {
        }

        void addStep(ParsedStep step) {
            this.m_lSteps.add(step);
        }

        IJob createJob() throws RemoteException, ServiceException, MdException {
            IJob job = JobParser.this.m_mdl.getJob();
            JobParser.this.m_log.info(bundle.formatString("JobParser.Create.StartJob.fmt", (Object)job.getSBIPUrl(false)));
            for (ParsedStep pStep : this.m_lSteps) {
                IDataTransform step = pStep.createStep();
                job.getTransformsList().add(step);
            }
            job.addAllUnorderedTransformsToControlOrder();
            JobParser.this.m_log.info("");
            JobParser.this.m_log.info(bundle.getString("JobParser.Create.EndJob.txt"));
            return job;
        }
    }

    private class ParsedStep {
        String m_sStepName;
        String m_sStepDesc;
        String m_sStepType;
        String m_sCode;
        String m_sComment;
        Map<String, ParsedLibrary> m_mLibraries = new LinkedHashMap<String, ParsedLibrary>();
        Map<String, String> m_mConcatenatedMembers = new HashMap<String, String>();
        List<ParsedTable> m_lInputTables = new ArrayList<ParsedTable>();
        List<ParsedTable> m_lOutputTables = new ArrayList<ParsedTable>();

        ParsedStep() {
        }

        public String toString() {
            return this.m_sStepName;
        }

        void addLibrary(String sBuffer) {
            ParsedLibrary library = new ParsedLibrary(sBuffer);
            if (!library.m_bConcatenatedMember) {
                this.m_mLibraries.put(library.m_sLibRef, library);
                JobParser.this.m_log.info(bundle.formatString("JobParser.Parse.Library.fmt", (Object)library));
            }
        }

        void addConcatenatedLibraryMember(String sBuffer) {
            String[] aTokens = sBuffer.split(" ");
            String memberName = aTokens[3];
            String libref = aTokens[4];
            JobParser.this.m_log.info(bundle.formatString("JobParser.Parse.ConcatenatedMember.fmt", (Object)memberName, (Object)libref));
            this.m_mConcatenatedMembers.put(memberName, libref);
        }

        void addTable(String sBuffer) {
            ParsedTable table = new ParsedTable(sBuffer, this);
            JobParser.this.m_log.info(bundle.formatString("JobParser.Parse.Table.fmt", (Object)table));
            if (table.isInput() && this.findInputTable(table.m_sTableRef) == null) {
                this.m_lInputTables.add(table);
            }
            if (table.isOutput() && this.findOutputTable(table.m_sTableRef) == null) {
                this.m_lOutputTables.add(table);
            }
        }

        void addColumn(String sBuffer) {
            ParsedColumn column = new ParsedColumn(sBuffer, this);
            JobParser.this.m_log.info(bundle.formatString("JobParser.Parse.Column.fmt", (Object)column));
            ParsedTable table = this.findTable(column);
            if (table != null) {
                table.addColumn(column);
            }
        }

        ParsedTable findTable(ParsedColumn column) {
            return column.isInput() ? this.findInputTable(column.m_sTableRef) : this.findOutputTable(column.m_sTableRef);
        }

        ParsedTable findInputTable(String sTableRef) {
            for (ParsedTable table : this.m_lInputTables) {
                if (!table.m_sTableRef.equalsIgnoreCase(sTableRef)) continue;
                return table;
            }
            return null;
        }

        ParsedTable findOutputTable(String sTableRef) {
            for (ParsedTable table : this.m_lOutputTables) {
                if (!table.m_sTableRef.equalsIgnoreCase(sTableRef)) continue;
                return table;
            }
            return null;
        }

        IDataTransform createStep() throws RemoteException, ServiceException, MdException {
            IPhysicalTable table;
            int i;
            boolean sqltransform = false;
            IDataTransform transform = null;
            if ("SORT".equals(this.m_sStepType)) {
                transform = (IDataTransform)JobParser.this.m_mdl.getObjectFactory().createNewTransform(ObjectFactory.SORT_TRANSFORM, JobParser.this.m_mdl.getJob().getID());
            } else if ("SQL".equals(this.m_sStepType)) {
                if (this.m_lInputTables.size() == 1 && this.m_lOutputTables.size() == 1) {
                    transform = (IDataTransform)JobParser.this.m_mdl.getObjectFactory().createNewTransform(ObjectFactory.EXTRACT_TRANSFORM, JobParser.this.m_mdl.getJob().getID());
                } else if (this.m_lOutputTables.size() == 1) {
                    transform = (IDataTransform)JobParser.this.m_mdl.getObjectFactory().createNewTransform(ObjectFactory.SQL_TRANSFORM, JobParser.this.m_mdl.getJob().getID());
                    sqltransform = true;
                }
            }
            if (transform == null) {
                transform = (IDataTransform)JobParser.this.m_mdl.getObjectFactory().createNewTransform(ObjectFactory.USER_WRITTEN_TRANSFORM, JobParser.this.m_mdl.getJob().getID());
            }
            if (this.m_sStepName != null) {
                transform.setName(this.m_sStepName);
            } else {
                transform.setName(this.m_sStepType);
            }
            JobParser.this.m_log.info("");
            JobParser.this.m_log.info(bundle.formatString("JobParser.Create.Step.fmt", (Object)transform.getName()));
            JobParser.this.m_iStepsCreated++;
            if (this.m_sStepDesc != null) {
                transform.setDescription(this.m_sStepDesc);
            }
            if (this.m_sComment != null) {
                transform.setPrivateNote(this.m_sComment);
            }
            transform.setGenerateDISHeaderAndFooters(true);
            ICodeFragment code = JobParser.this.m_mdl.getObjectFactory().createNewCodeFragment(transform.getID());
            code.setName(bundle.getString("JobParser.CodeFragmentName.txt"));
            try {
                code.setCode(this.m_sCode);
            }
            catch (ServerException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            transform.setUseUserWrittenCode(true);
            transform.setUserWrittenCode((ICodeSource)code);
            for (ParsedLibrary pLibrary : this.m_mLibraries.values()) {
                pLibrary.createLibrary();
            }
            List lDataObjects = JobParser.this.m_mdl.getJob().getDataObjectsList();
            for (i = 0; i < this.m_lInputTables.size(); ++i) {
                table = this.m_lInputTables.get(i).createTable();
                if (table == null) continue;
                try {
                    if (!sqltransform) {
                        transform.addDataSource((IDataObject)table);
                    } else {
                        ((SQLJoinTransformModel)transform).addInput();
                        ((SQLJoinTransformModel)transform).addAliasedDataSource(i + 1, (IDataObject)table, "");
                    }
                    if (table instanceof IWorkTable || lDataObjects.contains(table)) continue;
                    lDataObjects.add(table);
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            for (i = 0; i < this.m_lOutputTables.size(); ++i) {
                table = this.m_lOutputTables.get(i).createTable();
                if (table == null) continue;
                try {
                    transform.addDataTarget((IDataObject)table);
                    if (table instanceof IWorkTable || lDataObjects.contains(table)) continue;
                    lDataObjects.add(table);
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            transform.mapColumns();
            return transform;
        }
    }

    private class LibraryFilter
    extends Filter {
        private String m_sLibref;
        private String m_sSchemaName;

        LibraryFilter() {
            this.setOMRTemplate("<Templates><SASLibrary Name=\"\"><UsingPackages/></SASLibrary><Directory DirectoryName=\"\"/></Templates>");
            this.setOMRFlags(-2147475068);
        }

        public String getOMRType() {
            return "SASLibrary";
        }

        void setLibref(String sLibref) {
            this.m_sLibref = sLibref;
        }

        void setSchemaName(String sSchemaName) {
            this.m_sSchemaName = sSchemaName;
        }

        public String getXMLSelectString() {
            String baseSelect = this.component2Select(this._component);
            StringBuilder sbBuffer = new StringBuilder(128);
            String sLibref = this.m_sLibref;
            String sSchemaName = this.m_sSchemaName;
            if (sLibref != null || baseSelect.length() > 0) {
                sbBuffer.append("<XMLSelect Search=\"SASLibrary");
                if (sLibref != null) {
                    sbBuffer.append("[@Libref='" + sLibref + "']");
                }
                if (sSchemaName != null) {
                    sbBuffer.append("[UsingPackages/DatabaseSchema[@SchemaName='" + sSchemaName + "']]");
                }
                sbBuffer.append("\" />\n");
            }
            return sbBuffer.toString();
        }
    }

    private class BrowseLibrary {
        private BrowseMetadataInterface m_browseLibrary;

        BrowseLibrary(BrowseMetadataInterface browseLibrary) {
            this.m_browseLibrary = browseLibrary;
        }

        String[] getPaths() {
            List lUsingPackages = (List)this.m_browseLibrary.get("UsingPackages");
            if (lUsingPackages != null) {
                ArrayList<String> lPaths = new ArrayList<String>(lUsingPackages.size());
                for (BrowseMetadataInterface browseObject : lUsingPackages) {
                    if (!browseObject.getNativeType().equals("Directory")) continue;
                    lPaths.add((String)browseObject.get("DirectoryName"));
                }
                return lPaths.toArray(new String[lPaths.size()]);
            }
            return new String[0];
        }
    }

    private class TableFilter
    extends PhysicalTableFilter {
        private boolean m_bDBMSTable;

        TableFilter() {
            this.setOMRTemplate("<Templates><PhysicalTable ><Columns/></PhysicalTable><Column SASColumnName=\"\" SASColumnType=\"\" SASColumnLength=\"\" Desc=\"\" SASFormat=\"\" SASInformat=\"\"/></Templates>");
            this.setOMRFlags(-2147475068);
        }

        void setDBMSTable(boolean bDBMSTable) {
            this.m_bDBMSTable = bDBMSTable;
        }

        public String getXMLSelectString() {
            String baseSelect = this.component2Select(this._component);
            StringBuilder sbBuffer = new StringBuilder(128);
            String sName = this.getName();
            String sLibRef = this.getLibref();
            if (sName != null || baseSelect.length() > 0) {
                sbBuffer.append("<XMLSelect Search=\"PhysicalTable");
                if (sName != null) {
                    sbBuffer.append("[@SASTableName='" + XMLUtil.normalize((String)sName) + "']");
                }
                if (sLibRef != null) {
                    if (this.m_bDBMSTable) {
                        sbBuffer.append("[TablePackage/DatabaseSchema/UsedByPackages/SASLibrary[@LibRef='" + sLibRef + "']]\"");
                    } else {
                        sbBuffer.append("[TablePackage/SASLibrary[@LibRef='" + sLibRef + "']]\"");
                    }
                }
                sbBuffer.append(" />\n");
            }
            return sbBuffer.toString();
        }
    }

    private class BrowseTable {
        private BrowseMetadataInterface m_browseTable;

        BrowseTable(BrowseMetadataInterface browseTable) {
            this.m_browseTable = browseTable;
        }

        BrowseColumn[] getColumns() {
            List lColumns = (List)this.m_browseTable.get("Columns");
            if (lColumns != null) {
                BrowseColumn[] aColumns = new BrowseColumn[lColumns.size()];
                for (int i = 0; i < lColumns.size(); ++i) {
                    BrowseMetadataInterface browseObject = (BrowseMetadataInterface)lColumns.get(i);
                    aColumns[i] = new BrowseColumn(browseObject);
                }
                return aColumns;
            }
            return new BrowseColumn[0];
        }
    }

    private class BrowseColumn {
        String m_sName;
        String m_sDesc;
        String m_sFormat;
        String m_sInformat;
        int m_iType;
        int m_iLength;

        BrowseColumn(BrowseMetadataInterface browseColumn) {
            this.m_sName = (String)browseColumn.get("SASColumnName");
            this.m_sDesc = (String)browseColumn.get("Desc");
            this.m_sFormat = (String)browseColumn.get("SASFormat");
            this.m_sInformat = (String)browseColumn.get("SASInformat");
            String sType = (String)browseColumn.get("SASColumnType");
            this.m_iType = sType.equals("N") ? 1 : 0;
            String sLength = (String)browseColumn.get("SASColumnLength");
            this.m_iLength = Integer.parseInt(sLength);
        }
    }

    private class ParsedColumn {
        String m_sTableRef;
        String m_sInputOrOutput;
        String m_sName;
        String m_sType;
        String m_sLength;
        String m_sDesc;
        String m_sFormat;
        String m_sInformat;
        String m_sLibRef;
        String m_sTableName;
        int m_iType;
        int m_iLength;

        ParsedColumn(String sBuffer, ParsedStep pStep) {
            String sRegex = "JOBSPLIT: ATTR (.*?) (INPUT|OUTPUT) VARIABLE:(.*?) TYPE:(CHARACTER|NUMERIC) LENGTH:(.*?) LABEL:(.*?) FORMAT:(.*?) INFORMAT:(.*?) \\*/";
            Pattern pattern = Pattern.compile(sRegex, 32);
            Matcher matcher = pattern.matcher(sBuffer);
            matcher.find();
            this.m_sTableRef = matcher.group(1);
            this.m_sInputOrOutput = matcher.group(2);
            this.m_sName = matcher.group(3);
            this.m_sType = matcher.group(4);
            this.m_sLength = matcher.group(5);
            this.m_sDesc = matcher.group(6);
            this.m_sFormat = matcher.group(7);
            this.m_sInformat = matcher.group(8);
            String[] aTokens = this.m_sTableRef.split("\\.");
            this.m_sLibRef = aTokens[0];
            this.m_sTableName = aTokens[1];
            this.m_iType = this.m_sType.equals("NUMERIC") ? 1 : 0;
            this.m_iLength = Integer.parseInt(this.m_sLength);
        }

        public String toString() {
            return this.m_sLibRef + "." + this.m_sTableName + "." + this.m_sName;
        }

        boolean isInput() {
            return this.m_sInputOrOutput.equals("INPUT");
        }

        boolean equals(IColumn column) {
            return this.m_sName.equals(column.getName()) && this.m_iType == column.getType() && this.m_iLength == column.getLength() && this.m_sDesc.equals(column.getDescription()) && this.m_sFormat.equals(column.getFormat()) && this.m_sInformat.equals(column.getInformat());
        }

        boolean equals(BrowseColumn column) {
            return this.m_sName.equals(column.m_sName) && this.m_iType == column.m_iType && this.m_iLength == column.m_iLength && this.m_sDesc.equals(column.m_sDesc) && this.m_sFormat.equals(column.m_sFormat) && this.m_sInformat.equals(column.m_sInformat);
        }

        public int hashcode() {
            return super.hashCode();
        }

        IColumn createColumn(String sContainerID) throws RemoteException, ServiceException, MdException {
            JobParser.this.m_log.info(3, bundle.formatString("JobParser.Create.Column.fmt", (Object)this.m_sName));
            JobParser.this.m_iColumnsCreated++;
            IColumn column = JobParser.this.m_mdl.getObjectFactory().createNewColumn(sContainerID);
            column.setName(this.m_sName);
            column.setType(this.m_iType);
            column.setLength(this.m_iLength);
            column.setDescription(this.m_sDesc);
            column.setFormat(this.m_sFormat);
            column.setInformat(this.m_sInformat);
            return column;
        }
    }
}

