/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.sascodeimporter;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.wadmin.sascodeimporter.JobParser;
import com.sas.wadmin.sascodeimporter.SASCodeItem;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class AnalyzeCode {
    private static final WAdminResource bundle = WAdminResource.getBundle(AnalyzeCode.class);
    private SASCodeItem m_item;
    private WsAppServer m_wsAppServer;
    private OpRequestUI m_request;
    private StringBuilder m_strAnalyzedCode;
    private static String FILEREF = "DISRFILE";
    private PathUrl m_path;

    public AnalyzeCode(WsAppServer server, SASCodeItem item, OpRequestUI request) {
        this.m_item = item;
        this.m_wsAppServer = server;
        this.m_request = request;
    }

    public AnalyzeCode(SASCodeItem item) {
        this.m_item = item;
    }

    public void setPathUrl(PathUrl pathUrl) {
        this.m_path = pathUrl;
    }

    protected boolean isImportingFiles() {
        return this.m_item._action == SASCodeItem.Action.IMPORT;
    }

    protected boolean isAnalyzingFiles() {
        return this.m_item._action == SASCodeItem.Action.ANALYZE;
    }

    public StringBuilder getAnalyzedCode() {
        return this.m_strAnalyzedCode;
    }

    public String getAnalyzedFileName() {
        return this.getFileNameNoExtension() + ".sca";
    }

    public String getAnalyzedLogName() {
        return this.getFileNameNoExtension() + ".log";
    }

    private String getFileNameNoExtension() {
        return this.m_item._fileName.substring(0, this.m_item._fileName.lastIndexOf(46));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAnalyze() throws IOException, WsAppServerFailException, WsAppServerCodeException, GenericError {
        this.m_request.displayMessage(bundle.formatString("AnalyzeCode.ConvertStatus.fmt", (Object)this.m_item._fileName));
        StringBuilder contents = new StringBuilder();
        File file = new File(this.m_item._fileName);
        try (BufferedReader input = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        String analyzedFile = null;
        if (this.m_item.needsConversion()) {
            if (this.m_wsAppServer == null) {
                throw new IllegalStateException("AnalyzeCode.runAnalyze: AppServer must not be null");
            }
            IFileService fileService = this.m_wsAppServer.getFileService();
            try {
                IFileref test = null;
                try {
                    test = fileService.UseFileref(FILEREF);
                    if (test != null) {
                        test.DeleteFile();
                    }
                }
                catch (Exception e) {
                    Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                StringBuilder code = new StringBuilder();
                code.append((CharSequence)this.getProcStart(this.m_item._expandMacros)).append((CharSequence)contents).append((CharSequence)this.getProcEnd());
                this.m_wsAppServer.submitSASCode(code.toString(), false);
                IFileref fileRef = fileService.UseFileref(FILEREF);
                analyzedFile = this.m_wsAppServer.readFile(fileRef, "");
                BufferedWriter output = new BufferedWriter(new FileWriter(this.getAnalyzedFileName()));
                output.write(analyzedFile);
                output.close();
                Workspace.getDefaultLogger().debug((Object)analyzedFile);
            }
            catch (IOException logWriter) {
            }
            finally {
                this.m_item._convertLog = this.m_wsAppServer.getLogBuffer().toString();
                try (BufferedWriter logWriter = null;){
                    logWriter = new BufferedWriter(new FileWriter(this.getAnalyzedLogName()));
                    logWriter.write(this.m_item._convertLog);
                }
                this.m_wsAppServer.closeFileService();
            }
        } else {
            analyzedFile = contents.toString();
        }
        String statusMsg = this.m_item._action == SASCodeItem.Action.IMPORT ? bundle.formatString("AnalyzeCode.ImportStatus.fmt", (Object)this.m_item._fileName) : bundle.formatString("AnalyzeCode.AnalyzeStatus.fmt", (Object)this.m_item._fileName);
        this.m_request.displayMessage(statusMsg);
        try {
            ChildServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
            try {
                JobParser jobParser = new JobParser(contents.toString(), analyzedFile, (ServerInterface)server, this.m_item._registerWorkTables);
                MetadataInterface folder = server.getObjectByPath(this.m_path);
                String sName = file.getName();
                sName = sName.substring(0, sName.lastIndexOf(46));
                sName = bundle.formatString("AnalyzeCode.JobName.fmt", (Object)sName);
                sName = WsMetadataNameUtil.getValidName((String)sName, (Tree)((Tree)folder.getRepositoryEntity()), (String)"Job");
                if (this.m_item._action == SASCodeItem.Action.IMPORT) {
                    jobParser.parseAndCreateJob(sName, folder.getIdentifier());
                } else {
                    jobParser.parseAndAnalyzeJob(sName, folder.getIdentifier());
                }
                this.m_item._parseLog = jobParser.getParseLog().toString();
                this.m_item._parseResult = jobParser.getParseResult();
            }
            finally {
                server.rollback();
            }
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
    }

    private StringBuilder getProcStart(boolean expandMacros) {
        StringBuilder preCode = new StringBuilder();
        preCode.append("filename ").append(FILEREF).append(" temp;\n");
        preCode.append("proc scaproc; record ").append(FILEREF).append(" ATTR");
        if (expandMacros) {
            preCode.append(" expandmacros");
        }
        preCode.append("; run;\n\n");
        return preCode;
    }

    private StringBuilder getProcEnd() {
        return new StringBuilder("proc scaproc; write; run;\n");
    }
}

