/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.run;

import com.sas.editor.LogListHolder;
import com.sas.etl.models.ILogParsingObject;
import com.sas.etl.models.IObject;
import com.sas.wadmin.jobeditor.LogParser;
import com.sas.wadmin.run.IResults;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RunResults
implements IResults {
    private static WAdminResource bundle = WAdminResource.getBundle(RunResults.class);
    public static final int SUCCESSFUL = 0;
    public static final int WARNINGS = 1;
    public static final int ERRORS = 2;
    public static final int STOPPED = 3;
    public static final int ABORTED = 4;
    public static final int CPRSKIPPED = 5;
    public static final String CPRSKIPPED_TAG = "CPR_SKIPPED:";
    public static final String ERRORS_TAG = bundle.getString("RunResults.Error.txt") + ":";
    public static final String WARNINGS_TAG = bundle.getString("RunResults.Warning.txt") + ":";
    public static final String ERRORS_TAG2 = bundle.getString("RunResults.Error.txt") + " ";
    public static final String WARNINGS_TAG2 = bundle.getString("RunResults.Warning.txt") + " ";
    public static final String DETAILS_TAG = "ETLS_DIAG";
    public static final String BEGIN_DIS_ARM_TAG = "_DISARM";
    public static final String END_DIS_ARM_TAG = "_ENDDISARM";
    public static final String DIS_ARM_REGISTER_TAG = "REGISTER";
    public static final String DIS_ARM_PROC_TAG = bundle.getString("RunResults.Note.txt") + ": PROCEDURE";
    public static final String DIS_ARM_DISARM_TAG = bundle.getString("RunResults.Note.txt") + ": _DISARM";
    public static final String DIS_ARM_PROC = "PROCEDURE";
    private LogListHolder m_log;
    private LogListHolder m_output;
    private long m_timeStart;
    private long m_timeStop;
    private int m_eStatus;
    private int m_iLogLength;
    private String[] m_aWarnings;
    private String[] m_aErrors;
    private String[] m_aWarningsAndErrors;
    private String[] m_aDetails;
    private String[] m_aArmMessages;
    private String[] m_aArmProcMessages;
    private List m_lArmProcSegmentMessages;
    private boolean m_bLogParsed;
    private boolean m_bCPRSkipped;
    private IObject m_object;
    private boolean m_bArmTrans;
    private boolean m_ignoreArmMessage = false;
    private String m_sPushDown;
    private String m_sPushDownDBMSType;
    private int[] m_aWarningsStartLineNumbers;
    private int[] m_aWarningsStartIndexes;
    private int[] m_aWarningsEndIndexes;
    private int[] m_aErrorsStartLineNumbers;
    private int[] m_aErrorsStartIndexes;
    private int[] m_aErrorsEndIndexes;
    private int[] m_aWarningsAndErrorsStartLineNumbers;
    private int[] m_aWarningsAndErrorsStartIndexes;
    private int[] m_aWarningsAndErrorsEndIndexes;
    private String s_messageExpression;
    private static String[] DEFAULT_TAGS = new String[]{ERRORS_TAG, ERRORS_TAG2, WARNINGS_TAG, WARNINGS_TAG2, "ETLS_DIAG", "_DISARM", "_ENDDISARM", "CPR_SKIPPED:"};

    public RunResults() {
        if (this.s_messageExpression == null) {
            this.s_messageExpression = this.getMessageExpression(Arrays.asList(DEFAULT_TAGS));
        }
    }

    private String getMessageExpression(List<String> tags) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s).*(");
        for (String tag : tags) {
            sb.append(tag);
            sb.append('|');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(").*");
        return sb.toString();
    }

    public void setLog(LogListHolder log) {
        this.m_log = log;
        this.m_bLogParsed = false;
        this.m_eStatus = 0;
        this.m_aWarnings = new String[0];
        this.m_aErrors = new String[0];
        this.m_aDetails = new String[0];
    }

    @Override
    public LogListHolder getLog() {
        return this.m_log;
    }

    public void setOutput(LogListHolder output) {
        this.m_output = output;
    }

    @Override
    public LogListHolder getOutput() {
        return this.m_output;
    }

    public void setStatus(int eStatus) {
        this.m_eStatus = eStatus;
    }

    public int getStatus() {
        return this.m_eStatus;
    }

    public String getPushDownDBMSType() {
        return this.m_sPushDownDBMSType;
    }

    public void setPushDownDBMSType(String sPushDownDBMSType) {
        this.m_sPushDownDBMSType = sPushDownDBMSType;
    }

    public String getPushDown() {
        return this.m_sPushDown;
    }

    public void setPushDown(String sPushDown) {
        this.m_sPushDown = sPushDown;
    }

    public void setStartTime(long timeStart) {
        this.m_timeStart = timeStart;
    }

    public long getStartTime() {
        return this.m_timeStart;
    }

    public void setStopTime(long timeStop) {
        this.m_timeStop = timeStop;
    }

    public long getStopTime() {
        return this.m_timeStop;
    }

    public int getLogLength() {
        return this.m_iLogLength;
    }

    public String[] getWarnings() {
        return this.m_aWarnings;
    }

    public int[] getWarningsStartLineNumbers() {
        return this.m_aWarningsStartLineNumbers;
    }

    public int[] getWarningsStartIndexes() {
        return this.m_aWarningsStartIndexes;
    }

    public int[] getWarningsEndIndexes() {
        return this.m_aWarningsEndIndexes;
    }

    public String[] getErrors() {
        return this.m_aErrors;
    }

    public int[] getErrorsStartLineNumbers() {
        return this.m_aErrorsStartLineNumbers;
    }

    public int[] getErrorsStartIndexes() {
        return this.m_aErrorsStartIndexes;
    }

    public int[] getErrorsEndIndexes() {
        return this.m_aErrorsEndIndexes;
    }

    public String[] getWarningsAndErrors() {
        return this.m_aWarningsAndErrors;
    }

    public int[] getWarningsAndErrorsStartLineNumbers() {
        return this.m_aWarningsAndErrorsStartLineNumbers;
    }

    public int[] getWarningsAndErrorsStartIndexes() {
        return this.m_aWarningsAndErrorsStartIndexes;
    }

    public int[] getWarningsAndErrorsEndIndexes() {
        return this.m_aWarningsAndErrorsEndIndexes;
    }

    public String[] getDetails() {
        return this.m_aDetails;
    }

    public String[] getARMMessages() {
        return this.m_aArmMessages;
    }

    public String[] getARMProcMessages() {
        return this.m_aArmProcMessages;
    }

    public List getArmProcSegmentMessages() {
        return this.m_lArmProcSegmentMessages;
    }

    public void setModelObject(IObject object) {
        this.m_object = object;
        if (this.m_object instanceof ILogParsingObject) {
            ILogParsingObject logParser = (ILogParsingObject)this.getModelObject();
            List logParsingTags = logParser.getTags();
            ArrayList<String> parseTags = new ArrayList<String>(Arrays.asList(DEFAULT_TAGS));
            if (logParsingTags != null) {
                parseTags.addAll(logParsingTags);
            }
            this.s_messageExpression = this.getMessageExpression(parseTags);
        }
    }

    @Override
    public IObject getModelObject() {
        return this.m_object;
    }

    public void parseLog() {
        if (this.m_bLogParsed) {
            return;
        }
        String[] messages = LogParser.parse(this.s_messageExpression, this.m_log != null ? this.m_log.getLineArray() : new String[]{});
        int[] aMessageStartLineNumbers = LogParser.getStartLineNumbers();
        int[] aMessageStartIndexes = LogParser.getStartIndexes();
        int[] aMessageEndIndexes = LogParser.getEndIndexes();
        ArrayList<String> errorsList = new ArrayList<String>();
        ArrayList<String> warningsList = new ArrayList<String>();
        ArrayList<String> warningsAndErrorsList = new ArrayList<String>();
        ArrayList<String> detailsList = new ArrayList<String>();
        ArrayList<String> armList = new ArrayList<String>();
        ArrayList<String> armProcList = new ArrayList<String>();
        ArrayList<String[]> armProcSegmentList = new ArrayList<String[]>();
        ArrayList<Integer> errorsStartLineNumbersList = new ArrayList<Integer>();
        ArrayList<Integer> errorsStartIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> errorsEndIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsStartLineNumbersList = new ArrayList<Integer>();
        ArrayList<Integer> warningsStartIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsEndIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsAndErrorsStartLineNumbersList = new ArrayList<Integer>();
        ArrayList<Integer> warningsAndErrorsStartIndexesList = new ArrayList<Integer>();
        ArrayList<Integer> warningsAndErrorsEndIndexesList = new ArrayList<Integer>();
        boolean bCPRSkipped = false;
        List logParsingTags = null;
        if (this.m_object instanceof ILogParsingObject) {
            ILogParsingObject logParser = (ILogParsingObject)this.getModelObject();
            logParsingTags = logParser.getTags();
            logParser.clearExistingMatchingLines();
        }
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i].indexOf(CPRSKIPPED_TAG) == 0) {
                bCPRSkipped = true;
            }
            if ((messages[i].indexOf(ERRORS_TAG) == 0 || messages[i].indexOf(ERRORS_TAG2) == 0 || messages[i].indexOf("DB2 ERROR:") == 0) && messages[i].indexOf("ERRORCHECK") != 0 && messages[i].indexOf("ERRORS=") != 0) {
                errorsList.add(messages[i]);
                errorsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                errorsStartIndexesList.add(aMessageStartIndexes[i]);
                errorsEndIndexesList.add(aMessageEndIndexes[i]);
                warningsAndErrorsList.add(messages[i]);
                warningsAndErrorsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                warningsAndErrorsStartIndexesList.add(aMessageStartIndexes[i]);
                warningsAndErrorsEndIndexesList.add(aMessageEndIndexes[i]);
                continue;
            }
            if ((messages[i].indexOf(WARNINGS_TAG) == 0 || messages[i].indexOf(WARNINGS_TAG2) == 0 || messages[i].indexOf("DB2 WARNING:") == 0) && messages[i].indexOf("WARNING%QUOTE(:)") != 0) {
                warningsList.add(messages[i]);
                warningsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                warningsStartIndexesList.add(aMessageStartIndexes[i]);
                warningsEndIndexesList.add(aMessageEndIndexes[i]);
                warningsAndErrorsList.add(messages[i]);
                warningsAndErrorsStartLineNumbersList.add(aMessageStartLineNumbers[i]);
                warningsAndErrorsStartIndexesList.add(aMessageStartIndexes[i]);
                warningsAndErrorsEndIndexesList.add(aMessageEndIndexes[i]);
                continue;
            }
            if (messages[i].indexOf(DETAILS_TAG) == 0) {
                detailsList.add(messages[i]);
                continue;
            }
            if (messages[i].indexOf(BEGIN_DIS_ARM_TAG) >= 0) {
                if (messages[i].indexOf(DIS_ARM_PROC) >= 0) {
                    this.m_ignoreArmMessage = false;
                    if (messages[i].indexOf(DIS_ARM_REGISTER_TAG) != -1) continue;
                    armProcList.add(messages[i]);
                    continue;
                }
                if (messages[i].indexOf(DIS_ARM_DISARM_TAG) >= 0) {
                    armList.add(messages[i]);
                    this.m_bArmTrans = true;
                    this.m_ignoreArmMessage = false;
                    if (armProcList.size() <= 0) continue;
                    armProcSegmentList.add(armProcList.toArray(new String[0]));
                    armProcList = new ArrayList();
                    continue;
                }
                this.m_ignoreArmMessage = true;
                continue;
            }
            if (messages[i].indexOf(END_DIS_ARM_TAG) >= 0) {
                if (this.isArmTransactionRecord()) {
                    armList.add(messages[i]);
                    armProcSegmentList.add(armProcList.toArray(new String[0]));
                    armProcList = new ArrayList();
                    continue;
                }
                if (this.m_ignoreArmMessage) continue;
                armProcList.add(messages[i]);
                continue;
            }
            if (logParsingTags == null || logParsingTags.size() <= 0) continue;
            ILogParsingObject lo = (ILogParsingObject)this.getModelObject();
            for (String tag : logParsingTags) {
                if (messages[i].indexOf(tag) < 0) continue;
                lo.addMatchingTagLine(messages[i]);
            }
        }
        this.m_iLogLength = LogParser.getParsedLength();
        this.m_bCPRSkipped = bCPRSkipped;
        this.m_aErrors = errorsList.toArray(new String[0]);
        this.m_aWarnings = warningsList.toArray(new String[0]);
        this.m_aWarningsAndErrors = warningsAndErrorsList.toArray(new String[0]);
        this.m_aDetails = detailsList.toArray(new String[0]);
        this.m_aArmMessages = armList.toArray(new String[0]);
        if (this.m_aArmMessages.length > 0) {
            this.m_lArmProcSegmentMessages = armProcSegmentList;
        }
        this.m_aWarningsStartLineNumbers = LogParser.convertToIntArray(warningsStartLineNumbersList);
        this.m_aWarningsStartIndexes = LogParser.convertToIntArray(warningsStartIndexesList);
        this.m_aWarningsEndIndexes = LogParser.convertToIntArray(warningsEndIndexesList);
        this.m_aErrorsStartLineNumbers = LogParser.convertToIntArray(errorsStartLineNumbersList);
        this.m_aErrorsStartIndexes = LogParser.convertToIntArray(errorsStartIndexesList);
        this.m_aErrorsEndIndexes = LogParser.convertToIntArray(errorsEndIndexesList);
        this.m_aWarningsAndErrorsStartLineNumbers = LogParser.convertToIntArray(warningsAndErrorsStartLineNumbersList);
        this.m_aWarningsAndErrorsStartIndexes = LogParser.convertToIntArray(warningsAndErrorsStartIndexesList);
        this.m_aWarningsAndErrorsEndIndexes = LogParser.convertToIntArray(warningsAndErrorsEndIndexesList);
        if (this.m_eStatus != 4) {
            this.m_eStatus = this.m_aErrors.length > 0 ? 2 : (this.m_aWarnings.length > 0 ? 1 : (this.m_bCPRSkipped ? 5 : 0));
        }
        this.m_bLogParsed = true;
    }

    private boolean isArmTransactionRecord() {
        return this.m_bArmTrans;
    }
}

