/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.visuals;

import com.sas.wadmin.reports.ReportingController;
import com.sas.wadmin.reports.jobdoc.md.GlobalProperties;
import com.sas.wadmin.reports.jobdoc.visuals.DirectorySelectorDialog;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class JobDocPanel
extends WAPanel {
    private static WAdminResource bundle = new WAdminResource(JobDocPanel.class);
    private JCheckBox m_chkUseDefault = null;
    private WATextField m_txtLayout = null;
    private JCheckBox m_chkIncludeAll = null;
    private JButton m_btnBrowse;
    private WsAbstractAction m_actBrowse;
    private ReportingController m_controller;

    public JobDocPanel(ReportingController controller) {
        this.m_controller = controller;
        GlobalProperties.instance().setCalledFromConsole(false);
        GlobalProperties.instance().setHostname(Workspace.getWorkspace().getServerName());
        GlobalProperties.instance().setUsername(Workspace.getWorkspace().getUsername());
        Date d = new Date();
        GlobalProperties.instance().setDate(DateFormat.getDateInstance(1).format(d));
        GlobalProperties.instance().setDatetime(DateFormat.getDateTimeInstance(1, 1).format(d));
        this.setHelpProduct("wdb");
        this.setHelpTopic("reports_options_job");
        this.initialize();
    }

    protected void initialize() {
        this.m_chkUseDefault = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"JobDocPanel.UseDefault", (int)5);
        this.m_chkUseDefault.setSelected(true);
        this.m_chkUseDefault.addActionListener(new cUseDefaultListener());
        this.m_txtLayout = new WATextField();
        this.m_txtLayout.setEditable(false);
        this.m_actBrowse = new BrowseAction();
        this.m_btnBrowse = new JButton((Action)this.m_actBrowse);
        this.m_btnBrowse.setEnabled(false);
        this.m_chkIncludeAll = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"JobDocPanel.IncludeAll", (int)5);
        this.m_chkIncludeAll.setSelected(true);
        this.setLayout(new GridBagLayout());
        this.add(this.m_chkUseDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_txtLayout, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnBrowse, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_chkIncludeAll, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    protected void doShowFileSelectorDialog(WATextField txt) {
        DirectorySelectorDialog fsd = new DirectorySelectorDialog((Component)((Object)this), txt.getText());
        if (fsd.showSelectDialog()) {
            txt.setText(fsd.getFilePath());
        }
    }

    public boolean isDefaultLayout() {
        return this.m_chkUseDefault.isSelected();
    }

    public String getTemplateDirectory() {
        return this.m_txtLayout.getText();
    }

    public boolean isAllTables() {
        return this.m_chkIncludeAll.isSelected();
    }

    private class cUseDefaultListener
    implements ActionListener {
        private cUseDefaultListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!JobDocPanel.this.m_chkUseDefault.isSelected()) {
                JobDocPanel.this.m_txtLayout.setEditable(true);
                JobDocPanel.this.m_btnBrowse.setEnabled(true);
                GlobalProperties.instance().setTemplatedirectory(JobDocPanel.this.isDefaultLayout() ? "" : "" + JobDocPanel.this.getTemplateDirectory());
            } else {
                JobDocPanel.this.m_txtLayout.setEditable(false);
                JobDocPanel.this.m_btnBrowse.setEnabled(false);
                GlobalProperties.instance().setTemplatedirectory(JobDocPanel.this.isDefaultLayout() ? "" : "" + JobDocPanel.this.getTemplateDirectory());
            }
        }
    }

    private class BrowseAction
    extends WsAbstractAction {
        public BrowseAction() {
            super(bundle, "JobDocPanel.Action.Browse", 0);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JobDocPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                JobDocPanel.this.doShowFileSelectorDialog(JobDocPanel.this.m_txtLayout);
            }
            finally {
                JobDocPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

