/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.parser;

import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.parser.BaseChunk;
import com.sas.wadmin.reports.jobdoc.parser.Constants;
import com.sas.wadmin.reports.jobdoc.parser.HTMLGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;

public class HTMLInterpreter {
    public void run(PrintStream out, String srcdir, String file) {
        try {
            String s = this.readFile(srcdir, file);
            BaseChunk root = this.parse(s);
            root.write(out);
        }
        catch (IOException e) {
            PluginLogger.log("##### HTMLInterpreter.run(): " + PluginLogger.getStackTrace(e));
        }
    }

    private BaseChunk parse(String fileContents) {
        BaseChunk root;
        int count = 0;
        int pos = -1;
        while ((pos = fileContents.indexOf("<%=", pos + 1)) != -1) {
            ++count;
        }
        int[][] tagbounds = new int[count][2];
        count = 0;
        pos = -1;
        while ((pos = fileContents.indexOf("<%=", pos + 1)) != -1) {
            tagbounds[count++][0] = pos;
        }
        count = 0;
        pos = -1;
        while ((pos = fileContents.indexOf("%>", pos + 1)) != -1) {
            tagbounds[count++][1] = pos + "%>".length();
        }
        BaseChunk base = root = BaseChunk.createRootChunk();
        int lastpos = 0;
        for (int i = 0; i < tagbounds.length; ++i) {
            BaseChunk tc0 = BaseChunk.createChunk(fileContents.substring(lastpos, tagbounds[i][0]));
            BaseChunk tc1 = BaseChunk.createChunk(fileContents.substring(tagbounds[i][0], tagbounds[i][1]));
            lastpos = tagbounds[i][1];
            if (!tc0.isEmpty()) {
                if (tc0.endsSubGroup()) {
                    base = base.getParent();
                }
                base.addChunk(tc0);
                if (tc0.opensSubGroup()) {
                    base = tc0;
                }
            }
            if (tc1.isEmpty()) continue;
            if (tc1.endsSubGroup()) {
                base = base.getParent();
            }
            base.addChunk(tc1);
            if (!tc1.opensSubGroup()) continue;
            base = tc1;
        }
        BaseChunk tc0 = BaseChunk.createChunk(fileContents.substring(lastpos, fileContents.length()));
        base.addChunk(tc0);
        return root;
    }

    private String readFile(String dir, String file) throws IOException {
        BufferedReader br = HTMLGenerator.createReader(dir, file);
        StringBuffer page = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            page.append(line + Constants.SEP);
        }
        br.close();
        return page.toString();
    }
}

