/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.parser;

import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.parser.AccessorChunk;
import com.sas.wadmin.reports.jobdoc.parser.EndChunk;
import com.sas.wadmin.reports.jobdoc.parser.EndIfChunk;
import com.sas.wadmin.reports.jobdoc.parser.ForeachChunk;
import com.sas.wadmin.reports.jobdoc.parser.IfChunk;
import com.sas.wadmin.reports.jobdoc.parser.PlainTextChunk;
import com.sas.wadmin.reports.jobdoc.parser.RootChunk;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class BaseChunk {
    protected ArrayList chunks = new ArrayList();
    protected String contents = null;
    protected int chunkType = 0;
    protected boolean startsSubGroup = false;
    protected boolean endsSubGroup = false;
    protected boolean isEmpty = false;
    protected BaseChunk parent = null;

    public abstract void write(PrintStream var1);

    protected abstract Object getCurrentListObject(String var1);

    protected abstract ArrayList findObjectList(String var1);

    public BaseChunk[] getChunks() {
        BaseChunk[] tc = new BaseChunk[this.chunks.size()];
        for (int i = 0; i < this.chunks.size(); ++i) {
            tc[i] = (BaseChunk)this.chunks.get(i);
        }
        return tc;
    }

    public void addChunk(BaseChunk tc) {
        if (tc.endsSubGroup()) {
            return;
        }
        tc.setParent(this);
        this.chunks.add(tc);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean opensSubGroup() {
        return this.startsSubGroup;
    }

    public boolean endsSubGroup() {
        return this.endsSubGroup;
    }

    public void setParent(BaseChunk chunk) {
        this.parent = chunk;
    }

    public BaseChunk getParent() {
        return this.parent;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
        this.isEmpty = !BaseChunk.ok(contents);
    }

    public int getChunkType() {
        return this.chunkType;
    }

    public void setChunkType(int chunkType) {
        this.chunkType = chunkType;
    }

    public static BaseChunk createRootChunk() {
        return new RootChunk();
    }

    public static BaseChunk createChunk(String s) {
        if (BaseChunk.startsWithNonEmpty(s, "<%=")) {
            s = BaseChunk.chopOffFromStart(s, "<%=");
            s = BaseChunk.chopOffToEnd(s, "%>");
            if ((s = s.trim()).toUpperCase().startsWith("IF")) {
                return new IfChunk(s);
            }
            if (s.toUpperCase().startsWith("FOREACH")) {
                return new ForeachChunk(s);
            }
            if (s.toUpperCase().equals("END")) {
                return new EndChunk(s);
            }
            if (s.toUpperCase().equals("ENDIF")) {
                return new EndIfChunk(s);
            }
            return new AccessorChunk(s);
        }
        return new PlainTextChunk(s);
    }

    public static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static String[] parseForeach(String s) {
        String[] rc = new String[2];
        int pos = 0;
        String[] split = s.split(" ");
        for (int i = 0; i < split.length; ++i) {
            if (!BaseChunk.ok(split[i])) continue;
            if (pos == 1) {
                rc[0] = split[i];
            }
            if (pos == 3) {
                rc[1] = split[i];
            }
            ++pos;
        }
        return rc;
    }

    public static String[] parseIf(String s) {
        String[] rc = new String[3];
        int pos = 0;
        String[] split = s.split(" ");
        for (int i = 0; i < split.length; ++i) {
            if (!BaseChunk.ok(split[i])) continue;
            if (pos == 1) {
                rc[0] = split[i];
            }
            if (pos == 2) {
                rc[1] = split[i];
            }
            if (pos == 3) {
                rc[2] = split[i];
            }
            ++pos;
        }
        return rc;
    }

    public static String[] parseAccessor(String s) {
        if (s.indexOf(".") == -1) {
            return new String[]{s};
        }
        String[] rc = s.split("\\.");
        return rc;
    }

    public static boolean startsWithNonEmpty(String s, String find) {
        int startpos;
        if (!BaseChunk.ok(s)) {
            return false;
        }
        for (startpos = 0; startpos < s.length() && Character.isWhitespace(s.charAt(startpos)); ++startpos) {
        }
        return s.substring(startpos).toUpperCase().startsWith(find.toUpperCase());
    }

    public static String chopOffToEnd(String s, String tag) {
        int startpos = s.lastIndexOf(tag);
        if (startpos == -1) {
            return s;
        }
        return s.substring(0, startpos);
    }

    public static String chopOffFromStart(String s, String tag) {
        int startpos = s.indexOf(tag);
        if (startpos == -1) {
            return s;
        }
        return s.substring(startpos + tag.length());
    }

    public static Object invokeMethod(Object wrapped, String meth) {
        try {
            Class<?> c = wrapped.getClass();
            Method[] theMethods = c.getMethods();
            String javaMethod = "";
            if (meth != null && meth.length() > 0) {
                javaMethod = "get" + meth.substring(0, 1).toUpperCase() + meth.substring(1, meth.length()).toLowerCase();
            }
            for (int i = 0; i < theMethods.length; ++i) {
                String methodString = theMethods[i].getName();
                if (!methodString.equals(javaMethod) && !methodString.equals(meth)) continue;
                return theMethods[i].invoke(wrapped, new Object[0]);
            }
        }
        catch (Exception e) {
            PluginLogger.log("##### BaseChunk.invokeMethod(): error trying to invoke " + meth + " on " + wrapped);
            PluginLogger.log("##### BaseChunk.invokeMethod(): error: " + PluginLogger.getStackTrace(e));
        }
        return null;
    }
}

