/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.md;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.DatabaseSchema;
import com.sas.metadata.Directory;
import com.sas.metadata.MdException;
import com.sas.metadata.Property;
import com.sas.metadata.SASLibrary;
import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.md.BaseMetadata;
import com.sas.wadmin.reports.jobdoc.md.ETLObjects;
import com.sas.wadmin.reports.jobdoc.md.TableMetadata;
import java.util.ArrayList;

public class LibraryMetadata
extends BaseMetadata {
    private String libname = null;
    private String ispreassigned = null;
    private String engine = null;
    private String libref = null;
    private String path = null;
    private String properties = null;
    private String[] tables = null;

    public LibraryMetadata(CMetadata cm) {
        super(cm.getRepositoryID(), cm.getName(), cm.getFQID(), cm.getDesc(), cm.getMetadataCreated(), cm.getMetadataUpdated());
        try {
            SASLibrary sl = (SASLibrary)cm;
            this.libref = sl.getLibref();
            this.ispreassigned = sl.getIsPreassigned() == 0 ? "false" : "true";
            this.engine = sl.getEngine();
            LibraryMetadata.collectIds(sl.getTrees(), this, "_setTreeId");
            LibraryMetadata.collectIds(sl.getNotes(), this, "_setNoteIds");
            LibraryMetadata.collectIds(sl.getResponsibleParties(), this, "_setResponsiblePartyIds");
            this.libname = "libname " + this.libref + " " + this.engine;
            AssociationList list = sl.getUsingPackages();
            if (list != null && list.size() > 0) {
                DatabaseSchema ds;
                if (list.get(0) instanceof Directory) {
                    Directory d = (Directory)list.get(0);
                    if (d != null) {
                        if (d.getDirectoryName() != null && d.getDirectoryName().length() > 0) {
                            this.path = d.getDirectoryName();
                        }
                        this.libname = this.libname + " \"" + this.path + "\"";
                    }
                } else if (list.get(0) instanceof DatabaseSchema && (ds = (DatabaseSchema)list.get(0)) != null && ds.getSchemaName() != null && ds.getSchemaName().length() > 0) {
                    this.path = "SCHEMA=" + ds.getSchemaName();
                    this.libname = this.libname + " " + this.path;
                }
            }
            if ((list = sl.getProperties()) != null && list.size() > 0) {
                this.properties = "";
                for (int i = 0; i < list.size(); ++i) {
                    Property p = (Property)list.get(i);
                    if (!p.getPropertyName().equals("OptionString")) {
                        this.properties = this.properties + p.getPropertyName() + "=";
                    }
                    this.properties = this.properties + p.getDefaultValue() + " ";
                }
                if (this.properties.length() > 0) {
                    this.libname = this.libname + " " + this.properties;
                }
            }
            this.libname = this.libname + ";";
        }
        catch (MdException e) {
            PluginLogger.log("##### LibraryMetadata.<init>: error: " + PluginLogger.getStackTrace(e));
        }
    }

    public String getProperties() {
        return this.properties;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getPath() {
        return this.path;
    }

    public String getIspreassigned() {
        return this.ispreassigned;
    }

    public String getLibname() {
        return this.libname;
    }

    public String getLibref() {
        return this.libref;
    }

    public ArrayList getTables() {
        if (this.tables == null || this.tables.length == 0) {
            return null;
        }
        ArrayList<TableMetadata> tablelist = new ArrayList<TableMetadata>();
        for (int i = 0; i < this.tables.length; ++i) {
            TableMetadata tm = (TableMetadata)ETLObjects.instance().locate(TableMetadata.class, this.tables[i]);
            tablelist.add(tm);
        }
        return tablelist;
    }

    public void setTable(String id) {
        if (this.tables == null) {
            this.tables = new String[1];
            this.tables[0] = id;
            return;
        }
        String[] tmp = new String[this.tables.length + 1];
        System.arraycopy(this.tables, 0, tmp, 0, this.tables.length);
        tmp[tmp.length - 1] = id;
        this.tables = tmp;
    }
}

