/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.impl;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.reports.AbstractReport;
import com.sas.wadmin.reports.ReportingController;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsServerRequest;
import java.rmi.RemoteException;

public class TestTableAnalysisReport
extends AbstractReport {
    public String getName() {
        return "Test Table Analysis";
    }

    public String getDescription() {
        return "Some type of description will go here";
    }

    @Override
    public String getCategory() {
        return "Table Analysis";
    }

    @Override
    public String getReportingClass() {
        return "com.sas.wadmin.reports.impl.TestTableAnalysisReport";
    }

    @Override
    public void onSelected() {
        try {
            String msg = "";
            Root obj = this.getDefaultMetadataObject();
            msg = obj != null ? "Metadata object received " + obj.getName() : "No metadata object was set for this report view.";
            MessageUtil.displayMessage((String)msg, (int)1);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public StringBuffer getSourceCode() {
        String sAdditionalOptions;
        SASCodeGeneration codeGen = new SASCodeGeneration();
        codeGen.addCommentLine("Creates an overview or summary report of all table in the server.");
        WsServerRequest svrRequest = ReportingController.getInstance().getServerRequest();
        WsAppServer appServer = svrRequest.getAppServer();
        try {
            codeGen.genMetadataMacrosAndOptions((CMetadata)appServer.getServerContext(), appServer.getServerContext(), true);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        codeGen.addSourceCode("filename request temp;\n\n");
        codeGen.addSourceCode("data _null_;\n");
        codeGen.indent(3);
        codeGen.addSourceCode("file request;\n");
        codeGen.addSourceCode("infile cards4;\n");
        codeGen.addSourceCode("length long $256;\n");
        codeGen.addSourceCode("input;\n");
        codeGen.addSourceCode("long=_infile_;\n");
        codeGen.addSourceCode("put long ' ';\n");
        codeGen.unIndent(3);
        codeGen.addSourceCode("cards4;\n");
        codeGen.addSourceCode("<GetMetadataObjects>\n");
        codeGen.addSourceCode("<ReposId>$METAREPOSITORY</ReposId>\n");
        codeGen.addSourceCode("<Type>PhysicalTable</Type>\n");
        codeGen.addSourceCode("<Objects/>\n");
        codeGen.addSourceCode("<ns>SAS</ns>\n");
        codeGen.addSourceCode("<Flags>260</Flags>\n");
        codeGen.addSourceCode("<Options>\n");
        codeGen.addSourceCode("<Templates>\n");
        codeGen.addSourceCode("<PhysicalTable Name=\"\" Desc=\"\" ChangeState=\"\" MetadataCreated=\"\" MetadataUpdated=\"\">\n");
        codeGen.addSourceCode("<Trees/> <ResponsibleParties/><TablePackage/></PhysicalTable>\n");
        codeGen.addSourceCode("<ResponsibleParty Name=\"\"/>\n");
        codeGen.addSourceCode("<SASLibrary Name=\"\"/>\n");
        codeGen.addSourceCode("<Tree Name=\"\"/>\n");
        codeGen.addSourceCode("<DatabaseSchema Name=\"\"/>\n");
        codeGen.addSourceCode("</Templates>\n");
        codeGen.addSourceCode("</Options>\n");
        codeGen.addSourceCode("</GetMetadataObjects>\n");
        codeGen.addSourceCode(";;;;\n");
        codeGen.addSourceCode("run;\n\n");
        codeGen.addCommentLine("Issue the request.");
        codeGen.addSourceCode("filename response temp lrecl=1024;\n\n");
        codeGen.addSourceCode("proc metadata in=request out=response;\n");
        codeGen.addSourceCode("run;\n\n");
        codeGen.addCommentLine("Build the XML Map file to parse the response.");
        codeGen.addSourceCode("filename map temp;\n\n");
        codeGen.addSourceCode("data _null_;\n");
        codeGen.indent(3);
        codeGen.addSourceCode("file map;\n");
        codeGen.addSourceCode("put '<?xml version=\"1.0\" ?>';\n");
        codeGen.addSourceCode("put '<SXLEMAP version=\"1.2\">';\n");
        codeGen.addSourceCode("put '<TABLE name=\"Tables\">';\n");
        codeGen.addSourceCode("put '<TABLE-PATH syntax=\"xpath\">/GetMetadataObjects/Objects/PhysicalTable</TABLE-PATH>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"Table\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable@Name</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>character</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>STRING</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>60</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"Description\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable@Desc</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>character</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>STRING</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>200</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"Created\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable@MetadataCreated</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>date</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>TIME</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>20</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"Modified\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable@MetadataUpdated</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>date</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>TIME</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>20</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"Owner\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable/ResponsibleParties/ResponsibleParty@Name</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>character</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>STRING</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>60</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"Schema\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable/TablePackage/DatabaseSchema@Name</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>character</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>STRING</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>60</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"Group\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable/Trees/Tree@Name</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>character</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>STRING</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>60</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '<COLUMN name=\"CheckedOut\" retain=\"YES\">';\n");
        codeGen.addSourceCode("put \"<PATH>/GetMetadataObjects/Objects/PhysicalTable@ChangeState</PATH>\";\n");
        codeGen.addSourceCode("put '<TYPE>character</TYPE>';\n");
        codeGen.addSourceCode("put '<DATATYPE>STRING</DATATYPE>';\n");
        codeGen.addSourceCode("put '<LENGTH>60</LENGTH>';\n");
        codeGen.addSourceCode("put '</COLUMN>';\n");
        codeGen.addSourceCode("put '</TABLE>';\n");
        codeGen.addSourceCode("put '</SXLEMAP>';\n");
        codeGen.unIndent(3);
        codeGen.addSourceCode("run;\n\n");
        codeGen.addCommentLine("Parse the response with the XML library engine and PROC SQL.");
        codeGen.addSourceCode("libname response xml xmlmap=map;\n\n");
        codeGen.addCommentLine("Create a HTML report for viewing the table.");
        codeGen.addSourceCode("filename myReport \"").addSourceCode(this.getURL()).addSourceCode("\";\n");
        String sformat = this.getODSFormatType();
        codeGen.addSourceCode("ods ").addSourceCode(sformat).addSourceCode(" file=myReport \n");
        String sStyleSheet = this.getODSStyleSheet();
        if (sformat.equals("html") && sStyleSheet != null && sStyleSheet.length() > 0) {
            codeGen.addSourceCode("stylesheet=(URL=\"file:").addSourceCode(sStyleSheet.trim()).addSourceCode("\") \n");
        }
        if ((sAdditionalOptions = this.getODSAdditionalOptions()) != null && sAdditionalOptions.length() > 0) {
            codeGen.addSourceCode(sAdditionalOptions).addSourceCode("\n");
        }
        codeGen.addSourceCode(";\n");
        codeGen.addSourceCode("title \"").addSourceCode(this.getName()).addSourceCode("\";\n\n");
        codeGen.addSourceCode("proc print data=response.tables;\n");
        codeGen.addSourceCode("run;\n\n");
        codeGen.addSourceCode("ods ").addSourceCode(this.getODSFormatType()).addSourceCode(" close;\n\n");
        codeGen.addCommentLine("Cleanup");
        codeGen.addSourceCode("filename request;\n");
        codeGen.addSourceCode("filename response;\n");
        codeGen.addSourceCode("filename map;\n");
        return codeGen.getSourceBuffer();
    }
}

