/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports;

import com.sas.metadata.remote.Root;
import com.sas.wadmin.plugins.ReportingInterface;
import com.sas.wadmin.reports.ODSOptionsPanel;
import com.sas.wadmin.reports.ReportingController;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsServerRequest;
import java.awt.Frame;
import javax.swing.Icon;

public abstract class AbstractReport
implements ReportingInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractReport.class);
    private String m_defaultPath;
    private String m_defaultFileName;
    private String m_ODSFormatType = "";
    private String m_ODSStyleSheet = "";
    private String m_ODSAdditonalOptions = "";
    private Root m_metadataObject;

    public Icon getIcon() {
        return null;
    }

    @Override
    public void setFileName(String filename) {
        this.m_defaultFileName = filename.trim();
    }

    @Override
    public String getFileName() {
        String sDefaultName = this.getName().replaceAll(" ", "").trim() + "." + this.getODSFormatType();
        if (this.m_defaultFileName == null) {
            this.m_defaultFileName = sDefaultName;
            return this.m_defaultFileName;
        }
        if (this.m_defaultFileName.length() > 0) {
            String extension;
            if (this.hasAnOptionsDialog() && (extension = this.getODSFormatType()).length() > 0) {
                int index = this.m_defaultFileName.lastIndexOf(".");
                String filename = "";
                if (index != -1) {
                    filename = this.m_defaultFileName.substring(0, index + 1);
                    this.m_defaultFileName = filename + extension;
                } else {
                    this.m_defaultFileName = this.m_defaultFileName + "." + extension;
                }
            }
            return this.m_defaultFileName;
        }
        this.m_defaultFileName = sDefaultName;
        return this.m_defaultFileName;
    }

    @Override
    public void setPath(String path) {
        this.m_defaultPath = path;
    }

    @Override
    public String getPath() {
        if (this.m_defaultPath == null) {
            return "";
        }
        if (this.m_defaultPath.length() != 0) {
            return this.m_defaultPath;
        }
        return "";
    }

    @Override
    public String getURL() {
        if (this.m_defaultPath == null) {
            this.m_defaultPath = "";
        }
        String sURL = this.m_defaultPath.trim();
        try {
            WsServerRequest svrRequest = new WsServerRequest(null);
            WsAppServer appServer = svrRequest.getAppServer();
            String strOS = appServer.getOperatingSystem();
            if (strOS.contains("WIN")) {
                if (!sURL.endsWith("\\")) {
                    sURL = sURL + "\\";
                }
            } else if (!sURL.endsWith("/")) {
                sURL = sURL + "/";
            }
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        sURL = sURL + this.getFileName().trim();
        return sURL;
    }

    @Override
    public void setDefaultMetadataObject(Root object) {
        this.m_metadataObject = object;
    }

    @Override
    public Root getDefaultMetadataObject() {
        return this.m_metadataObject;
    }

    public void initPlugin() {
    }

    @Override
    public boolean hasAnOptionsDialog() {
        return true;
    }

    @Override
    public boolean isReportRunnableInBatch() {
        return false;
    }

    @Override
    public void showOptionsDialog(ReportingController controller) {
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("AbstractReport.Options.Title.txt"), true);
        ODSOptionsPanel pnlOptions = new ODSOptionsPanel(controller);
        if (this.m_ODSFormatType.length() > 0) {
            pnlOptions.setODSFormat(this.m_ODSFormatType);
        }
        if (this.m_ODSStyleSheet.length() > 0) {
            pnlOptions.setODSStyle(this.m_ODSStyleSheet);
        }
        if (this.m_ODSAdditonalOptions.length() > 0) {
            pnlOptions.setODSOptions(this.m_ODSAdditonalOptions);
        }
        dialog.setMainPanel((WAPanel)pnlOptions);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            this.m_ODSFormatType = pnlOptions.getODSFormat();
            this.m_ODSStyleSheet = pnlOptions.getODSStyle();
            this.m_ODSAdditonalOptions = pnlOptions.getODSOptions();
        }
    }

    public void dispose() {
    }

    @Override
    public String getODSAdditionalOptions() {
        return this.m_ODSAdditonalOptions;
    }

    @Override
    public String getODSFormatType() {
        if (this.m_ODSFormatType == null || this.m_ODSFormatType.length() == 0) {
            this.m_ODSFormatType = "html";
        }
        return this.m_ODSFormatType;
    }

    @Override
    public String getODSStyleSheet() {
        return this.m_ODSStyleSheet;
    }

    @Override
    public void setODSAdditionalOptions(String addOptions) {
        this.m_ODSAdditonalOptions = addOptions;
    }

    @Override
    public void setODSFormatType(String type) {
        this.m_ODSFormatType = type;
    }

    @Override
    public void setODSStyleSheet(String cssFile) {
        this.m_ODSStyleSheet = cssFile;
    }

    @Override
    public boolean isFileNameFieldEditable() {
        return true;
    }

    @Override
    public boolean isLocalBrowse() {
        return false;
    }
}

