/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.visuals;

import com.sas.prompts.definitions.DataSourceColumnDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.util.UserInfoInterface;
import com.sas.wadmin.prompts.model.PromptTypesProvider;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class ColumnPromptTypesAndValuesPanel
extends BasePromptTypesAndValuesPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnPromptTypesAndValuesPanel.class);
    private static final boolean DEFAULT_EMIT_SQL_SYNTAX = false;
    private static final boolean DEFAULT_LIMIT_COLUMNS = false;
    private static final int DEFAULT_MINIMUM_COLUMNS = 0;
    private static final int COLUMNS_DISPLAYED = 6;
    private boolean m_bContentsValid;
    private DataSourceColumnDefinition m_prompt;
    private WAPanel m_pnlSelectColumnsFrom;
    private JRadioButton m_rbnSelectFromSource;
    private JRadioButton m_rbnSelectFromTarget;
    private ButtonGroup m_bgpSelectColumnsFrom;
    private WAPanel m_pnlColumnTypes;
    private JCheckBox m_ckbNumericColumns;
    private JCheckBox m_ckbCharacterColumns;
    private JCheckBox m_ckbTimeColumns;
    private JCheckBox m_ckbDateColumns;
    private JCheckBox m_ckbTimeStampColumns;
    private JCheckBox m_ckbLimitColumns;
    private JLabel m_lblMinColumns;
    private JLabel m_lblMaxColumns;
    private WAIntTextField m_txtMinColumns;
    private WAIntTextField m_txtMaxColumns;
    private JCheckBox m_ckbEmitSQLSyntax;
    private FocusListener m_lstMinValueChange;
    private PropertyChangeListener m_lstRequired;
    public static final String HELP_ID = "prompt_data_source_col";

    public ColumnPromptTypesAndValuesPanel(PropertiesCommunicator pc, PromptDefinitionInterface prompt) {
        super(pc);
        this.setHelpID(HELP_ID);
        this.setHelpProduct("wdb");
        this.m_prompt = (DataSourceColumnDefinition)prompt;
        pc.setNumberOfValuesEnabled(false);
        this.m_bContentsValid = true;
        this.createListeners();
        this.initialize();
        this.layoutWidgets();
        this.moveDataToView();
    }

    protected void initialize() {
        this.m_pnlSelectColumnsFrom = new WAPanel();
        this.m_pnlSelectColumnsFrom.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("ColumnPromptTypesAndValuesPanel.SelectFromLabel.txt")));
        this.m_rbnSelectFromSource = new JRadioButton(bundle.getString("ColumnPromptTypesAndValuesPanel.SelectFromSource.txt"));
        this.m_rbnSelectFromSource.setMnemonic(bundle.getString("ColumnPromptTypesAndValuesPanel.SelectFromSource.mnem").charAt(0));
        this.m_rbnSelectFromSource.setSelected(true);
        this.m_rbnSelectFromTarget = new JRadioButton(bundle.getString("ColumnPromptTypesAndValuesPanel.SelectFromTarget.txt"));
        this.m_rbnSelectFromTarget.setMnemonic(bundle.getString("ColumnPromptTypesAndValuesPanel.SelectFromTarget.mnem").charAt(0));
        this.m_bgpSelectColumnsFrom = new ButtonGroup();
        this.m_bgpSelectColumnsFrom.add(this.m_rbnSelectFromSource);
        this.m_bgpSelectColumnsFrom.add(this.m_rbnSelectFromTarget);
        this.m_pnlColumnTypes = new WAPanel();
        this.m_pnlColumnTypes.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("ColumnPromptTypesAndValuesPanel.ColumnTypesLabel.txt")));
        this.m_ckbCharacterColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ColumnPromptTypesAndValuesPanel.ColumnTypesCharacter");
        this.m_ckbNumericColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ColumnPromptTypesAndValuesPanel.ColumnTypesNumeric");
        this.m_ckbDateColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ColumnPromptTypesAndValuesPanel.ColumnTypesDate");
        this.m_ckbTimeColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ColumnPromptTypesAndValuesPanel.ColumnTypesTime");
        this.m_ckbTimeStampColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ColumnPromptTypesAndValuesPanel.ColumnTypesTimeStamp");
        this.m_ckbCharacterColumns.setSelected(true);
        this.m_ckbNumericColumns.setSelected(true);
        this.m_ckbDateColumns.setSelected(true);
        this.m_ckbTimeColumns.setSelected(true);
        this.m_ckbTimeStampColumns.setSelected(true);
        this.m_ckbLimitColumns = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new cLimitColumnsAction());
        this.m_txtMinColumns = new WAIntTextField(false);
        this.m_lblMinColumns = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtMinColumns, (String)bundle.getString("ColumnPromptTypesAndValuesPanel.MinColumns.txt"));
        this.m_txtMinColumns.setEnabled(false);
        this.m_txtMinColumns.setColumns(6);
        this.m_txtMinColumns.setValue(0);
        this.m_txtMinColumns.setAllowNegatives(false);
        this.m_txtMinColumns.addFocusListener(this.m_lstMinValueChange);
        this.m_txtMaxColumns = new WAIntTextField(false);
        this.m_lblMaxColumns = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtMaxColumns, (String)bundle.getString("ColumnPromptTypesAndValuesPanel.MaxColumns.txt"));
        this.m_txtMaxColumns.setEnabled(false);
        this.m_txtMaxColumns.setColumns(6);
        this.m_txtMaxColumns.setAllowNegatives(false);
        this.m_ckbEmitSQLSyntax = new JCheckBox(bundle.getString("ColumnPromptTypesAndValuesPanel.EmitSQLSyntax.txt"));
        this.m_ckbEmitSQLSyntax.setMnemonic(bundle.getString("ColumnPromptTypesAndValuesPanel.EmitSQLSyntax.mnem").charAt(0));
        this.m_ckbEmitSQLSyntax.setSelected(false);
    }

    private void createListeners() {
        this.m_lstMinValueChange = new cMinValueChanged();
        this.m_lstRequired = new cRequiredChanged();
        this.communicator.addPropertyChangeListener(this.m_lstRequired);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_pnlSelectColumnsFrom.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlColumnTypes.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlSelectColumnsFrom.add((Component)this.m_rbnSelectFromSource, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlSelectColumnsFrom.add((Component)this.m_rbnSelectFromTarget, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_pnlColumnTypes.add((Component)this.m_ckbCharacterColumns, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlColumnTypes.add((Component)this.m_ckbNumericColumns, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlColumnTypes.add((Component)this.m_ckbDateColumns, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlColumnTypes.add((Component)this.m_ckbTimeColumns, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlColumnTypes.add((Component)this.m_ckbTimeStampColumns, (Object)new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlSelectColumnsFrom, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlColumnTypes, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_ckbLimitColumns, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblMinColumns, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtMinColumns, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_lblMaxColumns, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtMaxColumns, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_ckbEmitSQLSyntax, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public PromptDefinitionInterface getPromptDefinition() {
        this.setContentsValid(true);
        DataSourceColumnDefinition definition = (DataSourceColumnDefinition)PromptUtility.newConfiguredPrompt((PropertiesCommunicator)this.communicator, (String)"DataSourceColumnDefinition");
        boolean valid = true;
        try {
            this.m_txtMinColumns.getValue2();
        }
        catch (WAIntTextField.IllegalIntegerException exc) {
            JOptionPane.showOptionDialog((Component)((Object)this), bundle.formatString("ColumnPromptTypesAndValuesPanel.IntegerException.Error.msg.txt", (Object)bundle.getString("ColumnPromptTypesAndValuesPanel.Minimum.txt")), ERROR_MESSAGE_DIALOG_TITLE, -1, 0, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
            this.m_txtMinColumns.setValue(0);
            this.m_txtMinColumns.requestFocus();
            valid = false;
        }
        if (!"".equals(this.m_txtMaxColumns.getText())) {
            try {
                this.m_txtMaxColumns.getValue2();
            }
            catch (WAIntTextField.IllegalIntegerException exc) {
                JOptionPane.showOptionDialog((Component)((Object)this), bundle.formatString("ColumnPromptTypesAndValuesPanel.IntegerException.Error.msg.txt", (Object)bundle.getString("ColumnPromptTypesAndValuesPanel.Maximum.txt")), ERROR_MESSAGE_DIALOG_TITLE, -1, 0, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                this.m_txtMaxColumns.setText("");
                this.m_txtMaxColumns.requestFocus();
                valid = false;
            }
        }
        long columnType = 0L;
        if (this.m_ckbNumericColumns.isSelected()) {
            columnType |= 2L;
        }
        if (this.m_ckbCharacterColumns.isSelected()) {
            columnType |= 1L;
        }
        if (this.m_ckbDateColumns.isSelected()) {
            columnType |= 4L;
        }
        if (this.m_ckbTimeColumns.isSelected()) {
            columnType |= 8L;
        }
        if (this.m_ckbTimeStampColumns.isSelected()) {
            columnType |= 0x10L;
        }
        if (columnType == 0L) {
            JOptionPane.showOptionDialog((Component)((Object)this), bundle.getString("ColumnPromptTypesAndValuesPanel.NoColumnTypesDefined.msg.txt"), ERROR_MESSAGE_DIALOG_TITLE, -1, 0, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
            valid = false;
        }
        definition.setAllowedColumnTypes(columnType);
        definition.setAllowedDataSourceTypes(new Long(1L).longValue());
        definition.setSelectionOrdered(true);
        if (this.m_ckbLimitColumns.isSelected()) {
            definition.addUserInfo("LimitColumns", "Yes");
            int minColumns = this.m_txtMinColumns.getValue();
            int maxColumns = this.m_txtMaxColumns.getValue();
            if (minColumns < 0 || maxColumns < 0 || maxColumns >= minColumns) {
                if (minColumns >= 0) {
                    definition.setMinimumValueCount(minColumns);
                }
                if (maxColumns >= 0) {
                    definition.setMaximumValueCount(maxColumns);
                } else {
                    definition.setMaximumValueCount(-1);
                }
            }
        } else {
            definition.addUserInfo("LimitColumns", "No");
            definition.setMinimumValueCount(-1);
            definition.setMaximumValueCount(Integer.MAX_VALUE);
        }
        this.communicator.setRequired(definition.getMinimumValueCount() > 0);
        if (this.m_rbnSelectFromSource.isSelected()) {
            definition.addUserInfo("TableSelect", "Sources");
        } else {
            definition.addUserInfo("TableSelect", "Targets");
        }
        if (this.m_ckbEmitSQLSyntax.isSelected()) {
            definition.addUserInfo("EmitSQL", "Yes");
        } else {
            definition.addUserInfo("EmitSQL", "No");
        }
        PromptTypesProvider provider = (PromptTypesProvider)this.communicator.getPromptTypesProvider();
        provider.setPromptType((PromptDefinitionInterface)definition, this.getPromptType());
        this.m_txtMinColumns.removeFocusListener(this.m_lstMinValueChange);
        this.communicator.removePropertyChangeListener(this.m_lstRequired);
        this.setContentsValid(valid);
        return definition;
    }

    private PropertiesCommunicator getCommicator() {
        return this.communicator;
    }

    private void setRequiredMinimum() {
        this.communicator.setRequired(this.m_ckbLimitColumns.isSelected() && this.m_txtMinColumns.getValue() > 0);
    }

    public boolean isContentsValid() {
        return this.m_bContentsValid;
    }

    public void setContentsValid(boolean newValue) {
        if (newValue != this.m_bContentsValid) {
            this.m_bContentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.m_bContentsValid, this.m_bContentsValid);
        }
    }

    public PromptTypeInfoInterface getPromptType() {
        PromptTypesProvider provider = (PromptTypesProvider)this.communicator.getPromptTypesProvider();
        return provider.getColumnPromptType();
    }

    public void moveDataToView() {
        if (this.m_prompt != null) {
            UserInfoInterface userInfo;
            this.m_ckbNumericColumns.setSelected(this.isColumnTypeAllowed(2L));
            this.m_ckbCharacterColumns.setSelected(this.isColumnTypeAllowed(1L));
            this.m_ckbDateColumns.setSelected(this.isColumnTypeAllowed(4L));
            this.m_ckbTimeColumns.setSelected(this.isColumnTypeAllowed(8L));
            this.m_ckbTimeStampColumns.setSelected(this.isColumnTypeAllowed(16L));
            int minColumns = this.m_prompt.getMinimumValueCount();
            int maxColumns = this.m_prompt.getMaximumValueCount();
            if (maxColumns == Integer.MAX_VALUE) {
                maxColumns = 0;
            }
            if (minColumns > 0 || maxColumns > 0) {
                this.m_ckbLimitColumns.setSelected(true);
            }
            if ((userInfo = this.m_prompt.getUserInfo()) != null) {
                String sourceOrTargetValue = userInfo.get("TableSelect");
                if ("Sources".equals(sourceOrTargetValue)) {
                    this.m_rbnSelectFromSource.setSelected(true);
                } else if ("Targets".equals(sourceOrTargetValue)) {
                    this.m_rbnSelectFromTarget.setSelected(true);
                }
                String emitSQLValue = userInfo.get("EmitSQL");
                if ("Yes".equals(emitSQLValue)) {
                    this.m_ckbEmitSQLSyntax.setSelected(true);
                } else if ("No".equals(emitSQLValue)) {
                    this.m_ckbEmitSQLSyntax.setSelected(false);
                }
            }
            if (minColumns >= 0) {
                this.m_txtMinColumns.setValue(minColumns);
            }
            if (maxColumns >= 0) {
                this.m_txtMaxColumns.setValue(maxColumns);
            }
            this.m_txtMinColumns.setEnabled(this.m_ckbLimitColumns.isSelected());
            this.m_txtMaxColumns.setEnabled(this.m_ckbLimitColumns.isSelected());
        }
    }

    private boolean isColumnTypeAllowed(long columnType) {
        long allowedColumnTypes;
        long l = allowedColumnTypes = this.m_prompt == null ? -1L : this.m_prompt.getAllowedColumnTypes();
        if (allowedColumnTypes == -1L) {
            return true;
        }
        return (allowedColumnTypes & columnType) == columnType;
    }

    private void setMinMaxEnabled() {
        boolean limitColumns = this.m_ckbLimitColumns.isSelected();
        this.m_txtMinColumns.setEnabled(limitColumns);
        this.m_txtMaxColumns.setEnabled(limitColumns);
    }

    private class cLimitColumnsAction
    extends WsAbstractToggleAction {
        public cLimitColumnsAction() {
            this.setText(bundle.getString("ColumnPromptTypesAndValuesPanel.LimitColumns.txt"));
            this.setMnemonic(bundle.getString("ColumnPromptTypesAndValuesPanel.LimitColumns.mnem").charAt(0));
            this.setSelected(false);
        }

        public void actionPerformed(ActionEvent e) {
            ColumnPromptTypesAndValuesPanel.this.setMinMaxEnabled();
            ColumnPromptTypesAndValuesPanel.this.setRequiredMinimum();
        }
    }

    private class cMinValueChanged
    implements FocusListener {
        private cMinValueChanged() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            ColumnPromptTypesAndValuesPanel.this.setRequiredMinimum();
        }
    }

    private class cRequiredChanged
    implements PropertyChangeListener {
        private cRequiredChanged() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == ColumnPromptTypesAndValuesPanel.this.getCommicator() && e.getPropertyName().equals("requiredState")) {
                boolean newValue = (Boolean)e.getNewValue();
                ColumnPromptTypesAndValuesPanel.this.m_ckbLimitColumns.setSelected(newValue);
                if (newValue && ColumnPromptTypesAndValuesPanel.this.m_txtMinColumns.getValue() <= 0) {
                    ColumnPromptTypesAndValuesPanel.this.m_txtMinColumns.setValue(1);
                }
                ColumnPromptTypesAndValuesPanel.this.setMinMaxEnabled();
            }
        }
    }
}

