/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.visuals;

import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoInterface;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.wadmin.prompts.model.PromptTypesProvider;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class BooleanTrueFalsePromptTypesAndValuesPanel
extends BasePromptTypesAndValuesPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(BooleanTrueFalsePromptTypesAndValuesPanel.class);
    protected String m_sTrueDisplayValue;
    protected String m_sFalseDisplayValue;
    private PromptDefinitionInterface m_prompt;
    private JLabel m_lblDefaultValues;
    protected WAComboBox m_cmbDefaultValues;
    public static final String HELP_ID = "prompt_boolean_true";

    public BooleanTrueFalsePromptTypesAndValuesPanel(PropertiesCommunicator pc, PromptDefinitionInterface prompt) {
        super(pc);
        this.setHelpID(HELP_ID);
        this.setHelpProduct("wdb");
        this.m_prompt = prompt;
        this.initialize();
        this.layoutWidgets();
        this.moveDataToView();
        pc.setNumberOfValuesEnabled(false);
    }

    protected void initialize() {
        this.m_sTrueDisplayValue = bundle.getString("Common.True.txt");
        this.m_sFalseDisplayValue = bundle.getString("Common.False.txt");
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        Object[] listValues = new Object[]{this.m_sTrueDisplayValue, this.m_sFalseDisplayValue};
        this.m_cmbDefaultValues = new WAComboBox(listValues);
        this.m_lblDefaultValues = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbDefaultValues, (String)bundle.getString("BooleanTrueFalsePromptTypesAndValuesPanel.DefaultValue.txt"));
        this.add(this.m_lblDefaultValues, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbDefaultValues, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public PromptDefinitionInterface getPromptDefinition() {
        this.setContentsValid(true);
        PromptTypesProvider provider = (PromptTypesProvider)this.communicator.getPromptTypesProvider();
        TextDefinition definition = PromptUtils.createBooleanDefinition((PropertiesCommunicator)this.communicator, (boolean)true);
        provider.setPromptType((PromptDefinitionInterface)definition, this.getPromptType());
        if (this.m_cmbDefaultValues.getSelectedItem().equals(this.m_sFalseDisplayValue)) {
            definition.setDefaultValue((Object)"False");
        } else {
            definition.setDefaultValue((Object)"True");
        }
        definition.setValueProvider(PromptUtils.getValueProviderForBooleanDefinition((boolean)true, (boolean)false));
        return definition;
    }

    public PromptTypeInfoInterface getPromptType() {
        PromptTypesProvider provider = (PromptTypesProvider)this.communicator.getPromptTypesProvider();
        return provider.getBooleanTrueFalsePromptType();
    }

    public void moveDataToView() {
        if (this.m_prompt != null && this.m_prompt.isDefaultValueSet()) {
            if (this.m_sFalseDisplayValue.equals(this.m_prompt.getDefaultValue())) {
                this.m_cmbDefaultValues.setSelectedItem((Object)this.m_sFalseDisplayValue);
            } else {
                this.m_cmbDefaultValues.setSelectedItem((Object)this.m_sTrueDisplayValue);
            }
        } else {
            this.m_cmbDefaultValues.setSelectedItem((Object)this.m_sTrueDisplayValue);
        }
    }
}

