/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.model;

import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoFactory;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypesProviderInterface;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.util.UserInfoInterface;
import com.sas.wadmin.prompts.model.BooleanTrueFalsePromptType;
import com.sas.wadmin.prompts.model.BooleanYesNoPromptType;
import com.sas.wadmin.prompts.model.ColumnPromptType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PromptTypesProvider
implements PromptTypesProviderInterface {
    private List m_lPromptTypes;
    private PropertiesCommunicator m_propertiesCommunicator;
    private Map m_mapPromptTypes;
    private PromptTypeInfoInterface m_promptTypeBooleanTrueFalse;
    private PromptTypeInfoInterface m_promptTypeBooleanYesNo;
    private PromptTypeInfoInterface m_promptTypeColumn;
    private boolean m_bGeneratedTransform;

    public PromptTypesProvider(PropertiesCommunicator pc, boolean generatedTransform) {
        this.m_propertiesCommunicator = pc;
        this.m_bGeneratedTransform = generatedTransform;
        this.initialize();
    }

    protected void initialize() {
        this.m_mapPromptTypes = new HashMap();
        this.m_promptTypeBooleanTrueFalse = new BooleanTrueFalsePromptType(this.m_propertiesCommunicator);
        this.m_promptTypeBooleanYesNo = new BooleanYesNoPromptType(this.m_propertiesCommunicator);
        this.m_promptTypeColumn = new ColumnPromptType(this.m_propertiesCommunicator);
        this.m_lPromptTypes = PromptTypeInfoFactory.defaultSupportedTypes();
        this.m_lPromptTypes.add(this.m_promptTypeBooleanTrueFalse);
        this.m_lPromptTypes.add(this.m_promptTypeBooleanYesNo);
        if (this.m_bGeneratedTransform) {
            this.m_lPromptTypes.remove(PromptTypeInfoFactory.DATASOURCE_COLUMN_PROMPT_TYPE_INFO);
            this.m_lPromptTypes.add(this.m_promptTypeColumn);
        }
    }

    public List getSupportedTypes() {
        return this.m_lPromptTypes;
    }

    public PromptTypeInfoInterface getPromptType(PromptDefinitionInterface prompt) {
        UserInfoInterface userInfo = prompt.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        if (PromptUtils.BOOLEAN_TRUE_FALSE_PROMPT_ID.equals(userInfo.get("Boolean Type"))) {
            return this.getBooleanTrueFalsePromptType();
        }
        if (PromptUtils.BOOLEAN_YES_NO_PROMPT_ID.equals(userInfo.get("Boolean Type"))) {
            return this.getBooleanYesNoPromptType();
        }
        if (userInfo.contains("TableSelect")) {
            return this.getColumnPromptType();
        }
        return null;
    }

    public void setPromptType(PromptDefinitionInterface prompt, PromptTypeInfoInterface promptType) {
        this.m_mapPromptTypes.put(prompt, promptType);
    }

    public PromptTypeInfoInterface getBooleanTrueFalsePromptType() {
        return this.m_promptTypeBooleanTrueFalse;
    }

    public PromptTypeInfoInterface getBooleanYesNoPromptType() {
        return this.m_promptTypeBooleanYesNo;
    }

    public PromptTypeInfoInterface getColumnPromptType() {
        return this.m_promptTypeColumn;
    }
}

