/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Property;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;

public abstract class EntityObjectHandler {
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final int ATTRIBUTE_OPTION_COLUMN_TYPE_NUMERIC = 1;
    public static final int ATTRIBUTE_OPTION_COLUMN_TYPE_CHARACTER = 2;
    public static final int ATTRIBUTE_OPTION_COLUMN_TYPE_ALLTYPES = 0;
    public static final int ATTRIBUTE_OPTION_COLUMN_SELECTIONFROMSOURCE = 0;
    public static final int ATTRIBUTE_OPTION_COLUMN_SELECTIONFROMTARGET = 1;
    public static final int ATTRIBUTE_OPTION_COLUMN_NOEMITSQL = 0;
    public static final int ATTRIBUTE_OPTION_COLUMN_EMITSQL = 1;
    public static final int ATTRIBUTE_OPTION_COLUMN_NOLIMITCOLUMNS = 0;
    public static final int ATTRIBUTE_OPTION_COLUMN_LIMITCOLUMNS = 1;
    public static final int ATTRIBUTE_OPTION_COLUMN_NOLIMIT = -1;
    public static final String TRUE = "True";
    public static final String FALSE = "False";
    public static final String PARAMETERS_ENTITY_CONTAINER_NAME = "Parameters";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_STRING_LIST = "STRING_LIST";
    public static final String TYPE_LOOKUP = "Lookup";
    public static final String TYPE_TRUE_FALSE = "Boolean True/False";
    public static final String TYPE_YES_NO = "Boolean Yes/No";
    public static final String TYPE_COLUMN = "Column";
    public static final String TYPE_FLOAT = "Float";
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_LIBRARY = "Library";
    public static final String TYPE_FILE = "File";
    public static final String TYPE_TABLE = "Table";
    protected static final String TAGNAME_STRING = "String";
    protected static final String TAGNAME_INTEGER = "Integer";
    protected static final String TAGNAME_FLOAT = "Float";
    protected static final String TAGNAME_COLUMN = "Column";
    protected Document m_docConfig;
    private AttributeDescriptorInterface m_attributeDescriptor;
    private boolean m_fIsRequired = false;
    private boolean m_fIsVisible = true;
    private boolean m_fIsModifiable = true;
    private String m_tagName;
    boolean m_fIsEntryEditable = false;
    private static WAdminResource bundle = WAdminResource.getBundle(EntityObjectHandler.class);

    public EntityObjectHandler(MdFactory factory, AttributeDescriptorInterface attributeDescriptor, String tagName) throws MdException, RemoteException {
        this.m_attributeDescriptor = attributeDescriptor;
        String strConfigXML = attributeDescriptor.getConfigurationXML();
        this.m_docConfig = strConfigXML != null && strConfigXML.length() > 0 ? factory.getOMIUtil().parseXML(strConfigXML) : null;
        this.m_tagName = tagName;
        this.setupHandler();
    }

    public String getTagName() {
        return this.m_tagName;
    }

    protected void setupHandler() {
        this.m_fIsModifiable = this.m_attributeDescriptor.isModifiable();
        this.m_fIsVisible = this.m_attributeDescriptor.isVisible();
        this.m_fIsRequired = this.m_attributeDescriptor.isRequired();
    }

    public boolean fIsModifiable() {
        return this.m_fIsModifiable;
    }

    public boolean fIsVisible() {
        return this.m_fIsVisible;
    }

    public boolean fIsRequired() {
        return this.m_fIsRequired;
    }

    public boolean fIsEntryEditable() {
        return this.m_fIsEntryEditable;
    }

    public String validateInputValue(Object inputValue) {
        if (this.m_fIsRequired && (inputValue == null || inputValue.toString().length() == 0)) {
            return bundle.getString("MacroUserOptionsTable.OptionRequired.msg.txt");
        }
        return null;
    }

    public List getValidValues() {
        return null;
    }

    public String getDefaultValue() {
        Object defaultObject = this.m_attributeDescriptor.getDefault();
        if (defaultObject != null) {
            return this.m_attributeDescriptor.getDefault().toString();
        }
        return "";
    }

    public String getExistingValue(HashMap propertyMap) {
        if (propertyMap.get(this.m_attributeDescriptor) == null) {
            return null;
        }
        Property property = (Property)propertyMap.get(this.m_attributeDescriptor);
        try {
            return property.getDefaultValue();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public Property getExistingProperty(HashMap propertyMap) {
        if (propertyMap.get(this.m_attributeDescriptor) == null) {
            return null;
        }
        Property property = (Property)propertyMap.get(this.m_attributeDescriptor);
        return property;
    }

    public AttributeDescriptorInterface getAttributeDescriptor() {
        return this.m_attributeDescriptor;
    }
}

