/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.wadmin.prompts.conversion.EntityObjectHandler;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EntityColumnHandler
extends EntityObjectHandler {
    private static WAdminResource bundle = WAdminResource.getBundle(EntityColumnHandler.class);
    private int m_minColumns;
    private int m_maxColumns;
    private int m_iSelectLocation;
    private int m_iColumnType;
    private int m_iLimitColumns;
    private int m_iEmitSQLSyntax;
    private String m_toolTip;

    public EntityColumnHandler(MdFactory factory, AttributeDescriptorInterface attributeDescriptor) throws MdException, RemoteException {
        super(factory, attributeDescriptor, "Column");
        this.m_toolTip = attributeDescriptor.getDescription(Locale.getDefault());
    }

    @Override
    public void setupHandler() {
        Node m_iLimitColumns1;
        Node selectSQL;
        super.setupHandler();
        this.m_minColumns = -1;
        this.m_maxColumns = -1;
        this.m_iSelectLocation = 0;
        this.m_iColumnType = 0;
        this.m_iLimitColumns = 0;
        this.m_iEmitSQLSyntax = 0;
        Node selectCharacterNode = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "SelectCharacter");
        Node selectNumericNode = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "SelectNumeric");
        if (selectCharacterNode != null) {
            this.m_iColumnType = 2;
        } else if (selectNumericNode != null) {
            this.m_iColumnType = 1;
        }
        Node selectFromTargetNode = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "SelectFromTarget");
        if (selectFromTargetNode != null) {
            this.m_iSelectLocation = 1;
        }
        if ((selectSQL = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "EmitSQL")) != null) {
            this.m_iEmitSQLSyntax = 1;
        }
        if ((m_iLimitColumns1 = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "ColumnsLimit")) != null) {
            this.m_iLimitColumns = 1;
            NamedNodeMap rangeNodeMap = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "ColumnsLimit").getAttributes();
            String strLength = rangeNodeMap.getNamedItem("min").getNodeValue();
            if (strLength != null && strLength.length() > 0) {
                this.m_minColumns = Integer.parseInt(strLength);
            }
            if ((strLength = rangeNodeMap.getNamedItem("max").getNodeValue()) != null && strLength.length() > 0) {
                this.m_maxColumns = Integer.parseInt(strLength);
            }
        }
    }

    @Override
    public List getValidValues() {
        return new ArrayList();
    }

    public String getToolTip() {
        return this.m_toolTip;
    }

    public int getMinimumColumns() {
        return this.m_minColumns;
    }

    public int getMaximumColumns() {
        return this.m_maxColumns;
    }

    public int getSelectTable() {
        return this.m_iSelectLocation;
    }

    public int getColumnType() {
        return this.m_iColumnType;
    }

    public int getLimitColumns() {
        return this.m_iLimitColumns;
    }

    public int getEmitSQL() {
        return this.m_iEmitSQLSyntax;
    }

    public String fIsValidMinMaxColumns(String minColumns, String maxColumns) {
        if (minColumns.length() > 0 && maxColumns.length() > 0) {
            int minValue = Integer.parseInt(minColumns);
            int maxValue = Integer.parseInt(maxColumns);
            if (maxValue < minValue) {
                return bundle.formatString("MacroUserOptionsTable.OptionMinimum.msg.txt", (Object)"{0}", (Object)new Integer(minValue));
            }
        }
        return null;
    }

    public String toString() {
        return this.getAttributeDescriptor().getLabel(Locale.getDefault());
    }
}

