/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTemplateNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNode;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformLimitTypeInterface;
import com.sas.wadmin.plugins.TransformRejectNodeDrops;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.FileWriter;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsViewFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;

public class WAPFDWorkTableNode
extends WAPFDTableNode {
    public WAPFDWorkTableNode(Point loc, ImageIcon image, String sCaption, WAPFDWorkTableNodeModel Model, PFDPanel parentPanel) {
        super(loc, new Dimension(35, 35), 5, image, sCaption, Model, parentPanel);
        this.getLabel().setVisible(true);
        this.getDrawable().getPen().setLineWidth(3.0f);
        this.getDrawable().getPen().setColor(new Color(0, 153, 0));
        this.getDrawable().getBrush().setColor(new Color(191, 232, 191));
    }

    @Override
    public boolean fCanDelete() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanMakeOutput() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public void makeOutput() throws MdException, RemoteException, PFDException {
        ((WAPFDWorkTableNodeModel)this.m_nodeModel).makeOutput();
    }

    protected void redirectLinks(Vector links, PFDPort port, boolean in, WAPFDNode newnode) {
        for (int i = 0; i < links.size(); ++i) {
            PFDLink link = (PFDLink)links.elementAt(i);
            if (in) {
                link.setToPort(port);
                ((WAPFDLink)link).setToNode(newnode);
            } else {
                link.setFromPort(port);
                ((WAPFDLink)link).setFromNode(newnode);
            }
            link.getPen().setStyle(1);
        }
    }

    public void replaceWorkNode(WAPFDNode newNode) throws MdException, RemoteException {
        this.m_parentPanel.forceFlowDirectionChange();
        Vector east_ins = null;
        Vector west_ins = null;
        Vector east_outs = null;
        Vector west_outs = null;
        if (PFDPanel.getLayoutDirection() == 2 || PFDPanel.getLayoutDirection() == 0) {
            east_ins = this.getPort("east").getToLinks();
            east_outs = this.getPort("east").getFromLinks();
            west_ins = this.getPort("west").getToLinks();
            west_outs = this.getPort("west").getFromLinks();
            this.redirectLinks(east_ins, newNode.getPort("east"), true, newNode);
            this.redirectLinks(east_outs, newNode.getPort("east"), false, newNode);
            this.redirectLinks(west_ins, newNode.getPort("west"), true, newNode);
            this.redirectLinks(west_outs, newNode.getPort("west"), false, newNode);
        } else {
            east_ins = this.getPort("north").getToLinks();
            east_outs = this.getPort("north").getFromLinks();
            west_ins = this.getPort("south").getToLinks();
            west_outs = this.getPort("south").getFromLinks();
            this.redirectLinks(east_ins, newNode.getPort("north"), true, newNode);
            this.redirectLinks(east_outs, newNode.getPort("north"), false, newNode);
            this.redirectLinks(west_ins, newNode.getPort("south"), true, newNode);
            this.redirectLinks(west_outs, newNode.getPort("south"), false, newNode);
        }
        this.m_parentPanel.clearSelections();
        WAPFDWorkTableNodeModel workModel = (WAPFDWorkTableNodeModel)this.getWAPFDNodeModel();
        TransformationStep step = workModel.getTransformStep((MdObjectStore)this.m_activeJob.getObjectStore());
        WAPFDTransformNodeModel transModel = (WAPFDTransformNodeModel)this.m_parentPanel.getNodeModel(step.getFQID());
        transModel.deleteNodeFromWorkTableNodes(this);
        this.deleteNode();
    }

    @Override
    public boolean fCanShowImpact() throws MdException, RemoteException, PFDException {
        CMetadata iObj = this.m_nodeModel.getMetadataObject();
        return iObj instanceof WorkTable && !iObj.isNewObject();
    }

    @Override
    public boolean fCanShowReverseImpact() throws MdException, RemoteException, PFDException {
        CMetadata iObj = this.m_nodeModel.getMetadataObject();
        return iObj instanceof WorkTable && !iObj.isNewObject();
    }

    @Override
    public boolean fCanViewData() {
        try {
            String sJobStatus = WsJobSubmissionManager.getInstance().getWsServerRequestStatus(this.m_nodeModel.m_activeJob.getFQID());
            if (sJobStatus == null || sJobStatus.equals("") || sJobStatus.equals(WsServerRequest.JOBRUNNING) || sJobStatus.equals(WsServerRequest.JOBCANCELINPROGRESS)) {
                return false;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    @Override
    public void viewData() {
        try {
            WsServerRequest serverRequest = WsJobSubmissionManager.getInstance().getWsServerRequest(this.m_nodeModel.m_activeJob.getFQID());
            WsAppServer appServer = serverRequest.getAppServer();
            CMetadata iObj = this.m_nodeModel.getMetadataObject();
            HashMap<String, WsAppServer> map = new HashMap<String, WsAppServer>();
            map.put("AppServer", appServer);
            this.m_parentPanel.addChildFrame((JInternalFrame)WsViewFactory.showView((CMetadata)iObj, ViewDataView.class, map, (MdStore)iObj.getObjectStore()).getFrame());
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void showImpactAnalysis(boolean bForward) {
        try {
            CMetadata iObj = this.m_nodeModel.getMetadataObject();
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            CMetadata detailsObject = Workspace.getMdFactory().createComplexMetadataObject(store, iObj);
            detailsObject.setName(iObj.getName());
            if (detailsObject instanceof WorkTable) {
                ImpactAnalysisOMAView view = this.findImpactAnalysisView((Classifier)detailsObject, bForward);
                if (view != null) {
                    detailsObject.getObjectStore().dispose();
                    WsViewFactory.showExistingView((WsOMAView)view);
                    return;
                }
                view = new ImpactAnalysisOMAView((Classifier)detailsObject, bForward);
                WsViewFactory.attachViewToFrame((CMetadata)detailsObject, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame(detailsObject, ""));
            } else if (store != null) {
                store.dispose();
                Object var3_4 = null;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(Classifier oTable, boolean bForward) {
        try {
            ArrayList lViews = oTable.getViewList();
            int nViews = lViews.size();
            for (int iView = 0; iView < nViews; ++iView) {
                ImpactAnalysisOMAView view;
                if (!lViews.get(iView).getClass().equals(ImpactAnalysisOMAView.class) || (view = (ImpactAnalysisOMAView)((Object)lViews.get(iView))).isForward() != bForward) continue;
                return view;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    public static void isValidLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation) throws MdException, RemoteException, PFDException {
        if (primLogicalLocation instanceof WAPFDNode) {
            TransformationStep step;
            if (primLogicalLocation instanceof WAPFDTableNode || primLogicalLocation instanceof WAPFDTransformLoaderNode) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            WAPFDTransformNodeModel transformNodeModel = (WAPFDTransformNodeModel)((WAPFDTransformNode)primLogicalLocation).getWAPFDNodeModel();
            TransformInterface transformInterface = transformNodeModel.getTransformFromStep(step = (TransformationStep)transformNodeModel.getMetadataObject(newStore));
            if (transformInterface instanceof TransformRejectNodeDrops) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_TRANFORMREJECTSNODEDROPS.txt");
            }
            if (((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingInputTemplates() > 0 || ((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingOutputTemplates() > 0) {
                if (transformNodeModel.isMultiInputNode() && transformNodeModel.fNodeHasSpace(newStore, 0) && ((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingInputTemplates() > 0) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPONTONODEWITHTEMPLATES.txt");
                }
                if (transformNodeModel.isMultiOutputNode() && transformNodeModel.fNodeHasSpace(newStore, 1) && ((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingOutputTemplates() > 0) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPONTONODEWITHTEMPLATES.txt");
                }
                if (!transformNodeModel.isMultiInputNode() && !transformNodeModel.isMultiOutputNode()) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPONTONODEWITHTEMPLATES.txt");
                }
            }
            if (!transformNodeModel.fNodeHasSpace(newStore, 0) && !transformNodeModel.fNodeHasSpace(newStore, 1)) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
        } else {
            if (primLogicalLocation instanceof WAPFDLink) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTABLEONTOLINK.txt");
            }
            if (primLogicalLocation instanceof WAPFDTemplateNode) {
                String type;
                WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primLogicalLocation;
                AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
                TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
                if (templateNode.getOutputLinks().size() > 0 && existingStep instanceof SyncStep && existingStep.getTransformations().size() == 0 && !existingStep.getTransformRole().equalsIgnoreCase("SASReturnCodeCheck")) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTABLEONTOSYNCTEMPLATE.txt");
                }
                if (existingStep.getTransformRole().indexOf("SASJob") > -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
                }
                WAPFDTransformNodeModel model = (WAPFDTransformNodeModel)((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel();
                TransformInterface transformInterface = model.getTransformFromStep(existingStep);
                if (transformInterface instanceof TransformLimitTypeInterface && (type = assocProp.getAssociationName()).indexOf("ALL") == -1 && type.indexOf("PhysicalTable") == -1 && type.indexOf("ClassifierSources") == -1 && type.indexOf("ClassifierTargets") == -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
                }
            }
        }
    }

    @Override
    public void checkReconnectLocation(PFDPrimitive primitive) throws MdException, RemoteException, PFDException {
        if (primitive instanceof WAPFDTemplateNode) {
            WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primitive;
            AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
            WAPFDTransformNodeModel stepNodeModel = (WAPFDTransformNodeModel)((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel();
            TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
            if (existingStep instanceof SyncStep && existingStep.getTransformations().size() == 0 && !existingStep.getTransformRole().equalsIgnoreCase("LOOPEND") && !existingStep.getTransformRole().equalsIgnoreCase("LOOP") && !existingStep.getTransformRole().equalsIgnoreCase("SASReturnCodeCheck")) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTABLEONTOSYNCTEMPLATE.txt");
            }
            if (existingStep.getTransformRole().equalsIgnoreCase("LOOPEND") && templateNode.getOutputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (existingStep.getTransformRole().equalsIgnoreCase("LOOP") && templateNode.getInputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (existingStep.getTransformRole().indexOf("SASJob") > -1) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (existingStep.getTransformRole().indexOf("QueueReader") > -1 && templateNode.getOutputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
            }
            if (existingStep.getTransformRole().indexOf("FileReader") > -1 && templateNode.getOutputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
            }
            TransformInterface transformInterface = stepNodeModel.getTransformFromStep(existingStep);
            if (transformInterface instanceof FileWriter && templateNode.getInputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
            }
        }
    }
}

