/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Join;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDExternalTableNode;
import com.sas.wadmin.pfd.WAPFDInformationNode;
import com.sas.wadmin.pfd.WAPFDJobNode;
import com.sas.wadmin.pfd.WAPFDJobNodeModel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTemplateNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformComputeNode;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNode;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.plugins.TransformControlInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformLimitTypeInterface;
import com.sas.wadmin.plugins.TransformLoaderInterface;
import com.sas.wadmin.plugins.TransformOrderMattersInterface;
import com.sas.wadmin.transforms.control.Loop;
import com.sas.wadmin.transforms.control.LoopEnd;
import com.sas.wadmin.transforms.loader.TableLoader;
import com.sas.wadmin.transforms.xmlwriter.XMLWriter;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.FileReader;
import com.sas.wadmin.visuals.FileWriter;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.SASJob;
import com.sas.wadmin.visuals.SASLoader;
import com.sas.wadmin.visuals.SASReturnCodeCheck;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.wadmin.visuals.ViewDataWorkTablesPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsViewFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;

public class WAPFDTransformNode
extends WAPFDNode
implements WAPFDPrimitiveInterface {
    private static final WAdminResource bundle = new WAdminResource(WAPFDTransformNode.class);

    public WAPFDTransformNode(Point loc, ImageIcon image, String sCaption, WAPFDTransformNodeModel nodeModel, PFDPanel parentPanel) {
        super(loc, new Dimension(34, 34), 2, image, sCaption, nodeModel, parentPanel);
        this.getDrawable().getPen().setLineWidth(3.0f);
        this.getDrawable().getPen().setColor(new Color(70, 119, 206));
        this.getDrawable().getBrush().setColor(new Color(205, 218, 241));
    }

    public WAPFDTransformNode(Point loc, Dimension dim, int prim, ImageIcon image, String sCaption, WAPFDTransformNodeModel nodeModel, PFDPanel parentPanel) {
        super(loc, dim, prim, image, sCaption, nodeModel, parentPanel);
    }

    @Override
    public void showProperties() throws MdException, RemoteException, PFDException {
        MdObjectStore newStore = Workspace.getMdFactory().createObjectStore(this.m_parentPanel.getActiveJob().getObjectStore());
        newStore.setIsGotToServerForMetadata(false);
        CMetadata object = this.m_nodeModel.getMetadataObject();
        CMetadata newObject = Workspace.getMdFactory().createComplexMetadataObject(newStore, null, object);
        if (object instanceof Join) {
            this.m_parentPanel.addChildFrame((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.query.wa.", (String)"JoinView").getFrame());
        } else {
            String classname = null;
            try {
                AssociationList properties = ((TransformationStep)this.m_nodeModel.getMetadataObject()).getProperties();
                for (int i = 0; i < properties.size(); ++i) {
                    Property prop = (Property)properties.get(i);
                    if (!prop.getPropertyName().equals("Class")) continue;
                    classname = prop.getDefaultValue();
                    break;
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            TransformInterface transformInterface = TransformManager.getInstance().getTransform(classname);
            this.m_parentPanel.addChildFrame(transformInterface.displayProperties(newObject));
        }
    }

    @Override
    public int getShowingInputTemplates() {
        Vector inputs = this.getInputLinks();
        int templates = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            WAPFDLink link = (WAPFDLink)inputs.elementAt(i);
            if (!(link.getFromNode() instanceof WAPFDTemplateNode)) continue;
            ++templates;
        }
        return templates;
    }

    @Override
    public int getShowingOutputTemplates() {
        Vector outputs = this.getOutputLinks();
        int templates = 0;
        block0: for (int i = 0; i < outputs.size(); ++i) {
            WAPFDLink link = (WAPFDLink)outputs.elementAt(i);
            if (link.getToNode() instanceof WAPFDTemplateNode) {
                ++templates;
                continue;
            }
            if (!(link.getToNode() instanceof WAPFDWorkTableNode)) continue;
            WAPFDWorkTableNode workNode = (WAPFDWorkTableNode)link.getToNode();
            Vector workOutputs = workNode.getOutputLinks();
            for (int j = 0; j < workOutputs.size(); ++j) {
                WAPFDLink workLink = (WAPFDLink)workOutputs.elementAt(j);
                if (!(workLink.getToNode() instanceof WAPFDTemplateNode)) continue;
                ++templates;
                continue block0;
            }
        }
        return templates;
    }

    @Override
    public boolean fCanShowPopup() {
        return true;
    }

    @Override
    public boolean fCanViewStepCode() {
        return true;
    }

    @Override
    public boolean fCanViewData() {
        try {
            if (((TransformationStep)this.getMetadataObject()).getTransformRole().indexOf("LOOP") > -1) {
                String sJobStatus = WsJobSubmissionManager.getInstance().getWsServerRequestStatus(this.m_nodeModel.m_activeJob.getFQID());
                return sJobStatus != null && !sJobStatus.equals("") && !sJobStatus.equals(WsServerRequest.JOBRUNNING) && !sJobStatus.equals(WsServerRequest.JOBCANCELINPROGRESS);
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    @Override
    public boolean fCanDelete() {
        return true;
    }

    @Override
    public boolean fCanShowProperties() {
        return true;
    }

    @Override
    public boolean fCanMakeOutput() {
        return false;
    }

    @Override
    public boolean fCanViewJob() {
        return false;
    }

    @Override
    public boolean fCanAddInputTemplate() {
        try {
            return ((WAPFDTransformNodeModel)this.getWAPFDNodeModel()).fCanAddTemplate((TransformationStep)this.getMetadataObject(), 0);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    @Override
    public boolean fCanAddOutputTemplate() {
        try {
            return ((WAPFDTransformNodeModel)this.getWAPFDNodeModel()).fCanAddTemplate((TransformationStep)this.getMetadataObject(), 1);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    public static void isValidLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation, TransformInterface objectBeingDropped) throws MdException, RemoteException, PFDException {
        if (primLogicalLocation == null) {
            return;
        }
        if (primLogicalLocation instanceof WAPFDTemplateNode) {
            WAPFDNodeInterface node;
            String type;
            WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primLogicalLocation;
            WAPFDTransformNodeModel model = (WAPFDTransformNodeModel)((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel();
            TransformationStep step = (TransformationStep)model.getMetadataObject();
            TransformInterface transformInterface = model.getTransformFromStep(step);
            AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
            if (transformInterface instanceof TransformLimitTypeInterface && ((type = assocProp.getAssociationName()).indexOf("Job") <= -1 || !(objectBeingDropped instanceof SASJob)) && type.indexOf("ALL") == -1 && type.indexOf("ClassifierSources") == -1 && type.indexOf("ClassifierTargets") == -1) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDETRANSFORMATIONS.txt");
            }
            boolean fIsOutputTemplate = true;
            if (templateNode.getOutputLinks().size() > 0) {
                fIsOutputTemplate = false;
            }
            if (transformInterface instanceof Loop && fIsOutputTemplate && !(objectBeingDropped instanceof SASJob)) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDETRANSFORMATIONS.txt");
            }
            if (transformInterface instanceof LoopEnd && !fIsOutputTemplate && !(objectBeingDropped instanceof SASJob)) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDETRANSFORMATIONS.txt");
            }
            if (objectBeingDropped instanceof SASJob) {
                if (fIsOutputTemplate && !(transformInterface instanceof Loop)) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (!fIsOutputTemplate && !(transformInterface instanceof LoopEnd)) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
            }
            if (objectBeingDropped instanceof LoopEnd && fIsOutputTemplate && !(transformInterface instanceof SASJob)) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (objectBeingDropped instanceof Loop && !fIsOutputTemplate && !(transformInterface instanceof SASJob)) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (model instanceof WAPFDJobNodeModel) {
                boolean bValidDrop = false;
                if (objectBeingDropped instanceof Loop && !fIsOutputTemplate) {
                    bValidDrop = true;
                }
                if (objectBeingDropped instanceof LoopEnd && fIsOutputTemplate) {
                    bValidDrop = true;
                }
                if (!bValidDrop) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
            }
            if ((MacroPluginUtilities.isGeneratedTransform((Root)step) || MacroPluginUtilities.isOrderTypeTransform(step)) && objectBeingDropped instanceof TransformControlInterface) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (objectBeingDropped instanceof TransformLoaderInterface && !fIsOutputTemplate) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (objectBeingDropped instanceof FileReader && fIsOutputTemplate) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (objectBeingDropped instanceof XMLWriter && transformInterface instanceof TransformLoaderInterface) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (objectBeingDropped instanceof TransformOrderMattersInterface && (node = model.getViewNode()) instanceof WAPFDTransformComputeNode && step.getTransformations(false).size() == 0) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (objectBeingDropped instanceof MacroPlugin) {
                String strXML = objectBeingDropped.getXML();
                if (strXML == null) {
                    return;
                }
                int index = strXML.indexOf("AssociationProperty");
                if (index == -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTRANSFORMONTOTEMPLATE.txt");
                }
                ArrayList validDropObjects = transformInterface.getValidDropTargets();
                for (int i = 0; i < validDropObjects.size(); ++i) {
                    int location = (Integer)validDropObjects.get(i);
                    if (location != TransformInterface.TEMPLATE_TARGET_CLASSIFIER_ONLY || !fIsOutputTemplate) continue;
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPNONCLASSIFIERONTARGET.txt");
                }
                int index2 = strXML.indexOf("INPUT");
                int index3 = strXML.indexOf("OUTPUT");
                if (index3 == -1 && index2 == -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTRANSFORMONTOTEMPLATE.txt");
                }
                if (((WAPFDTemplateNode)primLogicalLocation).getInputLinks().size() > 0 && index2 > -1) {
                    return;
                }
                if (((WAPFDTemplateNode)primLogicalLocation).getOutputLinks().size() > 0 && index3 > -1) {
                    return;
                }
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTRANSFORMONTOTEMPLATE.txt");
            }
            boolean fSuccessDrop = false;
            ArrayList locations = objectBeingDropped.getValidDropTargets();
            for (int i = 0; i < locations.size(); ++i) {
                int location = (Integer)locations.get(i);
                if (location != TransformInterface.TEMPLATE && (location != TransformInterface.TEMPLATE_INPUT_ONLY || fIsOutputTemplate) && (location != TransformInterface.TEMPLATE_OUTPUT_ONLY || !fIsOutputTemplate)) continue;
                fSuccessDrop = true;
                break;
            }
            if (((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel() instanceof WAPFDTransformLoaderNodeModel && objectBeingDropped instanceof TransformLoaderInterface) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPLOADERTRANSFORMONTEMPLATE.txt");
            }
            ArrayList validDropObjects = transformInterface.getValidDropTargets();
            for (int i = 0; i < validDropObjects.size(); ++i) {
                int location = (Integer)validDropObjects.get(i);
                if (location != TransformInterface.TEMPLATE_TARGET_CLASSIFIER_ONLY || !fIsOutputTemplate) continue;
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPNONCLASSIFIERONTARGET.txt");
            }
            if (!fSuccessDrop) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            return;
        }
        if (primLogicalLocation instanceof WAPFDLink) {
            TransformationStep step;
            if (objectBeingDropped instanceof MacroPlugin) {
                String strXML = objectBeingDropped.getXML();
                if (strXML == null) {
                    return;
                }
                int index = strXML.indexOf("AssociationProperty");
                if (index == -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTRANSFORMONTOTEMPLATE.txt");
                }
                int index2 = strXML.indexOf("INPUT");
                int index3 = strXML.indexOf("OUTPUT");
                if (index3 == -1 || index2 == -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTRANSFORMONTOTEMPLATE.txt");
                }
                WAPFDLink link = (WAPFDLink)primLogicalLocation;
                WAPFDNodeInterface fromNode = link.getWAFromNode();
                WAPFDNodeInterface toNode = link.getWAToNode();
                if (fromNode instanceof WAPFDTransformComputeNode || toNode instanceof WAPFDTransformComputeNode && !((TransformationStep)toNode.getWAPFDNodeModel().getMetadataObject()).getTransformRole().equalsIgnoreCase("LOOP")) {
                    throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
                }
            }
            WAPFDLink link = (WAPFDLink)primLogicalLocation;
            WAPFDNodeInterface toWANode = link.getWAToNode();
            WAPFDNodeInterface fromWANode = link.getWAFromNode();
            if (objectBeingDropped instanceof SASReturnCodeCheck && toWANode instanceof WAPFDTableNode) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            if (objectBeingDropped instanceof FileWriter && !(toWANode instanceof WAPFDExternalTableNode)) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            if (objectBeingDropped instanceof FileReader && !(fromWANode instanceof WAPFDExternalTableNode)) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            if (toWANode instanceof WAPFDWorkTableNode) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            if (toWANode instanceof WAPFDInformationNode) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            if (fromWANode instanceof WAPFDInformationNode) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            WAPFDLink existingLink = (WAPFDLink)primLogicalLocation;
            if (!existingLink.isValidMetadataDropLocation()) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            boolean fSuccessDrop = false;
            ArrayList locations = objectBeingDropped.getValidDropTargets();
            for (int i = 0; i < locations.size(); ++i) {
                int location = (Integer)locations.get(i);
                if (location != TransformInterface.LINK) continue;
                fSuccessDrop = true;
                break;
            }
            if (!fSuccessDrop) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            WAPFDNodeInterface fromNode = existingLink.getWAFromNode();
            WAPFDNodeInterface toNode = existingLink.getWAToNode();
            if (objectBeingDropped instanceof XMLWriter && !(toNode instanceof WAPFDTableNode)) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (fromNode instanceof WAPFDTransformLoaderNode) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            if (toNode instanceof WAPFDTransformLoaderNode && (objectBeingDropped instanceof TableLoader || objectBeingDropped instanceof SASLoader || objectBeingDropped instanceof FileWriter)) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
            if (fromNode instanceof WAPFDTableNode && !(fromNode instanceof WAPFDWorkTableNode) && objectBeingDropped instanceof TransformControlInterface) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPSYNCTRANSFORMONLINK.txt");
            }
            if (fromNode instanceof WAPFDTransformNode) {
                CMetadata fromObject = ((WAPFDTransformNode)fromNode).getWAPFDNodeModel().getMetadataObject();
                step = (TransformationStep)fromObject;
                if ((MacroPluginUtilities.isGeneratedTransform((Root)((TransformationStep)fromObject)) || MacroPluginUtilities.isOrderTypeTransform((TransformationStep)fromObject)) && objectBeingDropped instanceof TransformControlInterface) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (step.getTransformRole().equalsIgnoreCase("Loop") && !(objectBeingDropped instanceof SASJob)) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (fromNode instanceof WAPFDJobNode && !(objectBeingDropped instanceof LoopEnd)) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (step.getTransformRole().indexOf("LOOP") > -1 && objectBeingDropped instanceof Loop) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (step.getTransformRole().indexOf("LOOPEND") > -1 && objectBeingDropped instanceof LoopEnd) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
            }
            if (objectBeingDropped instanceof TransformLoaderInterface && fromNode instanceof WAPFDTransformLoaderNode || objectBeingDropped instanceof TransformLoaderInterface && !(toNode instanceof WAPFDTableNode)) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (toNode instanceof WAPFDTransformNode) {
                CMetadata toObject = ((WAPFDTransformNode)toNode).getWAPFDNodeModel().getMetadataObject();
                step = (TransformationStep)toObject;
                if ((MacroPluginUtilities.isGeneratedTransform((Root)((TransformationStep)toObject)) || MacroPluginUtilities.isOrderTypeTransform((TransformationStep)toObject)) && objectBeingDropped instanceof TransformControlInterface) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (step.getTransformRole().indexOf("LOOP") > -1 && objectBeingDropped instanceof Loop) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (step.getTransformRole().indexOf("LOOPEND") > -1 && objectBeingDropped instanceof LoopEnd) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
            }
            if (fromNode instanceof WAPFDTemplateNode || toNode instanceof WAPFDTemplateNode) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
            }
        } else if (primLogicalLocation instanceof WAPFDNode) {
            throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONNODE.txt");
        }
    }

    @Override
    public void viewData() {
        try {
            WsServerRequest serverRequest = WsJobSubmissionManager.getInstance().getWsServerRequest(this.m_nodeModel.m_activeJob.getFQID());
            WsAppServer appServer = serverRequest.getAppServer();
            CMetadata iObj = this.m_nodeModel.getMetadataObject();
            Vector<Object> lTargetTables = new Vector<Object>();
            AssociationList alCMs = ((TransformationStep)iObj).getTransformations(false);
            int nCMs = alCMs.size();
            WorkTable workTable = null;
            for (int iCM = 0; iCM < nCMs; ++iCM) {
                ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
                AssociationList alTargets = oCM.getClassifierTargets(false);
                int nTargets = alTargets.size();
                for (int iTarget = 0; iTarget < nTargets; ++iTarget) {
                    lTargetTables.add(alTargets.get(iTarget));
                }
            }
            if (!lTargetTables.isEmpty()) {
                HashMap<String, WsAppServer> map = new HashMap<String, WsAppServer>();
                map.put("AppServer", appServer);
                if (lTargetTables.size() > 1) {
                    workTable = this.showTargetTablesDialog(lTargetTables);
                    if (workTable != null) {
                        this.m_parentPanel.addChildFrame((JInternalFrame)WsViewFactory.showView((CMetadata)workTable, ViewDataView.class, map, (MdStore)workTable.getObjectStore()).getFrame());
                    }
                } else {
                    workTable = (DataTable)lTargetTables.get(0);
                    this.m_parentPanel.addChildFrame((JInternalFrame)WsViewFactory.showView((CMetadata)workTable, ViewDataView.class, map, (MdStore)workTable.getObjectStore()).getFrame());
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("WAPFDTransformNode.NoTargetTableMessage.txt"), (String)bundle.getString("WAPFDTransformNode.NoTargetTableTitle.txt"), (int)0, (int)-1);
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected WorkTable showTargetTablesDialog(List lTargetTables) {
        ViewDataWorkTablesPanel pnl = new ViewDataWorkTablesPanel(lTargetTables);
        pnl.setPreferredSize(new Dimension(450, 400));
        String sTargetTablesDialogTitle = bundle.getString("WAPFDTransformNode.TargetTablesDialogTitle.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTargetTablesDialogTitle, true, (WAPanel)pnl);
        dlg.setResizable(true);
        dlg.setHelpProduct("wdb");
        dlg.setHelpTopic("target_view_win");
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            return (WorkTable)pnl.getSelectedItem();
        }
        return null;
    }

    public boolean isAutomapEnabled() throws MdException, RemoteException {
        TransformationStep object = (TransformationStep)this.m_nodeModel.getMetadataObject();
        return MappingUtil.isAutoMapEnabled(object);
    }

    public void setAutomapEnabled(boolean fState) throws MdException, RemoteException {
        TransformationStep object = (TransformationStep)this.m_nodeModel.getMetadataObject();
        MappingUtil.setAutomapEnabled(object, fState);
    }
}

