/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.plugins.TransformHiddenInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformNoDeleteLoaderInterface;
import com.sas.wadmin.plugins.TransformWorkTableInterface;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.awt.Point;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;

public class WAPFDTransformLoaderNode
extends WAPFDTransformNode
implements WAPFDPrimitiveInterface {
    public WAPFDTransformLoaderNode(Point loc, ImageIcon image, String sCaption, WAPFDTransformLoaderNodeModel Model, PFDPanel parentPanel) {
        super(loc, image, sCaption, Model, parentPanel);
    }

    @Override
    public boolean fCanDelete() {
        try {
            TransformationStep step = (TransformationStep)this.m_nodeModel.getMetadataObject();
            String classname = WAPFDNodeModel.getClassName(step);
            TransformInterface transformInterface = TransformManager.getInstance().getTransform(classname);
            if (transformInterface instanceof TransformHiddenInterface) {
                return false;
            }
            TransformationStep previousStep = this.m_nodeModel.findLastDataStep(step);
            if (previousStep != null) {
                classname = WAPFDNodeModel.getClassName(previousStep);
                transformInterface = TransformManager.getInstance().getTransform(classname);
                if (transformInterface instanceof TransformNoDeleteLoaderInterface) {
                    return false;
                }
                if (transformInterface instanceof TransformWorkTableInterface) {
                    DataTable table;
                    ClassifierMap map;
                    TransformWorkTableInterface workInterface = (TransformWorkTableInterface)((Object)transformInterface);
                    if (!step.getTransformations(false).isEmpty() && (map = (ClassifierMap)step.getTransformations(false).elementAt(0)).getClassifierSources(false).size() > 0 && !workInterface.recreateWorkTable(table = (DataTable)map.getClassifierSources(false).get(0), previousStep)) {
                        return false;
                    }
                }
            }
            return true;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return false;
        }
    }

    @Override
    public boolean fCanViewData() {
        return false;
    }
}

