/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDJobNodeModel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDTableNodeModel;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTransformComputeNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.Workspace;
import java.awt.Dimension;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class WAPFDTemplateNodeModel
extends WAPFDNodeModel {
    public static final int PFDTEMPLATETYPE_INPUT = 0;
    public static final int PFDTEMPLATETYPE_OUTPUT = 1;

    public WAPFDTemplateNodeModel(PFDPanel parentPanel, CMetadata object) {
        super(parentPanel, object);
    }

    public void addNode(CMetadata template) throws PFDException, MdException, RemoteException {
        this.m_viewNode = new WAPFDTemplateNode(new Point(0, 0), new Dimension(150, 40), template.getName(), this, this.m_parentPanel);
        this.m_viewNode.addNode();
    }

    public int getTemplateType(MdObjectStore newStore) {
        AssociationProperty assocProp = (AssociationProperty)this.getMetadataObject(newStore);
        try {
            if (assocProp.getMetadataType().indexOf("INPUT") > -1) {
                return 0;
            }
            return 1;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return -1;
        }
    }

    public TransformationStep getAssociatedStep(MdObjectStore newStore) throws MdException, RemoteException {
        AssociationProperty assocProp = (AssociationProperty)this.getMetadataObject(newStore);
        TransformationStep existingStep = (TransformationStep)assocProp.getOwningPrototype().getUsedByPrototypes(false).elementAt(0);
        return existingStep;
    }

    public TransformationStep getAssociatedStep() throws MdException, RemoteException {
        AssociationProperty assocProp = (AssociationProperty)this.getMetadataObject();
        if (assocProp == null) {
            return null;
        }
        Prototype proto = assocProp.getOwningPrototype();
        if (proto == null) {
            return null;
        }
        AssociationList list = proto.getUsedByPrototypes(false);
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        TransformationStep existingStep = (TransformationStep)assocProp.getOwningPrototype().getUsedByPrototypes(false).elementAt(0);
        return existingStep;
    }

    public WAPFDNodeModel getAssociatedTransformNodeModel() throws MdException, RemoteException {
        TransformationStep step = this.getAssociatedStep();
        if (step == null) {
            return null;
        }
        return this.m_parentPanel.getNodeModel(step.getFQID());
    }

    public boolean fCanDeleteInputTemplate() throws MdException, RemoteException {
        WAPFDTransformNodeModel transformModel = (WAPFDTransformNodeModel)this.getAssociatedTransformNodeModel();
        if (transformModel == null) {
            return true;
        }
        return transformModel.fCanDeleteTemplate(this.getAssociatedStep(), 0, (AssociationProperty)this.getMetadataObject());
    }

    public boolean fCanDeleteOutputTemplate() throws MdException, RemoteException {
        WAPFDTransformNodeModel transformModel = (WAPFDTransformNodeModel)this.getAssociatedTransformNodeModel();
        if (transformModel == null) {
            return true;
        }
        return transformModel.fCanDeleteTemplate(this.getAssociatedStep(), 1, (AssociationProperty)this.getMetadataObject());
    }

    private TransformationStep getLoopEndFromLoop(TransformationStep loop) throws MdException, RemoteException {
        if (loop.getPredecessorDependencies(false).size() == 0) {
            return null;
        }
        StepPrecedence sp = (StepPrecedence)loop.getPredecessorDependencies().get(0);
        if (sp.getSuccessors().size() == 0) {
            return null;
        }
        TransformationStep jobStep = (TransformationStep)sp.getSuccessors().get(0);
        if (jobStep.getPredecessorDependencies(false).size() == 0) {
            return null;
        }
        sp = (StepPrecedence)jobStep.getPredecessorDependencies().get(0);
        if (sp.getSuccessors().size() == 0) {
            return null;
        }
        TransformationStep loopEnd = (TransformationStep)sp.getSuccessors().get(0);
        return loopEnd;
    }

    public void connectNodeMetadata(MdObjectStore newStore, WAPFDNodeInterface fromNode, WAPFDNodeInterface toNode, ArrayList arrReturningData) throws MdException, RemoteException, PFDException {
        this.connectNodeMetadata(newStore, fromNode, toNode, arrReturningData, null, null);
    }

    public void connectNodeMetadata(MdObjectStore newStore, WAPFDNodeInterface fromNode, WAPFDNodeInterface toNode, ArrayList arrReturningData, WorkTable outWorkTable, WorkTable inWorkTable) throws MdException, RemoteException, PFDException {
        AssociationProperty assocProp = (AssociationProperty)this.getMetadataObject(newStore);
        TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
        WAPFDNodeModel existingNodeModel = this.m_parentPanel.getNodeModel(existingStep.getFQID());
        WAPFDNodeModel replacingNodeModel = ((WAPFDNode)fromNode).getWAPFDNodeModel();
        CMetadata replacingObject = replacingNodeModel.getMetadataObject(newStore);
        arrReturningData.add(existingStep);
        Object outputObject = null;
        if (assocProp.getMetadataType().indexOf("INPUT") > -1) {
            WAPFDTransformNodeModel transformModel;
            if (replacingObject instanceof TransformationStep) {
                TransformationStep newStep = (TransformationStep)replacingObject;
                transformModel = (WAPFDTransformNodeModel)existingNodeModel;
                transformModel.hookupSP(newStore, newStep, existingStep);
                if (existingNodeModel instanceof WAPFDTransformComputeNodeModel) {
                    // empty if block
                }
                outputObject = outWorkTable == null ? transformModel.findOutputClassifierOnThisStepToMapTo(newStore, newStep) : outWorkTable;
                boolean bothLookups = false;
                if (MacroPluginUtilities.isOrderTypeTransform(newStep) && MacroPluginUtilities.isOrderTypeTransform(existingStep)) {
                    bothLookups = true;
                }
                if (MacroPluginUtilities.isOrderTypeTransform(newStep) && !bothLookups) {
                    ClassifierMap map;
                    AssociationList properties = ((Prototype)newStep.getUsingPrototypes().get(0)).getPrototypeProperties();
                    AssociationProperty holdProperty = null;
                    for (int i = 0; i < properties.size(); ++i) {
                        AssociationProperty tempProperty = (AssociationProperty)properties.get(i);
                        if (!tempProperty.getMetadataType().equalsIgnoreCase("OUTPUT")) continue;
                        holdProperty = tempProperty;
                        break;
                    }
                    if (holdProperty != null && !newStep.getTransformations(false).isEmpty() && !(map = (ClassifierMap)newStep.getTransformations(false).get(0)).getClassifierTargets().isEmpty()) {
                        WorkTable table = (WorkTable)map.getClassifierTargets().get(0);
                        holdProperty.setUsingPrototype((Root)table);
                    }
                }
            } else {
                outputObject = replacingObject;
                if (outputObject instanceof Classifier && WAPFDTableNodeModel.isOutputTable((Job)this.m_activeJob, (Classifier)outputObject)) {
                    TransformationStep loaderStep = WAPFDTableNodeModel.getTableLoader((Job)this.m_activeJob, (Classifier)outputObject);
                    transformModel = (WAPFDTransformNodeModel)existingNodeModel;
                    if (loaderStep != null) {
                        TransformationStep loopEnd;
                        if (loaderStep instanceof SyncStep && loaderStep.getTransformRole().equalsIgnoreCase("Loop") && (loopEnd = this.getLoopEndFromLoop(loaderStep)) != null) {
                            loaderStep = loopEnd;
                        }
                        transformModel.hookupSP(newStore, loaderStep, existingStep);
                    }
                }
            }
            boolean bTableAdded = false;
            if (existingStep instanceof SyncStep && ((SyncStep)existingStep).getTransformations().size() == 0 && !(replacingObject instanceof SyncStep)) {
                TransformationStep nextStep = ((WAPFDTransformNodeModel)existingNodeModel).findNextDataStep(existingStep);
                if (nextStep != null) {
                    for (int i = 0; i < nextStep.getTransformations(false).size(); ++i) {
                        ClassifierMap existingMap = (ClassifierMap)nextStep.getTransformations().elementAt(i);
                        existingMap.getClassifierSources(false).add(outputObject);
                    }
                }
            } else if (replacingObject.getCMetadataType().equalsIgnoreCase("Transformation")) {
                existingStep.getTargetTransformations().add((Object)replacingObject);
                Vector links = fromNode.getInputLinks();
                for (int i = 0; i < links.size(); ++i) {
                    WAPFDLink link = (WAPFDLink)links.get(i);
                    TransformationStep fromStep = (TransformationStep)link.getWAFromNode().getWAPFDNodeModel().getMetadataObject(newStore);
                    ((WAPFDTransformNodeModel)existingNodeModel).hookupSP(newStore, fromStep, existingStep);
                }
            } else {
                TransformationStep nextStep;
                AssociationList stepTrans;
                ClassifierMap map;
                for (int i = 0; i < existingStep.getTransformations(false).size(); ++i) {
                    if (!(existingStep.getTransformations().elementAt(i) instanceof Job)) {
                        ClassifierMap existingMap = (ClassifierMap)existingStep.getTransformations().elementAt(i);
                        if (existingMap.getTransformRole().equals("Contents")) {
                            if (existingMap.getClassifierSources().isEmpty()) continue;
                            DataTable table = (DataTable)existingMap.getClassifierSources(false).get(0);
                            if (outputObject instanceof SASLibrary) {
                                table.getTablePackages(false).add(outputObject);
                                continue;
                            }
                            if (!(outputObject instanceof DataTable)) continue;
                            throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                        }
                        if (outputObject == null) continue;
                        existingMap.getClassifierSources(false).add(outputObject);
                        bTableAdded = true;
                        continue;
                    }
                    ArrayList inputCM = ((WAPFDJobNodeModel)existingNodeModel).findInputCMsOnThisStepToMapTo(existingStep);
                    if (outputObject == null) continue;
                    for (int t = 0; t < inputCM.size(); ++t) {
                        map = (ClassifierMap)inputCM.get(t);
                        map.getClassifierSources().add(outputObject);
                    }
                }
                if (outputObject != null && replacingObject instanceof TransformationStep && ((TransformationStep)replacingObject).getTransformRole().equalsIgnoreCase("SASReturnCodeCheck") && !bTableAdded && !(stepTrans = (nextStep = replacingNodeModel.findNextDataStep((TransformationStep)replacingObject)).getTransformations(false)).isEmpty()) {
                    for (int t = 0; t < stepTrans.size(); ++t) {
                        map = (ClassifierMap)stepTrans.get(t);
                        map.getClassifierSources().add(outputObject);
                    }
                }
            }
        } else if (replacingObject instanceof Classifier) {
            if (existingStep.getTransformRole().indexOf("Loader") == -1) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            ClassifierMap map = (ClassifierMap)existingStep.getTransformations(false).elementAt(0);
            map.getClassifierTargets(false).add((Object)replacingObject);
            if (replacingObject instanceof DataTable) {
                Vector links = fromNode.getOutputLinks();
                for (int i = 0; i < links.size(); ++i) {
                    WAPFDLink link = (WAPFDLink)links.get(i);
                    TransformationStep toStep = (TransformationStep)link.getWAToNode().getWAPFDNodeModel().getMetadataObject(newStore);
                    ((WAPFDTransformNodeModel)existingNodeModel).hookupSP(newStore, existingStep, toStep);
                }
            }
        } else if (replacingObject.getCMetadataType().equalsIgnoreCase("Transformation")) {
            existingStep.getSourceTransformations().add((Object)replacingObject);
            Vector links = fromNode.getOutputLinks();
            for (int i = 0; i < links.size(); ++i) {
                WAPFDLink link = (WAPFDLink)links.get(i);
                TransformationStep toStep = (TransformationStep)link.getWAToNode().getWAPFDNodeModel().getMetadataObject(newStore);
                ((WAPFDTransformNodeModel)existingNodeModel).hookupSP(newStore, existingStep, toStep);
            }
        } else if (replacingObject instanceof TransformationStep) {
            ArrayList inputCM = null;
            TransformationStep replacingStep = (TransformationStep)replacingObject;
            WAPFDTransformNodeModel replacingTransformNodeModel = (WAPFDTransformNodeModel)replacingNodeModel;
            replacingTransformNodeModel.hookupSP(newStore, existingStep, replacingStep);
            if (existingNodeModel instanceof WAPFDTransformComputeNodeModel) {
                // empty if block
            }
            if (replacingStep != null && replacingStep instanceof SyncStep && ((SyncStep)replacingStep).getTransformations().size() == 0) {
                TransformationStep step = replacingTransformNodeModel.findNextDataStep(replacingStep);
                inputCM = replacingTransformNodeModel.findInputCMsOnThisStepToMapTo(step);
            } else {
                inputCM = replacingTransformNodeModel.findInputCMsOnThisStepToMapTo(replacingStep);
            }
            Object output = null;
            if (MacroPluginUtilities.isGeneratedTransform((Root)existingStep) && !MacroPluginUtilities.isTemplateDefault(assocProp) && assocProp.getUsingPrototypes().size() > 0) {
                output = (Classifier)assocProp.getUsingPrototypes().get(0);
            }
            if (output == null) {
                output = inWorkTable == null ? ((WAPFDTransformNodeModel)existingNodeModel).findOutputClassifierOnThisStepToMapTo(newStore, existingStep) : inWorkTable;
            }
            if (output != null) {
                AssociationProperty property;
                for (int i = 0; i < inputCM.size(); ++i) {
                    output.getSourceClassifierMaps(false).add(inputCM.get(i));
                }
                if ((MacroPluginUtilities.isGeneratedTransform((Root)replacingStep) || MacroPluginUtilities.isOrderTypeTransform(replacingStep)) && !MacroPluginUtilities.isTemplateDefault(property = (AssociationProperty)MacroPluginUtilities.getNextAvailableObjectToConnectTo(newStore, replacingStep, "INPUT"))) {
                    property.getUsingPrototypes().add(output);
                }
            }
        }
        if (outWorkTable != null) {
            replacingObject = outWorkTable;
        }
        MacroPluginUtilities.createLinkToAssociationProperty(existingStep, assocProp, replacingObject);
    }

    @Override
    public void delete(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        Vector inputLinks = this.m_viewNode.getInputLinks();
        Vector outputLinks = this.m_viewNode.getOutputLinks();
        if (outputLinks.size() > 0) {
            WAPFDLink outputLink = (WAPFDLink)outputLinks.elementAt(0);
            outputLink.doDeleteOutputLink(affectedObjects);
        }
        if (inputLinks.size() > 0) {
            WAPFDLink inputLink = (WAPFDLink)inputLinks.elementAt(0);
            WAPFDNodeInterface workFromNode = inputLink.getWAFromNode();
            if (workFromNode instanceof WAPFDWorkTableNode) {
                WAPFDNodeInterface fromNode;
                WAPFDLink workInputLink = null;
                Vector workInputLinks = workFromNode.getInputLinks();
                if (workInputLinks != null && !workInputLinks.isEmpty() && (fromNode = (workInputLink = (WAPFDLink)workInputLinks.elementAt(0)).getWAFromNode()) instanceof WAPFDNode) {
                    TransformationStep step = (TransformationStep)fromNode.getWAPFDNodeModel().getMetadataObject();
                    WAPFDTransformNodeModel fromModel = (WAPFDTransformNodeModel)fromNode.getWAPFDNodeModel();
                    fromModel.deleteWorkTableNodeAndLink((WorkTable)workFromNode.getWAPFDNodeModel().getMetadataObject(), affectedObjects);
                    boolean bFound = false;
                    int iNumMaxOutputTemplates = fromModel.getMaxVisibleTemplates(step, "OUTPUT");
                    if (step.getTransformations().size() > iNumMaxOutputTemplates) {
                        AssociationList stepTransformations = step.getTransformations(false);
                        for (int iTable = 0; iTable < stepTransformations.size(); ++iTable) {
                            ClassifierMap oMap = (ClassifierMap)stepTransformations.get(iTable);
                            for (int p = 0; p < oMap.getClassifierTargets(false).size(); ++p) {
                                DataTable oTable = (DataTable)oMap.getClassifierTargets(false).get(p);
                                if (oTable == null || !(oTable instanceof WorkTable) || !oTable.getFQID().equalsIgnoreCase(workFromNode.getWAPFDNodeModel().getMetadataObject().getFQID())) continue;
                                affectedObjects.add(oTable);
                                ((MdObjectStore)step.getObjectStore()).removeObjectFromStore((CMetadata)oTable, "<WorkTable><Indexes/><PropertySets><SetProperties/><Properties/></PropertySets><Columns><Column><PropertySets><SetProperties/><Properties/></PropertySets></Column></Columns></WorkTable>");
                                if (step.getTransformRole().equalsIgnoreCase("SASSplitter") && stepTransformations.size() > 2) {
                                    ((MdObjectStore)step.getObjectStore()).removeObjectFromStore((CMetadata)oMap, "<ClassifierMap/>");
                                }
                                bFound = true;
                                break;
                            }
                            if (bFound) break;
                        }
                    }
                }
            }
            inputLink.doDeleteInputLink(affectedObjects);
        }
        this.m_viewNode.deleteNode();
    }
}

