/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDTableNodeModel;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTemplateNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformComputeNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNode;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.pfd.WAPFDWorkTableNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformLimitTypeInterface;
import com.sas.wadmin.plugins.TransformRejectNodeDrops;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.FileWriter;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;

public class WAPFDTableNode
extends WAPFDNode
implements WAPFDPrimitiveInterface {
    public WAPFDTableNode(Point loc, Dimension dim, int Shape2, ImageIcon image, String sCaption, WAPFDTableNodeModel Model, PFDPanel parentPanel) {
        super(loc, dim, Shape2, image, sCaption, Model, parentPanel);
    }

    public WAPFDTableNode(Point loc, ImageIcon image, String sCaption, WAPFDTableNodeModel Model, PFDPanel parentPanel) {
        super(loc, new Dimension(35, 35), 5, image, sCaption, Model, parentPanel);
        this.getDrawable().getPen().setLineWidth(3.0f);
        this.getDrawable().getPen().setColor(new Color(252, 181, 38));
        this.getDrawable().getBrush().setColor(new Color(254, 222, 158));
    }

    @Override
    public boolean fCanShowPopup() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanViewStepCode() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanDelete() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanShowProperties() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanMakeOutput() throws MdException, RemoteException, PFDException {
        return !((WAPFDTableNodeModel)this.m_nodeModel).isOutputTable();
    }

    @Override
    public boolean fCanViewJob() throws MdException, RemoteException, PFDException {
        return false;
    }

    public void makeOutput() throws MdException, RemoteException, PFDException {
        ((WAPFDTableNodeModel)this.m_nodeModel).makeOutput();
    }

    @Override
    public boolean fCanShowImpact() throws MdException, RemoteException, PFDException {
        CMetadata iObj = this.m_nodeModel.getMetadataObject();
        return iObj instanceof PhysicalTable || iObj.getCMetadataType().equals("Cube") || iObj.getCMetadataType().equals("ExternalTable");
    }

    @Override
    public boolean fCanShowReverseImpact() throws MdException, RemoteException, PFDException {
        CMetadata iObj = this.m_nodeModel.getMetadataObject();
        return iObj instanceof PhysicalTable || iObj.getCMetadataType().equals("Cube") || iObj.getCMetadataType().equals("ExternalTable");
    }

    @Override
    public boolean fCanViewData() throws MdException, RemoteException, PFDException {
        CMetadata iObj = this.m_nodeModel.getMetadataObject();
        return iObj.getCMetadataType().equals("PhysicalTable") || iObj.getCMetadataType().equals("ExternalTable");
    }

    @Override
    public void viewData() {
        CMetadata iObj = this.m_nodeModel.getMetadataObject();
        WsViewFactory.showView((CMetadata)iObj, ViewDataView.class);
    }

    @Override
    public void showImpactAnalysis(boolean bForward) {
        CMetadata iObj = this.m_nodeModel.getMetadataObject();
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            CMetadata detailsObject = Workspace.getMdFactory().createComplexMetadataObject(store, iObj);
            detailsObject.setName(iObj.getName());
            if (detailsObject instanceof PhysicalTable || detailsObject.getCMetadataType().equals("Cube") || detailsObject.getCMetadataType().equals("ExternalTable")) {
                ImpactAnalysisOMAView view = this.findImpactAnalysisView((Classifier)detailsObject, bForward);
                if (view != null) {
                    detailsObject.getObjectStore().dispose();
                    WsViewFactory.showExistingView((WsOMAView)view);
                    return;
                }
                view = new ImpactAnalysisOMAView((Classifier)detailsObject, bForward);
                WsViewFactory.attachViewToFrame((CMetadata)detailsObject, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame(detailsObject, ""));
            } else if (detailsObject instanceof Transformation) {
                ImpactAnalysisOMAView view = this.findImpactAnalysisView((Transformation)detailsObject, bForward);
                if (view != null) {
                    detailsObject.getObjectStore().dispose();
                    WsViewFactory.showExistingView((WsOMAView)view);
                    return;
                }
                view = new ImpactAnalysisOMAView((Transformation)detailsObject, bForward);
                WsViewFactory.attachViewToFrame((CMetadata)detailsObject, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame(detailsObject, ""));
            } else if (store != null) {
                store.dispose();
                store = null;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(Classifier oTable, boolean bForward) {
        try {
            ArrayList lViews = oTable.getViewList();
            int nViews = lViews.size();
            for (int iView = 0; iView < nViews; ++iView) {
                ImpactAnalysisOMAView view;
                if (!lViews.get(iView).getClass().equals(ImpactAnalysisOMAView.class) || (view = (ImpactAnalysisOMAView)((Object)lViews.get(iView))).isForward() != bForward) continue;
                return view;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(Transformation oTrans, boolean bForward) {
        try {
            ArrayList lViews = oTrans.getViewList();
            int nViews = lViews.size();
            for (int iView = 0; iView < nViews; ++iView) {
                ImpactAnalysisOMAView view;
                if (!lViews.get(iView).getClass().equals(ImpactAnalysisOMAView.class) || (view = (ImpactAnalysisOMAView)((Object)lViews.get(iView))).isForward() != bForward) continue;
                return view;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    public void viewJob() {
    }

    public static void isValidLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation) throws MdException, RemoteException, PFDException {
        if (primLogicalLocation instanceof WAPFDNode) {
            if ((primLogicalLocation instanceof WAPFDTableNode || primLogicalLocation instanceof WAPFDTransformLoaderNode) && !(primLogicalLocation instanceof WAPFDWorkTableNode)) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (!(primLogicalLocation instanceof WAPFDWorkTableNode)) {
                TransformationStep step;
                WAPFDTransformNodeModel transformNodeModel = (WAPFDTransformNodeModel)((WAPFDTransformNode)primLogicalLocation).getWAPFDNodeModel();
                TransformInterface transformInterface = transformNodeModel.getTransformFromStep(step = (TransformationStep)transformNodeModel.getMetadataObject(newStore));
                if (transformInterface instanceof TransformRejectNodeDrops) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_TRANFORMREJECTSNODEDROPS.txt");
                }
                if (((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingInputTemplates() > 0 || ((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingOutputTemplates() > 0) {
                    if (transformNodeModel.isMultiInputNode() && transformNodeModel.fNodeHasSpace(newStore, 0) && ((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingInputTemplates() > 0) {
                        throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPONTONODEWITHTEMPLATES.txt");
                    }
                    if (transformNodeModel.isMultiOutputNode() && transformNodeModel.fNodeHasSpace(newStore, 1) && ((WAPFDTransformNode)transformNodeModel.getViewNode()).getShowingOutputTemplates() > 0) {
                        throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPONTONODEWITHTEMPLATES.txt");
                    }
                    if (!transformNodeModel.isMultiInputNode() && !transformNodeModel.isMultiOutputNode()) {
                        throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPONTONODEWITHTEMPLATES.txt");
                    }
                }
                if (!transformNodeModel.fNodeHasSpace(newStore, 0) && !transformNodeModel.fNodeHasSpace(newStore, 1)) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
            } else {
                WAPFDLink workOutputLink;
                WAPFDNodeInterface workToNode;
                WAPFDNodeModel nodeModel;
                WAPFDWorkTableNodeModel workTableNodeModel = (WAPFDWorkTableNodeModel)((WAPFDWorkTableNode)primLogicalLocation).getWAPFDNodeModel();
                WorkTable workTable = (WorkTable)workTableNodeModel.getMetadataObject(newStore);
                AssociationList mdProperties = workTable.getUsedByPrototypes(false);
                AssociationProperty mdProperty = null;
                if (!mdProperties.isEmpty()) {
                    mdProperty = (AssociationProperty)mdProperties.get(0);
                }
                TransformationStep step = workTableNodeModel.getTransformStep(newStore);
                Prototype mdPFDTemplate = (Prototype)step.getUsingPrototype();
                AssociationList lProperties = mdPFDTemplate.getPrototypeProperties();
                int type = lProperties.indexOf(mdProperty);
                if (step.getTransformRole().equalsIgnoreCase("Lookup") && type != 100) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                Vector workOutputLinks = workTableNodeModel.getViewNode().getOutputLinks();
                if (workOutputLinks != null && !workOutputLinks.isEmpty() && (nodeModel = (workToNode = (workOutputLink = (WAPFDLink)workOutputLinks.elementAt(0)).getWAToNode()).getWAPFDNodeModel()) instanceof WAPFDTransformComputeNodeModel && ((TransformationStep)nodeModel.getMetadataObject(newStore)).getTransformRole().indexOf("SASReturnCodeCheck") > -1) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
            }
        } else {
            if (primLogicalLocation instanceof WAPFDLink) {
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTABLEONTOLINK.txt");
            }
            if (primLogicalLocation instanceof WAPFDTemplateNode) {
                String type;
                WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primLogicalLocation;
                AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
                TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
                if (templateNode.getOutputLinks().size() > 0 && existingStep instanceof SyncStep && existingStep.getTransformations().size() == 0) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTABLEONTOSYNCTEMPLATE.txt");
                }
                if (existingStep.getTransformRole().indexOf("SASJob") > -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
                }
                WAPFDTransformNodeModel model = (WAPFDTransformNodeModel)((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel();
                TransformInterface transformInterface = model.getTransformFromStep(existingStep);
                if (transformInterface instanceof TransformLimitTypeInterface && (type = assocProp.getAssociationName()).indexOf("ALL") == -1 && type.indexOf("PhysicalTable") == -1 && type.indexOf("ClassifierSources") == -1 && type.indexOf("ClassifierTargets") == -1) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
                }
            }
        }
    }

    @Override
    public void checkReconnectLocation(PFDPrimitive primitive) throws MdException, RemoteException, PFDException {
        if (primitive instanceof WAPFDTemplateNode) {
            WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primitive;
            AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
            WAPFDTransformNodeModel stepNodeModel = (WAPFDTransformNodeModel)((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel();
            TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
            if (existingStep instanceof SyncStep && existingStep.getTransformations().size() == 0 && !existingStep.getTransformRole().equalsIgnoreCase("LOOPEND") && !existingStep.getTransformRole().equalsIgnoreCase("LOOP")) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPTABLEONTOOUTSYNCTEMPLATE.txt");
            }
            if (existingStep.getTransformRole().equalsIgnoreCase("LOOPEND") && templateNode.getOutputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (existingStep.getTransformRole().equalsIgnoreCase("LOOP") && templateNode.getInputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (existingStep.getTransformRole().indexOf("SASJob") > -1) {
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
            if (existingStep.getTransformRole().indexOf("QueueReader") > -1 && templateNode.getOutputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
            }
            if (existingStep.getTransformRole().indexOf("FileReader") > -1 && templateNode.getOutputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
            }
            TransformInterface transformInterface = stepNodeModel.getTransformFromStep(existingStep);
            if (transformInterface instanceof FileWriter && templateNode.getInputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDEPHYSICALTABLE.txt");
            }
        }
    }
}

