/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDSASLibraryNodeModel;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTemplateNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformLimitTypeInterface;
import com.sas.wadmin.visuals.FileWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;

public class WAPFDSASLibraryNode
extends WAPFDNode
implements WAPFDPrimitiveInterface {
    public WAPFDSASLibraryNode(Point loc, ImageIcon image, String sCaption, WAPFDSASLibraryNodeModel nodeModel, PFDPanel parentPanel) {
        super(loc, new Dimension(36, 36), 5, image, sCaption, nodeModel, parentPanel);
        this.getDrawable().getPen().setLineWidth(3.0f);
        this.getDrawable().getPen().setColor(new Color(252, 181, 38));
        this.getDrawable().getBrush().setColor(new Color(254, 222, 158));
    }

    @Override
    public boolean fCanViewStepCode() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewData() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanDelete() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanShowProperties() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanMakeOutput() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewJob() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowPopup() throws MdException, RemoteException, PFDException {
        return true;
    }

    public static void isValidLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation) throws MdException, RemoteException, PFDException {
        if (primLogicalLocation instanceof WAPFDNode) {
            throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
        }
        if (primLogicalLocation instanceof WAPFDLink) {
            throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPSASLIBONTOLINK.txt");
        }
        if (primLogicalLocation instanceof WAPFDTemplateNode) {
            WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primLogicalLocation;
            AssociationProperty assocProp = (AssociationProperty)((WAPFDTemplateNode)primLogicalLocation).getWAPFDNodeModel().getMetadataObject();
            TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
            WAPFDTransformNodeModel model = (WAPFDTransformNodeModel)((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel();
            TransformInterface transformInterface = model.getTransformFromStep(existingStep);
            if (transformInterface instanceof TransformLimitTypeInterface) {
                String type = assocProp.getAssociationName();
                if (!type.equals("ALL") && !type.equals("SASLibrary")) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDESASLIBRARY.txt");
                }
                if (assocProp.getMetadataType().equals("OUTPUT")) {
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
            }
            boolean fIsOutputTemplate = true;
            if (templateNode.getOutputLinks().size() > 0) {
                fIsOutputTemplate = false;
            }
            if (fIsOutputTemplate) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPSASLIBRARYONTOOUTPUTTEMPLATE.txt");
            }
        }
    }

    @Override
    public void checkReconnectLocation(PFDPrimitive primitive) throws MdException, RemoteException, PFDException {
        if (primitive instanceof WAPFDTemplateNode) {
            WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primitive;
            AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
            WAPFDTransformNodeModel stepNodeModel = (WAPFDTransformNodeModel)((WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel()).getAssociatedTransformNodeModel();
            TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
            boolean fIsOutputTemplate = true;
            if (templateNode.getOutputLinks().size() > 0) {
                fIsOutputTemplate = false;
            }
            if (fIsOutputTemplate) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPSASLIBRARYONTOOUTPUTTEMPLATE.txt");
            }
            TransformInterface transformInterface = stepNodeModel.getTransformFromStep(existingStep);
            if (transformInterface instanceof FileWriter && templateNode.getInputLinks().size() > 0) {
                throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_LIMITTYPEDOESNTINCLUDESASLIBRARY.txt");
            }
        }
    }
}

