/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PFDMetadataParsing {
    public static final int OMI_ALL = 1;
    public static final int OMI_EXPAND = 2;
    public static final int OMI_TEMPLATE = 4;
    public static final int OMI_ALL_SIMPLE = 8;
    public static final int OMI_INCLUDE_SUBTYPES = 16;
    public static final int OMI_XMLSELECT = 128;
    public static final int OMI_GET_METADATA = 256;

    public static CMetadata populateNewObjects(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, String reposID, ArrayList inputs, ArrayList outputs) {
        metaObject = PFDMetadataParsing.doSimple(metaObject, simpleNodeMap, inputs, outputs);
        ArrayList outComplexNames = new ArrayList();
        ArrayList[] outComplexObjects = new ArrayList[1];
        outComplexObjects = PFDMetadataParsing.doComplex(metaObject, complexNodeList, outComplexNames, outComplexObjects, reposID, inputs, outputs);
        PFDMetadataParsing.setComplex(metaObject, outComplexNames, outComplexObjects);
        return metaObject;
    }

    private static CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap, ArrayList inputs, ArrayList outputs) {
        int iLengthinSimpleAttr = thisNodeMap.getLength();
        Class[] classes = new Class[]{String.class, Integer.TYPE};
        Integer state = new Integer(1);
        boolean AssocProptype = false;
        if (thisObject instanceof AssociationProperty) {
            AssocProptype = true;
        }
        for (int i = 0; i < iLengthinSimpleAttr; ++i) {
            try {
                try {
                    StringBuffer strTemp = new StringBuffer("set");
                    Object[] args = null;
                    if (AssocProptype && thisNodeMap.item(i).getNodeName().equals("MetadataType")) {
                        String value = thisNodeMap.item(i).getNodeValue();
                        if (value.indexOf("INPUT") > -1) {
                            inputs.add(thisObject);
                        } else if (value.indexOf("OUTPUT") > -1) {
                            outputs.add(thisObject);
                        }
                    }
                    strTemp.append(thisNodeMap.item(i).getNodeName());
                    args = new Object[]{thisNodeMap.item(i).getNodeValue(), state};
                    Method method = thisObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classes);
                    try {
                        method.invoke((Object)thisObject, args);
                    }
                    catch (InvocationTargetException e) {
                        Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::doSimple - Error calling method on object: " + thisObject.getFQID()));
                    }
                    catch (IllegalAccessException e) {
                        Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::doSimple - Access error on method: " + strTemp.substring(0, strTemp.length()) + "on object: " + thisObject.getFQID()));
                    }
                }
                catch (NoSuchMethodException e) {
                    Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::doSimple: Can't set attribute " + thisNodeMap.item(i).getNodeName() + " on object: " + thisObject.getFQID()));
                }
                continue;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return thisObject;
    }

    private static ArrayList[] doComplex(CMetadata thisObject, NodeList thisNodeList, ArrayList outComplexNames, ArrayList[] outComplexObjects, String reposID, ArrayList inputs, ArrayList outputs) {
        try {
            String name = "";
            int numChildLists = thisNodeList.getLength();
            MdStore thisStore = thisObject.getObjectStore();
            outComplexObjects = new ArrayList[numChildLists];
            for (int k = 0; k < numChildLists; ++k) {
                NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
                int length = myChildNodeList.getLength();
                outComplexObjects[k] = new ArrayList(length);
                outComplexNames.add(k, thisNodeList.item(k).getNodeName());
                for (int i = 0; i < length; ++i) {
                    NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                    String strType = myChildNodeList.item(i).getNodeName();
                    Node nameNode = childNodeMap2.getNamedItem("Name");
                    if (nameNode != null) {
                        name = nameNode.getNodeValue();
                    }
                    CMetadata complexObject = null;
                    complexObject = thisStore.getStoreType() == 1 ? Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)thisStore, null, name, strType, reposID, null) : Workspace.getMdFactory().createComplexMetadataObjectServerStoreOnly(name, strType, reposID);
                    thisObject.addElementToChangeList(complexObject);
                    complexObject = PFDMetadataParsing.populateNewObjects(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), reposID, inputs, outputs);
                    outComplexObjects[k].add(complexObject);
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return outComplexObjects;
    }

    private static void setComplex(CMetadata metaObject, ArrayList outComplexNames, ArrayList[] outComplexObjects) {
        int length = outComplexNames.size();
        Class[] classes = new Class[]{AssociationList.class};
        for (int i = 0; i < length; ++i) {
            String AssocName = (String)outComplexNames.get(i);
            AssociationList complexAssoc = new AssociationList(AssocName, (Collection)outComplexObjects[i]);
            complexAssoc.setState(4);
            try {
                StringBuffer strTemp = new StringBuffer("set");
                strTemp.append(AssocName);
                if (!AssocName.endsWith("s")) {
                    strTemp.append("s");
                }
                Method method = metaObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classes);
                Object[] args = new Object[]{complexAssoc};
                try {
                    method.invoke((Object)metaObject, args);
                }
                catch (InvocationTargetException e) {
                    Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::setComplex -> Can't call method: " + strTemp.substring(0, strTemp.length()) + ", Object not found"));
                }
                catch (IllegalAccessException e) {
                    Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::setComplex -> Can't call method: " + strTemp.substring(0, strTemp.length()) + ", No Permission"));
                }
                continue;
            }
            catch (NoSuchMethodException e) {
                try {
                    Workspace.getDefaultLogger().debug((Object)("PFDMetadataParsing::setComplex -> Can't set association: " + AssocName + ", on object:" + metaObject.getCMetadataType() + ", ID: " + metaObject.getFQID()));
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    public static void copyObjects(MdObjectStore pasteBuffer, CMetadata newObject, CMetadata oldObject, String copyTemplate, HashMap returningMap) {
        try {
            MdStoreUtil.copyObjectAttributes((CMetadata)oldObject, (CMetadata)newObject);
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(copyTemplate);
            Node firstNode = doc.getFirstChild();
            PFDMetadataParsing.doCopy(pasteBuffer, oldObject, newObject, firstNode, returningMap);
            returningMap.put(oldObject.getFQID(), newObject);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"parsing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private static void doCopy(MdObjectStore pasteBuffer, CMetadata oldObject, CMetadata newObject, Node currentNode, HashMap returningMap) {
        NodeList currentNodeList = currentNode.getChildNodes();
        int numChildLists = currentNodeList.getLength();
        for (int k = 0; k < numChildLists; ++k) {
            String associationName = currentNodeList.item(k).getNodeName();
            NodeList myChildNodeList = currentNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            if (length == 0) {
                try {
                    StringBuffer strTemp = new StringBuffer("get");
                    strTemp.append(associationName);
                    if (!associationName.endsWith("s")) {
                        strTemp.append("s");
                    }
                    AssociationList oldAssociatedObjects = null;
                    AssociationList newAssociatedObjects = null;
                    Class[] classArray = new Class[]{Boolean.TYPE};
                    Method method = oldObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classArray);
                    Object[] args = new Object[]{new Boolean(false)};
                    oldAssociatedObjects = (AssociationList)method.invoke((Object)oldObject, args);
                    method = newObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classArray);
                    newAssociatedObjects = (AssociationList)method.invoke((Object)newObject, args);
                    for (int p = 0; p < oldAssociatedObjects.size(); ++p) {
                        newAssociatedObjects.add(oldAssociatedObjects.elementAt(p));
                    }
                    continue;
                }
                catch (Exception ex3) {
                    Workspace.getDefaultLogger().debug((Object)"", (Throwable)ex3);
                    continue;
                }
            }
            for (int b = 0; b < myChildNodeList.getLength(); ++b) {
                Node grandChildNode = myChildNodeList.item(b);
                AssociationList oldAssociatedObjects = null;
                AssociationList newAssociatedObjects = null;
                try {
                    StringBuffer strTemp = new StringBuffer("get");
                    strTemp.append(associationName);
                    if (!associationName.endsWith("s")) {
                        strTemp.append("s");
                    }
                    Class[] classArray = new Class[]{Boolean.TYPE};
                    Method method = oldObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classArray);
                    Object[] args = new Object[]{new Boolean(false)};
                    oldAssociatedObjects = (AssociationList)method.invoke((Object)oldObject, args);
                }
                catch (Exception ex3) {
                    Workspace.getDefaultLogger().debug((Object)"", (Throwable)ex3);
                }
                try {
                    if (oldAssociatedObjects.size() <= 0) continue;
                    for (int p = 0; p < oldAssociatedObjects.size(); ++p) {
                        CMetadata oldAssociatedObject = (CMetadata)oldAssociatedObjects.elementAt(p);
                        String newName = "Copy of " + oldAssociatedObject.getName();
                        CMetadata newAssociatedObject = Workspace.getMdFactory().createComplexMetadataObject(pasteBuffer, null, newName, oldAssociatedObject.getCMetadataType(), oldAssociatedObject.getRepositoryID());
                        MdStoreUtil.copyObjectAttributes((CMetadata)oldAssociatedObject, (CMetadata)newAssociatedObject);
                        returningMap.put(oldAssociatedObject.getFQID(), newAssociatedObject);
                        try {
                            Object[] args = new Object[]{new Boolean(false)};
                            Class[] classArray = new Class[]{Boolean.TYPE};
                            StringBuffer strTemp = new StringBuffer("get");
                            strTemp.append(associationName);
                            if (!associationName.endsWith("s")) {
                                strTemp.append("s");
                            }
                            Method method = newObject.getClass().getMethod(strTemp.substring(0, strTemp.length()), classArray);
                            newAssociatedObjects = (AssociationList)method.invoke((Object)newObject, args);
                            newAssociatedObjects.add((Object)newAssociatedObject);
                            PFDMetadataParsing.doCopy(pasteBuffer, oldAssociatedObject, newAssociatedObject, grandChildNode, returningMap);
                            continue;
                        }
                        catch (Exception ex) {
                            Workspace.getDefaultLogger().debug((Object)"", (Throwable)ex);
                        }
                    }
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }
}

