/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Feature;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDInformationNodeModel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDPrototypeNode;
import com.sas.wadmin.pfd.WAPFDPrototypeNodeModel;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTableNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformComputeNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.ImpactAnalysisUtilities;
import com.sas.wadmin.visuals.JobTreeNode;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.RawDataView;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.wadmin.visuals.WAPFDPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationFrameworkManager;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ImpactPFDPanel
extends PFDPanel
implements WsSelectionProvider {
    private static WAdminResource bundle = WAdminResource.getBundle(ImpactPFDPanel.class);
    protected CMetadata m_oMetadata;
    protected TransformInterface m_oTransform;
    protected boolean m_bForward;
    protected boolean m_firstNode = false;
    protected WsAbstractAction m_actImpactMenu;
    protected WsAbstractAction m_actColumnImpact;
    protected cModelPopulator m_mdlPopulator;
    protected cImpactLauncher m_impactLauncher;
    private HashMap m_lRepositories;
    private static final String QTRANSFORMROLE_READER = "QueueReader";
    private static final String QTRANSFORMROLE_WRITER1 = "IBMWSQWriter";
    private static final String QTRANSFORMROLE_WRITER2 = "QueueWriter";
    private Object[] m_aSelectedObjects;
    private boolean m_bDoesBIReposExist;
    private String m_BIReposID = "";

    public ImpactPFDPanel(CMetadata oMetadata, boolean bForward) {
        this.m_oMetadata = oMetadata;
        this.m_bForward = bForward;
        this.m_impactLauncher = this.createImpactLauncher();
        this.initialize();
    }

    public ImpactPFDPanel(CMetadata oMetadata, TransformInterface oTransform, boolean bForward) {
        this.m_oMetadata = oMetadata;
        this.m_oTransform = oTransform;
        this.m_bForward = bForward;
        this.m_impactLauncher = this.createImpactLauncher();
        this.initialize();
    }

    @Override
    public void initialize() {
        if (m_layoutDirection == -1) {
            m_layoutDirection = this.m_defaultsFile.getPropertyInt("PFDFrame.LayoutDirection", 0);
        }
        ++m_numPFDs;
        m_vecPFDs.add(this);
        try {
            int i;
            List lRepositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
            this.m_lRepositories = new HashMap();
            for (i = 0; i < lRepositories.size(); ++i) {
                CMetadata repos = (CMetadata)lRepositories.get(i);
                String sFQID = repos.getFQID();
                String sReposName = repos.getName();
                this.m_lRepositories.put(sFQID.substring(9), sReposName);
            }
            this.m_bDoesBIReposExist = false;
            this.m_BIReposID = "";
            for (i = 0; i < lRepositories.size(); ++i) {
                CMetadata tmpMetadata = (CMetadata)lRepositories.get(i);
                if (!tmpMetadata.getName().equalsIgnoreCase("BILineage")) continue;
                this.m_bDoesBIReposExist = true;
                this.m_BIReposID = tmpMetadata.getFQID();
                break;
            }
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.setKeyboardEnabled(false);
        try {
            this.createListeners((MdObjectStore)this.m_oMetadata.getObjectStore());
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.setPopupMenuEnabled(false);
        this.setOpaque(false);
        if (this.m_oMetadata instanceof PhysicalTable || this.m_oMetadata instanceof ExternalTable || this.m_oMetadata instanceof Cube) {
            this.m_mdlPopulator = new cTablePopulator();
        } else if (this.m_oMetadata instanceof Column) {
            this.m_mdlPopulator = new cColumnPopulator();
        } else if (this.m_oMetadata instanceof Prototype) {
            this.m_mdlPopulator = new cTransformPopulator();
        } else if (this.m_oMetadata instanceof Transformation) {
            this.m_mdlPopulator = new cTransformationPopulator();
        }
        super.initialize();
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        if (!this.m_fFirstInstance) {
            int direction = ImpactPFDPanel.getLayoutDirection();
            this.setPanelLayoutDirection(0);
            this.setHoldDisplay(true);
            OpRequestUI op = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("ImpactView.Exec.Desc.txt"), bundle.getString("ImpactView.Exec.Title.txt"));
            op.setDelayBeforeProgressCancelDialog(0);
            op.setProgressShownOnStatusBar(false);
            op.execute((Runnable)this.m_impactLauncher);
            this.m_fFirstInstance = true;
            this.setOpaque(true);
            this.setHoldDisplay(false);
            this.setPanelLayoutDirection(direction);
        }
        if (this.m_fNeedZoomToFit) {
            this.zoomToFit();
        }
        ImpactPFDPanel.updateAllPreferredColors();
        this.updateView();
    }

    @Override
    protected void createListeners(MdObjectStore store) {
        this.m_lsnrMouseListener = this.createMouseListener();
        this.addMouseListener(this.m_lsnrMouseListener);
    }

    @Override
    protected void removeListeners() {
        this.removeMouseListener(this.m_lsnrMouseListener);
        this.m_lsnrMouseListener = null;
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_actProperties.setActive(bActive);
        this.m_actImpactMenu.setActive(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actPrinttogif.setActive(bActive);
        this.m_actViewJob.setActive(bActive);
        this.m_actViewData.setActive(bActive);
        this.m_actViewFile.setActive(bActive);
        this.m_actColumnImpact.setActive(bActive);
        this.updateActions(bActive);
        WsAbstractApplicationFrameworkManager.getInstance().setSelectionProvider((WsSelectionProvider)(bActive ? this : null));
    }

    @Override
    public void showNodePopupMenu(WAPFDPrimitiveInterface object, MouseEvent e) {
        JPopupMenu menuPopup = new JPopupMenu();
        menuPopup.add(new JMenuItem((Action)this.m_actProperties));
        menuPopup.addSeparator();
        menuPopup.add(new JMenuItem((Action)this.m_actColumnImpact));
        menuPopup.addSeparator();
        menuPopup.add(new JMenuItem((Action)this.m_actViewJob));
        menuPopup.add(new JMenuItem((Action)this.m_actViewData));
        menuPopup.add(new JMenuItem((Action)this.m_actViewFile));
        menuPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void showLinkPopupMenu(MouseEvent e) {
    }

    @Override
    public void showCanvasPopupMenu(MouseEvent e) {
        JPopupMenu menuPopup = new JPopupMenu();
        menuPopup.add(new JMenuItem((Action)this.m_actPrint));
        menuPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    private List getNextClassifierMaps(ClassifierMap oCurrentCM, Root prevObject) throws MdException, RemoteException {
        ArrayList nextObjects = new ArrayList();
        if (oCurrentCM.getClassifierTargets().size() == 0) {
            return null;
        }
        Classifier oCurrentTargetObject = (Classifier)oCurrentCM.getClassifierTargets().get(0);
        AssociationList alNextClassifierMaps = oCurrentTargetObject.getSourceClassifierMaps();
        for (int i = 0; i < alNextClassifierMaps.size(); ++i) {
            nextObjects.add(alNextClassifierMaps.get(i));
        }
        return nextObjects;
    }

    private TransformationStep getNextStep(TransformationStep oTS) throws MdException, RemoteException {
        AssociationList alCA = oTS.getReferencedObjects();
        CustomAssociation stepList = null;
        if (alCA.size() > 0) {
            stepList = (CustomAssociation)alCA.get(0);
            AssociationList listOfSteps = stepList.getAssociatedObjects();
            int indexOfoTS = listOfSteps.indexOf((Object)oTS);
            if (this.m_bForward) {
                if (indexOfoTS > -1 && indexOfoTS < stepList.getAssociatedObjects().size() - 1) {
                    return (TransformationStep)listOfSteps.get(indexOfoTS + 1);
                }
                return null;
            }
            if (indexOfoTS > -1 && indexOfoTS > 0 && ((TransformationStep)listOfSteps.get(indexOfoTS - 1)).getTransformations().size() > 0 && ((TransformationStep)listOfSteps.get(indexOfoTS - 1)).getTransformations().get(0) instanceof ClassifierMap) {
                return (TransformationStep)listOfSteps.get(indexOfoTS - 1);
            }
            return null;
        }
        return null;
    }

    protected static boolean getUseDependentReposFlag() {
        return true;
    }

    protected String getRepositoryNameForObject(CMetadata object) {
        try {
            String sReposName = (String)this.m_lRepositories.get(object.getFQID().substring(0, 8));
            if (sReposName != null) {
                return sReposName;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return "";
    }

    protected String getRepositoryNameAppendString(CMetadata object) {
        String reposName = this.getRepositoryNameForObject(object);
        StringBuffer sbName = new StringBuffer();
        if (reposName.length() > 0) {
            sbName.append(" (").append(reposName).append(")");
        }
        return sbName.toString();
    }

    private boolean isPhysicalTableColumn(Column oColumn) throws MdException, RemoteException {
        return oColumn.getTable().getCMetadataType().equals("PhysicalTable");
    }

    private boolean isWorkTableColumn(Column oColumn) throws MdException, RemoteException {
        return oColumn.getTable().getCMetadataType().equals("WorkTable");
    }

    private boolean isExternalTableColumn(Column oColumn) throws MdException, RemoteException {
        return oColumn.getTable().getCMetadataType().equals("ExternalTable");
    }

    protected static Job getJobFor(TransformationStep oTS) throws MdException, RemoteException {
        TransformationActivity oTA;
        AssociationList lJobs;
        if (oTS == null) {
            return null;
        }
        AssociationList lTAs = oTS.getActivities();
        if (lTAs.size() > 0 && (lJobs = (oTA = (TransformationActivity)lTAs.get(0)).getJobs()).size() > 0) {
            return (Job)lJobs.get(0);
        }
        return null;
    }

    protected TransformationStep findStep(Column oColumn, List lTSs) throws MdException, RemoteException {
        List lFMs = this.getFeatureMaps(oColumn);
        for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
            FeatureMap oFM = (FeatureMap)lFMs.get(iFM);
            TransformationStep oTS = this.getStepFor(oFM);
            if (oTS == null || !lTSs.contains(oTS)) continue;
            return oTS;
        }
        return null;
    }

    protected void getNextDataSteps(List lNextSteps, TransformationStep oTS) throws MdException, RemoteException {
        TransformationStep nextStep = this.getNextStep(oTS);
        if (nextStep != null) {
            lNextSteps.add(nextStep);
        }
    }

    protected List getFeatureMaps(Column oColumn) throws MdException, RemoteException {
        if (this.m_bForward) {
            return oColumn.getSourceFeatureMaps();
        }
        return oColumn.getTargetFeatureMaps();
    }

    protected List getColumns(FeatureMap oFM) throws MdException, RemoteException {
        if (this.m_bForward) {
            return oFM.getFeatureTargets();
        }
        return oFM.getFeatureSources();
    }

    private TransformationStep getStepFor(FeatureMap oFM) throws MdException, RemoteException {
        AssociationList lTSs;
        ClassifierMap oCM = oFM.getAssociatedClassifierMap();
        if (oCM != null && (lTSs = oCM.getSteps()).size() > 0) {
            return (TransformationStep)lTSs.get(0);
        }
        return null;
    }

    private TransformationStep getStepFor(WorkTable oWorkTable) throws MdException, RemoteException {
        AssociationList lTargetCMs = oWorkTable.getTargetClassifierMaps();
        if (lTargetCMs.size() == 0) {
            return null;
        }
        ClassifierMap oCM = (ClassifierMap)oWorkTable.getTargetClassifierMaps().get(0);
        AssociationList lTSs = oCM.getSteps();
        if (lTSs.size() > 0) {
            return (TransformationStep)lTSs.get(0);
        }
        return null;
    }

    protected List getNextColumns(FeatureMap oFM) throws MdException, RemoteException {
        if (this.m_bForward) {
            return oFM.getFeatureSources();
        }
        return oFM.getFeatureTargets();
    }

    private List getClassifierMaps(Classifier oMetadata) throws MdException, RemoteException {
        if (this.m_bForward) {
            return oMetadata.getSourceClassifierMaps();
        }
        return oMetadata.getTargetClassifierMaps();
    }

    private List getClassifierTables(ClassifierMap oCM) throws MdException, RemoteException {
        if (this.m_bForward) {
            return oCM.getClassifierTargets();
        }
        return oCM.getClassifierSources();
    }

    protected boolean isAddedAlready(Job oJob, TransformationStep oTS) {
        return super.isNodeModelAlreadyAdded((CMetadata)oTS);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
    }

    @Override
    public String getHelpTopic() {
        return "sometopic";
    }

    @Override
    public String getHelpProduct() {
        return "wdb";
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.removeListeners();
        --m_numPFDs;
        m_vecPFDs.remove((Object)this);
        try {
            this.cleanupViews(this.m_oMetadata.getObjectStore());
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_activeJob = null;
        this.myDefaultLocation = null;
        this.dispose();
    }

    @Override
    public boolean closeAllChildFrames() {
        return true;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new cImpactMouseListener();
    }

    @Override
    public void handlePopupEvent(MouseEvent e) {
        int iCanShowPopup = -1;
        PFDPrimitive object = null;
        if (this.getSelectionList().getNumPrimitives() == 0) {
            iCanShowPopup = 1;
        } else if (this.getSelectionList().getNumPrimitives() == 1) {
            object = this.getSelectedPrimitives()[0];
            if (object instanceof WAPFDNode) {
                iCanShowPopup = 3;
            }
        } else {
            return;
        }
        this.updateActions(true);
        if (e.isPopupTrigger() && iCanShowPopup > -1) {
            switch (iCanShowPopup) {
                case 1: {
                    this.showCanvasPopupMenu(e);
                    break;
                }
                default: {
                    this.showNodePopupMenu((WAPFDPrimitiveInterface)object, e);
                }
            }
        }
    }

    @Override
    protected void createActions() {
        this.m_actImpactMenu = this.createImpactMenuAction();
        this.m_actPopupMenu = this.createPopupMenuAction();
        this.m_actColumnImpact = this.createColumnImpactAction();
        this.m_actViewJob = this.createViewJobAction();
        this.m_actProperties = this.createPropertiesAction();
        this.m_actPrint = this.createPrintAction();
        this.m_actPageSetup = this.createPageSetupAction();
        this.m_actPrinttogif = this.createPrinttogifAction();
        this.m_actZoomout = this.createZoomoutAction();
        this.m_actZoomin = this.createZoominAction();
        this.m_actZoomToFit = this.createZoomToFitAction();
        this.m_actLayoutLeft = this.createLayoutLeftAction();
        this.m_actLayoutRight = this.createLayoutRightAction();
        this.m_actLayoutUp = this.createLayoutUpAction();
        this.m_actLayoutDown = this.createLayoutDownAction();
        this.m_actZoomCustom = this.createZoomCustomAction();
        this.m_actZoom25 = this.createZoom25Action();
        this.m_actZoom50 = this.createZoom50Action();
        this.m_actZoom75 = this.createZoom75Action();
        this.m_actZoom100 = this.createZoom100Action();
        this.m_actZoom200 = this.createZoom200Action();
        this.m_actViewData = this.createImpactViewDataAction();
        this.m_actViewFile = this.createImpactViewFileAction();
        this.m_vecZoomActions.add(this.m_actZoom200);
        this.m_vecZoomActions.add(this.m_actZoom100);
        this.m_vecZoomActions.add(this.m_actZoom75);
        this.m_vecZoomActions.add(this.m_actZoom50);
        this.m_vecZoomActions.add(this.m_actZoom25);
        this.m_vecZoomActions.add(this.m_actZoomToFit);
        this.m_vecZoomActions.add(this.m_actZoomCustom);
    }

    @Override
    protected void updateActions(boolean bActive) {
        block16: {
            if (bActive) {
                this.fireSelectionChangedEvent();
            }
            try {
                if (!bActive) {
                    this.m_actProperties.setEnabled(bActive);
                    this.m_actViewJob.setEnabled(bActive);
                    this.m_actViewData.setEnabled(bActive);
                    this.m_actViewFile.setEnabled(bActive);
                    this.m_actColumnImpact.setEnabled(bActive);
                    break block16;
                }
                if (this.getSelectionList().getNumPrimitives() == 1) {
                    PFDPrimitive primitive = this.getSelectedPrimitives()[0];
                    WAPFDPrimitiveInterface object = (WAPFDPrimitiveInterface)primitive;
                    if (object instanceof WAPFDLink) {
                        return;
                    }
                    try {
                        CMetadata oObject = this.m_oMetadata.getObjectStore().getObject(((WAPFDNode)object).m_nodeModel.m_objectID);
                        boolean bCanViewData = oObject.getCMetadataType().equals("PhysicalTable") || oObject.getCMetadataType().equals("ExternalTable");
                        boolean bCanViewFile = oObject.getCMetadataType().equals("ExternalTable");
                        this.m_actColumnImpact.setEnabled(false);
                        if (object instanceof cInformationMapWAPFDNode) {
                            this.m_actProperties.setEnabled(true);
                            this.m_actViewJob.setEnabled(false);
                            this.m_actViewData.setEnabled(false);
                            this.m_actViewFile.setEnabled(false);
                            break block16;
                        }
                        if (object instanceof cFeatureWAPFDNode || object instanceof cGroupWAPFDNode) {
                            this.m_actProperties.setEnabled(false);
                            this.m_actViewJob.setEnabled(false);
                            this.m_actViewData.setEnabled(false);
                            this.m_actViewFile.setEnabled(false);
                            break block16;
                        }
                        if (object instanceof WAPFDTableNode || object instanceof WAPFDPrototypeNode) {
                            this.m_actProperties.setEnabled(true);
                            this.m_actViewJob.setEnabled(false);
                            this.m_actColumnImpact.setEnabled(!oObject.getCMetadataType().equals("Cube"));
                            this.m_actViewData.setEnabled(bCanViewData);
                            this.m_actViewFile.setEnabled(bCanViewFile);
                            break block16;
                        }
                        this.m_actProperties.setEnabled(true);
                        this.m_actViewData.setEnabled(false);
                        Job job = null;
                        boolean bCanViewJob = false;
                        if (oObject.getCMetadataType().equals("TransformationStep")) {
                            job = ImpactPFDPanel.getJobFor((TransformationStep)oObject);
                        } else if (oObject.getCMetadataType().equals("FeatureMap")) {
                            TransformationStep oTs = this.getStepFor((FeatureMap)oObject);
                            job = ImpactPFDPanel.getJobFor(oTs);
                        }
                        if (job != null) {
                            SimpleObjectImpl simpleJob = new SimpleObjectImpl(job.getName(), job.getFQID(), job.getCMetadataType(), job.getPublicType());
                            bCanViewJob = AppViewFactory.getInstance().isOpenViewSupported((SimpleObject)simpleJob);
                        }
                        this.m_actViewJob.setEnabled(bCanViewJob);
                        this.m_actViewFile.setEnabled(false);
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    }
                    break block16;
                }
                this.m_actProperties.setEnabled(false);
                this.m_actViewJob.setEnabled(false);
                this.m_actColumnImpact.setEnabled(false);
                this.m_actViewData.setEnabled(false);
                this.m_actViewFile.setEnabled(false);
            }
            catch (PFDException ex2) {
                PFDPanel.displayPFDErrorMessage(ex2.getMessage());
            }
        }
    }

    protected WsAbstractAction createImpactMenuAction() {
        return new cImpactMenuAction();
    }

    protected WsAbstractAction createColumnImpactAction() {
        return new cColumnImpactAction();
    }

    @Override
    protected WsAbstractAction createPropertiesAction() {
        return new cImpactPropertiesAction();
    }

    @Override
    protected WsAbstractAction createViewJobAction() {
        return new cImpactViewJobAction();
    }

    protected WsAbstractAction createImpactViewDataAction() {
        return new cImpactViewDataAction();
    }

    protected WsAbstractAction createImpactViewFileAction() {
        return new cImpactViewFileAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handlePropertiesAction() {
        Object newStore = null;
        Object store = null;
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.setTransformationStepFQID(null);
            if (this.getSelectedPrimitives().length > 0) {
                WAPFDPrimitiveInterface primitive = (WAPFDPrimitiveInterface)this.getSelectedPrimitives()[0];
                if (primitive instanceof cGroupWAPFDNode || primitive instanceof cFeatureWAPFDNode) {
                    return;
                }
                if (!(primitive instanceof WAPFDNode)) {
                    return;
                }
                WAPFDNode node = (WAPFDNode)primitive;
                CMetadata currentObj = node.getWAPFDNodeModel().getMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore());
                if (primitive instanceof WAPFDTransformNode) {
                    TransformationStep stepObj = null;
                    if (currentObj.getCMetadataType().equals("FeatureMap")) {
                        TransformationStep oTs = this.getStepFor((FeatureMap)currentObj);
                        this.setTransformationStepFQID(oTs.getFQID());
                        stepObj = oTs;
                    } else {
                        stepObj = (TransformationStep)currentObj;
                        this.setTransformationStepFQID(currentObj.getFQID());
                    }
                    TransformationActivity act = (TransformationActivity)stepObj.getActivities().get(0);
                    Job job = (Job)act.getJobs().get(0);
                    SimpleObjectImpl iObjSimple = new SimpleObjectImpl(job.getName(), job.getFQID(), job.getCMetadataType(), job.getPublicType());
                    AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)iObjSimple);
                } else if (currentObj instanceof Prototype) {
                    SimpleObjectImpl simpleObj = new SimpleObjectImpl(currentObj.getName(), currentObj.getFQID(), currentObj.getCMetadataType(), ((Prototype)currentObj).getPublicType());
                    if (MacroPluginUtilities.isGeneratedTransform((Root)((Prototype)currentObj))) {
                        boolean fIsUsed = MacroPluginUtilities.isPrototypeUsedInJobs((Prototype)currentObj);
                        if (fIsUsed) {
                            MessageUtil.displayMessage((String)bundle.getString("UsedPlugin.txt"), (int)2);
                        }
                        AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)simpleObj);
                    }
                } else if (currentObj.getCMetadataType().equals("Transformation") && ((TransformationImpl)currentObj).getTransformRole().equalsIgnoreCase("SASMessageQueue")) {
                    SimpleObjectImpl simpleObj = new SimpleObjectImpl(currentObj.getName(), currentObj.getFQID(), currentObj.getCMetadataType(), ((Transformation)currentObj).getPublicType());
                    AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)simpleObj);
                } else {
                    DataTable iObj = null;
                    boolean fFound = false;
                    if (currentObj instanceof Column) {
                        iObj = ((Column)currentObj).getTable();
                    } else if (currentObj instanceof FeatureMap) {
                        iObj = this.getStepFor((FeatureMap)currentObj);
                    } else {
                        if (currentObj instanceof WorkTable) {
                            iObj = this.getStepFor((WorkTable)currentObj);
                            this.setTransformationStepFQID(iObj.getFQID());
                            TransformationActivity act = (TransformationActivity)((TransformationStep)iObj).getActivities().get(0);
                            Job job = (Job)act.getJobs().get(0);
                            SimpleObjectImpl iObjSimple = new SimpleObjectImpl(job.getName(), job.getFQID(), job.getCMetadataType(), job.getPublicType());
                            AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)iObjSimple);
                            return;
                        }
                        iObj = (PrimaryType)currentObj;
                    }
                    if (iObj != null) {
                        SimpleObjectImpl iObjSimple = new SimpleObjectImpl(iObj.getName(), iObj.getFQID(), iObj.getCMetadataType(), iObj.getPublicType());
                        AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)iObjSimple);
                    } else {
                        MessageUtil.displayMessage((String)bundle.getString("ImpactPFDPanel.nopropertysheet.txt"), (int)0);
                    }
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            if (newStore != null) {
                try {
                    newStore.dispose();
                    newStore = null;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void handleImpactViewJobAction() {
        try {
            WAPFDTransformNode node = (WAPFDTransformNode)this.getSelectedPrimitives()[0];
            TransformationStep stepObj = null;
            CMetadata obj = node.getWAPFDNodeModel().getMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore());
            stepObj = obj instanceof FeatureMap ? this.getStepFor((FeatureMap)obj) : (TransformationStep)obj;
            TransformationActivity act = (TransformationActivity)stepObj.getActivities().get(0);
            Job job = (Job)act.getJobs().get(0);
            SimpleObjectImpl simpleJob = new SimpleObjectImpl(job.getName(), job.getFQID(), job.getCMetadataType(), job.getPublicType());
            if (AppViewFactory.getInstance().isOpenViewSupported((SimpleObject)simpleJob)) {
                AppViewFactory.getInstance().showOpenView((SimpleObject)simpleJob);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected List getTransformationSteps(Transformation oTrans) throws MdException, RemoteException {
        if (this.m_bForward) {
            return oTrans.getTransformationTargets();
        }
        return oTrans.getTransformationSources();
    }

    public void handleImpactViewDataAction() {
        this.setTransformationStepFQID(null);
        if (this.getSelectedPrimitives().length > 0) {
            WAPFDPrimitiveInterface primitive = (WAPFDPrimitiveInterface)this.getSelectedPrimitives()[0];
            if (!(primitive instanceof WAPFDTableNode)) {
                return;
            }
            WAPFDTableNode node = (WAPFDTableNode)primitive;
            try {
                CMetadata currentObj = node.getWAPFDNodeModel().getMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore());
                if (currentObj != null) {
                    WsViewFactory.showView((CMetadata)currentObj, ViewDataView.class);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void handleImpactViewFileAction() {
        this.setTransformationStepFQID(null);
        if (this.getSelectedPrimitives().length > 0) {
            WAPFDPrimitiveInterface primitive = (WAPFDPrimitiveInterface)this.getSelectedPrimitives()[0];
            if (!(primitive instanceof WAPFDTableNode)) {
                return;
            }
            try {
                WAPFDTableNode node = (WAPFDTableNode)primitive;
                CMetadata currentObj = node.getWAPFDNodeModel().getMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore());
                if (currentObj != null) {
                    WsViewFactory.showView((CMetadata)currentObj, RawDataView.class);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected void createNewPFD(CMetadata simpleJob) {
        String str1 = bundle.getString("LaunchPFDMetadataProgressIndicator.Msg.Message");
        String str2 = bundle.getString("LaunchPFDMetadataProgressIndicator.Msg.Title");
        String str3 = bundle.getString("LaunchPFDMetadataProgressIndicator.Msg.Cancel");
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2, str3);
        request.setDelayBeforeProgressCancelDialog(0);
        request.setProgressShownOnStatusBar(false);
        request.execute((Runnable)new InitializeRunnableLaunchPFD(simpleJob));
        Workspace.getDefaultLogger().debug((Object)"Finished waiting on launch");
    }

    public void setPanelLayoutDirection(int iDirection) {
        LayeredLayoutStrategy lls = (LayeredLayoutStrategy)this.getPFDLayout();
        String strDirection = this.getLayoutDirectionString();
        if (lls == null) {
            lls = PFDPanel.createDefaultLayoutStrategy();
            lls.setNodePositionHonored(true);
            this.setPFDLayout((LayoutStrategyInterface)lls);
            lls.setGridHeight(99);
            lls.setGridWidth(99);
            lls.setLayerGridSpace(1.0);
            lls.setColumnGridSpace(0.0);
        } else if (iDirection == 2 || iDirection == 0) {
            lls.setReferenceNodeSize(130, 60);
        } else {
            lls.setReferenceNodeSize(150, 40);
        }
        lls.setFlowDirection(strDirection);
        this.getModel().disableChangeUpdate();
        this.getModel().setFlowDirection(this.getLayoutDirectionString((iDirection + 1) % 4));
        this.getModel().setFlowDirection(this.getLayoutDirectionString());
        this.getModel().enableChangeUpdate();
        this.updateView();
    }

    protected cImpactLauncher createImpactLauncher() {
        return new cImpactLauncher();
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        if (this.listenerList != null) {
            this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
        }
    }

    public Object[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    private void fireSelectionChangedEvent() {
        ArrayList<SimpleObjectImpl> lSelectedObjects = new ArrayList<SimpleObjectImpl>();
        try {
            PFDPrimitive[] aSelectedPrimitives = this.getSelectedPrimitives();
            for (int iPrimitive = 0; iPrimitive < aSelectedPrimitives.length; ++iPrimitive) {
                CMetadata mdo;
                if (!(aSelectedPrimitives[iPrimitive] instanceof WAPFDTableNode) && !(aSelectedPrimitives[iPrimitive] instanceof WAPFDTransformNode) && !(aSelectedPrimitives[iPrimitive] instanceof WAPFDPrototypeNode) || !((mdo = ((WAPFDNode)aSelectedPrimitives[iPrimitive]).getWAPFDNodeModel().getMetadataObject(this.m_oMetadata)) instanceof PrimaryType)) continue;
                SimpleObjectImpl obj = new SimpleObjectImpl(mdo.getName(), mdo.getFQID(), mdo.getCMetadataType(), ((PrimaryType)mdo).getPublicType());
                lSelectedObjects.add(obj);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.m_aSelectedObjects = lSelectedObjects.toArray();
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        if (aListeners.length == 0) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    protected boolean addTableNodeToDiagram(Classifier oMetadata, Column column, List lFoundModel) throws MdException, RemoteException {
        WAPFDNodeModel toTabModel = this.getNodeModel(oMetadata.getFQID());
        if (toTabModel == null) {
            toTabModel = oMetadata.getCMetadataType().equals("WorkTable") ? new WAPFDWorkTableNodeModel(this, (CMetadata)oMetadata) : new WAPFDTableNodeModel(this, (CMetadata)oMetadata);
            ((WAPFDTableNodeModel)toTabModel).addNode((CMetadata)oMetadata);
            WAPFDNode viewNode = (WAPFDNode)toTabModel.getViewNode();
            StringBuffer sbCaption = new StringBuffer();
            if (column != null) {
                sbCaption.append(viewNode.getLabel().getText() + "." + column.getName());
            } else {
                sbCaption.append(viewNode.getLabel().getText());
            }
            sbCaption.append(this.getRepositoryNameAppendString((CMetadata)oMetadata));
            viewNode.getLabel().setText(sbCaption.toString());
            lFoundModel.add(toTabModel);
            return false;
        }
        lFoundModel.add(toTabModel);
        return true;
    }

    protected boolean addTransformationStepNodeToDiagram(TransformationStep oMetadata, ClassifierMap map, Column column, List lFoundModel) throws MdException, RemoteException {
        WAPFDNodeModel toTabModel = this.getNodeModel(oMetadata.getFQID());
        if (toTabModel == null) {
            TransformationActivity activity;
            toTabModel = new WAPFDTransformNodeModel(this, (CMetadata)oMetadata);
            ((WAPFDTransformNodeModel)toTabModel).addNode((CMetadata)oMetadata);
            WAPFDNode viewNode = (WAPFDNode)toTabModel.getViewNode();
            String jobName = "";
            if (oMetadata.getActivities().size() > 0 && (activity = (TransformationActivity)oMetadata.getActivities().get(0)).getJobs().size() > 0) {
                jobName = ((Job)activity.getJobs().get(0)).getName();
            }
            StringBuffer sbCaption = new StringBuffer();
            if (jobName.length() > 0) {
                sbCaption.append(jobName);
                sbCaption.append(".");
            }
            sbCaption.append(viewNode.getLabel().getText());
            sbCaption.append(this.getRepositoryNameAppendString((CMetadata)oMetadata));
            viewNode.getLabel().setText(sbCaption.toString());
            lFoundModel.add(toTabModel);
            return false;
        }
        lFoundModel.add(toTabModel);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean addBIGroupNodeToDiagram(Group oMetadata, List lFoundModel) throws MdException, RemoteException {
        Object actualObject = null;
        String objectType = "";
        String actualObjectMetadataID = "";
        for (int i = 0; i < oMetadata.getProperties().size(); ++i) {
            Property property = (Property)oMetadata.getProperties().get(i);
            if (!property.getName().equalsIgnoreCase("ActualObject") || property.getDesc().length() <= 0) continue;
            actualObjectMetadataID = property.getDesc();
            if (oMetadata.getDesc().equalsIgnoreCase("Table")) {
                objectType = "PhysicalTable";
                break;
            }
            objectType = oMetadata.getDesc();
            break;
        }
        if (oMetadata.getDesc().equalsIgnoreCase("Table")) {
            Root oData = (Root)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)((MdObjectStore)this.m_oMetadata.getObjectStore()), objectType, actualObjectMetadataID, null, null, null, 8);
            WAPFDNodeModel toTabModel = this.getNodeModel(oData.getFQID());
            if (toTabModel == null) {
                if (!objectType.equalsIgnoreCase("PhysicalTable")) return false;
                return this.addTableNodeToDiagram((Classifier)oData, null, lFoundModel);
            }
            lFoundModel.add(toTabModel);
            return true;
        }
        WAPFDNodeModel toTabModel = this.getNodeModel(oMetadata.getFQID());
        if (toTabModel == null) {
            return this.addInformationMapNodeToDiagram((CMetadata)oMetadata, null);
        }
        lFoundModel.add(toTabModel);
        return true;
    }

    protected boolean addTransformationNodeToDiagram(Transformation oMetadata, Column column) throws MdException, RemoteException {
        WAPFDNodeModel toTabModel = this.getNodeModel(oMetadata.getFQID());
        if (toTabModel == null) {
            toTabModel = new WAPFDInformationNodeModel(this, (CMetadata)oMetadata);
            ((WAPFDTableNodeModel)toTabModel).addNode((CMetadata)oMetadata);
            WAPFDNode viewNode = (WAPFDNode)toTabModel.getViewNode();
            StringBuffer sbCaption = new StringBuffer(viewNode.getLabel().getText());
            sbCaption.append(this.getRepositoryNameAppendString((CMetadata)oMetadata));
            viewNode.getLabel().setText(sbCaption.toString());
            return false;
        }
        return true;
    }

    protected boolean addInformationMapNodeToDiagram(CMetadata oMetadata, CMetadata oOwningObject) throws MdException, RemoteException {
        WAPFDNodeModel toTabModel = this.getNodeModel(oMetadata.getFQID());
        if (toTabModel == null) {
            StringBuffer sbCaption = new StringBuffer(oMetadata.getName());
            if (oOwningObject != null) {
                sbCaption.append("." + oOwningObject.getName());
            }
            sbCaption.append(this.getRepositoryNameAppendString(oMetadata));
            toTabModel = new cInformationMapWAPFDNodeModel(this, oMetadata);
            ((cInformationMapWAPFDNodeModel)toTabModel).addNode(oMetadata, sbCaption.toString());
            return false;
        }
        return true;
    }

    protected boolean addBIFeatureNodeToDiagram(CMetadata oMetadata) throws MdException, RemoteException {
        WAPFDNodeModel toTabModel = this.getNodeModel(oMetadata.getFQID());
        if (toTabModel == null) {
            StringBuffer sbCaption = new StringBuffer(oMetadata.getName());
            sbCaption.append(this.getRepositoryNameAppendString(oMetadata));
            toTabModel = new cInformationMapWAPFDNodeModel(this, oMetadata);
            ((cInformationMapWAPFDNodeModel)toTabModel).addNode(oMetadata, sbCaption.toString());
            return false;
        }
        return true;
    }

    protected void processFeature(Feature oFeature, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
        this.populateStoreForBILineage((CMetadata)oFeature);
        if (this.m_bForward) {
            AssociationList l_SFMs = oFeature.getSourceFeatureMaps();
            for (int i = 0; i < l_SFMs.size(); ++i) {
                FeatureMap i_FM = (FeatureMap)l_SFMs.get(i);
                AssociationList l_FTs = i_FM.getFeatureTargets();
                for (int j = 0; j < l_FTs.size(); ++j) {
                    this.addFeatureNode((Feature)l_FTs.get(j), nodePrevious);
                }
            }
        } else {
            AssociationList l_SFMs = oFeature.getTargetFeatureMaps();
            for (int i = 0; i < l_SFMs.size(); ++i) {
                FeatureMap i_FM = (FeatureMap)l_SFMs.get(i);
                AssociationList l_FTs = i_FM.getFeatureSources();
                for (int j = 0; j < l_FTs.size(); ++j) {
                    this.addFeatureNode((Feature)l_FTs.get(j), nodePrevious);
                }
            }
        }
    }

    protected void addFeatureNode(Feature oFeature, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
        WAPFDNodeModel toTabModel = this.getNodeModel(oFeature.getFQID());
        if (toTabModel == null) {
            toTabModel = new cFeatureWAPFDNodeModel(this, (CMetadata)oFeature);
            StringBuffer newString = new StringBuffer(100);
            newString.append(oFeature.getName());
            String parentName = "";
            try {
                parentName = " (" + ((CMetadata)oFeature.getGroups().get(0)).getName() + ")";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            newString.append(parentName);
            newString.append(this.getRepositoryNameAppendString((CMetadata)oFeature));
            ((cFeatureWAPFDNodeModel)toTabModel).addNode((CMetadata)oFeature, newString.toString());
            WAPFDNodeInterface viewNode = toTabModel.getViewNode();
            if (nodePrevious != null) {
                if (this.m_bForward) {
                    new WAPFDLink(nodePrevious.getViewNode(), viewNode, this);
                } else {
                    new WAPFDLink(viewNode, nodePrevious.getViewNode(), this);
                }
            }
        } else {
            if (nodePrevious != null) {
                if (this.m_bForward) {
                    new WAPFDLink(nodePrevious.getViewNode(), toTabModel.getViewNode(), this);
                } else {
                    new WAPFDLink(toTabModel.getViewNode(), nodePrevious.getViewNode(), this);
                }
            }
            return;
        }
        nodePrevious = toTabModel;
        this.processFeature(oFeature, nodePrevious);
    }

    protected void processGroup(Group oGroup, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
        this.populateStoreForBILineage((CMetadata)oGroup);
        if (this.m_bForward) {
            AssociationList l_STs = oGroup.getSourceTransformations();
            for (int i = 0; i < l_STs.size(); ++i) {
                ClassifierMap i_CM = (ClassifierMap)l_STs.get(i);
                AssociationList l_TTs = i_CM.getTransformationTargets();
                for (int j = 0; j < l_TTs.size(); ++j) {
                    this.addGroupNode((Group)l_TTs.get(j), nodePrevious);
                }
            }
        } else {
            AssociationList l_TTs = oGroup.getTargetTransformations();
            for (int i = 0; i < l_TTs.size(); ++i) {
                ClassifierMap i_CM = (ClassifierMap)l_TTs.get(i);
                AssociationList l_TSs = i_CM.getTransformationSources();
                for (int j = 0; j < l_TSs.size(); ++j) {
                    this.addGroupNode((Group)l_TSs.get(j), nodePrevious);
                }
            }
        }
    }

    protected void addGroupNode(Group oGroup, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
        WAPFDNodeModel toTabModel = this.getNodeModel(oGroup.getFQID());
        if (toTabModel == null) {
            toTabModel = new cGroupWAPFDNodeModel(this, (CMetadata)oGroup);
            StringBuffer newString = new StringBuffer(100);
            newString.append(oGroup.getName());
            newString.append(this.getRepositoryNameAppendString((CMetadata)oGroup));
            ((cGroupWAPFDNodeModel)toTabModel).addNode((CMetadata)oGroup, newString.toString());
            WAPFDNodeInterface viewNode = toTabModel.getViewNode();
            if (nodePrevious != null) {
                if (this.m_bForward) {
                    new WAPFDLink(nodePrevious.getViewNode(), viewNode, this);
                } else {
                    new WAPFDLink(viewNode, nodePrevious.getViewNode(), this);
                }
            }
        } else {
            if (nodePrevious != null) {
                if (this.m_bForward) {
                    new WAPFDLink(nodePrevious.getViewNode(), toTabModel.getViewNode(), this);
                } else {
                    new WAPFDLink(toTabModel.getViewNode(), nodePrevious.getViewNode(), this);
                }
            }
            return;
        }
        nodePrevious = toTabModel;
        this.processGroup(oGroup, nodePrevious);
    }

    public void populateStoreForBILineage(CMetadata oMeta) throws MdException, RemoteException {
        ArrayList<String> lAssociations = new ArrayList<String>();
        StringBuffer sbTemplate = new StringBuffer(100);
        sbTemplate.append("<Templates>");
        if (this.m_bForward) {
            if (oMeta instanceof Feature) {
                lAssociations.add("SourceFeatureMaps");
            }
            if (oMeta instanceof Group) {
                lAssociations.add("SourceTransformations");
            }
        } else {
            if (oMeta instanceof Feature) {
                lAssociations.add("TargetFeatureMaps");
            }
            if (oMeta instanceof Group) {
                lAssociations.add("TargetTransformations");
            }
        }
        sbTemplate.append("</Templates>");
        int fFlags = 268;
        if (ImpactPFDPanel.getUseDependentReposFlag()) {
            fFlags = fFlags | 0x4000 | 0x2000;
        }
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oMeta, null, lAssociations, sbTemplate.toString(), fFlags);
    }

    protected class cImpactLauncher
    implements Runnable {
        @Override
        public void run() {
            ImpactPFDPanel.this.getModel().disableChangeUpdate();
            try {
                ImpactPFDPanel.this.m_mdlPopulator.moveDataToView();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            ImpactPFDPanel.this.getModel().enableChangeUpdate();
            PFDPanel.updateAllPreferredColors();
            ImpactPFDPanel.this.buildRenderables();
            ImpactPFDPanel.this.updateZoom();
        }
    }

    public class cTablePopulator
    extends cModelPopulator {
        @Override
        public void moveDataToView() throws MdException, RemoteException {
            this.addTableNode((Classifier)ImpactPFDPanel.this.m_oMetadata, null);
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            this.populateStore(ImpactPFDPanel.this.m_oMetadata);
        }

        public void populateStore(CMetadata oMeta) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (ImpactPFDPanel.this.m_bForward) {
                lAssociations.add("SourceClassifierMaps");
                lAssociations.add("SourceTransformations");
                sbTemplate.append("<Select><Steps/><ClassifierTargets/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierTargets/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><PredecessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Successors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TargetClassifierMaps");
                lAssociations.add("TargetTransformations");
                sbTemplate.append("<Select><Steps/><ClassifierSources/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><SuccessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Predecessors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (ImpactPFDPanel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(ImpactPFDPanel.this.m_oMetadata, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        protected boolean addClassifierMapNode(ClassifierMap oCM, WAPFDNode connectingNode) throws MdException, RemoteException {
            boolean fVisited = false;
            ArrayList lTransformModel = new ArrayList();
            TransformationStep step = (TransformationStep)oCM.getSteps().get(0);
            this.populateStore();
            fVisited = ImpactPFDPanel.this.addTransformationStepNodeToDiagram(step, oCM, null, lTransformModel);
            if (connectingNode != null) {
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(connectingNode, ((WAPFDNodeModel)lTransformModel.get(0)).getViewNode(), ImpactPFDPanel.this);
                } else {
                    new WAPFDLink(((WAPFDNodeModel)lTransformModel.get(0)).getViewNode(), connectingNode, ImpactPFDPanel.this);
                }
            }
            if (ImpactPFDPanel.this.m_bForward) {
                for (int i = 0; i < oCM.getClassifierTargets().size(); ++i) {
                    Classifier target = (Classifier)oCM.getClassifierTargets().get(i);
                    this.addTableNode(target, (WAPFDNode)((WAPFDNodeModel)lTransformModel.get(0)).getViewNode());
                }
            } else {
                for (int i = 0; i < oCM.getClassifierSources().size(); ++i) {
                    Classifier source = (Classifier)oCM.getClassifierSources().get(i);
                    this.addTableNode(source, (WAPFDNode)((WAPFDNodeModel)lTransformModel.get(0)).getViewNode());
                }
            }
            return fVisited;
        }

        protected boolean addTableNode(Classifier oTable, WAPFDNode connectingNode) throws MdException, RemoteException {
            boolean fVisited = false;
            ArrayList lTableModel = new ArrayList();
            this.populateStore((CMetadata)oTable);
            fVisited = ImpactPFDPanel.this.addTableNodeToDiagram(oTable, null, lTableModel);
            if (connectingNode != null) {
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(connectingNode, ((WAPFDNodeModel)lTableModel.get(0)).getViewNode(), ImpactPFDPanel.this);
                } else {
                    new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oTable.getFQID()).getViewNode(), connectingNode, ImpactPFDPanel.this);
                }
            }
            AssociationList lSourceTrans = oTable.getSourceTransformations();
            for (int i = 0; i < lSourceTrans.size(); ++i) {
                Transformation sourceTrans = (Transformation)lSourceTrans.get(i);
                String transformRole = sourceTrans.getTransformRole();
                if (sourceTrans.getName().equalsIgnoreCase("ImpactClassifierMap")) {
                    if (sourceTrans.getTransformationTargets().size() == 0) continue;
                    Group group = (Group)sourceTrans.getTransformationTargets().get(0);
                    this.addBINode((CMetadata)group, (WAPFDNode)ImpactPFDPanel.this.getNodeModel(oTable.getFQID()).getViewNode(), (CMetadata)oTable);
                    continue;
                }
                if (transformRole != null && (transformRole == null || transformRole.equalsIgnoreCase("STARDIM") || transformRole.equalsIgnoreCase("AGGREGATE"))) continue;
                this.addInformationMapNode(sourceTrans, (CMetadata)oTable);
            }
            if (fVisited) {
                return false;
            }
            boolean isCube = oTable.getCMetadataType().equals("Cube");
            TransformationStep cubeStep = null;
            List lCMs = ImpactPFDPanel.this.getClassifierMaps(oTable);
            Object oldTS = null;
            for (int iCM = 0; iCM < lCMs.size(); ++iCM) {
                ClassifierMap oCM = (ClassifierMap)lCMs.get(iCM);
                AssociationList lTSs = oCM.getSteps();
                if (lTSs.size() <= 0) continue;
                this.addClassifierMapNode(oCM, (WAPFDNode)ImpactPFDPanel.this.getNodeModel(oTable.getFQID()).getViewNode());
                if (!isCube) continue;
                cubeStep = (TransformationStep)oCM.getSteps().get(0);
            }
            if (!ImpactPFDPanel.this.m_bForward && isCube) {
                AssociationList lTargetTrans = oTable.getTargetTransformations();
                int size = lTargetTrans.size();
                for (int iTT = 0; iTT < size; ++iTT) {
                    ClassifierMap cm = (ClassifierMap)lTargetTrans.get(iTT);
                    AssociationList tables = cm.getTransformationSources();
                    int tablesize = tables.size();
                    for (int iTable = 0; iTable < tablesize; ++iTable) {
                        Classifier table = (Classifier)tables.get(iTable);
                        this.addTableNode(table, null);
                        if (cubeStep != null) {
                            new WAPFDLink(ImpactPFDPanel.this.getNodeModel(table.getFQID()).getViewNode(), ImpactPFDPanel.this.getNodeModel(cubeStep.getFQID()).getViewNode(), ImpactPFDPanel.this);
                            continue;
                        }
                        new WAPFDLink(ImpactPFDPanel.this.getNodeModel(table.getFQID()).getViewNode(), ImpactPFDPanel.this.getNodeModel(oTable.getFQID()).getViewNode(), ImpactPFDPanel.this);
                    }
                }
            }
            if (ImpactPFDPanel.this.m_bDoesBIReposExist) {
                Property thisProp;
                Group assocObj;
                String tempString = "<XMLSelect search=\"*[@Name='ActualObject' and @Desc='" + oTable.getFQID() + "']\"/>";
                List objects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((MdObjectStore)ImpactPFDPanel.this.m_oMetadata.getObjectStore()), ImpactPFDPanel.this.m_BIReposID, "Property", 8587, tempString);
                if (objects.size() > 0 && (assocObj = (Group)(thisProp = (Property)objects.get(objects.size() - 1)).getAssociatedObject()) != null) {
                    WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oTable.getFQID());
                    ImpactPFDPanel.this.processGroup(assocObj, toTabModel);
                }
            }
            return fVisited;
        }

        protected boolean addBINode(CMetadata oObject, WAPFDNode connectingNode, CMetadata oTable) throws MdException, RemoteException {
            boolean fVisited = false;
            ArrayList lModel = new ArrayList();
            Object newNodeModel = null;
            if (oTable == null) {
                fVisited = ImpactPFDPanel.this.addBIGroupNodeToDiagram((Group)oObject, lModel);
                if (connectingNode != null) {
                    if (ImpactPFDPanel.this.m_bForward) {
                        new WAPFDLink(connectingNode, ImpactPFDPanel.this.getNodeModel(oObject.getFQID()).getViewNode(), ImpactPFDPanel.this);
                    } else {
                        new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oObject.getFQID()).getViewNode(), connectingNode, ImpactPFDPanel.this);
                    }
                }
            }
            if (oObject instanceof Group) {
                Group oGroup = (Group)oObject;
                AssociationList sourceTransformations = oGroup.getSourceTransformations();
                for (int i = 0; i < sourceTransformations.size(); ++i) {
                    ClassifierMap impactClassifierMap = (ClassifierMap)sourceTransformations.get(i);
                    Group oNextGroup = (Group)impactClassifierMap.getTransformationTargets().get(0);
                    fVisited = oTable == null ? this.addBINode((CMetadata)oNextGroup, (WAPFDNode)ImpactPFDPanel.this.getNodeModel(oObject.getFQID()).getViewNode(), null) : this.addBINode((CMetadata)oNextGroup, (WAPFDNode)ImpactPFDPanel.this.getNodeModel(oTable.getFQID()).getViewNode(), null);
                }
            }
            return fVisited;
        }

        protected void addInformationMapNode(Transformation trans, CMetadata oMetadata) throws MdException, RemoteException {
            this.populateStore(oMetadata);
            ImpactPFDPanel.this.addInformationMapNodeToDiagram((CMetadata)trans, null);
            new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID()).getViewNode(), ImpactPFDPanel.this.getNodeModel(trans.getFQID()).getViewNode(), ImpactPFDPanel.this);
            AssociationList lSourceTrans = trans.getSourceTransformations();
            for (int i = 0; i < lSourceTrans.size(); ++i) {
                Transformation sourceTrans = (Transformation)lSourceTrans.get(i);
                this.addInformationMapNode(sourceTrans, (CMetadata)trans);
            }
        }
    }

    public abstract class cModelPopulator {
        public abstract void populateStore() throws MdException, RemoteException;

        public abstract void moveDataToView() throws MdException, RemoteException;
    }

    public class cColumnPopulator
    extends cModelPopulator {
        @Override
        public void moveDataToView() throws MdException, RemoteException {
            this.addColumnNode((Column)ImpactPFDPanel.this.m_oMetadata, null);
            if (!ImpactPFDPanel.this.m_bForward) {
                return;
            }
            WAPFDNodeModel columnNodeModel = ImpactPFDPanel.this.getNodeModel(ImpactPFDPanel.this.m_oMetadata.getFQID());
            if (columnNodeModel == null) {
                return;
            }
            List lookupList = ImpactAnalysisUtilities.getWhereColumnUsedAsLookup((Column)ImpactPFDPanel.this.m_oMetadata);
            for (int iJob = 0; iJob < lookupList.size(); ++iJob) {
                List lookupLocations = (List)lookupList.get(iJob);
                Job oJob = (Job)lookupLocations.get(0);
                Column oColumn = (Column)lookupLocations.get(2);
                TransformationStep oTS = (TransformationStep)lookupLocations.get(1);
                WAPFDTransformNodeModel stepNodeModel = new WAPFDTransformNodeModel(ImpactPFDPanel.this, (CMetadata)oTS);
                String jobName = oJob.getName();
                String tsName = oTS.getName();
                String columnName = oColumn.getName();
                StringBuffer sbCaption = new StringBuffer(bundle.formatString("ImpactPFDPanel.InvalidValuesNodeName.fmt.txt", (Object)jobName, (Object)tsName, (Object)columnName));
                sbCaption.append(ImpactPFDPanel.this.getRepositoryNameAppendString((CMetadata)oTS));
                stepNodeModel.addNode((CMetadata)oTS, sbCaption.toString());
                new WAPFDLink(columnNodeModel.getViewNode(), stepNodeModel.getViewNode(), ImpactPFDPanel.this);
            }
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            this.populateStore(ImpactPFDPanel.this.m_oMetadata);
        }

        public void populateStore(CMetadata oMeta) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (ImpactPFDPanel.this.m_bForward) {
                lAssociations.add("SourceFeatureMaps");
                lAssociations.add("Table");
                sbTemplate.append("<FeatureMap><FeatureTargets/><AssociatedClassifierMap/></FeatureMap>");
                sbTemplate.append("<Select><Steps/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/></TransformationStep>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TargetFeatureMaps");
                lAssociations.add("Table");
                sbTemplate.append("<FeatureMap><FeatureSources/><AssociatedClassifierMap/></FeatureMap>");
                sbTemplate.append("<Select><Steps/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/></TransformationStep>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (ImpactPFDPanel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(ImpactPFDPanel.this.m_oMetadata, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        private boolean addStepNode(FeatureMap oFM, WAPFDNodeModel nodePrevious, Column oColumn, boolean bLookup) throws MdException, RemoteException {
            TransformationStep oTS = ImpactPFDPanel.this.getStepFor(oFM);
            ClassifierMap oMap = oFM.getAssociatedClassifierMap();
            if (oTS == null || oMap == null) {
                return false;
            }
            if (ImpactPFDPanel.getJobFor(oTS) == null) {
                return false;
            }
            ArrayList lTransformNodeModel = new ArrayList();
            ImpactPFDPanel.this.addTransformationStepNodeToDiagram(oTS, oMap, oColumn, lTransformNodeModel);
            WAPFDNodeModel stepNodeModel = (WAPFDNodeModel)lTransformNodeModel.get(0);
            if (ImpactPFDPanel.this.m_bForward) {
                new WAPFDLink(nodePrevious.getViewNode(), stepNodeModel.getViewNode(), ImpactPFDPanel.this);
            } else {
                new WAPFDLink(stepNodeModel.getViewNode(), nodePrevious.getViewNode(), ImpactPFDPanel.this);
            }
            this.addInvalidValuesNodes(oFM, stepNodeModel);
            List lColumns = ImpactPFDPanel.this.getColumns(oFM);
            for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
                if (((CMetadata)lColumns.get(0)).getCMetadataType().equals("Column")) {
                    Column oNextColumn = (Column)lColumns.get(iColumn);
                    this.addColumnNode(oNextColumn, stepNodeModel);
                    continue;
                }
                this.addCubeFeatureNode((Feature)lColumns.get(0), stepNodeModel);
            }
            return false;
        }

        private boolean addColumnNode(Column oColumn, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
            if (!(ImpactPFDPanel.this.isPhysicalTableColumn(oColumn) || ImpactPFDPanel.this.isExternalTableColumn(oColumn) || ImpactPFDPanel.this.isWorkTableColumn(oColumn))) {
                return false;
            }
            boolean fVisited = false;
            ArrayList lTableModel = new ArrayList();
            this.populateStore((CMetadata)oColumn);
            DataTable oTable = oColumn.getTable();
            fVisited = ImpactPFDPanel.this.addTableNodeToDiagram((Classifier)oTable, oColumn, lTableModel);
            if (nodePrevious != null) {
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(nodePrevious.getViewNode(), ((WAPFDNodeModel)lTableModel.get(0)).getViewNode(), ImpactPFDPanel.this);
                } else {
                    new WAPFDLink(((WAPFDNodeModel)lTableModel.get(0)).getViewNode(), nodePrevious.getViewNode(), ImpactPFDPanel.this);
                }
            }
            if (fVisited) {
                return fVisited;
            }
            List lMaps = ImpactPFDPanel.this.getFeatureMaps(oColumn);
            for (int iMap = 0; iMap < lMaps.size(); ++iMap) {
                fVisited = this.addStepNode((FeatureMap)lMaps.get(iMap), (WAPFDNodeModel)lTableModel.get(0), oColumn, false);
            }
            if (ImpactPFDPanel.this.m_bDoesBIReposExist) {
                String tempString = "<XMLSelect search=\"*[@Name='ActualObject' and @Desc='" + oTable.getFQID() + "']\"/>";
                List objects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((MdObjectStore)ImpactPFDPanel.this.m_oMetadata.getObjectStore()), ImpactPFDPanel.this.m_BIReposID, "Property", 8587, tempString);
                if (objects.size() > 0) {
                    Property thisProp = (Property)objects.get(objects.size() - 1);
                    Group assocObj = (Group)thisProp.getAssociatedObject();
                    AssociationList l_members = assocObj.getMembers();
                    Feature oProxyColumn = null;
                    for (int i = 0; i < l_members.size(); ++i) {
                        Feature oPossibleColumn = (Feature)l_members.get(i);
                        if (!oPossibleColumn.getName().equals(oColumn.getName())) continue;
                        oProxyColumn = oPossibleColumn;
                        break;
                    }
                    if (oProxyColumn != null) {
                        WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oTable.getFQID());
                        ImpactPFDPanel.this.processFeature(oProxyColumn, toTabModel);
                    }
                }
            }
            return fVisited;
        }

        protected boolean addInformationMapNode(CMetadata oStartingFeature, CMetadata oOwningObject, WAPFDNode previousNode) throws MdException, RemoteException {
            boolean fVisited = false;
            ImpactPFDPanel.this.addInformationMapNodeToDiagram(oStartingFeature, oOwningObject);
            WAPFDNode thisViewNode = (WAPFDNode)ImpactPFDPanel.this.getNodeModel(oStartingFeature.getFQID()).getViewNode();
            new WAPFDLink(previousNode, thisViewNode, ImpactPFDPanel.this);
            if (((Feature)oStartingFeature).getSourceFeatureMaps().size() == 0) {
                return fVisited;
            }
            FeatureMap nextObject = (FeatureMap)((Feature)oStartingFeature).getSourceFeatureMaps().get(0);
            Feature nextObjectToAdd = (Feature)nextObject.getFeatureTargets().get(0);
            if (nextObjectToAdd.getDesc().equalsIgnoreCase("CharacterColumn") || nextObjectToAdd.getDesc().equalsIgnoreCase("NumericColumn")) {
                fVisited = this.addBIColumnNode(nextObjectToAdd, thisViewNode.getWAPFDNodeModel());
            } else {
                CMetadata owningNextObject = (CMetadata)nextObjectToAdd.getGroups().get(0);
                fVisited = this.addInformationMapNode((CMetadata)nextObjectToAdd, owningNextObject, thisViewNode);
            }
            return fVisited;
        }

        private boolean addBIColumnNode(Feature oIncomingProxyColumn, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
            Group group = (Group)oIncomingProxyColumn.getGroups().get(0);
            if (group.getTargetTransformations().size() == 0) {
                return false;
            }
            PhysicalTable oTable = (PhysicalTable)((ClassifierMap)group.getTargetTransformations().get(0)).getTransformationSources().get(0);
            Column oColumn = null;
            for (int i = 0; i < oTable.getColumns().size(); ++i) {
                Column tryColumn = (Column)oTable.getColumns().get(i);
                if (!oIncomingProxyColumn.getName().equalsIgnoreCase(tryColumn.getName())) continue;
                oColumn = tryColumn;
                break;
            }
            if (oColumn == null) {
                return false;
            }
            boolean fVisited = false;
            ArrayList lTableModel = new ArrayList();
            fVisited = ImpactPFDPanel.this.addTableNodeToDiagram((Classifier)oTable, oColumn, lTableModel);
            if (nodePrevious != null) {
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(nodePrevious.getViewNode(), ((WAPFDNodeModel)lTableModel.get(0)).getViewNode(), ImpactPFDPanel.this);
                } else {
                    new WAPFDLink(((WAPFDNodeModel)lTableModel.get(0)).getViewNode(), nodePrevious.getViewNode(), ImpactPFDPanel.this);
                }
            }
            if (fVisited) {
                return fVisited;
            }
            List lMaps = ImpactPFDPanel.this.getFeatureMaps(oColumn);
            for (int iMap = 0; iMap < lMaps.size(); ++iMap) {
                fVisited = this.addStepNode((FeatureMap)lMaps.get(iMap), (WAPFDNodeModel)lTableModel.get(0), oColumn, false);
            }
            for (int i = 0; i < oTable.getSourceTransformations().size(); ++i) {
                int j;
                CMetadata sourceTransform = (CMetadata)oTable.getSourceTransformations().get(i);
                if (!(sourceTransform instanceof ClassifierMap) || !sourceTransform.getName().equalsIgnoreCase("ImpactClassifierMap")) continue;
                AssociationList lMembers = ((Group)((ClassifierMap)sourceTransform).getTransformationTargets().get(0)).getMembers();
                Feature oProxyColumn = null;
                for (j = 0; j < lMembers.size(); ++j) {
                    Feature feature = (Feature)lMembers.get(j);
                    if (!feature.getName().equals(oColumn.getName())) continue;
                    oProxyColumn = feature;
                    break;
                }
                if (oProxyColumn == null) continue;
                for (j = 0; j < oProxyColumn.getSourceFeatureMaps().size(); ++j) {
                    FeatureMap impactMap = (FeatureMap)oProxyColumn.getSourceFeatureMaps().get(j);
                    Feature nextObject = (Feature)impactMap.getFeatureTargets().get(0);
                    Group owningObject = (Group)nextObject.getGroups().get(0);
                    this.addInformationMapNode((CMetadata)nextObject, (CMetadata)owningObject, (WAPFDNode)((WAPFDNodeModel)lTableModel.get(0)).getViewNode());
                }
            }
            return fVisited;
        }

        private void addInvalidValuesLookupColumnNode(Column oColumn, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
            if (ImpactPFDPanel.this.isPhysicalTableColumn(oColumn)) {
                DataTable oMetadata = oColumn.getTable();
                WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oColumn.getFQID());
                if (toTabModel == null) {
                    toTabModel = new WAPFDTableNodeModel(ImpactPFDPanel.this, (CMetadata)oColumn);
                    ((WAPFDTableNodeModel)toTabModel).addNode((CMetadata)oColumn);
                }
                WAPFDNode viewNode = (WAPFDNode)toTabModel.getViewNode();
                StringBuffer sbCaption = new StringBuffer(bundle.formatString("ImpactPFDPanel.InvalidValuesLookupColumnNodeName.fmt.txt", (Object)oMetadata.getName(), (Object)oColumn.getName()));
                sbCaption.append(ImpactPFDPanel.this.getRepositoryNameAppendString((CMetadata)oMetadata));
                viewNode.getLabel().setText(sbCaption.toString());
                if (nodePrevious != null) {
                    new WAPFDLink(nodePrevious.getViewNode(), viewNode, ImpactPFDPanel.this);
                }
            }
        }

        private boolean addCubeFeatureNode(Feature oFeature, WAPFDNodeModel nodePrevious) throws MdException, RemoteException {
            Cube cube = null;
            List lCubes = ImpactAnalysisUtilities.getCubesForFeature(oFeature);
            for (int iCube = 0; iCube < lCubes.size(); ++iCube) {
                String sType = oFeature.getCMetadataType();
                cube = (Cube)lCubes.get(iCube);
                WAPFDTableNodeModel toTabModel = new WAPFDTableNodeModel(ImpactPFDPanel.this, (CMetadata)cube);
                toTabModel.addNode((CMetadata)cube);
                WAPFDNode viewNode = (WAPFDNode)toTabModel.getViewNode();
                StringBuffer sbCaption = new StringBuffer(bundle.formatString("ImpactPFDPanel.CubeFeatureNodeName.fmt.txt", (Object)cube.getName(), (Object)oFeature.getName(), (Object)sType));
                sbCaption.append(ImpactPFDPanel.this.getRepositoryNameAppendString((CMetadata)cube));
                viewNode.getLabel().setText(sbCaption.toString());
                if (nodePrevious == null) continue;
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(nodePrevious.getViewNode(), viewNode, ImpactPFDPanel.this);
                    continue;
                }
                new WAPFDLink(viewNode, nodePrevious.getViewNode(), ImpactPFDPanel.this);
            }
            boolean fVisited = false;
            return fVisited;
        }

        private void addInvalidValuesNodes(FeatureMap oFM, WAPFDNodeModel stepNodeModel) throws MdException, RemoteException {
            ClassifierMap oCM = oFM.getAssociatedClassifierMap();
            if (oCM != null && oCM.getTransformRole().equalsIgnoreCase("VALIDATE")) {
                AssociationList workColumns = oFM.getFeatureTargets();
                for (int iColumn = 0; iColumn < workColumns.size(); ++iColumn) {
                    Column oWorkColumn = (Column)workColumns.get(iColumn);
                    List lValidations = ImpactAnalysisUtilities.getInvalidValuesValidation(oWorkColumn);
                    for (int iValidationColumn = 0; iValidationColumn < lValidations.size(); ++iValidationColumn) {
                        Column lookupColumn = (Column)lValidations.get(iValidationColumn);
                        this.addInvalidValuesLookupColumnNode(lookupColumn, stepNodeModel);
                    }
                }
            }
        }
    }

    public class cTransformPopulator
    extends cModelPopulator {
        @Override
        public void moveDataToView() throws MdException, RemoteException {
            this.addTransformNode(ImpactPFDPanel.this.m_oMetadata);
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
        }

        protected void addTransformNode(CMetadata oMetadata) throws MdException, RemoteException {
            WAPFDPrototypeNodeModel stepNodeModel = new WAPFDPrototypeNodeModel(ImpactPFDPanel.this, oMetadata);
            StringBuffer caption = new StringBuffer(100);
            caption.append(oMetadata.getName());
            caption.append(bundle.getString("Impactseparationchar.txt"));
            caption.append(oMetadata.getName());
            caption.append(ImpactPFDPanel.this.getRepositoryNameAppendString(oMetadata));
            stepNodeModel.addNode(oMetadata, caption.toString());
            String strGUID = MacroPluginUtilities.getGuid((Prototype)ImpactPFDPanel.this.m_oMetadata);
            List lTransforms = ImpactAnalysisUtilities.getTransforms(ImpactPFDPanel.this.m_oMetadata, strGUID);
            for (int iTransform = 0; iTransform < lTransforms.size(); ++iTransform) {
                TransformationStep oTS = (TransformationStep)lTransforms.get(iTransform);
                Job oJob = ImpactPFDPanel.getJobFor(oTS);
                if (oJob == null) continue;
                this.addStepNodes(oJob, oTS, stepNodeModel);
            }
        }

        protected void addStepNodes(Job oJob, TransformationStep oTS, WAPFDNodeModel connectingNodeModel) throws MdException, RemoteException {
            WAPFDNodeModel stepNodeModel = ImpactPFDPanel.this.getNodeModel(oTS.getFQID());
            if (stepNodeModel == null) {
                stepNodeModel = oTS.getTransformRole().indexOf("Loader") == -1 ? (oTS.getTransformations().size() == 0 ? new WAPFDTransformComputeNodeModel(ImpactPFDPanel.this, (CMetadata)oTS) : new WAPFDTransformNodeModel(ImpactPFDPanel.this, (CMetadata)oTS)) : new WAPFDTransformLoaderNodeModel(ImpactPFDPanel.this, (CMetadata)oTS);
                StringBuffer caption = new StringBuffer(100);
                caption.append(oJob.getName());
                caption.append(bundle.getString("Impactseparationchar.txt"));
                caption.append(oTS.getName());
                caption.append(ImpactPFDPanel.this.getRepositoryNameAppendString((CMetadata)oTS));
                ((WAPFDTransformNodeModel)stepNodeModel).addNode((CMetadata)oTS, caption.toString());
                new WAPFDLink(connectingNodeModel.getViewNode(), stepNodeModel.getViewNode(), ImpactPFDPanel.this);
            }
        }
    }

    public class cTransformationPopulator
    extends cModelPopulator {
        @Override
        public void moveDataToView() throws MdException, RemoteException {
            this.addJobNodes((Transformation)ImpactPFDPanel.this.m_oMetadata, null);
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            this.populateStore(ImpactPFDPanel.this.m_oMetadata);
        }

        public void populateStore(CMetadata oMeta) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (ImpactPFDPanel.this.m_bForward) {
                lAssociations.add("TransformationTargets");
                sbTemplate.append("<Select><Steps/><ClassifierTargets/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierTargets/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><PredecessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Successors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TransformationSources");
                sbTemplate.append("<Select><Steps/><ClassifierSources/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><SuccessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Predecessors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (ImpactPFDPanel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(ImpactPFDPanel.this.m_oMetadata, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        protected boolean addJobNodes(Classifier oMetadata, WAPFDNode connectingNode) throws MdException, RemoteException {
            boolean fVisited = false;
            fVisited = this.addTableNode(oMetadata, null);
            if (connectingNode != null) {
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(connectingNode, ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID()).getViewNode(), ImpactPFDPanel.this);
                } else {
                    new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID()).getViewNode(), connectingNode, ImpactPFDPanel.this);
                }
            }
            AssociationList lSourceTrans = oMetadata.getSourceTransformations();
            for (int i = 0; i < lSourceTrans.size(); ++i) {
                Transformation sourceTrans = (Transformation)lSourceTrans.get(i);
                this.addInformationMaps(sourceTrans, (CMetadata)oMetadata);
            }
            if (fVisited) {
                return false;
            }
            List lCMs = ImpactPFDPanel.this.getClassifierMaps(oMetadata);
            TransformationStep oldTS = null;
            for (int iCM = 0; iCM < lCMs.size(); ++iCM) {
                Job oJob;
                ClassifierMap oCM = (ClassifierMap)lCMs.get(iCM);
                AssociationList lTSs = oCM.getSteps();
                if (lTSs.size() <= 0) continue;
                TransformationStep oTS = (TransformationStep)lTSs.get(0);
                if (oldTS != null) {
                    if (oTS.getFQID().equals(oldTS.getFQID())) continue;
                    oldTS = null;
                }
                if ((oJob = ImpactPFDPanel.getJobFor(oTS)) == null || !fVisited) continue;
                if (oTS.getTransformations().size() > 1) {
                    oldTS = oTS;
                    fVisited = false;
                    continue;
                }
                fVisited = false;
            }
            return fVisited;
        }

        protected boolean addJobNodes(Transformation oMetadata, WAPFDNode connectingNode) throws MdException, RemoteException {
            boolean fVisited = false;
            fVisited = this.addTransformationNode(oMetadata, null);
            if (connectingNode != null) {
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(connectingNode, ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID()).getViewNode(), ImpactPFDPanel.this);
                } else {
                    new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID()).getViewNode(), connectingNode, ImpactPFDPanel.this);
                }
            }
            if (fVisited) {
                return false;
            }
            List lTSs = ImpactPFDPanel.this.getTransformationSteps(oMetadata);
            TransformationStep oldTS = null;
            for (int iTS = 0; iTS < lTSs.size(); ++iTS) {
                Job oJob;
                TransformationStep oTS = (TransformationStep)lTSs.get(iTS);
                if (lTSs.size() <= 0 || (oJob = ImpactPFDPanel.getJobFor(oTS)) == null || !fVisited) continue;
                if (oTS.getTransformations().size() > 1) {
                    oldTS = oTS;
                    fVisited = false;
                    continue;
                }
                fVisited = false;
            }
            return fVisited;
        }

        protected TransformationStep findNextDataStep(TransformationStep thisStep) throws MdException, RemoteException {
            return ImpactPFDPanel.this.getNextStep(thisStep);
        }

        private boolean addTableNodes(TransformationStep oTS) throws MdException, RemoteException {
            boolean fVisited = false;
            AssociationList lCMs = oTS.getTransformations();
            for (int iCM = 0; iCM < lCMs.size(); ++iCM) {
                ClassifierMap oCM = (ClassifierMap)lCMs.get(iCM);
                List lTargets = ImpactPFDPanel.this.getClassifierTables(oCM);
                for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
                    CMetadata oMetadata = (CMetadata)lTargets.get(iTarget);
                    if (!oMetadata.getCMetadataType().equals("PhysicalTable") && !oMetadata.getCMetadataType().equals("ExternalTable") && !oMetadata.getCMetadataType().equals("Cube")) continue;
                    this.populateStore(oMetadata);
                    WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID());
                    if (toTabModel == null) {
                        fVisited = this.addJobNodes((Classifier)oMetadata, (WAPFDNode)ImpactPFDPanel.this.getNodeModel(oTS.getFQID()).getViewNode());
                        continue;
                    }
                    if (ImpactPFDPanel.this.m_bForward) {
                        new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oTS.getFQID()).getViewNode(), toTabModel.getViewNode(), ImpactPFDPanel.this);
                    } else {
                        new WAPFDLink(toTabModel.getViewNode(), ImpactPFDPanel.this.getNodeModel(oTS.getFQID()).getViewNode(), ImpactPFDPanel.this);
                    }
                    fVisited = true;
                }
            }
            return fVisited;
        }

        protected boolean addTableNode(Classifier oMetadata, Column column) throws MdException, RemoteException {
            this.populateStore((CMetadata)oMetadata);
            WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID());
            if (toTabModel == null) {
                toTabModel = oMetadata.getCMetadataType().equals("WorkTable") ? new WAPFDWorkTableNodeModel(ImpactPFDPanel.this, (CMetadata)oMetadata) : new WAPFDTableNodeModel(ImpactPFDPanel.this, (CMetadata)oMetadata);
                ((WAPFDTableNodeModel)toTabModel).addNode((CMetadata)oMetadata);
                WAPFDNode viewNode = (WAPFDNode)toTabModel.getViewNode();
                StringBuffer sbCaption = new StringBuffer(viewNode.getLabel().getText());
                sbCaption.append(ImpactPFDPanel.this.getRepositoryNameAppendString((CMetadata)oMetadata));
                viewNode.getLabel().setText(sbCaption.toString());
                return false;
            }
            return true;
        }

        protected boolean addTransformationNode(Transformation oMetadata, Column column) throws MdException, RemoteException {
            this.populateStore((CMetadata)oMetadata);
            WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID());
            if (toTabModel == null) {
                toTabModel = new WAPFDInformationNodeModel(ImpactPFDPanel.this, (CMetadata)oMetadata);
                ((WAPFDTableNodeModel)toTabModel).addNode((CMetadata)oMetadata);
                WAPFDNode viewNode = (WAPFDNode)toTabModel.getViewNode();
                StringBuffer sbCaption = new StringBuffer(viewNode.getLabel().getText());
                sbCaption.append(ImpactPFDPanel.this.getRepositoryNameAppendString((CMetadata)oMetadata));
                viewNode.getLabel().setText(sbCaption.toString());
                return false;
            }
            return true;
        }

        protected boolean addInformationMapNode(CMetadata oMetadata) throws MdException, RemoteException {
            this.populateStore(oMetadata);
            WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID());
            if (toTabModel == null) {
                StringBuffer sbCaption = new StringBuffer(oMetadata.getName());
                sbCaption.append(ImpactPFDPanel.this.getRepositoryNameAppendString(oMetadata));
                toTabModel = new cInformationMapWAPFDNodeModel(ImpactPFDPanel.this, oMetadata);
                ((cInformationMapWAPFDNodeModel)toTabModel).addNode(oMetadata, sbCaption.toString());
                return false;
            }
            return true;
        }

        private boolean addTransformationNodes(TransformationStep oTS) throws MdException, RemoteException {
            boolean fVisited = false;
            AssociationList lTrans = ImpactPFDPanel.this.m_bForward ? oTS.getSourceTransformations() : oTS.getTargetTransformations();
            for (int iTrans = 0; iTrans < lTrans.size(); ++iTrans) {
                Transformation oTrans = (Transformation)lTrans.get(iTrans);
                WAPFDNodeModel toTabModel = ImpactPFDPanel.this.getNodeModel(oTrans.getFQID());
                if (toTabModel == null) {
                    fVisited = this.addJobNodes(oTrans, (WAPFDNode)ImpactPFDPanel.this.getNodeModel(oTS.getFQID()).getViewNode());
                    continue;
                }
                if (ImpactPFDPanel.this.m_bForward) {
                    new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oTS.getFQID()).getViewNode(), toTabModel.getViewNode(), ImpactPFDPanel.this);
                } else {
                    new WAPFDLink(toTabModel.getViewNode(), ImpactPFDPanel.this.getNodeModel(oTS.getFQID()).getViewNode(), ImpactPFDPanel.this);
                }
                fVisited = true;
            }
            return fVisited;
        }

        protected void addInformationMaps(Transformation trans, CMetadata oMetadata) throws MdException, RemoteException {
            this.addInformationMapNode((CMetadata)trans);
            new WAPFDLink(ImpactPFDPanel.this.getNodeModel(oMetadata.getFQID()).getViewNode(), ImpactPFDPanel.this.getNodeModel(trans.getFQID()).getViewNode(), ImpactPFDPanel.this);
            AssociationList lSourceTrans = trans.getSourceTransformations();
            for (int i = 0; i < lSourceTrans.size(); ++i) {
                Transformation sourceTrans = (Transformation)lSourceTrans.get(i);
                this.addInformationMaps(sourceTrans, (CMetadata)trans);
            }
        }
    }

    protected class cImpactMouseListener
    extends MouseAdapter {
        protected cImpactMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ImpactPFDPanel.this.requestFocusInWindow();
            if (e.isPopupTrigger()) {
                ImpactPFDPanel.this.handlePopupEvent(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (ImpactPFDPanel.this.getSelectionList().getNumPrimitives() == 1) {
                    if (ImpactPFDPanel.this.getSelectedPrimitives()[0] instanceof WAPFDTableNode || ImpactPFDPanel.this.getSelectedPrimitives()[0] instanceof WAPFDPrototypeNode) {
                        ImpactPFDPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        ImpactPFDPanel.this.handlePropertiesAction();
                        ImpactPFDPanel.this.setCursor(Cursor.getDefaultCursor());
                    } else if (ImpactPFDPanel.this.getSelectedPrimitives()[0] instanceof WAPFDTransformNode) {
                        try {
                            ImpactPFDPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            WAPFDNode node = (WAPFDNode)ImpactPFDPanel.this.getSelectedPrimitives()[0];
                            CMetadata currentObj = node.getWAPFDNodeModel().getMetadataObject((MdObjectStore)ImpactPFDPanel.this.m_oMetadata.getObjectStore());
                            TransformationStep stepObj = null;
                            if (currentObj.getCMetadataType().equals("FeatureMap")) {
                                TransformationStep oTs = ImpactPFDPanel.this.getStepFor((FeatureMap)currentObj);
                                ImpactPFDPanel.this.setTransformationStepFQID(oTs.getFQID());
                                stepObj = oTs;
                            } else {
                                ImpactPFDPanel.this.setTransformationStepFQID(currentObj.getFQID());
                                stepObj = (TransformationStep)currentObj;
                            }
                            TransformationActivity act = (TransformationActivity)stepObj.getActivities().get(0);
                            Job job = (Job)act.getJobs().get(0);
                            SimpleObjectImpl simpleJob = new SimpleObjectImpl(job.getName(), job.getFQID(), job.getCMetadataType(), job.getPublicType());
                            if (AppViewFactory.getInstance().isOpenViewSupported((SimpleObject)simpleJob)) {
                                ImpactPFDPanel.this.handleImpactViewJobAction();
                            } else {
                                ImpactPFDPanel.this.handlePropertiesAction();
                            }
                            ImpactPFDPanel.this.setCursor(Cursor.getDefaultCursor());
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException((RemoteException)re);
                        }
                        catch (MdException ex) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                        }
                    }
                }
            } else if (e.isPopupTrigger()) {
                ImpactPFDPanel.this.handlePopupEvent(e);
            } else {
                ImpactPFDPanel.this.updateActions(true);
            }
        }
    }

    public class cInformationMapWAPFDNode
    extends WAPFDPrototypeNode {
        public cInformationMapWAPFDNode(Point canvasLocation, Dimension size, int iShape, ImageIcon image, String sCaption, WAPFDNodeModel Model, PFDPanel parentPanel) {
            super(canvasLocation, size, iShape, image, sCaption, Model, parentPanel);
        }

        public cInformationMapWAPFDNode(Point loc, ImageIcon image, String sCaption, WAPFDPrototypeNodeModel Model, PFDPanel parentPanel) {
            super(loc, new Dimension(34, 34), 2, image, sCaption, Model, parentPanel);
            this.getDrawable().getPen().setLineWidth(3.0f);
            this.getDrawable().getPen().setColor(new Color(70, 119, 206));
            this.getDrawable().getBrush().setColor(new Color(205, 218, 241));
        }
    }

    public class cFeatureWAPFDNode
    extends WAPFDPrototypeNode {
        public cFeatureWAPFDNode(Point canvasLocation, Dimension size, int iShape, ImageIcon image, String sCaption, WAPFDNodeModel Model, PFDPanel parentPanel) {
            super(canvasLocation, size, iShape, image, sCaption, Model, parentPanel);
        }

        public cFeatureWAPFDNode(Point loc, ImageIcon image, String sCaption, WAPFDPrototypeNodeModel Model, PFDPanel parentPanel) {
            super(loc, new Dimension(34, 34), 2, image, sCaption, Model, parentPanel);
            this.getDrawable().getPen().setLineWidth(3.0f);
            this.getDrawable().getPen().setColor(new Color(70, 119, 206));
            this.getDrawable().getBrush().setColor(new Color(205, 218, 241));
        }
    }

    public class cGroupWAPFDNode
    extends WAPFDPrototypeNode {
        public cGroupWAPFDNode(Point canvasLocation, Dimension size, int iShape, ImageIcon image, String sCaption, WAPFDNodeModel Model, PFDPanel parentPanel) {
            super(canvasLocation, size, iShape, image, sCaption, Model, parentPanel);
        }

        public cGroupWAPFDNode(Point loc, ImageIcon image, String sCaption, WAPFDPrototypeNodeModel Model, PFDPanel parentPanel) {
            super(loc, new Dimension(34, 34), 2, image, sCaption, Model, parentPanel);
            this.getDrawable().getPen().setLineWidth(3.0f);
            this.getDrawable().getPen().setColor(new Color(70, 119, 206));
            this.getDrawable().getBrush().setColor(new Color(205, 218, 241));
        }
    }

    protected class cImpactMenuAction
    extends WsAbstractAction {
        public cImpactMenuAction() {
            super(bundle, "ImpactPFDPanel.Menu");
            this.setMenuSupportId("impactmenu");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cColumnImpactAction
    extends WsAbstractAction {
        private DualListSelector m_dlsSelectColumns;
        private CollectionToListModelAdapter m_adpAvailableColumns;
        private CollectionToListModelAdapter m_adpSelectedColumns;
        private WAPropertyTab m_panAdditionalColumns;

        public cColumnImpactAction() {
            super(bundle, "ImpactPFDPanel.Column");
        }

        public void actionPerformed(ActionEvent e) {
            PFDPrimitive[] aSelectedPrimitives = ImpactPFDPanel.this.getSelectedPrimitives();
            if (aSelectedPrimitives.length > 0 && aSelectedPrimitives[0] instanceof WAPFDTableNode) {
                CMetadata mdo = ((WAPFDNode)aSelectedPrimitives[0]).getWAPFDNodeModel().getMetadataObject(ImpactPFDPanel.this.m_oMetadata);
                DataTable table = (DataTable)mdo;
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ImpactPFDPanel.ColumnImpactDialog.Title.txt"), true);
                dlg.setHelpButtonVisible(false);
                dlg.setResizable(true);
                try {
                    this.createImpactColumnsPanel(table);
                    dlg.setMainPanel((WAPanel)this.m_panAdditionalColumns);
                    dlg.setPreferredSize(new Dimension(400, 400));
                    dlg.show();
                    if (dlg.getReturnValue() == 1 && this.m_adpSelectedColumns.getSize() > 0) {
                        Column selectedColumn = (Column)this.m_adpSelectedColumns.getElementAt(0);
                        SimpleObjectImpl simpleObj = new SimpleObjectImpl(selectedColumn.getName(), selectedColumn.getFQID(), selectedColumn.getCMetadataType(), selectedColumn.getPublicType());
                        AppViewFactory.getInstance().showAnalysisView((SimpleObject)simpleObj);
                    }
                    dlg.dispose();
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
                catch (MdException e1) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Reading");
                }
            }
        }

        private void createImpactColumnsPanel(DataTable table) throws MdException, RemoteException {
            AssociationList columns = table.getColumns();
            ArrayList availableColumns = new ArrayList(columns);
            Collections.sort(availableColumns, new cColumnComparator());
            ArrayList selectedColumns = new ArrayList();
            this.m_dlsSelectColumns = new DualListSelector();
            this.m_adpAvailableColumns = new CollectionToListModelAdapter();
            this.m_adpSelectedColumns = new CollectionToListModelAdapter();
            this.m_adpSelectedColumns.addListDataListener((ListDataListener)new DualListener());
            this.m_dlsSelectColumns.setTargetMaximumCount(1);
            this.m_dlsSelectColumns.setSourceLabel(bundle.getString("ImpactPFDPanel.source.txt"));
            this.m_dlsSelectColumns.getSourceComponent().setToolTipText(bundle.getString("ImpactPFDPanel.AvailableColumns.ToolTip.txt"));
            ((JLabel)this.m_dlsSelectColumns.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("ImpactPFDPanel.AvailableColumns.mnem").charAt(0));
            this.m_dlsSelectColumns.setTargetLabel(bundle.getString("ImpactPFDPanel.SelectedColumns.txt"));
            this.m_dlsSelectColumns.getTargetComponent().setToolTipText(bundle.getString("ImpactPFDPanel.SelectedColumns.ToolTip.txt"));
            ((JLabel)this.m_dlsSelectColumns.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("ImpactPFDPanel.SelectedColumns.mnem").charAt(0));
            this.m_panAdditionalColumns = new WAPropertyTab();
            this.m_panAdditionalColumns.setLayout((LayoutManager)new GridBagLayout());
            this.m_dlsSelectColumns.setModel((ListModel)this.m_adpAvailableColumns);
            this.m_dlsSelectColumns.setTargetModel((ListModel)this.m_adpSelectedColumns);
            this.m_dlsSelectColumns.setTargetCellRenderer((ListCellRenderer)new cListCellRenderer());
            this.m_dlsSelectColumns.setSourceCellRenderer((ListCellRenderer)new cListCellRenderer());
            this.m_adpAvailableColumns.setModel(availableColumns);
            this.m_adpSelectedColumns.setModel(selectedColumns);
            this.m_panAdditionalColumns.add((Component)this.m_dlsSelectColumns, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private class DualListener
        implements ListDataListener {
            private DualListener() {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ImpactPFDPanel.this.setDataChanged(true);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        }

        private class cListCellRenderer
        extends DefaultListCellRenderer {
            private cListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                try {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    WsCompoundIcon iconCompound = new WsCompoundIcon();
                    iconCompound.setIconGap(1);
                    String sType = WsColumnMetadataUtil.convertColumnTypeToView((String)((Column)value).getSASColumnType());
                    iconCompound.addIcon(WsColumnMetadataUtil.getColumnViewTypeIcon((String)sType));
                    if (iconCompound.getIconCount() == 0) {
                        this.setIcon(null);
                    } else {
                        this.setIcon((Icon)iconCompound);
                    }
                    return this;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                    return null;
                }
            }
        }
    }

    protected class cImpactPropertiesAction
    extends WsAbstractAction {
        public cImpactPropertiesAction() {
            super(bundle, "ImpactPFDPanel.Properties", true);
            this.setMenuSupportId("Edit:Properties");
        }

        public void actionPerformed(ActionEvent e) {
            ImpactPFDPanel.this.handlePropertiesAction();
        }
    }

    protected class cImpactViewJobAction
    extends WsAbstractAction {
        public cImpactViewJobAction() {
            super(bundle, "ImpactPFDPanel.ViewJob", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Open"));
            this.setMenuSupportId("File:Open:SelectedObjects");
        }

        public void actionPerformed(ActionEvent e) {
            ImpactPFDPanel.this.setTransformationStepFQID(null);
            ImpactPFDPanel.this.handleImpactViewJobAction();
        }
    }

    protected class cImpactViewDataAction
    extends PFDPanel.cViewDataAction {
        protected cImpactViewDataAction() {
            super(ImpactPFDPanel.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpactPFDPanel.this.handleImpactViewDataAction();
        }
    }

    protected class cImpactViewFileAction
    extends PFDPanel.cViewFileAction {
        protected cImpactViewFileAction() {
            super(ImpactPFDPanel.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpactPFDPanel.this.handleImpactViewFileAction();
        }
    }

    protected class InitializeRunnableLaunchPFD
    implements Runnable {
        CMetadata m_object;

        public InitializeRunnableLaunchPFD(CMetadata object) {
            this.m_object = object;
        }

        @Override
        public void run() {
            Workspace.getDefaultLogger().debug((Object)"Doing the launch");
            WsEditorOMAView view = JobTreeNode.showNewProcessView(this.m_object);
            if (ImpactPFDPanel.this.m_sTransformationStepFQID != null && ImpactPFDPanel.this.m_sTransformationStepFQID.length() > 0) {
                WAPFDPropertyTab pfdTab = ((WAPFDEditorOMAView)view).getPFDTab();
                PFDPanel pfdPanel = pfdTab.getPFDPanel();
                pfdPanel.showTSProperties(ImpactPFDPanel.this.m_sTransformationStepFQID);
            }
        }
    }

    public class cInformationMapWAPFDNodeModel
    extends WAPFDPrototypeNodeModel {
        public cInformationMapWAPFDNodeModel(PFDPanel parentPanel, CMetadata object) {
            super(parentPanel, object);
        }

        @Override
        public void addNode(CMetadata oObject, String strCaption) throws PFDException, MdException, RemoteException {
            Icon icon = AppIconFactory.getInstance().getIconForPublicType("InformationMap");
            if (oObject instanceof Group || oObject instanceof Feature) {
                String sType = oObject.getDesc();
                if (sType.equalsIgnoreCase("Cube")) {
                    icon = AppIconFactory.getInstance().getIconForPublicType("Cube");
                } else if (sType.equalsIgnoreCase("Report")) {
                    icon = AppIconFactory.getInstance().getIconForPublicType("Report");
                }
            }
            this.m_viewNode = new cInformationMapWAPFDNode(new Point(0, 0), (ImageIcon)icon, strCaption, this, this.m_parentPanel);
            this.m_viewNode.addNode();
        }
    }

    public class cFeatureWAPFDNodeModel
    extends WAPFDPrototypeNodeModel {
        public cFeatureWAPFDNodeModel(PFDPanel parentPanel, CMetadata object) {
            super(parentPanel, object);
        }

        @Override
        public void addNode(CMetadata oObject, String strCaption) throws PFDException, MdException, RemoteException {
            ImageIcon icon = ImpactAnalysisUtilities.getIconForBILineage(oObject);
            this.m_viewNode = new cFeatureWAPFDNode(new Point(0, 0), icon, strCaption, this, this.m_parentPanel);
            this.m_viewNode.addNode();
        }
    }

    public class cGroupWAPFDNodeModel
    extends WAPFDPrototypeNodeModel {
        public cGroupWAPFDNodeModel(PFDPanel parentPanel, CMetadata object) {
            super(parentPanel, object);
        }

        @Override
        public void addNode(CMetadata oObject, String strCaption) throws PFDException, MdException, RemoteException {
            ImageIcon icon = ImpactAnalysisUtilities.getIconForBILineage(oObject);
            this.m_viewNode = new cGroupWAPFDNode(new Point(0, 0), icon, strCaption, this, this.m_parentPanel);
            this.m_viewNode.addNode();
        }
    }

    public class cColumnComparator
    implements Comparator {
        private boolean m_bCaseSensitive = false;

        public int compare(Object first, Object second) {
            if (!(first instanceof Column) || !(second instanceof Column)) {
                throw new IllegalArgumentException();
            }
            Column node1 = (Column)first;
            Column node2 = (Column)second;
            try {
                return node1.getName().compareToIgnoreCase(node2.getName());
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return 0;
            }
        }
    }

    public class cBIMetadataPopulator
    extends cModelPopulator {
        @Override
        public void moveDataToView() throws MdException, RemoteException {
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            this.populateStore(ImpactPFDPanel.this.m_oMetadata);
        }

        public void populateStore(CMetadata oMeta) throws MdException, RemoteException {
        }
    }
}

