/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.LogicalObjectNode;
import com.sas.wadmin.visuals.OperationUIAdapter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsMessageDisplayer;
import java.rmi.RemoteException;
import javax.swing.tree.TreeNode;

public class TempLogicalObjectNode
extends WsDataTreeNode
implements LogicalObjectNode {
    private LogicalObjectInterface m_lob;

    public TempLogicalObjectNode(CMetadata oMetadata) {
        super(oMetadata);
    }

    public void setLogicalObject(LogicalObjectInterface lobData) {
        this.m_lob = lobData;
    }

    @Override
    public LogicalObjectInterface getLogicalObject() {
        return this.m_lob;
    }

    public boolean isRenameable() {
        try {
            return this.m_lob.isRenameAllowed();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
    }

    public boolean isDeleteable() {
        try {
            return this.m_lob.isDeleteAllowed();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
    }

    @Override
    public boolean isCheckOutable() {
        try {
            return this.m_lob.ischeckOutAllowed();
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return false;
        }
    }

    @Override
    public boolean isFetchable() {
        return false;
    }

    @Override
    public boolean isExportable() {
        try {
            return this.m_lob.isExportAllowed();
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
    }

    @Override
    public void updateMetadata(CMetadata mdo) {
        try {
            this.m_lob.refresh((Root)mdo);
            super.updateMetadata(mdo);
            if (this.getTreeModel() != null) {
                this.getTreeModel().nodeChanged((TreeNode)((Object)this));
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean isValidName(String sName) {
        try {
            return this.m_lob.isValidName(sName);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return false;
        }
    }

    @Override
    public void rename(String sName) {
        if (this.m_lob.getName().equals(sName)) {
            return;
        }
        try {
            OperationUIAdapter opUI = new OperationUIAdapter((WsMessageDisplayer)Workspace.getWorkspace().getStatusBar());
            this.m_lob.rename(sName, (OperationUserInteractionInterface)opUI);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void delete(OperationUserInteractionInterface op) {
        if (op.isOperationCancelled()) {
            return;
        }
        try {
            this.m_lob.delete(op);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void checkOut(OperationUserInteractionInterface op) {
        if (op.isOperationCancelled()) {
            return;
        }
        try {
            this.m_lob.checkOut((Root)Workspace.getWorkspace().getProjectRepository(), op);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void fetch(OperationUserInteractionInterface op) {
    }
}

