/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.model.tree.InventoryFolderNode;
import com.sas.wadmin.model.tree.InventoryMetadataObjectsFolderNode;
import com.sas.wadmin.model.tree.OSDataTableNode;
import com.sas.wadmin.model.tree.OSNodeFactory;
import com.sas.wadmin.model.tree.OSNodeFilter;
import com.sas.wadmin.visuals.MiningTreeUtilities;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;

public class ObjectSelectorTreeModel
extends CustomTreeModel {
    public static final int CUSTOM_TREE = 1;
    public static final int MINING_TREE = 2;
    public static final int ALL_TREES = 255;
    public static final int ALL_COLUMNS = 0;
    public static final int NUMERIC_COLUMNS = 1;
    public static final int CHARACTER_COLUMNS = 2;
    private int m_fTreesToShow;
    private OSNodeFilter m_filter = new OSNodeFilter();
    private OSNodeFactory m_factory;
    private boolean m_bSortColumns;
    private WsTreeNode[] m_aInventoryNodes;

    public ObjectSelectorTreeModel(MdObjectStore store) {
        super(new OSNodeFactory());
        this.setNodeFilter(this.m_filter);
        this.setStore(store);
        this.setTreesToShow(1);
        this.setColumnTypeToShow(0);
        this.m_aInventoryNodes = new WsTreeNode[0];
    }

    protected List createDefaultRepositoryList() {
        List lSelectedReps = Workspace.getWorkspace().getSelectedRepositories();
        if (lSelectedReps != null) {
            return new ArrayList(lSelectedReps);
        }
        return super.createDefaultRepositoryList();
    }

    public void setTreesToShow(int fTrees) {
        this.m_fTreesToShow = fTrees;
    }

    public int getTreesToShow() {
        return this.m_fTreesToShow;
    }

    public void setTypesToShow(String[] saTypes) {
        this.m_filter.setTypesToShow(saTypes);
    }

    public String[] getTypesToShow() {
        return this.m_filter.getTypesToShow();
    }

    public void addTypeToShow(String sType) {
        this.m_filter.addTypeToShow(sType);
    }

    public void setTypesToExpand(String[] saTypes) {
        this.m_factory.setTypesToExpand(saTypes);
    }

    public String[] getTypesToExpand() {
        return this.m_factory.getTypesToExpand();
    }

    public void addTypeToExpand(String sType) {
        this.m_factory.addTypeToExpand(sType);
    }

    public void setColumnTypeToShow(int eType) {
        this.m_filter.setColumnTypeToShow(eType);
    }

    public int getColumnTypeToShow() {
        return this.m_filter.getColumnTypeToShow();
    }

    public void setSortColumns(boolean bSort) {
        if (this.m_bSortColumns == bSort) {
            return;
        }
        this.m_bSortColumns = bSort;
        this.reorderTableColumns((TreeNode)this.getRoot());
    }

    public boolean isSortColumns() {
        return this.m_bSortColumns;
    }

    public void setInventoryNodes(WsTreeNode[] aInventoryNodes) {
        this.m_aInventoryNodes = (WsTreeNode[])aInventoryNodes.clone();
    }

    public WsTreeNode[] getInventoryNodes() {
        return (WsTreeNode[])this.m_aInventoryNodes.clone();
    }

    public void setNodeFilter(WsNodeFilter filter) {
        if (!(filter instanceof OSNodeFilter)) {
            throw new IllegalArgumentException("Filter must be an instance of OSNodeFilter");
        }
        super.setNodeFilter(filter);
        this.m_filter = (OSNodeFilter)filter;
    }

    public void setNodeFactory(WsNodeFactory factory) {
        if (!(factory instanceof OSNodeFactory)) {
            throw new IllegalArgumentException("Factory must be an instance of OSNodeFactory");
        }
        super.setNodeFactory(factory);
        this.m_factory = (OSNodeFactory)factory;
    }

    public void addInventoryNode(String sTitle, String sType) {
        InventoryMetadataObjectsFolderNode node = new InventoryMetadataObjectsFolderNode(sTitle, sType, null);
        this.setInventoryNodes(new WsTreeNode[]{node});
    }

    public void addInventoryNodes(String[] saTitles, String[] saTypes) {
        WsTreeNode[] aNodes = new WsTreeNode[saTypes.length];
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            aNodes[iNode] = new InventoryMetadataObjectsFolderNode(saTitles[iNode], saTypes[iNode], null);
        }
        this.setInventoryNodes(aNodes);
    }

    @Override
    public List getRootFolders(String sRepositoryFQID, MdObjectStore store) throws MdException, RemoteException {
        Tree mdoMiningTree;
        ArrayList<Tree> lRootFolders = (this.m_fTreesToShow & 1) != 0 ? super.getRootFolders(sRepositoryFQID, store) : new ArrayList<Tree>(1);
        if ((this.m_fTreesToShow & 2) != 0 && (mdoMiningTree = MiningTreeUtilities.getRoot(sRepositoryFQID, store)) != null) {
            lRootFolders.add(mdoMiningTree);
        }
        return lRootFolders;
    }

    @Override
    public WsDataTreeNode find(Root mdo) throws MdException, RemoteException {
        String sType = mdo.getCMetadataType();
        if (sType.equals("Column")) {
            DataTable table = ((Column)mdo).getTable();
            if (table == null) {
                return null;
            }
            WsDataTreeNode node = this.find((Root)table);
            if (node == null) {
                return null;
            }
            return this.findInChildren((WsTreeNode)node, mdo.getFQID());
        }
        if (sType.equals("RelationalTable")) {
            MiningResult mdoMining = this.getParentMiningResult((RelationalTable)mdo);
            if (mdoMining == null) {
                return null;
            }
            WsDataTreeNode node = this.find((Root)mdoMining);
            if (node == null) {
                return null;
            }
            return this.findInChildren((WsTreeNode)node, mdo.getFQID());
        }
        WsDataTreeNode node = super.find(mdo);
        if (node != null) {
            return node;
        }
        node = this.findInMiningTree(mdo);
        if (node != null) {
            return node;
        }
        return this.findInInventoryNodes(mdo);
    }

    private MiningResult getParentMiningResult(RelationalTable mdoTable) throws MdException, RemoteException {
        AssociationList lSources = mdoTable.getSourceTransformations();
        for (int iSource = 0; iSource < lSources.size(); ++iSource) {
            Root mdoSource = (Root)lSources.get(iSource);
            if (!mdoSource.getCMetadataType().equals("MiningResult")) continue;
            return (MiningResult)mdoSource;
        }
        AssociationList lTargets = mdoTable.getTargetTransformations();
        for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
            Root mdoTarget = (Root)lTargets.get(iTarget);
            if (!mdoTarget.getCMetadataType().equals("MiningResult")) continue;
            return (MiningResult)mdoTarget;
        }
        return null;
    }

    private WsDataTreeNode findInMiningTree(Root mdo) throws MdException, RemoteException {
        String sRepositoryFQID = "A0000001." + mdo.getRepositoryID();
        WsDataTreeNode node = this.findInChildren((WsTreeNode)this.getRoot(), sRepositoryFQID);
        if (node == null) {
            return null;
        }
        List lPathTrees = MiningTreeUtilities.getPath(mdo);
        for (int iTree = 0; iTree < lPathTrees.size(); ++iTree) {
            Tree mdoTree = (Tree)lPathTrees.get(iTree);
            if ((node = this.findInChildren((WsTreeNode)node, mdoTree.getFQID())) != null) continue;
            return null;
        }
        return this.findInChildren((WsTreeNode)node, mdo.getFQID());
    }

    private WsDataTreeNode findInInventoryNodes(Root mdo) {
        try {
            String sRepositoryFQID = "A0000001." + mdo.getRepositoryID();
            WsDataTreeNode node = this.findInChildren((WsTreeNode)this.getRoot(), sRepositoryFQID);
            if (node == null) {
                return null;
            }
            node.expand();
            for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
                WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
                if (!(nodeChild instanceof InventoryFolderNode) || !((InventoryFolderNode)nodeChild).isValidMember(mdo)) continue;
                return this.findInChildren(nodeChild, mdo.getFQID());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    private void reorderTableColumns(TreeNode node) {
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
            if (nodeChild instanceof OSDataTableNode) {
                if (!nodeChild.hasExpanded()) continue;
                nodeChild.removeChildren();
                nodeChild.setHasExpanded(false);
                nodeChild.setSorted(this.m_bSortColumns);
                nodeChild.addChildren();
                nodeChild.setHasExpanded(true);
                continue;
            }
            this.reorderTableColumns((TreeNode)nodeChild);
        }
    }
}

