/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.ColumnNode;
import com.sas.wadmin.model.tree.DefaultNodeFactory;
import com.sas.wadmin.model.tree.OSDataTableNode;
import com.sas.wadmin.model.tree.OSMiningResultNode;
import com.sas.wadmin.model.tree.OSRepositoryNode;
import com.sas.wadmin.model.tree.ObjectSelectorTreeModel;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;

public class OSNodeFactory
extends DefaultNodeFactory {
    private String[] m_saTypesToExpand = new String[0];

    public void setTypesToExpand(String[] saTypes) {
        this.m_saTypesToExpand = saTypes;
    }

    public String[] getTypesToExpand() {
        return this.m_saTypesToExpand;
    }

    public void addTypeToExpand(String sType) {
        if (this.m_saTypesToExpand == null) {
            this.m_saTypesToExpand = new String[]{sType};
            return;
        }
        int nTypes = this.m_saTypesToExpand.length + 1;
        String[] saTypes = new String[nTypes];
        System.arraycopy(this.m_saTypesToExpand, 0, saTypes, 0, nTypes);
        this.m_saTypesToExpand = saTypes;
        this.m_saTypesToExpand[nTypes - 1] = sType;
    }

    public boolean isTypeExpandable(String sType) {
        if (this.m_saTypesToExpand == null) {
            return true;
        }
        for (int iType = 0; iType < this.m_saTypesToExpand.length; ++iType) {
            if (!this.m_saTypesToExpand[iType].equals(sType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public WsTreeNode createRepositoryFolderNode(Root mdo, WsTreeNode nodeParent) {
        return new OSRepositoryNode(mdo);
    }

    @Override
    public WsTreeNode createObjectNode(Root mdo, WsTreeNode nodeParent) throws MdException, RemoteException {
        ObjectSelectorTreeModel model = (ObjectSelectorTreeModel)nodeParent.getTreeModel();
        String sType = mdo.getCMetadataType();
        if (sType.equals("PhysicalTable") || sType.equals("ExternalTable") || sType.equals("RelationalTable")) {
            OSDataTableNode node = new OSDataTableNode(mdo);
            node.setAllowsChildren(this.isTypeExpandable(sType));
            node.setSorted(model.isSortColumns());
            return node;
        }
        if (sType.equals("Column")) {
            ColumnNode node = new ColumnNode((Column)mdo);
            node.setAllowsChildren(false);
            return node;
        }
        if (sType.equals("MiningResult")) {
            OSMiningResultNode node = new OSMiningResultNode(mdo);
            node.setAllowsChildren(this.isTypeExpandable(sType));
            return node;
        }
        return super.createObjectNode(mdo, nodeParent);
    }
}

