/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.Factory;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.wadmin.model.LogicalPublicTypeFilter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class LogicalPublicTypeInventoryFilter
extends LogicalPublicTypeFilter {
    @Override
    public boolean accept(String sPublicType) {
        if (sPublicType == null || sPublicType.equals("Folder") || sPublicType.equals("RootFolder")) {
            return false;
        }
        if (super.accept(sPublicType)) {
            try {
                TypeDescriptorInterface typeDescriptor = Factory.getInstance().getMetadataServerInterface().getTypeDescriptor(sPublicType);
                return "Folder".equals(typeDescriptor.getContainerType());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            }
        }
        return false;
    }
}

