/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.AbstractInventoryFolderNode;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import com.sas.workspace.tree.WsTreeModel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class InventoryMetadataObjectsFolderNode
extends AbstractInventoryFolderNode {
    private static final WAdminResource bundle = WAdminResource.getBundle(InventoryMetadataObjectsFolderNode.class);
    private String m_sType;
    protected WsAbstractAction m_actNew;

    public InventoryMetadataObjectsFolderNode(String sName, String sType, String sRepositoryFQID) {
        super(sName, sRepositoryFQID);
        this.m_sType = sType;
        this.m_actNew = this.createNewAction();
    }

    public String getType() {
        return this.m_sType;
    }

    @Override
    public boolean isValidMember(Root mdo) {
        try {
            return this.m_sType.equals(mdo.getCMetadataType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren() {
        WsTreeModel model = this.getTreeModel();
        WsNodeFactory factory = model.getNodeFactory();
        WsNodeFilter filter = model.getNodeFilter();
        MdObjectStore store = model.acquireStore();
        List lObjects = this.getListOfObjects(store);
        if (lObjects == null) {
            return;
        }
        try {
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                Root mdoComplex = (Root)lObjects.get(iObject);
                if (filter != null && !filter.accept(mdoComplex, (WsTreeNode)this)) continue;
                this.addChild(factory.createObjectNode(mdoComplex, (WsTreeNode)this));
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            model.disposeStore(store);
        }
    }

    protected List getListOfObjects(MdObjectStore store) {
        try {
            int fFlags = 264;
            return Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, this.getRepositoryFQID(), this.m_sType, fFlags, "");
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_actNew.setActive(bActive);
    }

    public JPopupMenu getPopupMenu(WAdminResource abundle) {
        JPopupMenu menuPopup = super.getPopupMenu(abundle);
        menuPopup.add(new JMenuItem((Action)this.m_actNew));
        return menuPopup;
    }

    public void onNew() {
        new NewObjectWizard((Frame)Workspace.getWorkspace(), bundle.getString("InventoryMetadataObjectsFolderNode.NewObjectWizard.Title.txt"), this.m_sType, "");
    }

    protected WsAbstractAction createNewAction() {
        return new NewAction();
    }

    protected class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "InventoryMetadataObjectsFolderNode.Action.New", 258);
            this.setMenuSupportId("new");
            this.setEnabled(NewObjectWizard.isTypeSupported(InventoryMetadataObjectsFolderNode.this.m_sType));
        }

        public void actionPerformed(ActionEvent e) {
            InventoryMetadataObjectsFolderNode.this.onNew();
        }
    }
}

