/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.model.tree.ITransformationTreeNode;
import com.sas.wadmin.model.tree.LogicalBrowseObjectTreeNode;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;

public class GeneratedTransformationTreeNode
extends LogicalBrowseObjectTreeNode
implements ITransformationTreeNode {
    private TransformInterface m_transformation;
    private String m_name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneratedTransformationTreeNode(SimpleBrowseObject simpleObj) {
        super(simpleObj);
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "GeneratedTransformationTreeNode:getTransform");
            try {
                Prototype proto = (Prototype)ObjectConverter.getInstance().convertToJOMAObject(store, (SimpleObject)simpleObj);
                this.m_transformation = new MacroPlugin((CMetadata)proto, "", GeneratedTransformationUtilities.getProcessTreePath((Root)proto));
                this.m_name = this.m_transformation.getName();
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
    }

    public GeneratedTransformationTreeNode(SimpleBrowseObject simpleObj, TransformInterface transformation) {
        super(simpleObj);
        this.m_transformation = transformation;
        this.m_name = this.m_transformation.getName();
    }

    @Override
    public TransformInterface getTransformation() {
        return this.m_transformation;
    }

    @Override
    public String getCategory() {
        return this.truncateCategory(this.m_transformation.getCategory());
    }

    public String getName() {
        if (((MacroPlugin)this.m_transformation).isLoadedFromBundle()) {
            return this.m_name;
        }
        return this.m_simpleBrowseObject.getName();
    }

    private String truncateCategory(String sCategory) {
        int iFirstDot = sCategory.indexOf(46);
        if (iFirstDot > -1) {
            sCategory = sCategory.substring(0, iFirstDot);
        }
        return sCategory;
    }
}

