/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.DefaultLogicalObjectNode;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.wadmin.visuals.MacroPluginPropertiesView;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class GeneratedTransformNode
extends DefaultLogicalObjectNode {
    private static WAdminResource bundle = WAdminResource.getBundle(GeneratedTransformNode.class);
    private static WsAbstractAction s_actImpact = new ImpactAnalysisAction();
    private static GeneratedTransformNode s_nodeActive;

    public GeneratedTransformNode(LogicalObjectInterface lobData, Root mdoGenTrans) {
        super(lobData, mdoGenTrans);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        s_nodeActive = bActive ? this : null;
        s_actImpact.setActive(bActive);
    }

    @Override
    public WsOMAView onProperties() {
        try {
            boolean fIsUsed = false;
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            Prototype proto = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, this.getMetadata());
            if (MacroPluginUtilities.isGeneratedTransform((Root)proto) && (fIsUsed = MacroPluginUtilities.isPrototypeUsedInJobs(proto))) {
                MessageUtil.displayMessage((String)bundle.getString("GeneratedTransformNode.Warning.InUse.txt"), (int)2);
            }
            store.dispose();
            WsOMAView view = WsViewFactory.showView((CMetadata)this.getMetadata(), MacroPluginPropertiesView.class);
            if (fIsUsed) {
                view.getFrame().setEditable(false);
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    @Override
    public void checkOut(OperationUserInteractionInterface op) {
        if (op.isOperationCancelled()) {
            return;
        }
        op.updateProgress(bundle.formatString("GeneratedTransformNode.Progress.CheckingOut.fmt.txt", (Object)this.getName()));
        try {
            ArrayList<CMetadata> lObjects = new ArrayList<CMetadata>(1);
            lObjects.add(this.getMetadata());
            ProjectUtil.checkOutMetadata(lObjects, (CMetadata)Workspace.getWorkspace().getProjectRepository());
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Checkingout");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void fetch(OperationUserInteractionInterface op) {
        if (op.isOperationCancelled()) {
            return;
        }
        op.updateProgress(bundle.formatString("GeneratedTransformNode.Progress.Fetching.fmt.txt", (Object)this.getName()));
        try {
            ArrayList<CMetadata> lObjects = new ArrayList<CMetadata>(1);
            lObjects.add(this.getMetadata());
            ProjectUtil.fetchMetadata(lObjects, (CMetadata)Workspace.getWorkspace().getProjectRepository());
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Fetching");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showImpactAnalysis(Root mdoPermanent) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "GeneratedTransformNode:ImpactAnalysis");
            Prototype mdoTransform = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)mdoPermanent);
            ImpactAnalysisOMAView view = (ImpactAnalysisOMAView)WsViewFactory.findExistingView((CMetadata)mdoTransform, ImpactAnalysisOMAView.class);
            if (view != null) {
                mdoTransform.getObjectStore().dispose();
                WsViewFactory.showExistingView((WsOMAView)view);
                return;
            }
            view = new ImpactAnalysisOMAView(mdoTransform);
            WsViewFactory.attachViewToFrame((CMetadata)mdoTransform, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)mdoTransform, ""));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public JPopupMenu getPopupMenu(WAdminResource bdl) {
        JPopupMenu menuPopup = super.getPopupMenu(bdl);
        menuPopup.add((Action)s_actImpact);
        return menuPopup;
    }

    private static class ImpactAnalysisAction
    extends WsAbstractAction {
        public ImpactAnalysisAction() {
            super(bundle, "GeneratedTransformNode.Action.ImpactAnalysis", 258);
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (s_nodeActive != null) {
                GeneratedTransformNode.showImpactAnalysis((Root)s_nodeActive.getMetadata());
            }
        }
    }
}

