/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.Folder;
import com.sas.wadmin.model.tree.AbstractListenerTreeModel;
import com.sas.wadmin.model.tree.DefaultNodeFactory;
import com.sas.wadmin.model.tree.DefaultRootNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CustomTreeModel
extends AbstractListenerTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(CustomTreeModel.class);
    private static final String SOFTWARE_COMPONENT_CLASS = "E5F27790-2149-11D6-8828-AA0004006D06";
    private static final String OLD_SOFTWARE_COMPONENT_CLASS = "com.sas.wadmin.visuals.TheAppWA";
    private static final String FOLDER_TYPE = "BIP Folder";
    private boolean m_bReportingUnconvertedRepositories;

    public CustomTreeModel() {
        this(new DefaultRootNode(), null);
    }

    public CustomTreeModel(WsTreeNode nodeRoot) {
        this(nodeRoot, null);
    }

    public CustomTreeModel(WsNodeFactory factory) {
        this(new DefaultRootNode(), factory);
    }

    public CustomTreeModel(WsTreeNode nodeRoot, WsNodeFactory factory) {
        super(nodeRoot);
        this.setListenForChanges(false);
        if (factory == null) {
            factory = this.createDefaultNodeFactory();
        }
        this.setNodeFactory(factory);
        this.setRepositories(this.createDefaultRepositoryList());
    }

    protected WsNodeFactory createDefaultNodeFactory() {
        return new DefaultNodeFactory();
    }

    public void setReportUnconvertedRepositories(boolean bReport) {
        this.m_bReportingUnconvertedRepositories = bReport;
    }

    public boolean isReportingUnconvertedRepositories() {
        return this.m_bReportingUnconvertedRepositories;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        if (!nodeRoot.hasExpanded()) {
            nodeRoot.addChildren();
        }
    }

    public List getRootFolders(String sRepositoryFQID, MdObjectStore store) throws MdException, RemoteException {
        return CustomTreeModel.getRootFoldersImpl(sRepositoryFQID, store);
    }

    public WsDataTreeNode find(Root mdo) throws MdException, RemoteException {
        String sRepositoryFQID = "A0000001." + mdo.getRepositoryID();
        WsDataTreeNode node = this.findInChildren((WsTreeNode)this.getRoot(), sRepositoryFQID);
        if (node == null) {
            return null;
        }
        List lPathTrees = CustomTreeModel.getPathTo(mdo);
        for (int iTree = 0; iTree < lPathTrees.size(); ++iTree) {
            Tree mdoTree = (Tree)lPathTrees.get(iTree);
            if ((node = this.findInChildren((WsTreeNode)node, mdoTree.getFQID())) != null) continue;
            return null;
        }
        return this.findInChildren((WsTreeNode)node, mdo.getFQID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConvertedRepository(String sRepositoryFQID) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "CustomTreeModel:isConvertedRepository:" + sRepositoryFQID);
        try {
            StringBuffer sbOptions = new StringBuffer(100);
            sbOptions.append("<XMLSelect Search=\"@ClassIdentifier='");
            sbOptions.append(OLD_SOFTWARE_COMPONENT_CLASS);
            sbOptions.append("'\"/>");
            sbOptions.append("<Templates>");
            sbOptions.append("<SoftwareComponent><SoftwareTrees/></SoftwareComponent>");
            sbOptions.append("<Tree><SoftwareComponents/></Tree>");
            sbOptions.append("</Templates>");
            int fOptions = 524684;
            List lSoftwareComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "SoftwareComponent", fOptions, sbOptions.toString());
            if (lSoftwareComponents.size() != 1) {
                Workspace.getDefaultLogger().warn((Object)("CustomTreeModel:isConvertedRepository:Invalid number of old software components: " + lSoftwareComponents.size()));
            }
            if (lSoftwareComponents.size() == 0) {
                boolean bl = true;
                return bl;
            }
            SoftwareComponent mdoSoft = (SoftwareComponent)lSoftwareComponents.get(0);
            AssociationList lTrees = mdoSoft.getSoftwareTrees();
            if (lTrees.size() != 1) {
                Workspace.getDefaultLogger().warn((Object)("CustomTreeModel:isConvertedRepository:Invalid number of trees on old software component: " + lTrees.size()));
            }
            if (lTrees.size() == 0) {
                boolean bl = true;
                return bl;
            }
            Tree mdoTreeRoot = (Tree)lTrees.get(0);
            AssociationList lTreeSoftwareComponents = mdoTreeRoot.getSoftwareComponents();
            for (int iTreeSoftwareComponent = 0; iTreeSoftwareComponent < lTreeSoftwareComponents.size(); ++iTreeSoftwareComponent) {
                SoftwareComponent mdoTreeSoft = (SoftwareComponent)lTreeSoftwareComponents.get(iTreeSoftwareComponent);
                if (!mdoTreeSoft.getClassIdentifier().equals(SOFTWARE_COMPONENT_CLASS)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            store.dispose();
        }
    }

    public static List getPathTo(Root mdoData) throws MdException, RemoteException {
        String sRepository = "A0000001." + mdoData.getRepositoryID();
        MdObjectStore store = (MdObjectStore)mdoData.getObjectStore();
        List lRoots = CustomTreeModel.getRootFoldersImpl(sRepository, store);
        ArrayList<String> lAttrs = new ArrayList<String>(1);
        boolean bTree = mdoData.getCMetadataType().equals("Tree");
        if (bTree) {
            lAttrs.add("ParentTree");
        } else {
            lAttrs.add("Trees");
        }
        String sTemplate = "<Templates><Tree Name=\"\"><ParentTree/></Tree></Templates>";
        int fFlags = 260;
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdoData, null, lAttrs, sTemplate, fFlags);
        if (bTree) {
            return CustomTreeModel.getPath(((Tree)mdoData).getParentTree());
        }
        AssociationList lTrees = mdoData.getTrees();
        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
            Tree mdoTree = (Tree)lTrees.get(iTree);
            List lPath = CustomTreeModel.getPath(mdoTree);
            if (!lRoots.contains(lPath.get(0))) continue;
            return lPath;
        }
        return new ArrayList();
    }

    public static void moveToFolder(Tree mdoFolder, Root mdoMovee) throws MdException, RemoteException {
        if (mdoMovee.getCMetadataType().equals("Tree")) {
            ((Tree)mdoMovee).setParentTree(mdoFolder);
        } else {
            AssociationList lTrees = mdoMovee.getTrees();
            for (int iTree = lTrees.size() - 1; iTree >= 0; --iTree) {
                Tree mdoOldFolder = (Tree)lTrees.get(iTree);
                if (!mdoOldFolder.getTreeType().equalsIgnoreCase(FOLDER_TYPE)) continue;
                lTrees.remove(mdoOldFolder);
            }
            lTrees.add(mdoFolder);
        }
    }

    public static Tree addRootFolder(String sRepository, MdObjectStore store) throws MdException, RemoteException {
        String sCreateRepository = Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_ON ? Workspace.getWorkspace().getProjectRepositoryId() : sRepository.substring(9);
        Tree mdoNewFolder = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, bundle.getString("CustomTreeModel.Unitled.txt"), "Tree", sCreateRepository);
        mdoNewFolder.getSoftwareComponents().add((Object)CustomTreeModel.getSoftwareComponent(sRepository, store));
        mdoNewFolder.setTreeType(FOLDER_TYPE);
        mdoNewFolder.setPublicType("Folder");
        mdoNewFolder.setUsageVersion(Folder.CURRENT_VERSION.encode());
        return mdoNewFolder;
    }

    public static Tree addFolder(Tree mdoFolder) {
        try {
            String sRepository = Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_ON ? Workspace.getWorkspace().getProjectRepositoryId() : mdoFolder.getRepositoryID();
            Tree mdoNewFolder = (Tree)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)mdoFolder.getObjectStore(), null, bundle.getString("CustomTreeModel.Unitled.txt"), "Tree", sRepository);
            mdoNewFolder.setParentTree(mdoFolder);
            mdoNewFolder.setTreeType(FOLDER_TYPE);
            mdoNewFolder.setPublicType("Folder");
            return mdoNewFolder;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private static List getRootFoldersImpl(String sRepositoryFQID, MdObjectStore store) throws MdException, RemoteException {
        SoftwareComponent oSoft = CustomTreeModel.getSoftwareComponent(sRepositoryFQID, store);
        if (oSoft == null) {
            return new ArrayList();
        }
        return oSoft.getSoftwareTrees();
    }

    public static SoftwareComponent getSoftwareComponent(String sRepositoryFQID, MdObjectStore store) throws MdException, RemoteException {
        StringBuffer sbOptions = new StringBuffer(100);
        sbOptions.append("<XMLSelect Search=\"@ClassIdentifier='");
        sbOptions.append(SOFTWARE_COMPONENT_CLASS);
        sbOptions.append("'\"/>");
        sbOptions.append("<Templates>");
        sbOptions.append("<SoftwareComponent><SoftwareTrees/></SoftwareComponent>");
        sbOptions.append("</Templates>");
        int fOptions = 396;
        List lSoftComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "SoftwareComponent", fOptions, sbOptions.toString());
        if (lSoftComponents.isEmpty()) {
            return null;
        }
        return (SoftwareComponent)lSoftComponents.get(0);
    }

    private static List getPath(Tree mdoTree) throws MdException, RemoteException {
        ArrayList<Tree> lTrees = new ArrayList<Tree>(2);
        while (mdoTree != null) {
            lTrees.add(0, mdoTree);
            mdoTree = mdoTree.getParentTree();
        }
        return lTrees;
    }

    public static Tree getDISCustomTreeRootFolder(String sRepositoryID, MdObjectStore mdStore) throws MdException, RemoteException {
        String sTreeName = "SAS Data Integration Studio Custom Tree";
        SoftwareComponent mdSoftComp = CustomTreeModel.getSoftwareComponent(sRepositoryID, mdStore);
        AssociationList lRootTrees = mdSoftComp.getSoftwareTrees();
        for (Tree mdTree : lRootTrees) {
            if (!"SAS Data Integration Studio Custom Tree".equalsIgnoreCase(mdTree.getName())) continue;
            return mdTree;
        }
        Tree mdTree = CustomTreeModel.addRootFolder(sRepositoryID, mdStore);
        mdTree.setName("SAS Data Integration Studio Custom Tree");
        mdTree.updateMetadataAll();
        return mdTree;
    }

    public static Tree getUserTransformsFolder(String sRepositoryID, MdObjectStore mdStore) throws MdException, RemoteException {
        String sTreeName = bundle.getString("CustomTreeModel.UserTransforms.txt");
        Tree mdRootTree = CustomTreeModel.getDISCustomTreeRootFolder(sRepositoryID, mdStore);
        AssociationList lTrees = mdRootTree.getSubTrees();
        for (Tree mdTree : lTrees) {
            if (!mdTree.getName().equals(sTreeName)) continue;
            return mdTree;
        }
        Tree mdTree = CustomTreeModel.addFolder(mdRootTree);
        mdTree.setName(sTreeName);
        mdTree.updateMetadataAll();
        return mdTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateCreatedObjects(AbstractListenerTreeModel.BasicObject[] aBasicObjects) {
        try {
            WsNodeFilter filter = this.getNodeFilter();
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "CustomTreeModel:updateCreatedObjects");
            try {
                this.populateStore(store, aBasicObjects);
                for (int iBasicObject = 0; iBasicObject < aBasicObjects.length; ++iBasicObject) {
                    WsTreeNode nodeParent;
                    ArrayList lParentNodes;
                    String sFQID = aBasicObjects[iBasicObject].getFQID();
                    Root mdo = (Root)store.getObject(sFQID);
                    String sParentFQID = this.getParentFQID(mdo);
                    if (sParentFQID == null || (lParentNodes = this.findNodes(sParentFQID)).isEmpty() || !(nodeParent = (WsTreeNode)lParentNodes.get(0)).hasExpanded() || filter != null && !filter.accept(mdo, nodeParent)) continue;
                    this.addChild(this.createNode(mdo, nodeParent), nodeParent);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected void updateCheckedInObjects(AbstractListenerTreeModel.BasicObject[] aBasicObjects) {
        this.updateChangedObjects(aBasicObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateChangedObjects(AbstractListenerTreeModel.BasicObject[] aBasicObjects) {
        try {
            WsNodeFilter filter = this.getNodeFilter();
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "CustomTreeModel:updateChangedObjects");
            try {
                this.populateStore(store, aBasicObjects);
                for (int iBasicObject = 0; iBasicObject < aBasicObjects.length; ++iBasicObject) {
                    WsTreeNode nodeOldParent;
                    ArrayList lParentNodes;
                    String sFQID = aBasicObjects[iBasicObject].getFQID();
                    Root mdo = (Root)store.getObject(sFQID);
                    ArrayList lNodes = this.findNodes(sFQID);
                    WsTreeNode node = lNodes.isEmpty() ? null : (WsTreeNode)lNodes.get(0);
                    String sParentFQID = this.getParentFQID(mdo);
                    WsTreeNode nodeNewParent = null;
                    if (sParentFQID != null && !(lParentNodes = this.findNodes(sParentFQID)).isEmpty()) {
                        nodeNewParent = (WsTreeNode)lParentNodes.get(0);
                    }
                    WsTreeNode wsTreeNode = nodeOldParent = node == null ? null : (WsTreeNode)node.getParent();
                    if (nodeNewParent != nodeOldParent) {
                        if (nodeOldParent != null) {
                            this.removeChild(node);
                        }
                        if (nodeNewParent == null || !nodeNewParent.hasExpanded() || filter != null && !filter.accept(mdo, nodeNewParent)) continue;
                        if (node == null) {
                            node = this.createNode(mdo, nodeNewParent);
                        } else {
                            node.updateMetadata((CMetadata)mdo);
                        }
                        this.addChild(node, nodeNewParent);
                        continue;
                    }
                    if (node == null) continue;
                    node.updateMetadata((CMetadata)mdo);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private WsTreeNode createNode(Root mdo, WsTreeNode nodeParent) throws MdException, RemoteException {
        if (!mdo.getCMetadataType().equals("Tree")) {
            return this.getNodeFactory().createObjectNode(mdo, nodeParent);
        }
        if (nodeParent.getFQID().startsWith("A0000001")) {
            return this.getNodeFactory().createRootFolderNode(mdo, nodeParent);
        }
        return this.getNodeFactory().createFolderNode(mdo, nodeParent);
    }

    private String getParentFQID(Root mdo) throws MdException, RemoteException {
        if (mdo.getCMetadataType().equals("Tree")) {
            Tree mdoParent = ((Tree)mdo).getParentTree();
            if (mdoParent != null) {
                return mdoParent.getFQID();
            }
            AssociationList lSofts = ((Tree)mdo).getSoftwareComponents();
            for (int iSoft = 0; iSoft < lSofts.size(); ++iSoft) {
                SoftwareComponent mdoSoft = (SoftwareComponent)lSofts.get(iSoft);
                if (!mdoSoft.getClassIdentifier().equals(SOFTWARE_COMPONENT_CLASS)) continue;
                return "A0000001." + mdoSoft.getRepositoryID();
            }
            return null;
        }
        AssociationList lTrees = mdo.getTrees();
        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
            Tree mdoTree = (Tree)lTrees.get(iTree);
            if (!mdoTree.getTreeType().equalsIgnoreCase(FOLDER_TYPE)) continue;
            return mdoTree.getFQID();
        }
        return null;
    }

    private void populateStore(MdObjectStore store, AbstractListenerTreeModel.BasicObject[] aBasicObjects) throws MdException, RemoteException {
        StringBuffer sbXML = new StringBuffer();
        String sTemplate = "<Templates><Tree TreeType=\"\"/></Templates>";
        int fFlags = 260;
        for (int iBasicObject = 0; iBasicObject < aBasicObjects.length; ++iBasicObject) {
            AbstractListenerTreeModel.BasicObject basic = aBasicObjects[iBasicObject];
            if (basic == null) continue;
            sbXML.append("<");
            sbXML.append(basic.getType());
            sbXML.append(" Id=\"");
            sbXML.append(basic.getFQID());
            sbXML.append("\" Name=\"\" ChangeState=\"\" LockedBy=\"\" PublicType=\"\" >");
            if (basic.getType().equals("Tree")) {
                sbXML.append("<ParentTree/><SoftwareComponents/>");
                sTemplate = "<Templates><Tree TreeType=\"\"/><SoftwareComponent ClassIdentifier=\"\"></SoftwareComponent></Templates>";
            } else {
                sbXML.append("<Trees/>");
            }
            sbXML.append("</");
            sbXML.append(basic.getType());
            sbXML.append(">");
        }
        Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)store, sbXML.toString(), sTemplate, fFlags);
    }
}

