/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class AbstractListenerTreeModel
extends WorkspaceTreeModel {
    public AbstractListenerTreeModel(WsTreeNode nodeRoot) {
        super(nodeRoot);
    }

    protected void addCreatedObjects(Map mapObjects) {
        BasicObject[] aBasicObjects = this.convertObjectsMapToBasicObjects(mapObjects);
        if (aBasicObjects == null) {
            return;
        }
        this.updateCreatedObjects(aBasicObjects);
    }

    protected void updateModifiedObjects(Map mapObjects) {
        BasicObject[] aBasicObjects = this.convertObjectsMapToBasicObjects(mapObjects);
        if (aBasicObjects == null) {
            return;
        }
        this.updateChangedObjects(aBasicObjects);
    }

    protected void removeDeletedObjects(String[] saFQIDs) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateDeletedObjects(saFQIDs);
        } else {
            SwingUtilities.invokeLater(new DeletedObjectsRunnable(saFQIDs));
        }
    }

    private BasicObject[] convertObjectsMapToBasicObjects(Map mapObjects) {
        try {
            Set setKeys = mapObjects.keySet();
            if (setKeys.size() == 0) {
                return null;
            }
            String[] saKeys = new String[setKeys.size()];
            setKeys.toArray(saKeys);
            String sRepository = Workspace.getWorkspace().getProjectRepositoryId();
            ArrayList<BasicObject> lObjects = new ArrayList<BasicObject>();
            for (int iKey = 0; iKey < saKeys.length; ++iKey) {
                String sFQID = saKeys[iKey];
                if (sRepository != null && sRepository.equals(sFQID.substring(0, 8))) continue;
                lObjects.add(new BasicObject(null, (String)mapObjects.get(sFQID), sFQID));
            }
            if (lObjects.isEmpty()) {
                return null;
            }
            BasicObject[] aObjects = new BasicObject[lObjects.size()];
            lObjects.toArray(aObjects);
            return aObjects;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void objectsCreated(MdEvent ev, List lFQIDs) {
        BasicObject[] aBasicObjects = this.convertFQIDsToBasicObjects(lFQIDs);
        if (aBasicObjects.length == 0) {
            return;
        }
        this.updateCreatedObjects(aBasicObjects);
    }

    public void objectsModified(MdEvent ev, List lFQIDs) {
        BasicObject[] aBasicObjects = this.convertFQIDsToBasicObjects(lFQIDs);
        if (aBasicObjects.length == 0) {
            return;
        }
        this.updateChangedObjects(aBasicObjects);
    }

    public void objectDeleted(MdEvent ev, String sFQID) {
        String[] saFQIDs = new String[]{sFQID};
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeDeletedObjects(saFQIDs);
        } else {
            SwingUtilities.invokeLater(new DeletedObjectsRunnable(saFQIDs));
        }
    }

    public void doObjectsCheckedOut(ArrayList lObjects) {
        BasicObject[] aBasicObjects = this.convertProjectObjectsToBasicObjects(lObjects);
        if (aBasicObjects.length == 0) {
            return;
        }
        this.updateObjectsChangedStates(aBasicObjects);
    }

    public void doObjectsFetched(ArrayList lObjects) {
    }

    public void objectsDestroyed(Vector vFQIDs) {
        if (vFQIDs.isEmpty()) {
            return;
        }
        String[] saFQIDs = new String[vFQIDs.size()];
        for (int iFQID = 0; iFQID < vFQIDs.size(); ++iFQID) {
            saFQIDs[iFQID] = (String)vFQIDs.get(iFQID);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeDeletedObjects(saFQIDs);
        } else {
            SwingUtilities.invokeLater(new DeletedObjectsRunnable(saFQIDs));
        }
    }

    public void objectsUndoCheckout(ArrayList lObjects) {
        BasicObject[] aBasicObjects = this.convertProjectObjectsToBasicObjects(lObjects);
        if (aBasicObjects.length == 0) {
            return;
        }
        this.updateObjectsChangedStates(aBasicObjects);
    }

    public void objectsClearProject(ArrayList lObjects) {
        BasicObject[] aBasicObjects = this.convertProjectObjectsToBasicObjects(lObjects);
        if (aBasicObjects.length == 0) {
            return;
        }
        this.updateObjectsChangedStates(aBasicObjects);
    }

    public void objectsCheckedIn(ArrayList lObjects) {
        BasicObject[] aBasicObjects = this.convertObjectsToBasicObjects(lObjects);
        if (aBasicObjects.length == 0) {
            return;
        }
        this.updateCheckedInObjects(aBasicObjects);
    }

    protected abstract void updateCreatedObjects(BasicObject[] var1);

    protected abstract void updateCheckedInObjects(BasicObject[] var1);

    protected abstract void updateChangedObjects(BasicObject[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateObjectsChangedStates(BasicObject[] aBasicObjects) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "AbstractListenerTreeModel:updateObjectsChangedStates");
            try {
                this.populateStoreForChangeStateUpdates(store, aBasicObjects);
                for (int iBasicObject = 0; iBasicObject < aBasicObjects.length; ++iBasicObject) {
                    String sFQID = aBasicObjects[iBasicObject].getFQID();
                    Root mdo = (Root)store.getObject(sFQID);
                    ArrayList lNodes = this.findNodes(sFQID);
                    for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
                        WsTreeNode node = (WsTreeNode)lNodes.get(iNode);
                        node.updateMetadata((CMetadata)mdo);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void updateDeletedObjects(String[] saFQIDs) {
        for (int iFQID = 0; iFQID < saFQIDs.length; ++iFQID) {
            ArrayList lNodes = this.findNodes(saFQIDs[iFQID]);
            for (int iNode = 0; iNode < lNodes.size(); ++iNode) {
                this.removeChild((WsTreeNode)lNodes.get(iNode));
            }
        }
    }

    private BasicObject[] convertFQIDsToBasicObjects(List lFQIDs) {
        try {
            String sRepository = Workspace.getWorkspace().getProjectRepositoryId();
            ArrayList<BasicObject> lBasicObjects = new ArrayList<BasicObject>(lFQIDs.size());
            for (int iFQID = 0; iFQID < lFQIDs.size(); ++iFQID) {
                Root mdo;
                String sFQID = (String)lFQIDs.get(iFQID);
                if (sRepository != null && sRepository.equals(sFQID.substring(0, 8)) || (mdo = (Root)Workspace.getMdFactory().getObject(sFQID)) == null) continue;
                lBasicObjects.add(new BasicObject(mdo.getName(), mdo.getCMetadataType(), sFQID));
            }
            BasicObject[] aBasicObjects = new BasicObject[lBasicObjects.size()];
            lBasicObjects.toArray(aBasicObjects);
            return aBasicObjects;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private BasicObject[] convertObjectsToBasicObjects(List lObjects) {
        try {
            BasicObject[] aBasicObjects = new BasicObject[lObjects.size()];
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                Root mdo = (Root)lObjects.get(iObject);
                aBasicObjects[iObject] = new BasicObject(mdo.getName(), mdo.getCMetadataType(), mdo.getFQID());
            }
            return aBasicObjects;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private BasicObject[] convertProjectObjectsToBasicObjects(List lProjectObjects) {
        try {
            ArrayList<BasicObject> lBasicObjects = new ArrayList<BasicObject>(lProjectObjects.size());
            for (int iProjectObject = 0; iProjectObject < lProjectObjects.size(); ++iProjectObject) {
                String sFQID;
                Root mdoProjectObject = (Root)lProjectObjects.get(iProjectObject);
                String sChangeState = mdoProjectObject.getChangeState();
                if (sChangeState.length() == 0) {
                    sFQID = mdoProjectObject.getFQID();
                } else {
                    int iColon;
                    if (sChangeState.startsWith("New") || (iColon = sChangeState.indexOf(58)) == -1 || iColon + 2 >= sChangeState.length()) continue;
                    sFQID = sChangeState.substring(iColon + 2);
                }
                lBasicObjects.add(new BasicObject(null, mdoProjectObject.getCMetadataType(), sFQID));
            }
            BasicObject[] aBasicObjects = new BasicObject[lBasicObjects.size()];
            lBasicObjects.toArray(aBasicObjects);
            return aBasicObjects;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    protected void populateStoreForChangeStateUpdates(MdObjectStore store, BasicObject[] aBasicObjects) throws MdException, RemoteException {
        StringBuffer sbXML = new StringBuffer();
        String sTemplate = "";
        int fFlags = 256;
        for (int iBasicObject = 0; iBasicObject < aBasicObjects.length; ++iBasicObject) {
            BasicObject basic = aBasicObjects[iBasicObject];
            if (basic == null) continue;
            sbXML.append("<");
            sbXML.append(basic.getType());
            sbXML.append(" Id=\"");
            sbXML.append(basic.m_sFQID);
            sbXML.append("\" Name=\"\" ChangeState=\"\" LockedBy = \"\" ");
            sbXML.append("></");
            sbXML.append(basic.getType());
            sbXML.append(">");
        }
        Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)store, sbXML.toString(), sTemplate, fFlags);
    }

    protected static final class BasicObject {
        private String m_sType;
        private String m_sFQID;
        private String m_sName;

        public BasicObject(String sName, String sType, String sFQID) {
            this.m_sType = sType;
            this.m_sFQID = sFQID;
        }

        public String getType() {
            return this.m_sType;
        }

        public String getFQID() {
            return this.m_sFQID;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(30);
            sb.append(this.m_sType);
            sb.append(":");
            sb.append(this.m_sName);
            sb.append(" (");
            sb.append(this.m_sFQID);
            sb.append(")");
            return sb.toString();
        }
    }

    private class DeletedObjectsRunnable
    implements Runnable {
        private String[] m_saFQIDs;

        public DeletedObjectsRunnable(String[] saFQIDs) {
            this.m_saFQIDs = saFQIDs;
        }

        @Override
        public void run() {
            AbstractListenerTreeModel.this.removeDeletedObjects(this.m_saFQIDs);
        }
    }
}

