/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MiningResultsTargetColumnsTableModel
extends TransformationTargetColumnsTableModel {
    private static final boolean g_bGotoServer = true;
    protected List m_lRequiredInputs;
    protected DataTable m_oRequiredInputTable;

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        this.m_lDataTables.clear();
        AssociationList alCMs = this.m_oTS.getTransformations();
        int nCMs = alCMs.size();
        for (int iCM = 0; iCM < nCMs; ++iCM) {
            ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
            AssociationList alFMs = oCM.getFeatureMaps();
            boolean bUsesQuotes = false;
            AssociationList alSources = oCM.getClassifierSources();
            int nSources = alSources.size();
            for (int iSource = 0; iSource < nSources; ++iSource) {
                DataTable oSource = (DataTable)alSources.get(iSource);
                if (!DBMSNamesPropertyHandler.needQuotes((DataTable)oSource)) continue;
                bUsesQuotes = true;
                break;
            }
            this.m_lRequiredInputs = new ArrayList();
            AssociationList alSourceSpecifications = oCM.getSourceSpecifications();
            int nMiningResults = alSourceSpecifications.size();
            for (int iMiningResult = 0; iMiningResult < nMiningResults; ++iMiningResult) {
                MiningResult oMiningResult;
                AssociationList alRequiredInputTables;
                Root oRoot = (Root)alSourceSpecifications.get(iMiningResult);
                if (!(oRoot instanceof MiningResult) || (alRequiredInputTables = (oMiningResult = (MiningResult)oRoot).getTransformationSources()).isEmpty()) continue;
                this.m_oRequiredInputTable = (DataTable)alRequiredInputTables.get(0);
                this.m_lRequiredInputs.add(this.m_oRequiredInputTable);
                if (this.m_lDataTables.contains(this.m_oRequiredInputTable)) continue;
                this.m_lDataTables.add(this.m_oRequiredInputTable);
                AssociationList alColumns = this.m_oRequiredInputTable.getColumns();
                int nColumns = alColumns.size();
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    Column oColumn = (Column)alColumns.get(iColumn);
                    String sName = MiningResultsTargetColumnsTableModel.getDataTableDisplayName(this.m_oRequiredInputTable);
                    FeatureMap oFM = this.findFeatureMapForColumn(alFMs, oColumn);
                    String sExpression = "";
                    int eMappingType = 0;
                    if (oFM != null) {
                        String sTransformRole = oFM.getTransformRole();
                        if (sTransformRole.equalsIgnoreCase("ONETOONE")) {
                            if (oFM.getFeatureSources().size() == 0) {
                                oFM = null;
                            } else {
                                eMappingType = 1;
                            }
                        } else if (sTransformRole.equalsIgnoreCase("Derived")) {
                            eMappingType = 2;
                            TextStore oExpression = (TextStore)oFM.getSourceCode();
                            if (oExpression != null) {
                                sExpression = ExpressionParser.detokenizeString((String)oExpression.getStoredText(), (AbstractTransformation)oFM, (boolean)bUsesQuotes);
                            }
                        } else if (sTransformRole.equalsIgnoreCase("MANYTOONE")) {
                            eMappingType = 3;
                        }
                    }
                    ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                    alRow.add(oColumn.getSASColumnName());
                    alRow.add(sExpression);
                    alRow.add(oColumn.getDesc());
                    alRow.add(sName);
                    alRow.add(this.m_oRequiredInputTable.getDesc());
                    alRow.add(new Boolean(false));
                    alRow.add(MiningResultsTargetColumnsTableModel.getViewMappingTypeString(eMappingType));
                    alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn));
                    alRow.add(new Integer(oColumn.getSASColumnLength()));
                    alRow.add(oColumn.getSASInformat());
                    alRow.add(oColumn.getSASFormat());
                    alRow.add(oColumn);
                    alRow.add(oFM);
                    this.m_lData.add(alRow);
                }
            }
        }
        int nDataTables = this.m_lDataTables.size();
        String[] saDataTables = new String[nDataTables];
        for (int iDataTable = 0; iDataTable < nDataTables; ++iDataTable) {
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(iDataTable);
            saDataTables[iDataTable] = MiningResultsTargetColumnsTableModel.getDataTableDisplayName(oDataTable);
        }
        WsEnumeratedTableColumn colTableName = (WsEnumeratedTableColumn)this.m_aColumns[3];
        if (saDataTables == null) {
            colTableName.setPossibleValues(saDataTables);
        }
        if (nDataTables > 0) {
            DataTable oDataTable = (DataTable)this.m_lDataTables.get(0);
            WsStringTableColumn colTableDescr = (WsStringTableColumn)this.m_aColumns[4];
            colTableDescr.setDefaultValue(oDataTable.getDesc());
        }
        if ((nRows = this.m_lData.size()) > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
    }

    public static String getDataTableDisplayName(DataTable oDataTable) {
        try {
            if (oDataTable instanceof RelationalTable) {
                return ((RelationalTable)oDataTable).getTableName();
            }
            return oDataTable.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }
}

