/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class DocumentTableModel
extends WATableModel {
    boolean[] baColumnsEditable = new boolean[]{true, true};
    private static WAdminResource bundle = WAdminResource.getBundle(DocumentTableModel.class);
    public static final int NAME_COL = 0;
    public static final int URL_COL = 1;
    public static final int DOC_COL = 2;
    static final int TOTAL_COLS = 3;
    private static final int MAX_NAME_GENERATION_ATTEMPTS = 4;

    public DocumentTableModel() {
        this.columnNames.add(bundle.getString("DocumentTableModel.Name.txt"));
        this.columnNames.add(bundle.getString("DocumentTableModel.Path.txt"));
        this.columnNames.add("Document");
    }

    public void populateData(Root oMetadata) {
        try {
            String sTemplate = "<Templates><Documents/></Templates>";
            Vector<String> vAssociations = new Vector<String>();
            vAssociations.add("Documents");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oMetadata, null, vAssociations, sTemplate, 12, true);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void populate(Root oMetadata) {
        try {
            AssociationList alDocuments = oMetadata.getDocuments();
            int nDocuments = alDocuments.size();
            for (int iDocument = 0; iDocument < nDocuments; ++iDocument) {
                Document oDocument = (Document)alDocuments.get(iDocument);
                ArrayList<String> alRow = new ArrayList<String>();
                alRow.add(oDocument.getName());
                alRow.add(oDocument.getURI());
                alRow.add((String)oDocument);
                this.data.add(alRow);
                ++this.instanceCount;
            }
            this.fireTableRowsInserted(0, this.data.size() - 1);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Document.class;
            }
        }
        return Object.class;
    }

    protected Object getDefaultObject(Class c, int col) {
        if (c == String.class) {
            if (col == 0) {
                String newName = WsMetadataNameUtil.getUniqueNameForType((String)"Document", (String)bundle.getString("Common.Untitled2.txt"));
                for (int attempts = 0; !this.validateName(newName, -1) && attempts < 4; ++attempts) {
                    newName = WsMetadataNameUtil.getUniqueNameForType((String)"Document", (String)bundle.getString("Common.Untitled2.txt"));
                }
                return newName;
            }
            return "";
        }
        if (c == Document.class) {
            return " ";
        }
        return super.getDefaultObject(c, col);
    }

    public boolean isCellEditable(int row, int col) {
        return this.baColumnsEditable[col];
    }

    public void setValueAt(Object a, int row, int col) {
        String c;
        this.undoableSet = true;
        this.resetPersistedUndo();
        if (col == 0 && (c = (String)a).trim().length() == 0) {
            return;
        }
        super.setValueAt(a, row, col);
    }

    public boolean validateName(String newName, int row) {
        ArrayList m = null;
        if (newName.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            m = (ArrayList)this.data.get(i);
            String name = (String)m.get(0);
            if (!name.equals(newName) || i == row) continue;
            return false;
        }
        return true;
    }

    public boolean insertRow(Document _doc) {
        try {
            ++this.instanceCount;
            ArrayList<String> m = new ArrayList<String>();
            m.add(_doc.getName());
            m.add(_doc.getURI());
            m.add((String)_doc);
            this.data.add(m);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public WAUndoable undoableInsertRow(Document _doc) {
        try {
            ++this.instanceCount;
            ArrayList<String> m = new ArrayList<String>();
            String n = _doc.getName();
            String u = _doc.getURI();
            if (n != null) {
                m.add(_doc.getName());
            } else {
                m.add(" ");
            }
            if (u != null) {
                m.add(_doc.getURI());
            } else {
                m.add(" ");
            }
            m.add((String)_doc);
            this.data.add(m);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            WATableModel.UndoableInsertRow dui = new WATableModel.UndoableInsertRow((WATableModel)this, m, this.data.size() - 1);
            return dui;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }
}

