/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.lineage;

import com.sas.dmv.relationship.ox.RelationshipWorkUnit;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.metadata.Util;
import com.sas.wadmin.lineage.JobLineage;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.omg.CORBA.StringHolder;

public class LineageExporterWorker {
    protected static WAdminResource bundle = new WAdminResource(LineageExporterWorker.class);
    private boolean m_isCanceled = false;
    private boolean m_isProcessing = false;
    private Thread m_threadOperation;
    private ArrayList<SimpleObject> m_failedObjects;
    private RelationshipWorkUnit m_workUnit;
    private JobLineage m_jobLineage;
    private static final int WEB_STATUS_OKAY = 200;
    private static final int WEB_STATUS_FORBIDDEN = 403;
    private static final int WEB_STATUS_FAIL = 500;
    private boolean m_bUseSecondURL = false;

    public LineageExporterWorker() {
        this.initRelationshipService();
    }

    private void initRelationshipService() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineageExporterWorker.this.m_workUnit = new RelationshipWorkUnit();
            }
        });
    }

    public boolean isCanceled() {
        return this.m_isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.m_isCanceled = isCanceled;
    }

    public boolean isProcessing() {
        return this.m_isProcessing;
    }

    private void setIsProcessing(boolean isProcessing) {
        this.m_isProcessing = isProcessing;
    }

    public ArrayList<SimpleObject> getFailedObjects() {
        return this.m_failedObjects;
    }

    public void getLineageFor(SimpleObject simpleObject, Date date) {
        try {
            this.m_jobLineage.getJobLineage(simpleObject, date);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)(bundle.getString("LineageExporterWorker.Errors.GetLineage.txt") + " " + simpleObject), (Throwable)e);
            this.m_failedObjects.add(simpleObject);
        }
        WorkspaceUtil.sleep((int)100);
    }

    public void doShowProgressBar(SimpleObject[] selectedObjects, Date selectedDate, JProgressBar progressBar, String outFilePath, boolean writeLocal, boolean pushToWeb, Runnable doRunComplete, String userName, String password) {
        final SimpleObject[] f_selectedObjects = selectedObjects;
        final Date f_selectedDate = selectedDate;
        final JProgressBar f_progressBar = progressBar;
        final String f_outFilePath = outFilePath;
        final boolean f_writeLocal = writeLocal;
        final boolean f_pushToWeb = pushToWeb;
        final String f_userName = userName;
        final String f_password = password;
        this.execute(new Runnable(){

            @Override
            public void run() {
                LineageExporterWorker.this.doRunReportGeneration(f_selectedObjects, f_selectedDate, f_progressBar, f_outFilePath, f_writeLocal, f_pushToWeb, f_userName, f_password);
            }
        }, doRunComplete);
    }

    public void doRunReportGeneration(SimpleObject[] selectedObjects, Date selectedDate, JProgressBar progressBar, String outFilePath, boolean writeLocal, boolean pushToWeb, String userName, String password) {
        Util.printLogln((String)"***** LineageExporterPanel.doRunJobGeneration(): starting");
        this.setIsProcessing(true);
        this.setCanceled(false);
        this.initializeWorkers();
        int totalJobs = selectedObjects.length;
        progressBar.setMaximum(totalJobs);
        progressBar.setIndeterminate(false);
        for (int i = 0; i < totalJobs; ++i) {
            if (!this.isCanceled()) {
                progressBar.setString(bundle.getString("LineageExporterWorker.ProcessingJob.txt") + " " + (i + 1) + " " + bundle.getString("LineageExporterWorker.ProcessingJob.Of.txt") + " " + totalJobs + ": " + selectedObjects[i].getName());
                progressBar.setValue(i);
                if (totalJobs == 1) {
                    progressBar.setIndeterminate(true);
                }
            } else {
                progressBar.setIndeterminate(false);
                progressBar.setString(bundle.getString("LineageExporterWorker.Canceled.txt"));
                progressBar.setValue(0);
                this.setIsProcessing(false);
                return;
            }
            this.getLineageFor(selectedObjects[i], selectedDate);
        }
        String serializedLineage = this.getSerializedLineage();
        try {
            if (writeLocal) {
                this.writeLocalFile(outFilePath, serializedLineage, pushToWeb);
            } else {
                this.writeRemoteFile(outFilePath, serializedLineage, pushToWeb);
            }
        }
        catch (Exception e) {
            this.setIsProcessing(false);
            progressBar.setIndeterminate(false);
            progressBar.setString(bundle.getString("LineageExporterWorker.Failed.txt"));
            Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.FileWriteError.txt"), (Throwable)e);
            return;
        }
        if (pushToWeb) {
            progressBar.setString(bundle.getString("LineageExporterWorker.ExportingToWeb.txt"));
            String baseURL = this.m_bUseSecondURL ? Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("Workspace.ImpactAnalysisUploadURL") : Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("Workspace.ImpactAnalysisURL");
            int statusCode = this.pushFileToWebService(this.getCompressedFileName(outFilePath), writeLocal, userName, password, baseURL);
            if (statusCode == 500) {
                this.setIsProcessing(false);
                progressBar.setIndeterminate(false);
                progressBar.setString(bundle.getString("LineageExporterWorker.WebTransferFailed.txt"));
                Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.PushToWeb.txt"));
                return;
            }
            if (statusCode == 403) {
                this.setIsProcessing(false);
                progressBar.setIndeterminate(false);
                progressBar.setString(bundle.getString("LineageExporterWorker.InvalidCredentials.txt"));
                Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.InvalidCredentials.txt"));
                return;
            }
            if (statusCode != 200) {
                this.setIsProcessing(false);
                progressBar.setIndeterminate(false);
                progressBar.setString(bundle.getString("LineageExporterWorker.Failed.txt"));
                Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.Unknown.txt"));
                return;
            }
        }
        progressBar.setIndeterminate(false);
        progressBar.setString(bundle.getString("LineageExporterWorker.Complete.txt"));
        progressBar.setValue(totalJobs);
        this.setIsProcessing(false);
        Util.printLogln((String)"***** LineageExporterPanel.doRunJobGeneration(): closing");
    }

    public String getSerializedLineage() {
        return this.m_workUnit.serializeWorkUnit();
    }

    public void initializeWorkers() {
        this.m_failedObjects = new ArrayList();
        try {
            for (int i = 0; this.m_workUnit == null && i <= 10; ++i) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.ThreadInterrupted.txt"));
        }
        if (this.m_workUnit == null) {
            throw new NullPointerException();
        }
        this.m_workUnit.clear();
        this.m_jobLineage = new JobLineage(this.m_workUnit);
    }

    public void execute(Runnable runOperation) {
        this.execute(runOperation, null);
    }

    public void execute(Runnable runOperation, Runnable runCompletionNotification) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_threadOperation = this.createOperationThread(runOperation, runCompletionNotification);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LineageExporterWorker.this.m_threadOperation.start();
                }
            });
        }
        finally {
            Workspace.getWorkspace().clearStatusText();
            Workspace.getWorkspace().setCursor(null);
        }
    }

    protected Thread createOperationThread(Runnable runOperation, Runnable runCompletionNotification) {
        return new cOperationThread(runOperation, runCompletionNotification);
    }

    private void compressStream(String contents, ByteArrayOutputStream baos) throws IOException, FileNotFoundException {
        GZIPOutputStream out = new GZIPOutputStream(baos);
        byte[] contentBytes = contents.getBytes("UTF-8");
        out.write(contentBytes, 0, contentBytes.length);
        out.close();
    }

    public String getCompressedFileName(String outFilePath) {
        int extensionStart = outFilePath.lastIndexOf(".") == -1 ? outFilePath.length() : outFilePath.lastIndexOf(".");
        String compressedFileName = outFilePath.substring(0, extensionStart) + ".gz";
        return compressedFileName;
    }

    public String getParentPath(String filePath) {
        if (filePath.contains("\\")) {
            return filePath.substring(0, filePath.lastIndexOf("\\") + 1);
        }
        if (filePath.contains("/")) {
            return filePath.substring(0, filePath.lastIndexOf("/") + 1);
        }
        return null;
    }

    public String getFileName(String filePath) {
        if (filePath.contains("\\")) {
            return filePath.substring(filePath.lastIndexOf("\\") + 1);
        }
        if (filePath.contains("/")) {
            return filePath.substring(filePath.lastIndexOf("/") + 1);
        }
        return filePath;
    }

    private String addExtensionIfMissing(String filePath) {
        if (!filePath.endsWith(".xml") && !filePath.endsWith(".XML")) {
            filePath = filePath + ".xml";
        }
        return filePath;
    }

    public void writeLocalFile(String outFilePath, String contents, boolean writeCompressedFile) throws IOException {
        File myDocsFolder;
        String parentPath = this.getParentPath(outFilePath = this.addExtensionIfMissing(outFilePath));
        if (!new File(parentPath).exists()) {
            Workspace.getDefaultLogger().error((Object)("The folder: " + parentPath + " does not exist"));
        }
        if ((parentPath == null || !new File(parentPath).exists()) && System.getProperty("os.name").contains("Windows") && (myDocsFolder = new JFileChooser().getFileSystemView().getDefaultDirectory()) != null) {
            outFilePath = myDocsFolder.getAbsolutePath() + "\\" + this.getFileName(outFilePath);
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFilePath), "UTF-8"));
        bw.write(contents);
        bw.close();
        if (writeCompressedFile) {
            String compressedFileName = this.getCompressedFileName(outFilePath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.compressStream(contents, baos);
            FileOutputStream fos = new FileOutputStream(compressedFileName);
            fos.write(baos.toByteArray());
            fos.close();
        }
    }

    public void writeRemoteFile(String outFilePath, String contents, boolean writeCompressedFile) throws GenericError, WsAppServerFailException, IOException {
        WsAppServer appServer = WsAppServer.createDefaultAppServer();
        if (appServer == null) {
            Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.NoAppServerDefined.UnableToWrite.txt"));
            return;
        }
        outFilePath = this.addExtensionIfMissing(outFilePath);
        String parentPath = this.getParentPath(outFilePath);
        if (!appServer.doesFileExist(appServer.getParentDirectory(outFilePath))) {
            Workspace.getDefaultLogger().error((Object)("The folder: " + parentPath + " does not exist"));
        }
        appServer.writeBinaryFile(contents.getBytes("UTF-8"), outFilePath, "");
        if (writeCompressedFile) {
            String compressedFileName = this.getCompressedFileName(outFilePath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.compressStream(contents, baos);
            appServer.writeBinaryFile(baos.toByteArray(), compressedFileName, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readRemoteFileFromAppServer(String filePath) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String encoding;
            WsAppServer appServer = WsAppServer.createDefaultAppServer();
            if (appServer == null) {
                Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.NoAppServerDefined.UnableToRead.txt"));
                return null;
            }
            if (!appServer.isOpen()) {
                appServer.open();
            }
            String options = !(encoding = "").equals("") ? "encoding=" + encoding : "";
            IWorkspace workspace = appServer.getWorkspace();
            IFileService fileService = workspace.FileService();
            IFileref fileRef = fileService.AssignFileref("TempRef", "DISK", filePath, options, new StringHolder());
            IBinaryStream binaryStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
            OctetSeqHolder binaryData = new OctetSeqHolder();
            try {
                binaryStream.Read(1024, binaryData);
                while (binaryData.value.length > 0) {
                    out.write(binaryData.value);
                    binaryStream.Read(1024, binaryData);
                }
            }
            finally {
                out.flush();
                out.close();
                try {
                    binaryStream.Close();
                }
                catch (GenericError genericError) {}
                appServer.close();
            }
        }
        catch (IOException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (GenericError e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (WsAppServerFailException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return out.toByteArray();
    }

    public int pushFileToWebService(String filePath, boolean localFile, String username, String password, String baseURL) {
        String encodedUsername = new String(Base64.encodeBase64((byte[])username.getBytes()));
        String encodedPassword = new String(Base64.encodeBase64((byte[])password.getBytes()));
        String completeURL = this.m_bUseSecondURL ? baseURL : baseURL + "/webstudio/lineage/";
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(completeURL);
        InputStream inStream = null;
        try {
            if (localFile) {
                inStream = new FileInputStream(filePath);
            } else {
                WsAppServer appServer = WsAppServer.createDefaultAppServer();
                if (appServer == null) {
                    Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.NoAppServerDefined.UnableToRead.txt"));
                    return 500;
                }
                byte[] contents = this.readRemoteFileFromAppServer(filePath);
                inStream = new ByteArrayInputStream(contents);
            }
        }
        catch (FileNotFoundException e) {
            Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.InvalidFile.txt"), (Throwable)e);
        }
        MultipartEntity reqEntity = new MultipartEntity();
        InputStreamBody attachmentBody = new InputStreamBody(inStream, "application/x-gzip", filePath);
        reqEntity.addPart("data", (ContentBody)attachmentBody);
        try {
            reqEntity.addPart("username", (ContentBody)new StringBody(encodedUsername));
            reqEntity.addPart("password", (ContentBody)new StringBody(encodedPassword));
            reqEntity.addPart("iszipped", (ContentBody)new StringBody(Base64.encodeBase64String((byte[])"1".getBytes())));
        }
        catch (UnsupportedEncodingException e) {
            Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.FormPartCreation.txt"), (Throwable)e);
        }
        httppost.setEntity((HttpEntity)reqEntity);
        int statusCode = 500;
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity responseEntity = response.getEntity();
            statusCode = response.getStatusLine().getStatusCode();
            StringBuilder responseContentBuilder = new StringBuilder();
            InputStream responseStream = responseEntity.getContent();
            int responseBytesRead = 0;
            byte[] responseBuffer = new byte[8192];
            do {
                if ((responseBytesRead = responseStream.read(responseBuffer)) <= 0) continue;
                byte[] newArray = new byte[responseBytesRead];
                System.arraycopy(responseBuffer, 0, newArray, 0, responseBytesRead);
                responseContentBuilder.append(new String(newArray));
            } while (responseBytesRead >= 0);
            Workspace.getDefaultLogger().info((Object)statusCode, "Response (" + statusCode + "): " + responseContentBuilder.toString());
        }
        catch (ClientProtocolException e) {
            Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.UploadToWeb.txt"), (Throwable)e);
        }
        catch (IOException e) {
            Workspace.getDefaultLogger().error((Object)bundle.getString("LineageExporterWorker.Errors.UploadToWeb.txt"), (Throwable)e);
        }
        return statusCode;
    }

    public void setUseSecondURL(boolean bUseSecondURL) {
        this.m_bUseSecondURL = bUseSecondURL;
    }

    protected class cOperationThread
    extends Thread {
        protected Runnable m_runOperation;
        protected Runnable m_runCompletionNotification;

        public cOperationThread(Runnable runOperation, Runnable runCompletionNotification) {
            super("BackgroundOperation");
            this.m_runOperation = runOperation;
            this.m_runCompletionNotification = runCompletionNotification;
            this.setPriority(5);
        }

        @Override
        public void run() {
            this.m_runOperation.run();
            if (this.m_runCompletionNotification != null) {
                SwingUtilities.invokeLater(this.m_runCompletionNotification);
            }
        }
    }
}

