/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.jobeditor.runtimedetails.StatisticsLineChartPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StatisticsSelectionPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(StatisticsSelectionPanel.class);
    private JPanel m_stats;
    private JButton m_ckbAll;
    private JCheckBox m_ckbRecords;
    private JCheckBox m_ckbReal;
    private JCheckBox m_ckbSystem;
    private JCheckBox m_ckbMemory;
    private JCheckBox m_ckbIO;
    private JCheckBox m_ckbMemory2;
    private JCheckBox m_ckbIO2;
    private boolean m_lastRecords = true;
    private boolean m_lastReal = true;
    private boolean m_lastSystem = true;
    private boolean m_lastMemory = true;
    private boolean m_lastIO = true;
    private boolean m_lastMemory2 = true;
    private boolean m_lastIO2 = true;
    private StatisticsLineChartPanel.cSelectionListener m_selectionListener;

    public StatisticsSelectionPanel() {
        this.initialize();
        this.layoutWidgets();
    }

    public void moveDataToStore() {
        cSelectionEvent ev = new cSelectionEvent("SelectionApplied");
        this.m_selectionListener.selectionEventHappened(ev, this.isRecordsSelected(), this.isRealSelected(), this.isSystemSelected(), this.isMemorySelected(), this.isMemory2Selected(), this.isIOSelected(), this.isIO2Selected());
        this.setDataChanged(false);
    }

    public void initialize() {
        this.m_stats = new JPanel();
        this.m_ckbRecords = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"StatisticsTab.Select.Records");
        this.m_ckbRecords.setBackground(Color.white);
        this.m_ckbRecords.setSelected(true);
        this.m_ckbReal = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"StatisticsTab.Select.Real");
        this.m_ckbReal.setBackground(Color.white);
        this.m_ckbReal.setSelected(true);
        this.m_ckbSystem = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"StatisticsTab.Select.System");
        this.m_ckbSystem.setBackground(Color.white);
        this.m_ckbSystem.setSelected(true);
        this.m_ckbMemory = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"StatisticsTab.Select.Memory");
        this.m_ckbMemory.setBackground(Color.white);
        this.m_ckbMemory.setSelected(true);
        this.m_ckbIO = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"StatisticsTab.Select.IO");
        this.m_ckbIO.setBackground(Color.white);
        this.m_ckbIO.setSelected(true);
        this.m_ckbMemory2 = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"StatisticsTab.Select.Memory2");
        this.m_ckbMemory2.setBackground(Color.white);
        this.m_ckbMemory2.setSelected(true);
        this.m_ckbIO2 = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"StatisticsTab.Select.IO2");
        this.m_ckbIO2.setSelected(true);
        this.m_ckbIO2.setBackground(Color.white);
        this.listenForDataChangesTo(this.m_ckbRecords);
        this.listenForDataChangesTo(this.m_ckbReal);
        this.listenForDataChangesTo(this.m_ckbSystem);
        this.listenForDataChangesTo(this.m_ckbMemory);
        this.listenForDataChangesTo(this.m_ckbIO);
        this.listenForDataChangesTo(this.m_ckbMemory2);
        this.listenForDataChangesTo(this.m_ckbIO2);
        this.m_ckbAll = WsUIUtilities.createTextButton((WsAbstractAction)new cSelectAllAction());
        this.m_ckbAll.setText(bundle.getString("StatisticsTab.Select.All.txt"));
        this.m_ckbAll.setToolTipText(bundle.getString("StatisticsTab.Select.All.tip"));
        this.m_ckbAll.setMnemonic(bundle.getString("StatisticsTab.Select.All.mnem").charAt(0));
    }

    public void moveDataToView() throws RemoteException, MdException {
        super.moveDataToView();
        this.m_ckbRecords.setSelected(this.m_lastRecords);
        this.m_ckbReal.setSelected(this.m_lastReal);
        this.m_ckbSystem.setSelected(this.m_lastSystem);
        this.m_ckbMemory.setSelected(this.m_lastMemory);
        this.m_ckbIO.setSelected(this.m_lastIO);
        this.m_ckbMemory2.setSelected(this.m_lastMemory2);
        this.m_ckbIO2.setSelected(this.m_lastIO2);
    }

    public void onParentCancel() {
        this.setDataChanged(false);
    }

    public void layoutWidgets() {
        this.m_stats.setLayout(new GridBagLayout());
        this.m_stats.setBackground(Color.white);
        Border grayLine = BorderFactory.createLineBorder(Color.lightGray);
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        this.setBackground(Color.white);
        this.setBorder(grayLine);
        this.m_stats.add((Component)this.m_ckbRecords, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_stats.add((Component)this.m_ckbReal, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_stats.add((Component)this.m_ckbSystem, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_stats.add((Component)this.m_ckbMemory, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_stats.add((Component)this.m_ckbMemory2, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_stats.add((Component)this.m_ckbIO, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_stats.add((Component)this.m_ckbIO2, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.setBorder(blackLine);
        this.add(this.m_ckbAll, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_stats, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
    }

    public boolean validateData() {
        if (!this.isAtLeastOneStatisticSelected()) {
            MessageUtil.displayMessage((String)bundle.getString("StatisticsSelectionPanel.OneStatistic.txt"));
            return false;
        }
        this.m_lastRecords = this.m_ckbRecords.isSelected();
        this.m_lastReal = this.m_ckbReal.isSelected();
        this.m_lastSystem = this.m_ckbSystem.isSelected();
        this.m_lastMemory = this.m_ckbMemory.isSelected();
        this.m_lastIO = this.m_ckbIO.isSelected();
        this.m_lastMemory2 = this.m_ckbMemory2.isSelected();
        this.m_lastIO2 = this.m_ckbIO2.isSelected();
        return true;
    }

    public void setSelectionListener(StatisticsLineChartPanel.cSelectionListener selectionListener) {
        this.m_selectionListener = selectionListener;
    }

    public boolean isRecordsSelected() {
        return this.m_ckbRecords.isSelected();
    }

    public boolean isRealSelected() {
        return this.m_ckbReal.isSelected();
    }

    public boolean isSystemSelected() {
        return this.m_ckbSystem.isSelected();
    }

    public boolean isMemorySelected() {
        return this.m_ckbMemory.isSelected();
    }

    public boolean isMemory2Selected() {
        return this.m_ckbMemory2.isSelected();
    }

    public boolean isIOSelected() {
        return this.m_ckbIO.isSelected();
    }

    public boolean isIO2Selected() {
        return this.m_ckbIO2.isSelected();
    }

    public boolean isAtLeastOneStatisticSelected() {
        return this.isRecordsSelected() || this.isRealSelected() || this.isSystemSelected() || this.isMemorySelected() || this.isIOSelected() || this.isMemory2Selected() || this.isIO2Selected();
    }

    public void resetSelections() {
        this.m_lastRecords = true;
        this.m_lastReal = true;
        this.m_lastSystem = true;
        this.m_lastMemory = true;
        this.m_lastIO = true;
        this.m_lastMemory2 = true;
        this.m_lastIO2 = true;
    }

    public class cSelectionEvent
    extends EventObject {
        private String m_sType;
        public static final String SELECTION_APPLIED = "SelectionApplied";

        public cSelectionEvent(String sType) {
            super(sType);
            this.m_sType = sType;
        }

        public String getType() {
            return this.m_sType;
        }
    }

    private class cSelectAllAction
    extends WsAbstractAction {
        public void actionPerformed(ActionEvent event) {
            StatisticsSelectionPanel.this.m_ckbRecords.setSelected(true);
            StatisticsSelectionPanel.this.m_ckbReal.setSelected(true);
            StatisticsSelectionPanel.this.m_ckbSystem.setSelected(true);
            StatisticsSelectionPanel.this.m_ckbMemory.setSelected(true);
            StatisticsSelectionPanel.this.m_ckbIO.setSelected(true);
            StatisticsSelectionPanel.this.m_ckbMemory2.setSelected(true);
            StatisticsSelectionPanel.this.m_ckbIO2.setSelected(true);
        }
    }
}

