/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.runtimedetails;

import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AnalysisVariableList;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.DataElementColors;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.barchart.BarChart;
import com.sas.graphics.components.barchart.BarChartDataModel;
import com.sas.graphics.components.barchart.BarChartTableDataModel;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class StatisticsBarChartPanel
extends JPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(StatisticsBarChartPanel.class);
    private BarChart m_barChart;
    private boolean m_barCreated;
    private TableModel m_perfDataModel;
    private BarChartTableDataModel m_dataModel;
    private static String m_selectedNode;
    private Object m_selection;
    private int m_selectionIndex;
    private TableModel m_subsettedTableModel;

    public StatisticsBarChartPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.m_barChart = new BarChart();
        this.m_barChart.getGraphModel().setOrientation(0);
        this.m_barChart.getGraphModel().getLegendModel().setVisible(false);
        this.m_barChart.getGraphModel().setStackBarPolicy(10201);
        this.m_barChart.getGraphModel().getDataElementStyles().getFillStyles()[0].setVisible(false);
        this.m_barChart.getGraphModel().setOutsideBarLabelContent(10200);
        this.m_barChart.setPreferredSize(new Dimension(20, 0));
        this.m_dataModel = new BarChartTableDataModel();
        this.buildChart();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_barChart, "Center");
    }

    public void setGraphModel(TableModel model) {
        this.m_perfDataModel = model;
    }

    public void resetModel() {
        this.m_dataModel.setModel(this.m_perfDataModel);
        this.m_selection = null;
    }

    public void moveDataToView() {
        if (this.m_selection != null) {
            this.moveDataToView(this.m_selectionIndex, this.m_selection);
        } else {
            this.moveDataToView(0, null);
        }
    }

    public void moveDataToView(int index, Object obj) {
        if (index <= 0) {
            this.m_dataModel.setModel(this.m_perfDataModel);
            if (this.m_perfDataModel != null && this.m_perfDataModel.getRowCount() > 0) {
                Double maxStop = (Double)this.m_perfDataModel.getValueAt(0, 13);
                this.m_barChart.getGraphModel().getResponseAxisModel().setMinimum(0.0);
                this.m_barChart.getGraphModel().getResponseAxisModel().setMaximum(maxStop.doubleValue());
            }
            m_selectedNode = "";
            this.m_selection = null;
        } else {
            this.m_selectionIndex = index;
            this.m_selection = obj;
            String selection = (String)this.m_selection;
            String newSelectedNode = selection.trim();
            if (!newSelectedNode.equals(m_selectedNode)) {
                m_selectedNode = newSelectedNode;
                this.m_subsettedTableModel = null;
                this.m_subsettedTableModel = new SubsetData(this.m_perfDataModel);
                this.m_dataModel.setModel(this.m_subsettedTableModel);
                double maxDuration = 0.0;
                double maxStart = 0.0;
                for (int i = 0; i < this.m_subsettedTableModel.getRowCount(); ++i) {
                    Double dvalue = (Double)this.m_subsettedTableModel.getValueAt(i, 2);
                    Double svalue = (Double)this.m_subsettedTableModel.getValueAt(i, 0);
                    if (dvalue > maxDuration) {
                        maxDuration = dvalue;
                    }
                    if (!(svalue > maxStart)) continue;
                    maxStart = svalue;
                }
                Double maxStop = (Double)this.m_perfDataModel.getValueAt(0, 13);
                double hmin = maxStop;
                for (int i = 0; i < this.m_subsettedTableModel.getRowCount(); ++i) {
                    Double dMinValue = (Double)this.m_subsettedTableModel.getValueAt(i, 0);
                    if (!(dMinValue < hmin)) continue;
                    hmin = dMinValue;
                }
                this.m_barChart.getGraphModel().getResponseAxisModel().setMinimum(hmin);
                this.m_barChart.getGraphModel().getResponseAxisModel().setMaximum(maxDuration + maxStart);
            }
        }
    }

    public void buildChart() {
        String durationFormat = "12.3";
        String startFormat = "nldatmap18.2";
        AnalysisVariable a2 = new AnalysisVariable("aStart", startFormat, null, bundle.getString("StatisticsBarChartPanel.StartTime.label.txt"), 10506);
        AnalysisVariable a3 = new AnalysisVariable("Transid", null, null, bundle.getString("StatisticsBarChartPanel.TransformationId.label.txt"), 10506);
        this.m_dataModel.setDataTipVariable(new Variable[]{a2, a3});
        ClassificationVariable cTask = new ClassificationVariable("Task", null, null, bundle.getString("StatisticsBarChartPanel.NodeName.label.txt"), 10400);
        AnalysisVariable r1 = new AnalysisVariable("Start", durationFormat, null, bundle.getString("StatisticsBarChartPanel.RelativeStartTime.label.txt"), 10506);
        AnalysisVariable r2 = new AnalysisVariable("Duration", durationFormat, null, bundle.getString("StatisticsBarChartPanel.Duration.label.txt"), 10506);
        AnalysisVariableList blength = new AnalysisVariableList(new AnalysisVariable[]{r1, r2});
        this.m_dataModel.setCategoryVariable(cTask);
        this.m_dataModel.setResponseVariable((AnalysisVariable)blength);
        this.m_barChart.getGraphModel().getLegendModel().setVisible(false);
        this.m_barChart.getGraphModel().setStackBarPolicy(10201);
        this.m_barChart.getGraphModel().getDataElementStyles().getFillStyles()[0].setVisible(false);
        this.m_barChart.setDisplayPolicy(10002);
        this.m_barChart.getGraphModel().setOutsideBarLabelContent(10200);
        this.m_barChart.getGraphModel().setOrientation(0);
        this.m_barChart.getGraphModel().getResponseAxisModel().setLabel(bundle.getString("StatisticsBarChartPanel.Time.label.txt"));
        this.m_barChart.getGraphModel().getResponseAxisModel().setLabelPlacementPolicy(11306);
        this.m_barChart.getGraphModel().getResponseAxisModel().setFormat(durationFormat);
        this.m_barChart.getTitle1().setText(bundle.getString("StatisticsBarChartPanel.ProcessDuration.label.txt"));
        this.m_barChart.setDataModel((BarChartDataModel)this.m_dataModel);
        ColorScheme colorScheme = new ColorScheme(101012);
        DataElementColors dec = colorScheme.getDataElementColors();
        Color[] colors = dec.getDiscreteFillColors();
        Color thirdColor = colors[0];
        this.m_barChart.getGraphModel().getDataElementStyles().getFillStyles()[1].setSolidFillColor(thirdColor);
        this.m_barCreated = true;
    }

    public boolean isBarChartCreated() {
        return this.m_barCreated;
    }

    public BarChart getBarChart() {
        return this.m_barChart;
    }

    private static class SubsetData
    extends DefaultTableModel {
        private Class[] columnClass = new Class[]{Double.class, String.class, Double.class, String.class, String.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};
        private String[] columnNames = new String[]{"Start", "aStart", "Duration", "Task", "Transid", "records", "real", "cpu", "memory", "memory2", "io", "io2", "lstart", "hstop"};

        public SubsetData(TableModel tableModel) {
            this.setColumnIdentifiers(this.columnNames);
            Vector<Object> dVector = null;
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                String tVal = (String)tableModel.getValueAt(i, 3);
                if (!tVal.trim().equals(m_selectedNode)) continue;
                dVector = new Vector<Object>();
                int colCount = tableModel.getColumnCount();
                for (int j = 0; j < colCount; ++j) {
                    dVector.add(tableModel.getValueAt(i, j));
                }
                this.addRow(dVector);
            }
        }

        public Class getColumnClass(int column) {
            return this.columnClass[column];
        }
    }
}

