/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataLink;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.BaseLink;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DataLink
extends BaseLink
implements IDataLink {
    private int m_iNumberOfRows;
    private int m_iStartingRow;

    public DataLink() {
    }

    public DataLink(PFDPort from, PFDPort to, boolean bDoValidation) {
        super(from, to, false, bDoValidation);
    }

    public DataLink(PFDPort from, PFDPort to) {
        super(from, to, false);
    }

    protected DataLink(List lAttributes, List lValues) {
        super(null, null, false, false);
        for (int i = 0; i < lAttributes.size(); ++i) {
            StringTokenizer sTok;
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.setId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("ToNode")) {
                this.setToNodeId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("FromNode")) {
                this.setFromNodeId(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("ToPortIndex")) {
                this.setToNodePortIndex(Integer.parseInt(sValue));
                continue;
            }
            if (sAttribute.equalsIgnoreCase("FromPortIndex")) {
                this.setFromNodePortIndex(Integer.parseInt(sValue));
                continue;
            }
            if (sAttribute.equalsIgnoreCase("Positions")) {
                sTok = new StringTokenizer(sValue, ",");
                this.setCustomBreakPointsUsed(true);
                while (sTok.hasMoreTokens()) {
                    Point point = new Point();
                    point.x = Integer.parseInt(sTok.nextToken());
                    if (!sTok.hasMoreTokens()) continue;
                    point.y = Integer.parseInt(sTok.nextToken());
                    this.addBreakPoint(point);
                }
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("CollapsedPositions")) continue;
            sTok = new StringTokenizer(sValue, ",");
            ArrayList<Point> collapsedPts = new ArrayList<Point>();
            while (sTok.hasMoreTokens()) {
                Point point = new Point();
                point.x = Integer.parseInt(sTok.nextToken());
                if (!sTok.hasMoreTokens()) continue;
                point.y = Integer.parseInt(sTok.nextToken());
                collapsedPts.add(point);
            }
            this.setCollapsedBreakPoints(collapsedPts.toArray(new Point[collapsedPts.size()]));
        }
    }

    public int getNumberOfRows() {
        return this.m_iNumberOfRows;
    }

    public int getStartingRow() {
        return this.m_iStartingRow;
    }

    public void setNumberOfRows(int iNumberOfRows) {
        this.m_iNumberOfRows = iNumberOfRows;
    }

    public void setStartingRow(int iStartingRow) {
        this.m_iStartingRow = iStartingRow;
    }

    @Override
    public String writeToXML(IDesignTimeModel designModel) {
        Point[] collapsedPts;
        StringBuffer outXML = new StringBuffer();
        outXML.append("<DataLink>");
        outXML.append("<NodeId>");
        outXML.append(this.getId());
        outXML.append("</NodeId>");
        outXML.append("<ToNode>");
        outXML.append(this.getToNodeId());
        outXML.append("</ToNode>");
        outXML.append("<FromNode>");
        outXML.append(this.getFromNodeId());
        outXML.append("</FromNode>");
        outXML.append("<ToPortIndex>");
        outXML.append(String.valueOf(this.getToNodePortIndex(this.getToPort())));
        outXML.append("</ToPortIndex>");
        outXML.append("<FromPortIndex>");
        outXML.append(String.valueOf(this.getFromNodePortIndex(this.getFromPort())));
        outXML.append("</FromPortIndex>");
        Point[] pts = this.getBreakPoints();
        if (pts.length > 0) {
            outXML.append("<Positions>");
            for (int iPoint = 0; iPoint < pts.length; ++iPoint) {
                outXML.append(String.valueOf(pts[iPoint].x));
                outXML.append(",");
                outXML.append(String.valueOf(pts[iPoint].y));
                outXML.append(",");
            }
            outXML.append("</Positions>");
        }
        if ((collapsedPts = this.getCollapsedBreakPoints()).length > 0) {
            outXML.append("<CollapsedPositions>");
            for (int iPoint = 0; iPoint < collapsedPts.length; ++iPoint) {
                outXML.append(String.valueOf(collapsedPts[iPoint].x));
                outXML.append(",");
                outXML.append(String.valueOf(collapsedPts[iPoint].y));
                outXML.append(",");
            }
            outXML.append("</CollapsedPositions>");
        }
        outXML.append("</DataLink>");
        return outXML.toString();
    }
}

