/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.IUIPlacement;
import com.sas.graphics.components.pfd.PFDAbstractButton;
import com.sas.graphics.components.pfd.PFDButton;
import com.sas.graphics.components.pfd.PFDButtonGroup;
import com.sas.graphics.components.pfd.PFDDiamondControlNode;
import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollection;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IControlTransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.ITransformNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IAdapterNode;
import com.sas.wadmin.jobeditor.diagram.shapes.ITransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.AdapterNode;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class ControlTransformNode
extends PFDDiamondControlNode
implements ITransformNode,
WsPFDPrimitive {
    private static final WAdminResource bundle = WAdminResource.getBundle(ControlTransformNode.class);
    private IAdapterNode m_adapterNode;
    private int m_eValidateStatus;
    private String[] m_eValidateStatusMessages;
    private int m_eRunStatus;
    private String[] m_eRunStatusMessages;
    private int m_eMode;
    private String m_sId;
    private int m_xPosition;
    private int m_yPosition;
    private boolean m_bActive;
    private boolean m_bCleanUpRequired;
    protected static final Dimension noteOffset = new Dimension(-9, -9);
    protected static final Dimension statusDetailsOffset = new Dimension(-12, -12);
    private List m_lIndicatorButtons;
    protected PFDButtonGroup buttonGroup;
    protected PFDButton noteButton;

    public ControlTransformNode(IControlTransformNodeAdapter adapter) {
        this.m_adapterNode = new AdapterNode(adapter, this);
        if (this.getUIPlacement().getNodeId() != null) {
            this.setForceShowPorts(!this.getUIPlacement().getCollapsed());
            this.setSpotLocation(1, new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition()));
            this.refresh();
        } else {
            this.getUIPlacement().setNodeId(GUID.newGUID());
        }
        this.initButtonGroup();
    }

    protected ControlTransformNode(List lAttributes, List lValues, IDesignTimeModel jobModel) {
        String message;
        boolean bCollapsed = false;
        int iIndex = -1;
        for (int i = 0; i < lAttributes.size(); ++i) {
            String sAttribute = (String)lAttributes.get(i);
            String sValue = (String)lValues.get(i);
            if (sAttribute.equalsIgnoreCase("NodeId")) {
                this.m_sId = sValue;
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionX")) {
                this.m_xPosition = Integer.parseInt(sValue);
                continue;
            }
            if (sAttribute.equalsIgnoreCase("PositionY")) {
                this.m_yPosition = Integer.parseInt(sValue);
                continue;
            }
            if (!sAttribute.equalsIgnoreCase("Index")) continue;
            iIndex = Integer.parseInt(sValue);
        }
        try {
            IDiagramNodeAdapter adapter = DiagramNodeAdapterFactory.getInstance().createAdapter((IObject)jobModel.getJob().getTransformsList().get(iIndex));
            if (!(adapter.getObject() instanceof ITransform)) {
                message = "The wrong type of adapter was created while trying to create a control node with the index - " + iIndex + " in the transformation list: " + jobModel.getJob().getTransformsList().toString() + " the adapter created was: " + adapter.getObject().getClass().toString();
                Workspace.getDefaultLogger().debug((Object)message);
                this.setCleanUpRequired(true);
                return;
            }
            this.m_adapterNode = new AdapterNode(adapter, this);
            this.getUIPlacement().setNodeId(this.m_sId);
            this.getUIPlacement().setXPosition(this.m_xPosition);
            this.getUIPlacement().setYPosition(this.m_yPosition);
            this.setSpotLocation(1, new Point(this.getUIPlacement().getXPosition(), this.getUIPlacement().getYPosition()));
            this.getUIPlacement().setChanged(false);
            this.refresh();
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            message = "An exception occurred while trying to create a control node with the index - " + iIndex + " in the transformation list: " + jobModel.getJob().getTransformsList().toString();
            Workspace.getDefaultLogger().debug((Object)message);
            this.setCleanUpRequired(true);
            return;
        }
        this.setForceShowPorts(!bCollapsed);
        this.initButtonGroup();
    }

    public void initButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new PFDButtonGroup();
        }
        this.addPrimitive((PFDPrimitive)this.buttonGroup);
        if (this.m_lIndicatorButtons == null) {
            this.m_lIndicatorButtons = new ArrayList();
        }
    }

    protected PFDButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.initButtonGroup();
        }
        return this.buttonGroup;
    }

    protected void draw(Graphics2D g2d, PFDView v, boolean selected) {
        super.draw(g2d, v, selected);
        if (this.noteButton != null) {
            this.noteButton.paint(g2d);
        }
        this.buttonGroup.paint(g2d);
    }

    protected void drawStatusButton(Graphics2D g) {
        super.drawStatusButton(g);
        if (this.noteButton != null) {
            this.noteButton.paint(g);
        }
        this.buttonGroup.paint(g);
        this.drawNote(g);
    }

    public Object cloneObject(Hashtable table) {
        ControlTransformNode clone = (ControlTransformNode)super.cloneObject(table);
        PFDButtonGroup newButtons = (PFDButtonGroup)this.buttonGroup.cloneObject(table);
        for (int i = 0; i < newButtons.getNumButtons(); ++i) {
            clone.getIndicatorButtons().addButton(newButtons.removeButton(i));
        }
        return clone;
    }

    public PFDButtonCollection getIndicatorButtons() {
        List indicatorButtons = this.getAdapterNode().getAdapter().getIndicatorButtons();
        PFDButtonGroup buttons = this.getButtonGroup();
        if (!this.m_lIndicatorButtons.equals(indicatorButtons)) {
            int iButton;
            for (iButton = 0; iButton < indicatorButtons.size(); ++iButton) {
                if (buttons.containsButton((PFDAbstractButton)((PFDButton)indicatorButtons.get(iButton)))) continue;
                buttons.addButton((PFDAbstractButton)((PFDButton)indicatorButtons.get(iButton)));
            }
            for (iButton = 0; iButton < this.m_lIndicatorButtons.size(); ++iButton) {
                if (indicatorButtons.contains(this.m_lIndicatorButtons.get(iButton))) continue;
                buttons.removeButton((PFDAbstractButton)((PFDButton)this.m_lIndicatorButtons.get(iButton)));
            }
            this.m_lIndicatorButtons.clear();
            this.m_lIndicatorButtons.addAll(indicatorButtons);
        }
        return buttons;
    }

    protected void layoutStatusButton() {
        super.layoutStatusButton();
        Point p = this.controlShape.getSpotLocation(3, null);
        if (this.noteButton != null) {
            this.noteButton.setLocation(p.x - this.noteButton.getWidth(), p.y - this.noteButton.getHeight() / 2);
            p.x -= this.noteButton.getWidth() + this.buttonGroup.getButtonSpacing();
        }
        if (this.buttonGroup != null) {
            Dimension d = this.buttonGroup.getSize();
            this.buttonGroup.setLocation(p.x - d.width, p.y - d.height / 2);
        }
    }

    public void updateNotes() {
        if (this.note == null) {
            if (this.noteButton != null) {
                this.removePrimitive((PFDPrimitive)this.noteButton);
                this.noteButton = null;
            }
        } else if (this.noteButton == null) {
            this.noteButton = new PFDButton();
            this.noteButton.setAction(this.getAction("ACTION_OPEN_QUICK_NOTE"));
            this.noteButton.setIcon(PFDIconManager.getIcon((String)"StickyNote_yellow8.gif"));
            this.noteButton.setRolloverIcon(PFDIconManager.getIcon((String)"StickyNote_yellow12.gif"));
            this.noteButton.setRolloverEnabled(true);
            this.addPrimitive((PFDPrimitive)this.noteButton);
        }
    }

    protected void setNoteLocation() {
        if (this.noteButton == null) {
            super.setNoteLocation();
        } else if (this.note != null) {
            this.note.setLocation(this.noteButton.getX() + ControlTransformNode.noteOffset.width, this.noteButton.getY() + ControlTransformNode.noteOffset.height);
        }
    }

    @Override
    public void setLocation(Point location) {
        super.setSpotLocation(1, location);
    }

    @Override
    public void setMode(int eMode) {
        if (eMode != 0 && eMode != 1 && eMode != 2) {
            throw new IllegalArgumentException("illegal mode: " + eMode);
        }
        if (this.m_eMode == eMode) {
            return;
        }
        this.m_eMode = eMode;
        this.refresh();
    }

    @Override
    public int getMode() {
        return this.m_eMode;
    }

    @Override
    public void setValidateStatusMessages(String[] messages) {
        this.m_eValidateStatusMessages = messages;
    }

    @Override
    public String[] getValidateStatusMessages() {
        return this.m_eValidateStatusMessages;
    }

    @Override
    public void setValidateStatus(int eStatus) {
        if (eStatus != 0 && eStatus != 1 && eStatus != 2 && eStatus != 3 && eStatus != 5 && eStatus != 4) {
            throw new IllegalArgumentException("validate status is invalid " + eStatus);
        }
        if (this.m_eValidateStatus == eStatus) {
            return;
        }
        this.m_eValidateStatus = eStatus;
        if (this.m_eMode == 2) {
            this.refreshValidateStatus();
        }
    }

    @Override
    public int getValidateStatus() {
        return this.m_eValidateStatus;
    }

    @Override
    public void setRunStatusMessages(String[] messages) {
        this.m_eRunStatusMessages = messages;
    }

    @Override
    public String[] getRunStatusMessages() {
        return this.m_eRunStatusMessages;
    }

    @Override
    public void setRunStatus(int eStatus) {
        if (eStatus != 0 && eStatus != 1 && eStatus != 2 && eStatus != 3 && eStatus != 4 && eStatus != 5) {
            throw new IllegalArgumentException("run status is invalid " + eStatus);
        }
        if (this.m_eRunStatus == eStatus) {
            return;
        }
        this.m_eRunStatus = eStatus;
        if (this.m_eMode == 1) {
            this.refreshRunStatus();
        }
    }

    @Override
    public int getRunStatus() {
        return this.m_eRunStatus;
    }

    private IAdapterNode getAdapterNode() {
        return this.m_adapterNode;
    }

    @Override
    public IDiagramNodeAdapter getAdapter() {
        return this.getAdapterNode().getAdapter();
    }

    @Override
    public PFDPort getInputPort(IObject obj) {
        return this.getAdapterNode().getInputPort(obj);
    }

    @Override
    public PFDPort getOutputPort(int index) {
        return this.getOutputPort();
    }

    @Override
    public PFDPort getInputPort(int index) {
        return this.getInputPort();
    }

    @Override
    public PFDPort getOutputPort(IObject obj) {
        return this.getAdapterNode().getOutputPort(obj);
    }

    @Override
    public IObject getObject() {
        return this.getAdapterNode().getObject();
    }

    public void refresh(ModelEvent ev) {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.m_adapterNode.refresh();
        if (this.getMode() == 0) {
            this.refreshDesignStatus();
        } else {
            this.refreshRunStatus();
        }
        this.getIndicatorButtons();
        this.refreshCodeIndicators();
    }

    protected void update(String property, PFDView v) {
        super.update(property, v);
        if (property.equals("note")) {
            this.updateNotes();
        } else if (property.equals("all")) {
            this.updateNotes();
        }
    }

    protected ITransformNodeAdapter getTransformAdapter() {
        return (ITransformNodeAdapter)this.m_adapterNode.getAdapter();
    }

    @Override
    public String getId() {
        return this.getUIPlacement().getNodeId();
    }

    protected void setId(String sId) {
        this.getUIPlacement().setNodeId(sId);
    }

    protected ITransform getTransform() {
        return (ITransform)this.m_adapterNode.getObject();
    }

    public void addPopupMenuItems(JPopupMenu menuPopup) {
    }

    public boolean drop(Point ptEvent, List lObjects) {
        return false;
    }

    public boolean isActive() {
        return this.m_bActive;
    }

    @Override
    public boolean isAutomaticAddToControlFlow() {
        return ((ITransformNodeAdapter)this.getAdapter()).isAutomaticAddToControlFlow();
    }

    public void setActive(boolean bActive) {
        this.m_bActive = bActive;
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        return false;
    }

    @Override
    public boolean isCleanUpRequired() {
        return this.m_bCleanUpRequired;
    }

    @Override
    public void setCleanUpRequired(boolean bRequired) {
        this.m_bCleanUpRequired = bRequired;
    }

    public void setDefaultAction(Action actDefault) {
        this.getAdapter().setDefaultAction(actDefault);
    }

    public Action getDefaultAction() {
        return this.getAdapter().getDefaultAction();
    }

    public void setDeleteAction(Action actDelete) {
        this.getAdapter().setDeleteAction(actDelete);
    }

    public Action getDeleteAction() {
        return this.getAdapter().getDeleteAction();
    }

    private void refreshDesignStatus() {
        String sContent;
        String sTitle;
        String sToolTip;
        int eStatus;
        ITransform transform = this.getTransform();
        if (transform.isCodeGenerationEnabled() && !transform.isCompleteWithUserWritten()) {
            List lMessages = this.getTransform().getReasonsIncomplete();
            StringBuffer sbContent = new StringBuffer(128);
            for (int iMessage = 0; iMessage < lMessages.size(); ++iMessage) {
                sbContent.append("- ").append(lMessages.get(iMessage)).append("<br>");
            }
            if (lMessages.isEmpty()) {
                sbContent.append("TODO: This transform needs reasons incomplete!");
            }
            eStatus = 4;
            sToolTip = bundle.getString("ControlTransformNode.Incomplete.tip");
            sTitle = bundle.getString("ControlTransformNode.Errors.Title.txt");
            sContent = sbContent.toString();
        } else if (transform.isCodeGenerationEnabled() && transform.hasWarnings()) {
            List lMessages = this.getTransform().getWarnings();
            StringBuffer sbContent = new StringBuffer(128);
            for (int iMessage = 0; iMessage < lMessages.size(); ++iMessage) {
                sbContent.append("- ").append(lMessages.get(iMessage)).append("<br>");
            }
            if (lMessages.isEmpty()) {
                sbContent.append("TODO: This transform needs warnings!");
            }
            sContent = sbContent.toString();
            eStatus = 1;
            sToolTip = bundle.getString("ControlTransformNode.DesignWarnings.tip");
            sTitle = bundle.getString("ControlTransformNode.DesignWarnings.Title.txt");
        } else {
            eStatus = 5;
            sToolTip = bundle.getString("ControlTransformNode.Complete.tip");
            sTitle = null;
            sContent = null;
        }
        this.setStatus(eStatus, sToolTip, sTitle, sContent, null);
    }

    private void refreshRunStatus() {
        switch (this.getRunStatus()) {
            case 0: {
                this.setStatus(0);
                break;
            }
            case 1: {
                this.setStatus(3);
                break;
            }
            case 2: {
                this.setStatus(5);
                break;
            }
            case 3: {
                this.setStatus(1);
                break;
            }
            case 4: {
                this.setStatus(2);
                break;
            }
            case 5: {
                this.setStatus(5);
            }
        }
    }

    private void refreshValidateStatus() {
        switch (this.getValidateStatus()) {
            case 0: {
                this.setStatus(0);
                break;
            }
            case 1: {
                this.setStatus(3);
                break;
            }
            case 5: {
                this.setStatus(0);
                break;
            }
            case 2: {
                this.setStatus(5);
                break;
            }
            case 3: {
                this.setStatus(1);
                break;
            }
            case 4: {
                this.setStatus(2);
            }
        }
    }

    private void refreshCodeIndicators() {
        this.setGhosted(!this.getTransform().isCodeGenerationEnabled());
        String sNote = ((ITransform)this.m_adapterNode.getAdapter().getObject()).getPrivateNote();
        if (sNote == null || sNote.equals("")) {
            this.removeNote();
        } else {
            this.setNoteText(sNote);
            this.getNoteTextPane().setFocusable(false);
            this.getNoteTextPane().setEditable(false);
        }
    }

    @Override
    public void addInputPort(PFDPort port) {
        this.setInputPort(port);
    }

    @Override
    public void addOutputPort(PFDPort port) {
        this.setOutputPort(port);
    }

    @Override
    public int getInputPortIndex(PFDPort port) {
        return 0;
    }

    @Override
    public int getOutputPortIndex(PFDPort port) {
        return 0;
    }

    @Override
    public void removeAllInputPorts() {
    }

    @Override
    public void removeAllOutputPorts() {
    }

    @Override
    public void setContentText(String text) {
    }

    @Override
    public void setNodeIcon(Icon icon) {
    }

    @Override
    public boolean isCollapsed() {
        return false;
    }

    @Override
    public void setCollapsed(boolean collapsed) {
    }

    @Override
    public String writeToXML(IDesignTimeModel job) {
        return null;
    }

    @Override
    public int getNumInputPorts() {
        return 1;
    }

    @Override
    public int getNumOutputPorts() {
        return 1;
    }

    @Override
    public IUIPlacement getUIPlacement() {
        return this.getTransform().getUIPlacement();
    }
}

