/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.shapes.impl;

import com.sas.entities.GUID;
import com.sas.etl.models.IObject;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.interfaces.PFDLinkValidator;
import com.sas.wadmin.jobeditor.diagram.adapters.ISourceInvalidMessage;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataPort;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.workspace.WAdminResource;

public class BaseLink
extends PFDLink
implements IDiagramLink {
    private static final WAdminResource bundle = WAdminResource.getBundle(BaseLink.class);
    private String m_sId;
    private int m_iFromNodePortIndex;
    private int m_iToNodePortIndex;
    private String m_sFromNodeId;
    private String m_sToNodeId;
    private boolean m_bDoLinkSupportedValidation;

    public BaseLink() {
        this.m_sId = GUID.newGUID();
        this.setLinkSupportedValidation(true);
        this.addValidator(new LinkValidator());
    }

    public BaseLink(PFDPort from, PFDPort to, boolean bControl) {
        super(from, to, bControl);
        this.addValidator(new LinkValidator());
        this.setLinkSupportedValidation(true);
        this.m_sId = GUID.newGUID();
        if (to != null) {
            this.m_sToNodeId = this.getToNodeId();
            this.m_iToNodePortIndex = this.getToNodePortIndex(to);
        }
        if (from != null) {
            this.m_sFromNodeId = this.getFromNodeId();
            this.m_iFromNodePortIndex = this.getFromNodePortIndex(from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseLink(PFDPort from, PFDPort to, boolean bControl, boolean bDoValidation) {
        super(null, null, bControl);
        this.m_sId = GUID.newGUID();
        this.addValidator(new LinkValidator());
        this.setLinkSupportedValidation(bDoValidation);
        try {
            this.setFromPort(from);
            this.setToPort(to);
            if (this.getToNodeId() == null || this.getFromNodeId() == null) {
                this.setFromPort(null);
                this.setToPort(null);
                return;
            }
        }
        finally {
            this.setLinkSupportedValidation(true);
        }
        if (to != null) {
            this.setToNodeId(this.getToNodeId());
            this.setToNodePortIndex(this.getToNodePortIndex(to));
        }
        if (from != null) {
            this.setFromNodeId(this.getFromNodeId());
            this.setFromNodePortIndex(this.getFromNodePortIndex(from));
        }
    }

    @Override
    public String getId() {
        return this.m_sId;
    }

    protected void setId(String sId) {
        this.m_sId = sId;
    }

    @Override
    public void setLinkSupportedValidation(boolean bDoValidation) {
        this.m_bDoLinkSupportedValidation = bDoValidation;
    }

    @Override
    public boolean doLinkSupportedValidation() {
        return this.m_bDoLinkSupportedValidation;
    }

    @Override
    public int getFromNodePortIndex() {
        return this.getFromNodePortIndex(null);
    }

    @Override
    public int getFromNodePortIndex(PFDPort port) {
        int iPort;
        if (this.getFromNode() != null && (iPort = ((IDiagramNode)this.getFromNode()).getOutputPortIndex(port)) != -1) {
            return iPort;
        }
        return this.m_iFromNodePortIndex;
    }

    @Override
    public int getToNodePortIndex() {
        return this.getToNodePortIndex(null);
    }

    @Override
    public int getToNodePortIndex(PFDPort port) {
        if (this.getToNode() != null) {
            IDiagramNode node = (IDiagramNode)this.getToNode();
            int iPort = ((IDiagramNode)this.getToNode()).getInputPortIndex(port);
            if (iPort != -1) {
                return iPort;
            }
        }
        return this.m_iToNodePortIndex;
    }

    @Override
    public void setFromNodePortIndex(int iFromNodePortIndex) {
        this.m_iFromNodePortIndex = iFromNodePortIndex;
    }

    @Override
    public void setToNodePortIndex(int iToNodePortIndex) {
        this.m_iToNodePortIndex = iToNodePortIndex;
    }

    @Override
    public String getFromNodeId() {
        if (this.getFromNode() != null) {
            return ((IDiagramNode)this.getFromNode()).getId();
        }
        return this.m_sFromNodeId;
    }

    @Override
    public String getToNodeId() {
        if (this.getToNode() != null) {
            return ((IDiagramNode)this.getToNode()).getId();
        }
        return this.m_sToNodeId;
    }

    @Override
    public void setFromNodeId(String fromNodeId) {
        this.m_sFromNodeId = fromNodeId;
    }

    @Override
    public void setToNodeId(String toNodeId) {
        this.m_sToNodeId = toNodeId;
    }

    @Override
    public String writeToXML(IDesignTimeModel job) {
        return null;
    }

    private class LinkValidator
    implements PFDLinkValidator {
        private LinkValidator() {
        }

        public boolean validateLink(PFDLink link, PFDPort from, PFDPort to) {
            if (from == null || to == null) {
                return true;
            }
            if (from instanceof IDataPort && to instanceof IDataPort && BaseLink.this.doLinkSupportedValidation()) {
                IDiagramNode fromNode = (IDiagramNode)((IDataPort)from).getParentNode();
                IDiagramNode toNode = (IDiagramNode)((IDataPort)to).getParentNode();
                if (fromNode != null && toNode != null) {
                    IObject objFrom = fromNode.getObject();
                    IObject objTo = toNode.getObject();
                    int portIndexFrom = fromNode.getOutputPortIndex(from);
                    int portIndexTo = toNode.getInputPortIndex(to);
                    boolean bToSupported = toNode.getAdapter().isValidConnectToInput(objFrom, portIndexTo);
                    boolean bFromSupported = fromNode.getAdapter().isValidConnectToOutput(objTo, portIndexFrom);
                    if (!bToSupported || !bFromSupported) {
                        return false;
                    }
                }
            }
            return true;
        }

        public String getInvalidLinkMessage(PFDLink link, PFDAbstractNode fromNode, PFDPort fromPort, PFDAbstractNode toNode, PFDPort toPort) {
            if (fromNode == null || toNode == null) {
                return null;
            }
            if (fromNode != null && toNode != null && fromNode instanceof IDiagramNode && toNode instanceof IDiagramNode) {
                IObject objFrom = ((IDiagramNode)fromNode).getObject();
                IObject objTo = ((IDiagramNode)toNode).getObject();
                int portIndexFrom = -1;
                int portIndexTo = -1;
                if (BaseLink.this.getValidationStatus() == 9) {
                    return bundle.getString("BaseLink.NoPortAvailable.txt");
                }
                if (fromPort != null) {
                    portIndexFrom = ((IDiagramNode)fromNode).getOutputPortIndex(fromPort);
                }
                if (toPort != null) {
                    portIndexTo = ((IDiagramNode)toNode).getInputPortIndex(toPort);
                }
                String sToMessage = ((IDiagramNode)toNode).getAdapter().getInvalidConnectInputMessage(objFrom, portIndexTo);
                String sFromMessage = ((IDiagramNode)fromNode).getAdapter().getInvalidConnectOutputMessage(objTo, portIndexFrom);
                if (((IDiagramNode)fromNode).getAdapter() instanceof ISourceInvalidMessage && sFromMessage != null) {
                    return sFromMessage;
                }
                return sToMessage == null ? sFromMessage : sToMessage;
            }
            return null;
        }
    }
}

