/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.copypaste;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPasteModify;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IJob;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.copypaste.PasteItem;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PasteItemsContainer
implements IModelListener {
    private List<IPasteModify> _pasteModifyObjects;
    private Map<IObject, Point> _addedObjects;
    private Map<IDiagramStickyNote, Point> _notes;
    private IJob _job;
    private List<PasteItem> _pastedItems;

    public PasteItemsContainer(IJob job) {
        this._job = job;
        this._pasteModifyObjects = new ArrayList<IPasteModify>();
        this._addedObjects = new HashMap<IObject, Point>();
        this._notes = new HashMap<IDiagramStickyNote, Point>();
        this._pastedItems = new ArrayList<PasteItem>();
    }

    public List<PasteItem> getPastedItems() {
        return new ArrayList<PasteItem>(this._pastedItems);
    }

    private List<IPasteModify> getPasteModifiedObjects() {
        return this._pasteModifyObjects;
    }

    public List<IPasteModify> getPasteModifiedDependent() {
        ArrayList<IPasteModify> dependent = new ArrayList<IPasteModify>(this.getPasteModifiedObjects());
        for (IPasteModify pm : this._pasteModifyObjects) {
            List cp = pm.getPasteChildObjects();
            if (cp == null || cp.isEmpty()) continue;
            dependent.removeAll(cp);
        }
        return dependent;
    }

    public Map<IObject, Point> getAddedObjects() {
        return this._addedObjects;
    }

    public void addPasteObject(IObject obj, Point pt) {
        this._addedObjects.put(obj, pt);
        this.addPasteItem(obj, pt);
    }

    public void addNote(IDiagramStickyNote note, Point pt) throws RemoteException, MdException {
        this._notes.put(note, pt);
        note.pasteAction();
        this.addPasteItem(note, pt);
    }

    private void addPasteItem(Object obj, Point pt) {
        if (!(obj instanceof IWorkTable)) {
            this._pastedItems.add(new PasteItem(obj, pt));
        }
    }

    public boolean hasItem(Object obj) {
        for (PasteItem item : this._pastedItems) {
            if (item.getObject() != obj) continue;
            return true;
        }
        return false;
    }

    public void fireModelEventForPasteComplete() {
        this._job.getModel().fireModelEvent((IObject)this._job, "ModelController:ItemsPasted", (Object)this);
    }

    public List<PasteItem> getSortedPasteItems() {
        ArrayList<PasteItem> lst = new ArrayList<PasteItem>(this._pastedItems);
        Collections.sort(lst, new PasteItemComparator());
        return lst;
    }

    public void updateModelPoints(Map<String, Point> points) {
        for (PasteItem item : this._pastedItems) {
            IObject obj;
            if (!(item.getObject() instanceof IObject) || !points.containsKey((obj = (IObject)item.getObject()).getID())) continue;
            item.setPoint(points.get(obj.getID()));
        }
    }

    public void modelChanged(ModelEvent ev) {
        if ("ModelController:ObjectAdded".equals(ev.getType())) {
            if (ev.getModelObject() instanceof IPasteModify) {
                this._pasteModifyObjects.add((IPasteModify)ev.getModelObject());
            }
        } else if (ev.getModelObject() == this._job) {
            if ("Job:DataObjectAdded".equals(ev.getType())) {
                if (!this.hasItem(ev.getData())) {
                    this.addPasteObject((IObject)ev.getData(), null);
                }
            } else if ("Job:TransformAdded".equals(ev.getType())) {
                try {
                    IDiagramNodeAdapter ad = DiagramNodeAdapterFactory.getInstance().createAdapter((IObject)ev.getData());
                    if (ad != null) {
                        this.addPasteObject((IObject)ev.getData(), null);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    private class PasteItemComparator
    implements Comparator<PasteItem> {
        private PasteItemComparator() {
        }

        @Override
        public int compare(PasteItem o1, PasteItem o2) {
            boolean isDO1 = o1.getObject() instanceof IDataObject;
            boolean isDO2 = o2.getObject() instanceof IDataObject;
            if (isDO1 && !isDO2) {
                return -1;
            }
            if (isDO1 && isDO2) {
                return 0;
            }
            return 1;
        }
    }
}

