/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.TeradataTableLoaderTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.ISourceInvalidMessage;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.teradataloader.TeradataLoaderLoadTechniqueTab;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TeradataTableLoaderTransformAdapter
extends AbstractDataTransformAdapter
implements ISourceInvalidMessage {
    private static final WAdminResource bundle = WAdminResource.getBundle(TeradataTableLoaderTransformAdapter.class);
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(TeradataTableLoaderTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(TeradataTableLoaderTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(TeradataTableLoaderTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(TeradataTableLoaderTransformModel.getTransformTypeID(), 24);
    protected static final IPortDescription DEFAULT_OUTPUT_TERADATA_DATA_PORT = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(bundle.getString("TeradataTableLoaderTransformAdapter.OutputDataPort.ToolTip.txt"), 1, DEFAULT_TABLE_TYPES);
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{DEFAULT_OUTPUT_CONTROL_PORT, DEFAULT_OUTPUT_TERADATA_DATA_PORT};
    private TeradataTableLoaderTransformModel m_transform;

    public TeradataTableLoaderTransformAdapter(TeradataTableLoaderTransformModel transform) {
        super((IDataTransform)transform);
        this.m_transform = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        OptionsTab optionTab = null;
        try {
            optionTab = new OptionsTab(this.m_transform.getOptionModel(), "options_tab_loader_tera", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_transform, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(new TeradataLoaderLoadTechniqueTab(this.m_transform));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(optionTab);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, false));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ConditionActionsTab((IConditionActionSetContainer)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            super.isValidConnectToOutput(obj, portIndex);
        } else if (portIndex == 1 && obj instanceof IDataObject && !this.m_transform.containsInDataTargets((IDataObject)obj) && this.m_transform.isValidAsTargetTable((IDataObject)obj)) {
            return true;
        }
        return false;
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.formatString("TeradataTableLoaderTransformAdapter.InvalidOutputMessage.txt", (Object)this.getName());
    }
}

