/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.SPDSTableLoaderTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.spdsloader.SPDSTableLoaderLoadTechniquePropertyTab;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.ExtendedAttributesTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SPDSTableLoaderTransformAdapter
extends AbstractDataTransformAdapter {
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(SPDSTableLoaderTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(SPDSTableLoaderTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(SPDSTableLoaderTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(SPDSTableLoaderTransformModel.getTransformTypeID(), 24);
    private SPDSTableLoaderTransformModel m_loader;

    public SPDSTableLoaderTransformAdapter(SPDSTableLoaderTransformModel transform) {
        super((IDataTransform)transform);
        this.m_loader = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        OptionsTab optionTab = null;
        try {
            optionTab = new OptionsTab(this.m_loader.getOptionModel(), "options_tab_loader_spds", false);
            optionTab.setPreferredSize(new Dimension(200, 200));
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_loader, null, false);
            return new WAPropertyTab[]{new GeneralTab((IObject)this.m_loader), new SPDSTableLoaderLoadTechniquePropertyTab(this.m_loader), new ProcessTab((ICodeGenerator)this.m_loader, true, false), this.createMappingsTab(false), optionTab, tableOptionsTab, new PrePostCodeTab((IPrePostCode)this.m_loader), new ConditionActionsTab((IConditionActionSetContainer)this.m_loader), new ParameterTab((IParametersContainer)this.m_loader), new NotesTab((INotesAndDocumentsContainer)this.m_loader), new ExtendedAttributesTab((IExtendedAttributesContainer)this.m_loader)};
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }
}

