/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ISortingTransform;
import com.sas.etl.models.job.transforms.rank.RankTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.transforms.rank.SASRankVariablesPropertyTab;
import com.sas.wadmin.transforms.sort.SASSortByTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class RankTransformAdapter
extends AbstractDataTransformAdapter {
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(RankTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(RankTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(RankTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(RankTransformModel.getTransformTypeID(), 24);
    private RankTransformModel m_rank;
    private static final WAdminResource bundle = WAdminResource.getBundle(RankTransformAdapter.class);

    public RankTransformAdapter(RankTransformModel transform) {
        super((IDataTransform)transform);
        this.m_rank = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    public WAPropertyTab[] getPropertyTabs() {
        OptionsTab optionTab = null;
        try {
            optionTab = new OptionsTab(this.m_rank.getOptionModel(), "options_tab_rank", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_rank, null, false);
            SASSortByTab tabRankByColumns = new SASSortByTab((ISortingTransform)this.m_rank, 0, bundle.getString("RankTransformAdapter.RankByColumns.Title.txt"), bundle.getString("RankTransformAdapter.RankByColumnsTargetPanel.Title.txt"));
            tabRankByColumns.setHelpProduct("wdb");
            tabRankByColumns.setHelpTopic("rank_by_cols_tab");
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_rank));
            lTabs.add(tabRankByColumns);
            lTabs.add(new SASRankVariablesPropertyTab(this.m_rank));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(optionTab);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_rank, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_rank));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_rank));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_rank));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_rank, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }
}

