/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.actions.AppActionsManager;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;

public class JobTransformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(JobTransformAdapter.class);
    private static final IPortDescription[] JOB_INPUT_PORTS = new IPortDescription[]{DEFAULT_INPUT_CONTROL_PORT};
    private static final IPortDescription[] JOB_OUTPUT_PORTS = new IPortDescription[]{DEFAULT_OUTPUT_CONTROL_PORT};
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(JobTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(JobTransformModel.getTransformTypeID(), 24);
    private JobTransformModel m_job;

    public JobTransformAdapter(JobTransformModel transform) {
        super((IDataTransform)transform);
        this.m_job = transform;
        this.setDefaultAction((Action)AppActionsManager.getInstance().getAction("File:Open:SelectedObjects"));
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL() {
        return this.getIconURL(16);
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        return null;
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        return null;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return JOB_OUTPUT_PORTS;
    }

    @Override
    public boolean isAutomaticAddToControlFlow() {
        return true;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return JOB_INPUT_PORTS;
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.getString("JobTransformAdapter.InvalidOutputMessage.txt");
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.getString("JobTransformAdapter.InvalidInputMessage.txt");
    }
}

