/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IGeneratedTransformPort;
import com.sas.etl.models.job.IGeneratedTransformTemplate;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GeneratedTransformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(GeneratedTransformAdapter.class);
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(GeneratedTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(GeneratedTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(GeneratedTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(GeneratedTransformModel.getTransformTypeID(), 24);
    private static final String SOAP_NODISPLAY = "SOAP";
    private static final String REST_NODISPLAY = "REST";
    private GeneratedTransformModel m_transform;
    private IGeneratedTransformTemplate m_template;
    private List m_sourcePorts;
    private List m_targetPorts;

    public GeneratedTransformAdapter(GeneratedTransformModel transform) {
        super((IDataTransform)transform);
        this.m_transform = transform;
        this.m_sourcePorts = new ArrayList();
        this.m_targetPorts = new ArrayList();
        this.m_template = transform.getTemplate();
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab createMappingsTab(boolean details) {
        MappingsTab.Configuration config = new MappingsTab.Configuration();
        config.setMultipleSourceTablesEnabled(this.m_transform.getMaximumSourceTableCount() > 1);
        config.setMultipleTargetTablesEnabled(this.m_transform.getMaximumTargetTableCount() > 1);
        config.setHiddenColumnsInSourceColumnsTable(new int[0]);
        config.setHiddenColumnsInTargetColumnsTable(new int[0]);
        config.setWhereUsedSettingsKeyPrefix(details ? "Details" : "Properties");
        config.setSourceTableSettingsKeyPrefix("GeneratedTransform.SourceColumnsTable");
        config.setTargetTableSettingsKeyPrefix("GeneratedTransform.TargetColumnsTable");
        return new MappingsTab((IMappingsContainer)this.m_transform, config);
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        int ports = 1;
        IGeneratedTransformPort[] sourcePorts = null;
        if (this.m_template != null) {
            sourcePorts = this.m_template.getSourcePorts();
            ports += sourcePorts.length;
        }
        IPortDescription[] portDesc = new IPortDescription[ports];
        if (sourcePorts != null) {
            for (int i = 0; i < sourcePorts.length; ++i) {
                IPortDescription desc;
                portDesc[i + 1] = desc = this.createInputPortDescription(sourcePorts[i], i);
            }
        }
        portDesc[0] = PortDescriptionFactory.getInstance().createControlInputPortDescriptionForTransform(1);
        return portDesc;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        int ports = 1;
        IGeneratedTransformPort[] targetPorts = null;
        if (this.m_template != null) {
            targetPorts = this.m_template.getTargetPorts();
            ports += targetPorts.length;
        }
        IPortDescription[] portDesc = new IPortDescription[ports];
        if (targetPorts != null) {
            for (int i = 0; i < targetPorts.length; ++i) {
                IPortDescription desc;
                portDesc[i + 1] = desc = this.createOutputPortDescription(targetPorts[i], i);
            }
        }
        portDesc[0] = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
        return portDesc;
    }

    private IPortDescription createOutputPortDescription(IGeneratedTransformPort gtPort, int index) {
        IPortDescription desc = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(gtPort.getName() + " - " + gtPort.getMacro(), gtPort.getMacro(), 1, DEFAULT_TABLE_TYPES);
        this.m_targetPorts.add(new PortDescriptionModel(gtPort, desc));
        return desc;
    }

    private IPortDescription createInputPortDescription(IGeneratedTransformPort gtPort, int index) {
        IPortDescription desc = PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(gtPort.getName() + " - " + gtPort.getMacro(), gtPort.getMacro(), 1, DEFAULT_TABLE_TYPES);
        this.m_sourcePorts.add(new PortDescriptionModel(gtPort, desc));
        return desc;
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.connectToInput(obj, portIndex);
        }
        if (portIndex > 0 && obj instanceof IPhysicalTable) {
            this.m_transform.addDataSource(this.m_template.getSourcePorts()[portIndex - 1], (IPhysicalTable)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            super.disconnectFromInput(obj, portIndex);
        } else if (portIndex > 0 && obj instanceof IDataObject) {
            this.m_transform.removeDataSource(this.m_template.getSourcePorts()[portIndex - 1], (IPhysicalTable)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.connectToOutput(obj, portIndex);
        }
        if (portIndex > 0 && obj instanceof IPhysicalTable) {
            this.m_transform.addDataTarget(this.m_template.getTargetPorts()[portIndex - 1], (IPhysicalTable)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            super.disconnectFromOutput(obj, portIndex);
        } else if (portIndex > 0 && obj instanceof IDataObject) {
            this.m_transform.removeDataTarget(this.m_template.getTargetPorts()[portIndex - 1], (IPhysicalTable)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.isValidConnectToInput(obj, portIndex);
        }
        return portIndex > 0 && obj instanceof IDataObject;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.isValidConnectToOutput(obj, portIndex);
        }
        return portIndex > 0 && obj instanceof IDataObject && !this.m_transform.containsInDataTargets((IDataObject)obj);
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        if (obj instanceof IDataObject) {
            return this.m_template.findInSourcePorts((IPhysicalTable)obj) + 1;
        }
        return -1;
    }

    @Override
    public int[] getInputPortIndexes(IObject obj) {
        ArrayList<Integer> indPorts = new ArrayList<Integer>();
        IGeneratedTransformPort[] ports = this.m_template.getSourcePorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i].getTable() != obj) continue;
            indPorts.add(new Integer(i + 1));
        }
        int[] portArray = new int[indPorts.size()];
        for (int i = 0; i < indPorts.size(); ++i) {
            portArray[i] = (Integer)indPorts.get(i);
        }
        return portArray;
    }

    @Override
    public int[] getOutputPortIndexes(IObject obj) {
        ArrayList<Integer> indPorts = new ArrayList<Integer>();
        IGeneratedTransformPort[] ports = this.m_template.getTargetPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i].getTable() != obj) continue;
            indPorts.add(new Integer(i + 1));
        }
        int[] portArray = new int[indPorts.size()];
        for (int i = 0; i < indPorts.size(); ++i) {
            portArray[i] = (Integer)indPorts.get(i);
        }
        return portArray;
    }

    @Override
    public boolean isValidToConnectInputOnRedraw(IObject obj) {
        if (obj instanceof IPhysicalTable) {
            return this.m_template.getNumberTimesTableUsedInSources((IPhysicalTable)obj) == 1;
        }
        return true;
    }

    @Override
    public boolean isValidToConnectOutputOnRedraw(IObject obj) {
        if (obj instanceof IPhysicalTable) {
            return this.m_template.getNumberTimesTableUsedInTargets((IPhysicalTable)obj) == 1;
        }
        return true;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        if (obj instanceof IDataObject) {
            return this.m_template.findInTargetPorts((IPhysicalTable)obj) + 1;
        }
        return -1;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab tabOptions = new OptionsTab(this.m_transform.getOptionModel(), this.m_transform.getHelpProduct(), this.m_transform.getHelpId(), this.m_transform.getHelpClass(), false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_transform, null, false);
            tabOptions.setPreferredSize(new Dimension(700, 500));
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(tabOptions);
            if (!this.m_transform.getName().equalsIgnoreCase(SOAP_NODISPLAY) && !this.m_transform.getName().equalsIgnoreCase(REST_NODISPLAY)) {
                lTabs.add(tableOptionsTab);
            }
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj) {
        IPortDescription desc = null;
        if (obj != null && obj instanceof IGeneratedTransformPort) {
            int index = Arrays.asList(this.m_template.getSourcePorts()).indexOf(obj);
            desc = this.createInputPortDescription((IGeneratedTransformPort)obj, index);
        }
        return desc;
    }

    @Override
    public IPortDescription addOutputPortDescription(Object obj) {
        IPortDescription desc = null;
        if (obj != null && obj instanceof IGeneratedTransformPort) {
            int index = Arrays.asList(this.m_template.getTargetPorts()).indexOf(obj);
            desc = this.createOutputPortDescription((IGeneratedTransformPort)obj, index);
        }
        return desc;
    }

    @Override
    public int deleteInputPort(Object obj) {
        int index = -1;
        if (obj != null && obj instanceof IGeneratedTransformPort) {
            for (int i = 0; i < this.m_sourcePorts.size(); ++i) {
                PortDescriptionModel mdl = (PortDescriptionModel)this.m_sourcePorts.get(i);
                if (mdl.getTransformPort() != (IGeneratedTransformPort)obj) continue;
                this.m_sourcePorts.remove(mdl);
                return i + 1;
            }
        }
        return index;
    }

    @Override
    public int deleteOutputPort(Object obj) {
        int index = -1;
        if (obj != null && obj instanceof IGeneratedTransformPort) {
            for (int i = 0; i < this.m_targetPorts.size(); ++i) {
                PortDescriptionModel mdl = (PortDescriptionModel)this.m_targetPorts.get(i);
                if (mdl.getTransformPort() != (IGeneratedTransformPort)obj) continue;
                this.m_targetPorts.remove(mdl);
                return i + 1;
            }
        }
        return index;
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        if (portIndex == -1) {
            IGeneratedTransformPort port = this.m_template.getNextAvailablePort(true);
            if (port == null) {
                if (this.m_template.canPortBeAdded(true)) {
                    return bundle.getString("GeneratedTransformAdapter.NoInputDataPort.txt");
                }
                return bundle.formatString("GeneratedTransformAdapter.NoInputDataPortToBeAdded.txt", (Object)this.m_transform.getName());
            }
        } else {
            IGeneratedTransformPort port = this.m_template.getSourcePorts()[portIndex];
            if (port.getTable() != null) {
                return bundle.getString("GeneratedTransformAdapter.InputPortUsed.txt");
            }
        }
        return super.getInvalidConnectInputMessage(obj, portIndex);
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        if (portIndex == -1) {
            IGeneratedTransformPort port = this.m_template.getNextAvailablePort(false);
            if (port == null) {
                if (this.m_template.canPortBeAdded(false)) {
                    return bundle.getString("GeneratedTransformAdapter.NoOutputDataPort.txt");
                }
                return bundle.formatString("GeneratedTransformAdapter.NoOutputDataPortToBeAdded.txt", (Object)this.m_transform.getName());
            }
        } else {
            IGeneratedTransformPort port = this.m_template.getTargetPorts()[portIndex];
            if (port.getTable() != null) {
                return bundle.getString("GeneratedTransformAdapter.OutputPortUsed.txt");
            }
        }
        return super.getInvalidConnectInputMessage(obj, portIndex);
    }

    private class PortDescriptionModel {
        private IGeneratedTransformPort m_gtPort;
        private IPortDescription m_visualPort;

        public PortDescriptionModel(IGeneratedTransformPort gtPort, IPortDescription visualPort) {
            this.m_gtPort = gtPort;
            this.m_visualPort = visualPort;
        }

        public IGeneratedTransformPort getTransformPort() {
            return this.m_gtPort;
        }

        public IPortDescription getVisualPort() {
            return this.m_visualPort;
        }
    }
}

