/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.dataValidation.DVPortDescriptionModel;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.DataValidationActionFactory;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableViewer;
import com.sas.wadmin.transforms.datavalidation.ErrorsTab;
import com.sas.wadmin.transforms.hadoop.util.ActionFactory;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TransformTableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DataValidationTransformAdapter
extends AbstractDataTransformAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(DataValidationTransformAdapter.class);
    public static final int CONTROL_PORT = 0;
    public static final int TARGET_PORT = 1;
    public static final int ERROR_PORT = 2;
    public static final int EXCEPTION_PORT = 3;
    private static final int TARGET_PORTS = 3;
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(DataValidationTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(DataValidationTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(DataValidationTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(DataValidationTransformModel.getTransformTypeID(), 24);
    private DataValidationTransformModel m_validate;

    public DataValidationTransformAdapter(DataValidationTransformModel transform) {
        super((IDataTransform)transform);
        this.m_validate = transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public void addContextMenuItems(JPopupMenu menuPopup) {
        Action[] aActions = DataValidationActionFactory.getInstance().createDVActions(this.m_validate);
        ActionFactory.addActionsToPopupMenu(menuPopup, aActions);
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            return ICON_URL_SMALL;
        }
        if (size == 24) {
            return ICON_URL_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab tabOptions = new OptionsTab(this.m_validate.getOptionModel(), "options_tab_validation", false);
            TransformTableOptionsTab tableOptionsTab = new TransformTableOptionsTab((IDataTransform)this.m_validate, null, false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_validate));
            lTabs.add(new DataValidationTableViewer(this.m_validate, "Invalid"));
            lTabs.add(new DataValidationTableViewer(this.m_validate, "Missing"));
            lTabs.add(new DataValidationTableViewer(this.m_validate, "Duplicate"));
            lTabs.add(new DataValidationTableViewer(this.m_validate, "Custom"));
            lTabs.add(new ErrorsTab(this.m_validate));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(tabOptions);
            lTabs.add(tableOptionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_validate, true, true));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_validate));
            lTabs.add(new ConditionActionsTab((IConditionActionSetContainer)this.m_validate));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_validate));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_validate));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_validate, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        DVPortDescriptionModel[] aOutputPorts = this.m_validate.getOutputPortDescriptions();
        IPortDescription[] aPortDesc = new IPortDescription[aOutputPorts.length + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
        for (int i = 0; i < aOutputPorts.length; ++i) {
            DVPortDescriptionModel outputPort = aOutputPorts[i];
            aPortDesc[i + 1] = PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(outputPort.getTooltipText(), outputPort.getName(), 1, DEFAULT_TABLE_TYPES);
        }
        return aPortDesc;
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        int[] iaPorts;
        if (obj instanceof IPhysicalTable && (iaPorts = this.m_validate.findInTargetPorts((IPhysicalTable)obj)).length > 0) {
            return iaPorts[0] + 1;
        }
        return -1;
    }

    @Override
    public int[] getOutputPortIndexes(IObject obj) {
        int[] iaPorts = this.m_validate.findInTargetPorts((IPhysicalTable)obj);
        int i = 0;
        while (i < iaPorts.length) {
            int n = i++;
            iaPorts[n] = iaPorts[n] + 1;
        }
        return iaPorts;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        return portIndex == 0 ? obj instanceof ITransform : (portIndex == 1 || portIndex == 2 || portIndex == 3) && obj instanceof IPhysicalTable && !this.m_validate.containsInDataTargets((IDataObject)obj);
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_validate.setTargetTable((IPhysicalTable)obj);
                return true;
            }
        } else if (portIndex == 2) {
            if (obj instanceof IPhysicalTable) {
                this.m_validate.setErrorTable((IPhysicalTable)obj);
                return true;
            }
        } else if (portIndex == 3 && obj instanceof IPhysicalTable) {
            this.m_validate.setExceptionTable((IPhysicalTable)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            throw new IllegalArgumentException("connect to control port not supported");
        }
        if (portIndex == 1) {
            if (obj instanceof IPhysicalTable) {
                this.m_validate.setTargetTable(null);
                return true;
            }
        } else if (portIndex == 2) {
            if (obj instanceof IPhysicalTable) {
                this.m_validate.setErrorTable(null);
                return true;
            }
        } else if (portIndex == 3 && obj instanceof IPhysicalTable) {
            this.m_validate.setExceptionTable(null);
            return true;
        }
        return false;
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        if (portIndex > 1) {
            return bundle.formatString("LookupTransformAdapter.InvalidOutputMessage.txt", (Object)this.getName());
        }
        return null;
    }
}

