/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class DataValidationActionFactory {
    private static final WAdminResource bundle = WAdminResource.getBundle(DataValidationActionFactory.class);
    private static DataValidationActionFactory s_instance;

    private DataValidationActionFactory() {
    }

    public static DataValidationActionFactory getInstance() {
        if (s_instance == null) {
            s_instance = new DataValidationActionFactory();
        }
        return s_instance;
    }

    public Action[] createDVActions(DataValidationTransformModel transform) {
        boolean bEditable = transform != null;
        Action[] aActions = new Action[]{new AddErrorTableAction(transform), new AddExceptionTableAction(transform)};
        if (!bEditable) {
            this.disableActions(aActions);
        }
        return aActions;
    }

    public static void addActionsToMenu(JMenu menu, Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) {
                menu.addSeparator();
                continue;
            }
            if (aActions[iAction] instanceof WsAbstractToggleAction) {
                menu.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)((WsAbstractToggleAction)aActions[iAction])));
                continue;
            }
            menu.add(aActions[iAction]);
        }
    }

    public static void addActionsToPopupMenu(JPopupMenu menuPopup, Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) {
                menuPopup.addSeparator();
                continue;
            }
            if (aActions[iAction] instanceof WsAbstractToggleAction) {
                menuPopup.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)((WsAbstractToggleAction)aActions[iAction])));
                continue;
            }
            menuPopup.add(aActions[iAction]);
        }
    }

    private void disableActions(Action[] aActions) {
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (aActions[iAction] == null) continue;
            aActions[iAction].setEnabled(false);
        }
    }

    public class AddErrorTableAction
    extends WsAbstractAction {
        private DataValidationTransformModel _transform;

        public AddErrorTableAction(DataValidationTransformModel transform) {
            super(bundle, "DataValidationActionFactory.AddErrorTableAction", 256);
            this._transform = transform;
            if (this._transform == null || this._transform.getErrorTable() != null) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent event) {
            if (this._transform == null) {
                return;
            }
            this._transform.setErrorTable(DataValidationUtil.createErrorWorkTable((DataValidationTransformModel)this._transform));
        }
    }

    public class AddExceptionTableAction
    extends WsAbstractAction {
        private DataValidationTransformModel _transform;

        public AddExceptionTableAction(DataValidationTransformModel transform) {
            super(bundle, "DataValidationActionFactory.AddExceptionTableAction", 256);
            this._transform = transform;
            if (this._transform == null || this._transform.getExceptionTable() != null) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent event) {
            if (this._transform == null) {
                return;
            }
            this._transform.setExceptionTable(DataValidationUtil.createExceptionWorkTable((DataValidationTransformModel)this._transform));
        }
    }
}

